/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.service.ServiceDescriptor;
import org.apache.flink.table.api.OperatorType$;
import org.apache.flink.table.api.TableConfig$;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.api.functions.AggregateFunction;
import org.apache.flink.table.calcite.CalciteConfig;
import org.apache.flink.table.calcite.CalciteConfig$;
import org.apache.flink.table.plan.nodes.process.ChainedDAGProcessors;
import org.apache.flink.table.temptable.FlinkTableServiceFactoryDescriptor;
import org.apache.flink.table.temptable.util.TableServiceUtil;
import org.apache.flink.util.Preconditions;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r]a\u0001B\u0001\u0003\u00015\u00111\u0002V1cY\u0016\u001cuN\u001c4jO*\u00111\u0001B\u0001\u0004CBL'BA\u0003\u0007\u0003\u0015!\u0018M\u00197f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002\u00011A\u0005\nm\t\u0001\u0002^5nKj{g.Z\u000b\u00029A\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005kRLGNC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"\u0001\u0003+j[\u0016TvN\\3\t\u000f\u0015\u0002\u0001\u0019!C\u0005M\u0005aA/[7f5>tWm\u0018\u0013fcR\u0011qE\u000b\t\u0003\u001f!J!!\u000b\t\u0003\tUs\u0017\u000e\u001e\u0005\bW\u0011\n\t\u00111\u0001\u001d\u0003\rAH%\r\u0005\u0007[\u0001\u0001\u000b\u0015\u0002\u000f\u0002\u0013QLW.\u001a.p]\u0016\u0004\u0003bB\u0018\u0001\u0001\u0004%I\u0001M\u0001\n]VdGn\u00115fG.,\u0012!\r\t\u0003\u001fIJ!a\r\t\u0003\u000f\t{w\u000e\\3b]\"9Q\u0007\u0001a\u0001\n\u00131\u0014!\u00048vY2\u001c\u0005.Z2l?\u0012*\u0017\u000f\u0006\u0002(o!91\u0006NA\u0001\u0002\u0004\t\u0004BB\u001d\u0001A\u0003&\u0011'\u0001\u0006ok2d7\t[3dW\u0002Bqa\u000f\u0001A\u0002\u0013%A(A\u0007dC2\u001c\u0017\u000e^3D_:4\u0017nZ\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tB\u0001\bG\u0006d7-\u001b;f\u0013\t\u0011uHA\u0007DC2\u001c\u0017\u000e^3D_:4\u0017n\u001a\u0005\b\t\u0002\u0001\r\u0011\"\u0003F\u0003E\u0019\u0017\r\\2ji\u0016\u001cuN\u001c4jO~#S-\u001d\u000b\u0003O\u0019CqaK\"\u0002\u0002\u0003\u0007Q\b\u0003\u0004I\u0001\u0001\u0006K!P\u0001\u000fG\u0006d7-\u001b;f\u0007>tg-[4!\u0011\u001dQ\u0005\u00011A\u0005\n-\u000bAaY8oMV\tA\n\u0005\u0002N!6\taJ\u0003\u0002P\r\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\u0015(\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\u0019\u0006\u00011A\u0005\nQ\u000b\u0001bY8oM~#S-\u001d\u000b\u0003OUCqa\u000b*\u0002\u0002\u0003\u0007A\n\u0003\u0004X\u0001\u0001\u0006K\u0001T\u0001\u0006G>tg\r\t\u0005\b3\u0002\u0001\r\u0011\"\u0003[\u0003I\u0011\u0017\r^2i\t\u0006;\u0005K]8dKN\u001cxN]:\u0016\u0003m\u0003\"\u0001X2\u000e\u0003uS!AX0\u0002\u000fA\u0014xnY3tg*\u0011\u0001-Y\u0001\u0006]>$Wm\u001d\u0006\u0003E\u0012\tA\u0001\u001d7b]&\u0011A-\u0018\u0002\u0015\u0007\"\f\u0017N\\3e\t\u0006;\u0005K]8dKN\u001cxN]:\t\u000f\u0019\u0004\u0001\u0019!C\u0005O\u00061\"-\u0019;dQ\u0012\u000bu\t\u0015:pG\u0016\u001c8o\u001c:t?\u0012*\u0017\u000f\u0006\u0002(Q\"91&ZA\u0001\u0002\u0004Y\u0006B\u00026\u0001A\u0003&1,A\ncCR\u001c\u0007\u000eR!H!J|7-Z:t_J\u001c\b\u0005C\u0004m\u0001\u0001\u0007I\u0011\u0002.\u0002'M$(/Z1n\t\u0006;\u0005K]8dKN\u001cxN]:\t\u000f9\u0004\u0001\u0019!C\u0005_\u000692\u000f\u001e:fC6$\u0015i\u0012)s_\u000e,7o]8sg~#S-\u001d\u000b\u0003OADqaK7\u0002\u0002\u0003\u00071\f\u0003\u0004s\u0001\u0001\u0006KaW\u0001\u0015gR\u0014X-Y7E\u0003\u001e\u0003&o\\2fgN|'o\u001d\u0011\t\u000bQ\u0004A\u0011\u0001.\u0002+\u001d,GOQ1uG\"$\u0015i\u0012)s_\u000e,7o]8sg\")a\u000f\u0001C\u00015\u00061r-\u001a;TiJ,\u0017-\u001c#B\u000fB\u0013xnY3tg>\u00148\u000fC\u0003y\u0001\u0011\u0005\u00110A\u000btKR\u0014\u0015\r^2i\t\u0006;\u0005K]8dKN\u001cxN]:\u0015\u0005\u001dR\b\"B>x\u0001\u0004Y\u0016!\u00043bOB\u0013xnY3tg>\u00148\u000fC\u0003~\u0001\u0011\u0005a0\u0001\ftKR\u001cFO]3b[\u0012\u000bu\t\u0015:pG\u0016\u001c8o\u001c:t)\t9s\u0010C\u0003|y\u0002\u00071\fC\u0004\u0002\u0004\u0001!\t!!\u0002\u0002\u0017M,G\u000fV5nKj{g.\u001a\u000b\u0004O\u0005\u001d\u0001B\u0002\u000e\u0002\u0002\u0001\u0007A\u0004\u0003\u0004\u0002\f\u0001!\taG\u0001\fO\u0016$H+[7f5>tW\r\u0003\u0004\u0002\u0010\u0001!\t\u0001M\u0001\rO\u0016$h*\u001e7m\u0007\",7m\u001b\u0005\b\u0003'\u0001A\u0011AA\u000b\u00031\u0019X\r\u001e(vY2\u001c\u0005.Z2l)\r9\u0013q\u0003\u0005\u0007_\u0005E\u0001\u0019A\u0019\t\r\u0005m\u0001\u0001\"\u0001=\u0003A9W\r^\"bY\u000eLG/Z\"p]\u001aLw\rC\u0004\u0002 \u0001!\t!!\t\u0002!M,GoQ1mG&$XmQ8oM&<GcA\u0014\u0002$!11(!\bA\u0002uBa!a\n\u0001\t\u0003Y\u0015aB4fi\u000e{gN\u001a\u0005\b\u0003W\u0001A\u0011AA\u0017\u0003\u001d\u0019X\r^\"p]\u001a$2aJA\u0018\u0011\u0019Q\u0015\u0011\u0006a\u0001\u0019\"9\u00111\u0007\u0001\u0005\u0002\u0005U\u0012AE3oC\ndW\rZ$jm\u0016tw\n\u001d+za\u0016$2!MA\u001c\u0011!\tI$!\rA\u0002\u0005m\u0012\u0001C8qKJ\fGo\u001c:\u0011\t\u0005u\u0012Q\f\b\u0005\u0003\u007f\tIF\u0004\u0003\u0002B\u0005]c\u0002BA\"\u0003+rA!!\u0012\u0002T9!\u0011qIA)\u001d\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\r\tYFA\u0001\r\u001fB,'/\u0019;peRK\b/Z\u0005\u0005\u0003?\n\tG\u0001\u0007Pa\u0016\u0014\u0018\r^8s)f\u0004XMC\u0002\u0002\\\tA\u0011\"!\u001a\u0001\u0005\u0004%I!a\u001a\u0002+\u0011+e)Q+M)~3\u0015JU#`\u0013:#VI\u0015,B\u0019V\u0011\u0011\u0011\u000e\t\u0004\u001f\u0005-\u0014bAA7!\t!Aj\u001c8h\u0011!\t\t\b\u0001Q\u0001\n\u0005%\u0014A\u0006#F\r\u0006+F\nV0G\u0013J+u,\u0013(U\u000bJ3\u0016\t\u0014\u0011\t\u0013\u0005U\u0004\u00011A\u0005\n\u0005\u001d\u0014!E3be2Lh)\u001b:f\u0013:$XM\u001d<bY\"I\u0011\u0011\u0010\u0001A\u0002\u0013%\u00111P\u0001\u0016K\u0006\u0014H.\u001f$je\u0016Le\u000e^3sm\u0006dw\fJ3r)\r9\u0013Q\u0010\u0005\nW\u0005]\u0014\u0011!a\u0001\u0003SB\u0001\"!!\u0001A\u0003&\u0011\u0011N\u0001\u0013K\u0006\u0014H.\u001f$je\u0016Le\u000e^3sm\u0006d\u0007\u0005C\u0005\u0002\u0006\u0002\u0001\r\u0011\"\u0003\u0002h\u0005\u0001B.\u0019;f\r&\u0014X-\u00138uKJ4\u0018\r\u001c\u0005\n\u0003\u0013\u0003\u0001\u0019!C\u0005\u0003\u0017\u000bA\u0003\\1uK\u001aK'/Z%oi\u0016\u0014h/\u00197`I\u0015\fHcA\u0014\u0002\u000e\"I1&a\"\u0002\u0002\u0003\u0007\u0011\u0011\u000e\u0005\t\u0003#\u0003\u0001\u0015)\u0003\u0002j\u0005\tB.\u0019;f\r&\u0014X-\u00138uKJ4\u0018\r\u001c\u0011\t\u0013\u0005U\u0005\u00011A\u0005\n\u0005]\u0015!H9vKJL\u0018M\u00197f'R\fG/\u001a\u001aBO\u001e4UO\\2uS>tW*\u00199\u0016\u0005\u0005e\u0005\u0003CAN\u0003C\u000b9+!,\u000f\u0007=\ti*C\u0002\u0002 B\ta\u0001\u0015:fI\u00164\u0017\u0002BAR\u0003K\u00131!T1q\u0015\r\ty\n\u0005\t\u0005\u00037\u000bI+\u0003\u0003\u0002,\u0006\u0015&AB*ue&tw\r\u0005\u0005\u00020\u0006e\u0016qUA_\u001b\t\t\tL\u0003\u0003\u00024\u0006U\u0016!\u0002;va2,'bA\u0011\u00028*\u00111AB\u0005\u0005\u0003w\u000b\tL\u0001\u0004UkBdWM\r\u0019\u0007\u0003\u007f\u000by-!?\u0011\u0011\u0005\u0005\u0017qYAf\u0003ol!!a1\u000b\u0007\u0005\u0015'!A\u0005gk:\u001cG/[8og&!\u0011\u0011ZAb\u0005E\tum\u001a:fO\u0006$XMR;oGRLwN\u001c\t\u0005\u0003\u001b\fy\r\u0004\u0001\u0005\u0019\u0005E\u00171[A\u0001\u0002\u0003\u0015\t!a9\u0003\u0007}#\u0013\u0007\u0003\u0005\u0002V\u0002\u0001\u000b\u0015BAl\u0003y\tX/\u001a:zC\ndWm\u0015;bi\u0016\u0014\u0014iZ4Gk:\u001cG/[8o\u001b\u0006\u0004\b\u0005\u0005\u0005\u0002\u001c\u0006\u0005\u0016qUAm!!\ty+!/\u0002(\u0006m\u0007GBAo\u0003C\f\u0019\u0010\u0005\u0005\u0002B\u0006\u001d\u0017q\\Ay!\u0011\ti-!9\u0005\u0019\u0005E\u00171[A\u0001\u0002\u0003\u0015\t!a9\u0012\t\u0005\u0015\u00181\u001e\t\u0004\u001f\u0005\u001d\u0018bAAu!\t9aj\u001c;iS:<\u0007cA\b\u0002n&\u0019\u0011q\u001e\t\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002N\u0006MH\u0001DA{\u0003'\f\t\u0011!A\u0003\u0002\u0005\r(aA0%eA!\u0011QZA}\t1\t)0a5\u0002\u0002\u0003\u0005)\u0011AAr\u0011%\ti\u0010\u0001a\u0001\n\u0013\ty0A\u0011rk\u0016\u0014\u00180\u00192mKN#\u0018\r^33\u0003\u001e<g)\u001e8di&|g.T1q?\u0012*\u0017\u000fF\u0002(\u0005\u0003A\u0011bKA~\u0003\u0003\u0005\rAa\u0001\u0011\u0011\u0005m\u0015\u0011UAT\u0005\u000b\u0001\u0002\"a,\u0002:\u0006\u001d&q\u0001\u0019\u0007\u0005\u0013\u0011iA!\u0005\u0011\u0011\u0005\u0005\u0017q\u0019B\u0006\u0005\u001f\u0001B!!4\u0003\u000e\u0011a\u0011\u0011[Aj\u0003\u0003\u0005\tQ!\u0001\u0002dB!\u0011Q\u001aB\t\t1\t)0a5\u0002\u0002\u0003\u0005)\u0011AAr\u0011%\u0011)\u0002\u0001a\u0001\n\u0003\u00119\"A\frk\u0016\u0014\u00180\u00192mKN#\u0018\r^33!\u0006\u0014\u0018-\\'baV\u0011!\u0011\u0004\t\t\u00037\u000b\t+a*\u0003\u001cAA\u00111TAQ\u0003O\u000b9\u000bC\u0005\u0003 \u0001\u0001\r\u0011\"\u0001\u0003\"\u0005Y\u0012/^3ss\u0006\u0014G.Z*uCR,'\u0007U1sC6l\u0015\r]0%KF$2a\nB\u0012\u0011%Y#QDA\u0001\u0002\u0004\u0011I\u0002\u0003\u0005\u0003(\u0001\u0001\u000b\u0015\u0002B\r\u0003a\tX/\u001a:zC\ndWm\u0015;bi\u0016\u0014\u0004+\u0019:b[6\u000b\u0007\u000f\t\u0005\b\u0005W\u0001A\u0011\u0001B\u0017\u0003i9\u0018\u000e\u001e5JI2,7\u000b^1uKJ+G/\u001a8uS>tG+[7f)\r9\"q\u0006\u0005\t\u0005c\u0011I\u00031\u0001\u00034\u0005!A/[7f!\u0011\u0011)D!\u0010\u000e\u0005\t]\"\u0002\u0002B\u0019\u0005sQAAa\u000f\u00028\u000611m\\7n_:LAAa\u0010\u00038\t!A+[7f\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0005\u0007\"Ra\u0006B#\u0005\u0013B\u0001Ba\u0012\u0003B\u0001\u0007!1G\u0001\b[&tG+[7f\u0011!\u0011YE!\u0011A\u0002\tM\u0012aB7bqRKW.\u001a\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0003U9\u0018\u000e\u001e5FCJd\u0017PR5sK&sG/\u001a:wC2$2a\u0006B*\u0011!\u0011)F!\u0014A\u0002\tM\u0012\u0001C5oi\u0016\u0014h/\u00197\t\u000f\te\u0003\u0001\"\u0001\u0003\\\u0005!r/\u001b;i\u0019\u0006$XMR5sK&sG/\u001a:wC2$2a\u0006B/\u0011!\u0011)Fa\u0016A\u0002\tM\u0002b\u0002B1\u0001\u0011\u0005\u0011qM\u0001\u001dO\u0016$X*\u001b8JI2,7\u000b^1uKJ+G/\u001a8uS>tG+[7f\u0011\u001d\u0011)\u0007\u0001C\u0001\u0003O\nAdZ3u\u001b\u0006D\u0018\n\u001a7f'R\fG/\u001a*fi\u0016tG/[8o)&lW\rC\u0004\u0003j\u0001!\t!a\u001a\u0002)\u001d,G/R1sYf4\u0015N]3J]R,'O^1m\u0011\u001d\u0011i\u0007\u0001C\u0001\u0003O\n1cZ3u\u0019\u0006$XMR5sK&sG/\u001a:wC2DqA!\u001d\u0001\t\u0003\u0011\u0019(\u0001\u0013bI\u0012\fV/\u001a:zC\ndWm\u0015;bi\u0016\u0014\u0014iZ4Gk:\u001cG/[8o\u001b\u0006\u0004\b/\u001b8h)\u00159\"Q\u000fB=\u0011!\u00119Ha\u001cA\u0002\u0005\u001d\u0016!D9vKJL\u0018M\u00197f\u001d\u0006lW\r\u0003\u0005\u0003|\t=\u0004\u0019\u0001B?\u0003\u0015)H-Y4h!!\ty+!/\u0002(\n}\u0004G\u0002BA\u0005\u000b\u0013Y\t\u0005\u0005\u0002B\u0006\u001d'1\u0011BE!\u0011\tiM!\"\u0005\u0019\t\u001d%\u0011PA\u0001\u0002\u0003\u0015\t!a9\u0003\u0007}#3\u0007\u0005\u0003\u0002N\n-E\u0001\u0004BG\u0005s\n\t\u0011!A\u0003\u0002\u0005\r(aA0%i!9!\u0011\u0013\u0001\u0005\u0002\tM\u0015AI4fi\u0006;wMR;oGRLwN\u001c\"z#V,'/_1cY\u0016\u001cF/\u0019;f\u001d\u0006lW\r\u0006\u0003\u0003\u0016\n\u001d\u0006\u0003CAX\u0003s\u000b9Ka&1\r\te%Q\u0014BR!!\t\t-a2\u0003\u001c\n\u0005\u0006\u0003BAg\u0005;#ABa(\u0003\u0010\u0006\u0005\t\u0011!B\u0001\u0003G\u00141a\u0018\u00136!\u0011\tiMa)\u0005\u0019\t\u0015&qRA\u0001\u0002\u0003\u0015\t!a9\u0003\u0007}#c\u0007\u0003\u0005\u0003x\t=\u0005\u0019AAT\u0011-\u0011Y\u000b\u0001a\u0001\u0002\u0004%IA!,\u0002-Q\f'\r\\3TKJ4\u0018nY3EKN\u001c'/\u001b9u_J,\"Aa,\u0011\t\tE&qW\u0007\u0003\u0005gS1A!.\u0007\u0003\u001d\u0019XM\u001d<jG\u0016LAA!/\u00034\n\t2+\u001a:wS\u000e,G)Z:de&\u0004Ho\u001c:\t\u0017\tu\u0006\u00011AA\u0002\u0013%!qX\u0001\u001bi\u0006\u0014G.Z*feZL7-\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe~#S-\u001d\u000b\u0004O\t\u0005\u0007\"C\u0016\u0003<\u0006\u0005\t\u0019\u0001BX\u0011!\u0011)\r\u0001Q!\n\t=\u0016a\u0006;bE2,7+\u001a:wS\u000e,G)Z:de&\u0004Ho\u001c:!\u0011\u001d\u0011I\r\u0001C\u0001\u0005\u0017\f\u0011dZ3u)\u0006\u0014G.Z*feZL7-\u001a#fg\u000e\u0014\u0018\u000e\u001d;peR\u0011!q\u0016\u0005\b\u0005\u001f\u0004A\u0011\u0001Bi\u0003e\u0019X\r\u001e+bE2,7+\u001a:wS\u000e,G)Z:de&\u0004Ho\u001c:\u0015\u0007\u001d\u0012\u0019\u000e\u0003\u0005\u0003V\n5\u0007\u0019\u0001BX\u0003)!Wm]2sSB$xN\u001d\u0005\n\u00053\u0004\u0001\u0019!C\u0005\u00057\fQ\u0004^1cY\u0016\u001cVM\u001d<jG\u00164\u0015m\u0019;pef$Um]2sSB$xN]\u000b\u0003\u0005;\u0004BAa8\u0003f6\u0011!\u0011\u001d\u0006\u0004\u0005G$\u0011!\u0003;f[B$\u0018M\u00197f\u0013\u0011\u00119O!9\u0003E\u0019c\u0017N\\6UC\ndWmU3sm&\u001cWMR1di>\u0014\u0018\u0010R3tGJL\u0007\u000f^8s\u0011%\u0011Y\u000f\u0001a\u0001\n\u0013\u0011i/A\u0011uC\ndWmU3sm&\u001cWMR1di>\u0014\u0018\u0010R3tGJL\u0007\u000f^8s?\u0012*\u0017\u000fF\u0002(\u0005_D\u0011b\u000bBu\u0003\u0003\u0005\rA!8\t\u0011\tM\b\u0001)Q\u0005\u0005;\fa\u0004^1cY\u0016\u001cVM\u001d<jG\u00164\u0015m\u0019;pef$Um]2sSB$xN\u001d\u0011\t\u000f\t]\b\u0001\"\u0001\u0003z\u0006\u0001s-\u001a;UC\ndWmU3sm&\u001cWMR1di>\u0014\u0018\u0010R3tGJL\u0007\u000f^8s)\t\u0011i\u000eC\u0004\u0003~\u0002!\tAa@\u0002AM,G\u000fV1cY\u0016\u001cVM\u001d<jG\u00164\u0015m\u0019;pef$Um]2sSB$xN\u001d\u000b\u0004O\r\u0005\u0001\u0002\u0003Bk\u0005w\u0004\rA!8\b\u000f\r\u0015!\u0001#\u0001\u0004\b\u0005YA+\u00192mK\u000e{gNZ5h!\rA2\u0011\u0002\u0004\u0007\u0003\tA\taa\u0003\u0014\u0007\r%a\u0002C\u0004\u0016\u0007\u0013!\taa\u0004\u0015\u0005\r\u001d\u0001\u0002CB\n\u0007\u0013!\ta!\u0006\u0002\u000f\u0011+e)Q+M)V\tq\u0003")
public class TableConfig {
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    private boolean nullCheck = true;
    private CalciteConfig calciteConfig = CalciteConfig$.MODULE$.createBuilder().build();
    private Configuration conf = GlobalConfiguration.loadConfiguration();
    private ChainedDAGProcessors batchDAGProcessors = ChainedDAGProcessors.buildBatchProcessors();
    private ChainedDAGProcessors streamDAGProcessors = ChainedDAGProcessors.buildStreamProcessors();
    private final long DEFAULT_FIRE_INTERVAL = Long.MIN_VALUE;
    private long earlyFireInterval = this.DEFAULT_FIRE_INTERVAL();
    private long lateFireInterval = this.DEFAULT_FIRE_INTERVAL();
    private Map<String, Tuple2<String, AggregateFunction<?, ?>>> queryableState2AggFunctionMap = Predef$.MODULE$.Map().empty();
    private Map<String, Map<String, String>> queryableState2ParamMap = Predef$.MODULE$.Map().empty();
    private ServiceDescriptor tableServiceDescriptor;
    private FlinkTableServiceFactoryDescriptor tableServiceFactoryDescriptor;

    public static TableConfig DEFAULT() {
        return TableConfig$.MODULE$.DEFAULT();
    }

    private TimeZone timeZone() {
        return this.timeZone;
    }

    private void timeZone_$eq(TimeZone x$1) {
        this.timeZone = x$1;
    }

    private boolean nullCheck() {
        return this.nullCheck;
    }

    private void nullCheck_$eq(boolean x$1) {
        this.nullCheck = x$1;
    }

    private CalciteConfig calciteConfig() {
        return this.calciteConfig;
    }

    private void calciteConfig_$eq(CalciteConfig x$1) {
        this.calciteConfig = x$1;
    }

    private Configuration conf() {
        return this.conf;
    }

    private void conf_$eq(Configuration x$1) {
        this.conf = x$1;
    }

    private ChainedDAGProcessors batchDAGProcessors() {
        return this.batchDAGProcessors;
    }

    private void batchDAGProcessors_$eq(ChainedDAGProcessors x$1) {
        this.batchDAGProcessors = x$1;
    }

    private ChainedDAGProcessors streamDAGProcessors() {
        return this.streamDAGProcessors;
    }

    private void streamDAGProcessors_$eq(ChainedDAGProcessors x$1) {
        this.streamDAGProcessors = x$1;
    }

    public ChainedDAGProcessors getBatchDAGProcessors() {
        return this.batchDAGProcessors();
    }

    public ChainedDAGProcessors getStreamDAGProcessors() {
        return this.streamDAGProcessors();
    }

    public void setBatchDAGProcessors(ChainedDAGProcessors dagProcessors) {
        this.batchDAGProcessors_$eq(dagProcessors);
    }

    public void setStreamDAGProcessors(ChainedDAGProcessors dagProcessors) {
        this.streamDAGProcessors_$eq(dagProcessors);
    }

    public void setTimeZone(TimeZone timeZone) {
        Predef$.MODULE$.require(timeZone != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "timeZone must not be null.";
            }
        });
        this.timeZone_$eq(timeZone);
        DateTimeUtils.setUserZone(timeZone);
    }

    public TimeZone getTimeZone() {
        return this.timeZone();
    }

    public boolean getNullCheck() {
        return this.nullCheck();
    }

    public void setNullCheck(boolean nullCheck) {
        this.nullCheck_$eq(nullCheck);
    }

    public CalciteConfig getCalciteConfig() {
        return this.calciteConfig();
    }

    public void setCalciteConfig(CalciteConfig calciteConfig) {
        this.calciteConfig_$eq(Preconditions.checkNotNull(calciteConfig));
    }

    public Configuration getConf() {
        return this.conf();
    }

    public void setConf(Configuration conf) {
        this.conf_$eq(GlobalConfiguration.loadConfiguration());
        this.conf().addAll(conf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enabledGivenOpType(Enumeration.Value operator) {
        String[] disableOperators = (String[])Predef$.MODULE$.refArrayOps((Object[])this.conf().getString(TableConfigOptions.SQL_EXEC_DISABLED_OPERATORS).split(",")).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        if (Predef$.MODULE$.refArrayOps((Object[])disableOperators).contains((Object)"HashJoin")) {
            Enumeration.Value value = operator;
            Enumeration.Value value2 = OperatorType$.MODULE$.BroadcastHashJoin();
            if (value == null) {
                if (value2 == null) return false;
            } else if (value.equals(value2)) return false;
            Enumeration.Value value3 = operator;
            Enumeration.Value value4 = OperatorType$.MODULE$.ShuffleHashJoin();
            if (value3 == null) {
                if (value4 == null) return false;
            } else if (value3.equals(value4)) {
                return false;
            }
        }
        if (!Predef$.MODULE$.refArrayOps((Object[])disableOperators).contains((Object)operator.toString())) return true;
        return false;
    }

    private long DEFAULT_FIRE_INTERVAL() {
        return this.DEFAULT_FIRE_INTERVAL;
    }

    private long earlyFireInterval() {
        return this.earlyFireInterval;
    }

    private void earlyFireInterval_$eq(long x$1) {
        this.earlyFireInterval = x$1;
    }

    private long lateFireInterval() {
        return this.lateFireInterval;
    }

    private void lateFireInterval_$eq(long x$1) {
        this.lateFireInterval = x$1;
    }

    private Map<String, Tuple2<String, AggregateFunction<?, ?>>> queryableState2AggFunctionMap() {
        return this.queryableState2AggFunctionMap;
    }

    private void queryableState2AggFunctionMap_$eq(Map<String, Tuple2<String, AggregateFunction<?, ?>>> x$1) {
        this.queryableState2AggFunctionMap = x$1;
    }

    public Map<String, Map<String, String>> queryableState2ParamMap() {
        return this.queryableState2ParamMap;
    }

    public void queryableState2ParamMap_$eq(Map<String, Map<String, String>> x$1) {
        this.queryableState2ParamMap = x$1;
    }

    public TableConfig withIdleStateRetentionTime(Time time) {
        this.withIdleStateRetentionTime(time, time);
        return this;
    }

    public TableConfig withIdleStateRetentionTime(Time minTime, Time maxTime) {
        if (maxTime.toMilliseconds() < minTime.toMilliseconds()) {
            throw new IllegalArgumentException("maxTime may not be smaller than minTime.");
        }
        this.conf().setLong(TableConfigOptions.SQL_EXEC_STATE_TTL_MS, minTime.toMilliseconds());
        this.conf().setLong(TableConfigOptions.SQL_EXEC_STATE_TTL_MAX_MS, maxTime.toMilliseconds());
        return this;
    }

    public TableConfig withEarlyFireInterval(Time interval) {
        if (this.earlyFireInterval() != this.DEFAULT_FIRE_INTERVAL() && this.earlyFireInterval() != interval.toMilliseconds()) {
            throw new RuntimeException("Currently not support different earlyFireInterval configs in one job");
        }
        this.earlyFireInterval_$eq(interval.toMilliseconds());
        return this;
    }

    public TableConfig withLateFireInterval(Time interval) {
        if (this.lateFireInterval() != this.DEFAULT_FIRE_INTERVAL() && this.lateFireInterval() != interval.toMilliseconds()) {
            throw new RuntimeException("Currently not support different lateFireInterval configs in one job");
        }
        this.lateFireInterval_$eq(interval.toMilliseconds());
        return this;
    }

    public long getMinIdleStateRetentionTime() {
        return this.conf().getLong(TableConfigOptions.SQL_EXEC_STATE_TTL_MS);
    }

    public long getMaxIdleStateRetentionTime() {
        if (this.conf().contains(TableConfigOptions.SQL_EXEC_STATE_TTL_MS) && !this.conf().contains(TableConfigOptions.SQL_EXEC_STATE_TTL_MAX_MS)) {
            this.conf().setLong(TableConfigOptions.SQL_EXEC_STATE_TTL_MAX_MS, this.getMinIdleStateRetentionTime() * 2L);
        }
        return this.conf().getLong(TableConfigOptions.SQL_EXEC_STATE_TTL_MAX_MS);
    }

    public long getEarlyFireInterval() {
        return this.earlyFireInterval();
    }

    public long getLateFireInterval() {
        return this.lateFireInterval();
    }

    public TableConfig addQueryableState2AggFunctionMapping(String queryableName, Tuple2<String, AggregateFunction<?, ?>> udagg) {
        this.queryableState2AggFunctionMap_$eq(this.queryableState2AggFunctionMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)queryableName), udagg)));
        return this;
    }

    public Tuple2<String, AggregateFunction<?, ?>> getAggFunctionByQueryableStateName(String queryableName) {
        return (Tuple2)this.queryableState2AggFunctionMap().get((Object)queryableName).orNull(Predef$.MODULE$.$conforms());
    }

    private ServiceDescriptor tableServiceDescriptor() {
        return this.tableServiceDescriptor;
    }

    private void tableServiceDescriptor_$eq(ServiceDescriptor x$1) {
        this.tableServiceDescriptor = x$1;
    }

    public ServiceDescriptor getTableServiceDescriptor() {
        return this.tableServiceDescriptor() == null ? TableServiceUtil.createTableServiceDescriptor(this.conf()) : this.tableServiceDescriptor();
    }

    public void setTableServiceDescriptor(ServiceDescriptor descriptor) {
        this.tableServiceDescriptor_$eq(descriptor);
    }

    private FlinkTableServiceFactoryDescriptor tableServiceFactoryDescriptor() {
        return this.tableServiceFactoryDescriptor;
    }

    private void tableServiceFactoryDescriptor_$eq(FlinkTableServiceFactoryDescriptor x$1) {
        this.tableServiceFactoryDescriptor = x$1;
    }

    public FlinkTableServiceFactoryDescriptor getTableServiceFactoryDescriptor() {
        return this.tableServiceFactoryDescriptor();
    }

    public void setTableServiceFactoryDescriptor(FlinkTableServiceFactoryDescriptor descriptor) {
        this.tableServiceFactoryDescriptor_$eq(descriptor);
    }

    /*
     * WARNING - void declaration
     */
    public TableConfig() {
        void var1_1;
        FlinkTableServiceFactoryDescriptor desc = TableServiceUtil.getDefaultTableServiceFactoryDescriptor();
        desc.getTableProperties().addAll(this.getConf());
        this.tableServiceFactoryDescriptor = var1_1;
    }
}

