/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.exceptions;

import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.ObjectPath;

public class PartitionNotExistException
extends RuntimeException {
    private static final String MSG = "Partition %s of table %s in catalog %s does not exist.";

    public PartitionNotExistException(String catalogName, ObjectPath tablePath, CatalogPartition.PartitionSpec partitionSpec) {
        super(String.format(MSG, partitionSpec, tablePath.getFullName(), catalogName), null);
    }

    public PartitionNotExistException(String catalogName, ObjectPath tablePath, CatalogPartition.PartitionSpec partitionSpec, Throwable cause) {
        super(String.format(MSG, partitionSpec, tablePath.getFullName(), catalogName), cause);
    }
}

