/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.functions;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.functions.UserDefinedFunction;
import org.apache.flink.table.descriptors.ClassInstanceValidator$;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FunctionDescriptor;
import org.apache.flink.table.descriptors.FunctionDescriptorValidator;
import org.apache.flink.table.descriptors.HierarchyDescriptorValidator$;
import org.apache.flink.table.descriptors.LiteralValueValidator$;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class FunctionService$
implements Logging {
    public static final FunctionService$ MODULE$;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    static {
        new FunctionService$();
    }

    private Logger LOG$lzycompute() {
        FunctionService$ functionService$ = this;
        synchronized (functionService$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    public UserDefinedFunction createFunction(FunctionDescriptor descriptor) {
        return this.createFunction(descriptor, Thread.currentThread().getContextClassLoader(), this.createFunction$default$3());
    }

    /*
     * WARNING - void declaration
     */
    public UserDefinedFunction createFunction(FunctionDescriptor descriptor, ClassLoader classLoader, boolean performValidation) {
        Tuple2 tuple2;
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(descriptor.toProperties());
        if (performValidation) {
            new FunctionDescriptorValidator().validate(properties);
        }
        if ((tuple2 = this.generateInstance(HierarchyDescriptorValidator$.MODULE$.EMPTY_PREFIX(), properties, classLoader)) != null) {
            void var10_10;
            Tuple2 tuple22;
            Class instanceClass = (Class)tuple2._1();
            Object instance = tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)instanceClass, instance);
            Class instanceClass2 = (Class)tuple23._1();
            Object instance2 = tuple23._2();
            if (UserDefinedFunction.class.isAssignableFrom(instanceClass2)) {
                return (UserDefinedFunction)instance2;
            }
            throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Instantiated class '", "' is not a user-defined function."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var10_10.getName()})));
        }
        throw new MatchError(tuple2);
    }

    public boolean createFunction$default$3() {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> Tuple2<Class<T>, T> generateInstance(String keyPrefix, DescriptorProperties descriptorProperties, ClassLoader classLoader) {
        void var9_9;
        Constructor<?> constructor;
        void var4_4;
        Class<?> instanceClass;
        String instanceClassName = descriptorProperties.getString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyPrefix, ClassInstanceValidator$.MODULE$.CLASS()})));
        try {
            instanceClass = Class.forName(descriptorProperties.getString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyPrefix, ClassInstanceValidator$.MODULE$.CLASS()}))), true, classLoader);
        }
        catch (Exception exception) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find class '", "' for creating an instance."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4}));
            this.LOG().error(msg, (Throwable)exception);
            throw new ValidationException(msg);
        }
        String constructorPrefix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyPrefix, ClassInstanceValidator$.MODULE$.CONSTRUCTOR()}));
        List<Map<String, String>> constructorProps = descriptorProperties.getVariableIndexedProperties(constructorPrefix, JavaConversions$.MODULE$.seqAsJavaList((Seq)Nil$.MODULE$));
        ArrayBuffer parameterList = new ArrayBuffer();
        for (int i = 0; i < constructorProps.size(); ++i) {
            ArrayBuffer arrayBuffer;
            if (((Map)JavaConversions$.MODULE$.asScalaBuffer(constructorProps).apply(i)).containsKey(ClassInstanceValidator$.MODULE$.CLASS())) {
                arrayBuffer = parameterList.$plus$eq(this.generateInstance(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{constructorPrefix, BoxesRunTime.boxToInteger((int)i)})), descriptorProperties, classLoader));
                continue;
            }
            Object literalValue = LiteralValueValidator$.MODULE$.getValue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{constructorPrefix, BoxesRunTime.boxToInteger((int)i)})), descriptorProperties);
            arrayBuffer = parameterList.$plus$eq((Object)new Tuple2(literalValue.getClass(), literalValue));
        }
        try {
            constructor = instanceClass.getConstructor((Class[])((TraversableOnce)parameterList.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Class<?> apply(Tuple2<Class<?>, Object> x$2) {
                    return (Class)x$2._1();
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class)));
        }
        catch (Exception exception) {
            String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find a public constructor with parameter types "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' for '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)var9_9.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<Class<?>, Object> x$3) {
                    return ((Class)x$3._1()).getName();
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(", "), var4_4}))).toString();
            this.LOG().error(msg, (Throwable)exception);
            throw new ValidationException(msg);
        }
        try {}
        catch (Exception exception) {
            String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while creating instance of class '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with parameter types '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)var9_9.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<Class<?>, Object> x$5) {
                    return ((Class)x$5._1()).getName();
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(", ")}))).toString();
            this.LOG().error(msg, (Throwable)exception);
            throw new ValidationException(msg);
        }
        Object instance = constructor.newInstance((Object[])((TraversableOnce)parameterList.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Tuple2<Class<?>, Object> x$4) {
                return x$4._2();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef()));
        return new Tuple2(instanceClass, instance);
    }

    private FunctionService$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

