/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.calcite.type;

import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.flink.table.calcite.type.NumericOrDefaultReturnTypeInference;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.types.DecimalType;

public class FlinkReturnTypes {
    public static final SqlReturnTypeInference ROUND_FUNCTION = new SqlReturnTypeInference(){

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            BigDecimal lenVal;
            RelDataType numType = opBinding.getOperandType(0);
            if (numType.getSqlTypeName() != SqlTypeName.DECIMAL) {
                return numType;
            }
            if (opBinding.getOperandCount() == 1) {
                lenVal = BigDecimal.ZERO;
            } else if (opBinding.getOperandCount() == 2) {
                lenVal = this.getArg1Literal(opBinding);
            } else {
                throw new AssertionError();
            }
            if (lenVal == null) {
                return numType;
            }
            int p = numType.getPrecision();
            int s = numType.getScale();
            int r = lenVal.intValueExact();
            DecimalType dt = Decimal.inferRoundType(p, s, r);
            return opBinding.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, dt.precision(), dt.scale());
        }

        private BigDecimal getArg1Literal(SqlOperatorBinding opBinding) {
            try {
                return opBinding.getOperandLiteralValue(1, BigDecimal.class);
            }
            catch (Throwable e2) {
                return null;
            }
        }
    };
    public static final SqlReturnTypeInference ROUND_FUNCTION_NULLABLE = ReturnTypes.cascade(ROUND_FUNCTION, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference NUMERIC_FROM_ARG1_DEFAULT1 = new NumericOrDefaultReturnTypeInference(1, 1);
    public static final SqlReturnTypeInference NUMERIC_FROM_ARG1_DEFAULT1_NULLABLE = ReturnTypes.cascade(NUMERIC_FROM_ARG1_DEFAULT1, SqlTypeTransforms.TO_NULLABLE);
}

