/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.calcite.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.util.Static;

public class SameOperandTypeExceptFirstOperandChecker
extends SameOperandTypeChecker {
    private final String firstOperandTypeName;

    public SameOperandTypeExceptFirstOperandChecker(int nOperands, String firstOperandTypeName) {
        super(nOperands);
        this.firstOperandTypeName = firstOperandTypeName;
    }

    @Override
    protected boolean checkOperandTypesImpl(SqlOperatorBinding operatorBinding, boolean throwOnFailure, SqlCallBinding callBinding) {
        int nOperandsActual = this.nOperands;
        if (nOperandsActual == -1) {
            nOperandsActual = operatorBinding.getOperandCount();
        }
        assert (!throwOnFailure || callBinding != null);
        RelDataType[] types = new RelDataType[nOperandsActual];
        List<Integer> operandList = this.getOperandList(operatorBinding.getOperandCount());
        for (int i : operandList) {
            if (operatorBinding.isOperandNull(i, false)) {
                if (throwOnFailure) {
                    throw callBinding.getValidator().newValidationError(callBinding.operand(i), Static.RESOURCE.nullIllegal());
                }
                return false;
            }
            types[i] = operatorBinding.getOperandType(i);
        }
        int prev = -1;
        for (int i : operandList) {
            if (prev >= 1 && !types[i].getSqlTypeName().equals((Object)types[prev].getSqlTypeName())) {
                if (!throwOnFailure) {
                    return false;
                }
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            prev = i;
        }
        return true;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        String typeName = this.getTypeName();
        if (this.nOperands == -1) {
            return SqlUtil.getAliasedSignature(op, opName, Arrays.asList(typeName, typeName, "..."));
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add(this.firstOperandTypeName);
        types.addAll(Collections.nCopies(this.nOperands - 1, typeName));
        return SqlUtil.getAliasedSignature(op, opName, types);
    }
}

