/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.table.api.CatalogAlreadyExistException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.FlinkTempTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ReadableCatalog;
import org.apache.flink.table.plan.schema.CatalogCalciteTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogCalciteSchema
implements Schema {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatalogCalciteSchema.class);
    private final String catalogName;
    private final ReadableCatalog catalog;

    public CatalogCalciteSchema(String catalogName, ReadableCatalog catalog) {
        this.catalogName = catalogName;
        this.catalog = catalog;
    }

    @Override
    public Schema getSubSchema(String schemaName) {
        if (this.catalog.dbExists(schemaName)) {
            return new DatabaseCalciteSchema(schemaName, this.catalog);
        }
        LOGGER.warn(String.format("Schema %s does not exist in catalog %s", schemaName, this.catalogName));
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return new HashSet<String>(this.catalog.listDatabases());
    }

    @Override
    public Table getTable(String name) {
        return null;
    }

    @Override
    public Set<String> getTableNames() {
        return new HashSet<String>();
    }

    @Override
    public RelProtoDataType getType(final String name) {
        return new RelProtoDataType(){

            @Override
            public RelDataType apply(RelDataTypeFactory relDataTypeFactory) {
                return relDataTypeFactory.createSqlType(SqlTypeName.valueOf(name));
            }
        };
    }

    @Override
    public Set<String> getTypeNames() {
        return new HashSet<String>();
    }

    @Override
    public Collection<Function> getFunctions(String s) {
        return new HashSet<Function>();
    }

    @Override
    public Set<String> getFunctionNames() {
        return new HashSet<String>();
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Schemas.subSchemaExpression(parentSchema, name, this.getClass());
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Schema snapshot(SchemaVersion schemaVersion) {
        return this;
    }

    public static void registerCatalog(SchemaPlus parentSchema, String catalogName, ReadableCatalog catalog) {
        LOGGER.info("Register catalog '{}' to Calcite", (Object)catalogName);
        SchemaPlus catalogSchema = parentSchema.getSubSchema(catalogName);
        if (catalogSchema != null) {
            throw new CatalogAlreadyExistException(catalogName);
        }
        CatalogCalciteSchema newCatalog = new CatalogCalciteSchema(catalogName, catalog);
        parentSchema.add(catalogName, newCatalog);
    }

    private class DatabaseCalciteSchema
    implements Schema {
        private final String dbName;
        private final ReadableCatalog catalog;

        public DatabaseCalciteSchema(String dbName, ReadableCatalog catalog) {
            this.dbName = dbName;
            this.catalog = catalog;
        }

        @Override
        public Table getTable(String tableName) {
            LOGGER.info("Getting table '{}' from catalog '{}'", (Object)tableName, (Object)CatalogCalciteSchema.this.catalogName);
            ObjectPath tablePath = new ObjectPath(this.dbName, tableName);
            if (this.catalog.tableExists(tablePath)) {
                CatalogTable table = this.catalog.getTable(tablePath);
                LOGGER.info("Successfully got table '{}' from catalog '{}'", (Object)tableName, (Object)CatalogCalciteSchema.this.catalogName);
                if (table instanceof FlinkTempTable) {
                    return ((FlinkTempTable)table).getAbstractTable();
                }
                return new CatalogCalciteTable(tableName, table);
            }
            LOGGER.warn(String.format("Table %s.%s does not exist in catalog %s", this.dbName, tableName, CatalogCalciteSchema.this.catalogName));
            return null;
        }

        @Override
        public Set<String> getTableNames() {
            return this.catalog.listTables(this.dbName).stream().map(op -> op.getObjectName()).collect(Collectors.toSet());
        }

        @Override
        public RelProtoDataType getType(final String name) {
            return new RelProtoDataType(){

                @Override
                public RelDataType apply(RelDataTypeFactory relDataTypeFactory) {
                    return relDataTypeFactory.createSqlType(SqlTypeName.valueOf(name));
                }
            };
        }

        @Override
        public Set<String> getTypeNames() {
            return new HashSet<String>();
        }

        @Override
        public Collection<Function> getFunctions(String s) {
            return new HashSet<Function>();
        }

        @Override
        public Set<String> getFunctionNames() {
            return new HashSet<String>();
        }

        @Override
        public Schema getSubSchema(String s) {
            return null;
        }

        @Override
        public Set<String> getSubSchemaNames() {
            return new HashSet<String>();
        }

        @Override
        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return Schemas.subSchemaExpression(parentSchema, name, this.getClass());
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public Schema snapshot(SchemaVersion schemaVersion) {
            return this;
        }
    }
}

