/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.flink.table.api.CatalogAlreadyExistException;
import org.apache.flink.table.api.CatalogNotExistException;
import org.apache.flink.table.catalog.CatalogCalciteSchema;
import org.apache.flink.table.catalog.FlinkInMemoryCatalog;
import org.apache.flink.table.catalog.ReadableCatalog;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogManager {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogManager.class);
    public static final String BUILTIN_CATALOG_NAME = "builtin";
    private CalciteSchema internalSchema = CalciteSchema.createRootSchema(true, false);
    private SchemaPlus rootSchema = this.internalSchema.plus();
    private Map<String, ReadableCatalog> catalogs;
    private String defaultCatalogName;
    private String defaultDbName;

    public CatalogManager() {
        LOG.info("Initializing CatalogManager");
        this.catalogs = new HashMap<String, ReadableCatalog>();
        FlinkInMemoryCatalog inMemoryCatalog = new FlinkInMemoryCatalog(BUILTIN_CATALOG_NAME);
        this.catalogs.put(BUILTIN_CATALOG_NAME, inMemoryCatalog);
        this.defaultCatalogName = BUILTIN_CATALOG_NAME;
        this.defaultDbName = inMemoryCatalog.getDefaultDatabaseName();
        CatalogCalciteSchema.registerCatalog(this.rootSchema, BUILTIN_CATALOG_NAME, inMemoryCatalog);
    }

    public void registerCatalog(String catalogName, ReadableCatalog catalog) throws CatalogAlreadyExistException {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(catalogName), "catalogName cannot be null or empty");
        Preconditions.checkNotNull(catalog, "catalog cannot be null");
        if (this.catalogs.containsKey(catalogName)) {
            throw new CatalogAlreadyExistException(catalogName);
        }
        this.catalogs.put(catalogName, catalog);
        catalog.open();
        CatalogCalciteSchema.registerCatalog(this.rootSchema, catalogName, catalog);
    }

    public ReadableCatalog getCatalog(String catalogName) throws CatalogNotExistException {
        if (!this.catalogs.keySet().contains(catalogName)) {
            throw new CatalogNotExistException(catalogName);
        }
        return this.catalogs.get(catalogName);
    }

    public Set<String> getCatalogs() {
        return this.catalogs.keySet();
    }

    public void setDefaultCatalog(String catalogName) {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(catalogName), "catalogName cannot be null or empty");
        Preconditions.checkArgument(this.catalogs.keySet().contains(catalogName), String.format("Cannot find registered catalog %s", catalogName));
        if (!this.defaultCatalogName.equals(catalogName)) {
            this.defaultCatalogName = catalogName;
            this.defaultDbName = this.catalogs.get(catalogName).getDefaultDatabaseName();
            LOG.info("Set default catalog as '{}' and default database as '{}'", (Object)this.defaultCatalogName, (Object)this.defaultDbName);
        }
    }

    public ReadableCatalog getDefaultCatalog() {
        return this.catalogs.get(this.defaultCatalogName);
    }

    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    public void setDefaultDatabase(String catalogName, String dbName) {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(catalogName), "catalogName cannot be null or empty");
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(dbName), "dbName cannot be null or empty");
        Preconditions.checkArgument(this.catalogs.containsKey(catalogName), String.format("Cannot find registered catalog %s", catalogName));
        Preconditions.checkArgument(this.catalogs.get(catalogName).listDatabases().contains(dbName), String.format("Cannot find registered database %s", dbName));
        this.defaultCatalogName = catalogName;
        this.defaultDbName = dbName;
        LOG.info("Set default catalog as '{}' and default database as '{}'", (Object)this.defaultCatalogName, (Object)this.defaultDbName);
    }

    public String getDefaultDatabaseName() {
        return this.defaultDbName;
    }

    public SchemaPlus getRootSchema() {
        return this.rootSchema;
    }

    public String[] resolveTableName(String ... paths) {
        return this.resolveTableName(Arrays.asList(paths));
    }

    public String[] resolveTableName(List<String> paths) {
        String tableName;
        String dbName;
        String catalogName;
        Preconditions.checkNotNull(paths, "paths cannot be null");
        Preconditions.checkArgument(paths.size() >= 1 && paths.size() <= 3, "paths length has to be between 1 and 3");
        Preconditions.checkArgument(!paths.stream().anyMatch(p -> StringUtils.isNullOrWhitespaceOnly(p)), "Paths contains null or while-space-only string");
        if (paths.size() == 3) {
            return new String[]{paths.get(0), paths.get(1), paths.get(2)};
        }
        if (paths.size() == 1) {
            catalogName = this.getDefaultCatalogName();
            dbName = this.getDefaultDatabaseName();
            tableName = paths.get(0);
        } else {
            catalogName = this.getDefaultCatalogName();
            dbName = paths.get(0);
            tableName = paths.get(1);
        }
        return new String[]{catalogName, dbName, tableName};
    }

    public String resolveTableNameAsString(String[] paths) {
        return String.join((CharSequence)".", this.resolveTableName(paths));
    }

    public List<List<String>> getCalciteReaderDefaultPaths(SchemaPlus defaultSchema) {
        ArrayList<List<String>> paths = new ArrayList<List<String>>();
        paths.add(new ArrayList<String>(CalciteSchema.from(defaultSchema).path(this.getDefaultCatalogName())));
        if (this.getDefaultDatabaseName() != null && defaultSchema.getSubSchema(this.getDefaultCatalogName()) != null) {
            paths.add(new ArrayList<String>(CalciteSchema.from(defaultSchema.getSubSchema(this.getDefaultCatalogName())).path(this.getDefaultDatabaseName())));
        }
        return paths;
    }
}

