/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.util.Preconditions;

public class CatalogPartition {
    private final PartitionSpec partitionSpec;
    private final Map<String, String> properties;

    public CatalogPartition(PartitionSpec partitionSpec, Map<String, String> properties) {
        this.partitionSpec = Preconditions.checkNotNull(partitionSpec);
        this.properties = Preconditions.checkNotNull(properties);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public PartitionSpec getPartitionSpec() {
        return this.partitionSpec;
    }

    public CatalogPartition deepCopy() {
        return new CatalogPartition(this.partitionSpec, new HashMap<String, String>(this.properties));
    }

    public String toString() {
        return "CatalogPartition{partitionSpec=" + this.partitionSpec + ", properties=" + this.properties + '}';
    }

    public static PartitionSpec fromStrings(List<String> partitionSpecStrings) {
        HashMap<String, String> map2 = new HashMap<String, String>(partitionSpecStrings.size());
        for (String s : partitionSpecStrings) {
            String[] kv = s.split("=");
            map2.put(kv[0], kv[1]);
        }
        return new PartitionSpec(map2);
    }

    public static class PartitionSpec {
        private final Map<String, String> partitionSpec;

        public PartitionSpec(Map<String, String> partitionSpecs) {
            this.partitionSpec = Collections.unmodifiableMap(partitionSpecs);
        }

        public boolean contains(PartitionSpec that) {
            Preconditions.checkNotNull(that);
            return this.partitionSpec.entrySet().containsAll(that.partitionSpec.entrySet());
        }

        public List<String> getOrderedValues(List<String> partitionKeys) {
            Preconditions.checkNotNull(partitionKeys, "partitionKeys cannot be null");
            int size = Math.min(this.partitionSpec.size(), partitionKeys.size());
            ArrayList<String> values = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                String key = partitionKeys.get(i);
                if (!this.partitionSpec.containsKey(key)) {
                    throw new IllegalArgumentException(String.format("PartitionSpec %s doesn't have key '%s' in the given partition key list %s", this.toString(), key, partitionKeys));
                }
                values.add(this.partitionSpec.get(key));
            }
            return values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionSpec that = (PartitionSpec)o;
            return this.partitionSpec.equals(that.partitionSpec);
        }

        public int hashCode() {
            return Objects.hash(this.partitionSpec);
        }

        public String toString() {
            return "PartitionSpec{" + this.partitionSpec + '}';
        }
    }
}

