/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.RichTableSchema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class CatalogTable {
    private final String tableType;
    private final TableSchema tableSchema;
    private final Map<String, String> properties;
    private RichTableSchema richTableSchema;
    private TableStats tableStats = TableStats.UNKNOWN();
    private String comment;
    private LinkedHashSet<String> partitionColumnNames = new LinkedHashSet();
    private boolean isPartitioned = false;
    private Map<String, RexNode> computedColumns;
    private String rowTimeField = null;
    private long watermarkOffset = -1L;
    private long createTime = System.currentTimeMillis();
    private long lastAccessTime = -1L;

    public CatalogTable(String tableType, TableSchema tableSchema2, TableStats tableStats2, Map<String, String> properties) {
        this.tableType = tableType;
        this.tableSchema = tableSchema2;
        this.tableStats = tableStats2;
        this.properties = properties;
        if (tableSchema2 != null) {
            this.richTableSchema = new RichTableSchema(tableSchema2.getFieldNames(), tableSchema2.getFieldTypes());
        }
    }

    public CatalogTable(String tableType, TableSchema tableSchema2, Map<String, String> properties, RichTableSchema richTableSchema, TableStats tableStats2, String comment, LinkedHashSet<String> partitionColumnNames, boolean isPartitioned, Map<String, RexNode> computedColumns, String rowTimeField, long watermarkOffset, long createTime, long lastAccessTime) {
        if (tableSchema2 != null && partitionColumnNames != null) {
            this.checkPartitionKeys(tableSchema2, partitionColumnNames);
        }
        this.tableType = tableType;
        this.tableSchema = tableSchema2;
        this.properties = properties;
        this.richTableSchema = richTableSchema;
        this.tableStats = tableStats2;
        this.comment = comment;
        this.partitionColumnNames = partitionColumnNames;
        this.isPartitioned = isPartitioned;
        this.computedColumns = computedColumns;
        this.rowTimeField = rowTimeField;
        this.watermarkOffset = watermarkOffset;
        this.createTime = createTime;
        this.lastAccessTime = lastAccessTime;
    }

    private void checkPartitionKeys(TableSchema schema2, LinkedHashSet<String> partitionColumnNames) {
        if (!partitionColumnNames.isEmpty()) {
            String[] colNames = schema2.getFieldNames();
            Object[] expectedPartitionCols = Arrays.copyOfRange(colNames, colNames.length - partitionColumnNames.size(), colNames.length);
            Object[] partitionCols = new String[partitionColumnNames.size()];
            partitionColumnNames.toArray(partitionCols);
            if (!Arrays.equals(expectedPartitionCols, partitionCols)) {
                throw new IllegalArgumentException(String.format("Partition columns %s does not match the last %d columns of TableSchema %s", partitionColumnNames, partitionColumnNames.size(), this.tableSchema.getFieldNames()));
            }
        }
    }

    public String getTableType() {
        return this.tableType;
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public RichTableSchema getRichTableSchema() {
        return this.richTableSchema;
    }

    public TableStats getTableStats() {
        return this.tableStats;
    }

    public String getComment() {
        return this.comment;
    }

    public LinkedHashSet<String> getPartitionColumnNames() {
        return this.partitionColumnNames;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public Map<String, RexNode> getComputedColumns() {
        return this.computedColumns;
    }

    public String getRowTimeField() {
        return this.rowTimeField;
    }

    public long getWatermarkOffset() {
        return this.watermarkOffset;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public CatalogTable deepCopy() {
        return new CatalogTable(this.getTableType(), this.getTableSchema(), new HashMap<String, String>(this.getProperties()), this.getRichTableSchema(), this.getTableStats(), this.getComment(), this.getPartitionColumnNames(), this.isPartitioned(), this.getComputedColumns(), this.getRowTimeField(), this.getWatermarkOffset(), this.getCreateTime(), this.getLastAccessTime());
    }

    public String toString() {
        return "CatalogTable{tableType='" + this.tableType + '\'' + ", tableSchema=" + this.tableSchema + ", tableStats=" + this.tableStats + ", properties=" + this.properties + ", richTableSchema=" + this.richTableSchema + ", comment='" + this.comment + '\'' + ", partitionColumnNames=" + this.partitionColumnNames + ", isPartitioned=" + this.isPartitioned + ", computedColumns=" + this.computedColumns + ", rowTimeField='" + this.rowTimeField + '\'' + ", watermarkOffset=" + this.watermarkOffset + ", createTime=" + this.createTime + ", lastAccessTime=" + this.lastAccessTime + '}';
    }

    public static class Builder {
        private final String tableType;
        private final TableSchema tableSchema;
        private Map<String, String> properties;
        private TableStats tableStats = TableStats.UNKNOWN();

        public Builder(String tableType, TableSchema tableSchema2, Map<String, String> properties) {
            Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(tableType), "tableType cannot be null or empty");
            this.tableType = tableType;
            this.tableSchema = Preconditions.checkNotNull(tableSchema2, "tableSchema cannot be null or empty");
            this.properties = Preconditions.checkNotNull(properties, "properties cannot be null or empty");
        }

        public Builder withTableStats(TableStats tableStats2) {
            this.tableStats = Preconditions.checkNotNull(tableStats2);
            return this;
        }

        public CatalogTable build() {
            return new CatalogTable(this.tableType, this.tableSchema, this.tableStats, this.properties);
        }
    }
}

