/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.table.api.DatabaseAlreadyExistException;
import org.apache.flink.table.api.DatabaseNotExistException;
import org.apache.flink.table.api.FunctionAlreadyExistException;
import org.apache.flink.table.api.FunctionNotExistException;
import org.apache.flink.table.api.TableAlreadyExistException;
import org.apache.flink.table.api.TableNotExistException;
import org.apache.flink.table.api.exceptions.PartitionAlreadyExistException;
import org.apache.flink.table.api.exceptions.PartitionNotExistException;
import org.apache.flink.table.api.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.FlinkCatalogException;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ReadableWritableCatalog;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class FlinkInMemoryCatalog
implements ReadableWritableCatalog {
    public static final String DEFAULT_DB = "default";
    private String defaultDatabaseName = "default";
    private final String catalogName;
    private final Map<String, CatalogDatabase> databases;
    private final Map<ObjectPath, CatalogTable> tables;
    private final Map<ObjectPath, Map<CatalogPartition.PartitionSpec, CatalogPartition>> partitions;
    private final Map<ObjectPath, CatalogFunction> functions;

    public FlinkInMemoryCatalog(String name) {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(name), "name cannot be null or empty");
        this.catalogName = name;
        this.databases = new LinkedHashMap<String, CatalogDatabase>();
        this.databases.put(DEFAULT_DB, new CatalogDatabase());
        this.tables = new LinkedHashMap<ObjectPath, CatalogTable>();
        this.partitions = new LinkedHashMap<ObjectPath, Map<CatalogPartition.PartitionSpec, CatalogPartition>>();
        this.functions = new LinkedHashMap<ObjectPath, CatalogFunction>();
    }

    @Override
    public String getDefaultDatabaseName() {
        return this.defaultDatabaseName;
    }

    @Override
    public void setDefaultDatabaseName(String databaseName) {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(databaseName));
        this.defaultDatabaseName = databaseName;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void createFunction(ObjectPath path, CatalogFunction function, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException {
        if (!this.dbExists(path.getDbName())) {
            throw new DatabaseNotExistException(this.catalogName, path.getDbName());
        }
        if (this.functionExists(path)) {
            if (!ignoreIfExists) {
                throw new FunctionAlreadyExistException(this.catalogName, path.getFullName());
            }
        } else {
            this.functions.put(path, function.deepCopy());
        }
    }

    @Override
    public void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws FunctionNotExistException {
        if (this.functionExists(functionPath)) {
            this.functions.put(functionPath, newFunction.deepCopy());
        } else if (!ignoreIfNotExists) {
            throw new FunctionNotExistException(this.catalogName, functionPath.getFullName());
        }
    }

    @Override
    public void dropFunction(ObjectPath path, boolean ignoreIfNotExists) throws FunctionNotExistException {
        if (this.functionExists(path)) {
            this.functions.remove(path);
        } else if (!ignoreIfNotExists) {
            throw new FunctionNotExistException(this.catalogName, path.getFullName());
        }
    }

    @Override
    public List<ObjectPath> listFunctions(String dbName) throws DatabaseNotExistException {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(dbName), "dbName cannot be null or empty");
        if (!this.dbExists(dbName)) {
            throw new DatabaseNotExistException(this.catalogName, dbName);
        }
        return this.functions.keySet().stream().filter(k -> k.getDbName().equals(dbName)).collect(Collectors.toList());
    }

    @Override
    public CatalogFunction getFunction(ObjectPath path) throws FunctionNotExistException {
        if (!this.functionExists(path)) {
            throw new FunctionNotExistException(this.catalogName, path.getFullName());
        }
        return this.functions.get(path).deepCopy();
    }

    @Override
    public boolean functionExists(ObjectPath path) {
        return this.dbExists(path.getDbName()) && this.functions.containsKey(path);
    }

    @Override
    public void createTable(ObjectPath tableName, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException {
        if (!this.dbExists(tableName.getDbName())) {
            throw new DatabaseNotExistException(this.catalogName, tableName.getDbName());
        }
        if (this.tableExists(tableName)) {
            if (!ignoreIfExists) {
                throw new TableAlreadyExistException(this.catalogName, tableName.getFullName());
            }
        } else {
            this.tables.put(tableName, table.deepCopy());
            if (table.isPartitioned()) {
                this.partitions.put(tableName, new LinkedHashMap());
            }
        }
    }

    @Override
    public void alterTable(ObjectPath tableName, CatalogTable newTable, boolean ignoreIfNotExists) throws TableNotExistException {
        if (this.tableExists(tableName)) {
            this.tables.put(tableName, newTable.deepCopy());
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.catalogName, tableName.getFullName());
        }
    }

    @Override
    public void renameTable(ObjectPath tableName, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException {
        if (this.tableExists(tableName)) {
            ObjectPath newPath = new ObjectPath(tableName.getDbName(), newTableName);
            if (this.tableExists(newPath)) {
                throw new TableAlreadyExistException(this.catalogName, newPath.getFullName());
            }
            this.tables.put(newPath, this.tables.remove(tableName));
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.catalogName, tableName.getFullName());
        }
    }

    @Override
    public void dropTable(ObjectPath path, boolean ignoreIfNotExists) throws TableNotExistException {
        if (this.tableExists(path)) {
            this.tables.remove(path);
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.catalogName, path.getFullName());
        }
    }

    @Override
    public List<ObjectPath> listTables(String dbName) throws DatabaseNotExistException {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(dbName), "dbName cannot be null or empty");
        if (!this.dbExists(dbName)) {
            throw new DatabaseNotExistException(this.catalogName, dbName);
        }
        return this.tables.keySet().stream().filter(k -> k.getDbName().equals(dbName)).collect(Collectors.toList());
    }

    @Override
    public List<ObjectPath> listAllTables() {
        return new ArrayList<ObjectPath>(this.tables.keySet());
    }

    @Override
    public CatalogTable getTable(ObjectPath tableName) throws TableNotExistException {
        if (!this.tableExists(tableName)) {
            throw new TableNotExistException(this.catalogName, tableName.getFullName());
        }
        return this.tables.get(tableName).deepCopy();
    }

    @Override
    public boolean tableExists(ObjectPath path) {
        return this.dbExists(path.getDbName()) && this.tables.containsKey(path);
    }

    @Override
    public List<ObjectPath> listViews(String dbName) throws DatabaseNotExistException {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(dbName), "dbName cannot be null or empty");
        if (!this.dbExists(dbName)) {
            throw new DatabaseNotExistException(this.catalogName, dbName);
        }
        return this.tables.keySet().stream().filter(k -> k.getDbName().equals(dbName)).filter(k -> this.tables.get(k) instanceof CatalogView).collect(Collectors.toList());
    }

    @Override
    public void createView(ObjectPath viewPath, CatalogView view, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException {
        this.createTable(viewPath, view, ignoreIfExists);
    }

    @Override
    public void alterView(ObjectPath viewPath, CatalogView newView, boolean ignoreIfNotExists) throws TableNotExistException {
        this.alterTable(viewPath, newView, ignoreIfNotExists);
    }

    @Override
    public TableStats getTableStats(ObjectPath path) throws TableNotExistException {
        if (!this.tableExists(path)) {
            throw new TableNotExistException(this.catalogName, path.getFullName());
        }
        if (!this.isTablePartitioned(path)) {
            return this.tables.get(path).getTableStats();
        }
        return TableStats.UNKNOWN();
    }

    @Override
    public void alterTableStats(ObjectPath tablePath, TableStats newtTableStats, boolean ignoreIfNotExists) throws TableNotExistException {
        if (this.tableExists(tablePath)) {
            if (!this.isTablePartitioned(tablePath)) {
                CatalogTable oldTable = this.tables.get(tablePath);
                this.tables.put(tablePath, new CatalogTable(oldTable.getTableType(), oldTable.getTableSchema(), oldTable.getProperties(), oldTable.getRichTableSchema(), newtTableStats, oldTable.getComment(), oldTable.getPartitionColumnNames(), oldTable.isPartitioned(), oldTable.getComputedColumns(), oldTable.getRowTimeField(), oldTable.getWatermarkOffset(), oldTable.getCreateTime(), oldTable.getLastAccessTime()));
            }
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.catalogName, tablePath.getFullName());
        }
    }

    @Override
    public void createDatabase(String dbName, CatalogDatabase db, boolean ignoreIfExists) throws DatabaseAlreadyExistException {
        if (this.dbExists(dbName)) {
            if (!ignoreIfExists) {
                throw new DatabaseAlreadyExistException(this.catalogName, dbName);
            }
        } else {
            this.databases.put(dbName, db.deepCopy());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dropDatabase(String dbName, boolean ignoreIfNotExists) throws DatabaseNotExistException {
        if (this.databases.containsKey(dbName)) {
            if (!this.isDatabaseEmpty(dbName)) throw new FlinkCatalogException(String.format("Database %s is not empty, thus cannot be dropped.", dbName));
            this.databases.remove(dbName);
            return;
        } else {
            if (ignoreIfNotExists) return;
            throw new DatabaseNotExistException(this.catalogName, dbName);
        }
    }

    private boolean isDatabaseEmpty(String dbName) {
        return this.tables.keySet().stream().noneMatch(op -> op.getDbName().equals(dbName)) && this.functions.keySet().stream().noneMatch(op -> op.getDbName().equals(dbName));
    }

    @Override
    public void alterDatabase(String dbName, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException {
        if (this.dbExists(dbName)) {
            this.databases.put(dbName, newDatabase.deepCopy());
        } else if (!ignoreIfNotExists) {
            throw new DatabaseNotExistException(this.catalogName, dbName);
        }
    }

    @Override
    public List<String> listDatabases() {
        return new ArrayList<String>(this.databases.keySet());
    }

    @Override
    public CatalogDatabase getDatabase(String dbName) throws DatabaseNotExistException {
        if (!this.dbExists(dbName)) {
            throw new DatabaseNotExistException(this.catalogName, dbName);
        }
        return this.databases.get(dbName).deepCopy();
    }

    @Override
    public boolean dbExists(String dbName) {
        return this.databases.containsKey(dbName);
    }

    @Override
    public void createPartition(ObjectPath path, CatalogPartition partition2, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionAlreadyExistException {
        if (!this.tableExists(path)) {
            throw new TableNotExistException(this.catalogName, path.getFullName());
        }
        if (!this.isTablePartitioned(path)) {
            throw new TableNotPartitionedException(this.catalogName, path);
        }
        if (this.partitionExists(path, partition2.getPartitionSpec())) {
            if (!ignoreIfExists) {
                throw new PartitionAlreadyExistException(this.catalogName, path, partition2.getPartitionSpec());
            }
        } else {
            this.partitions.get(path).put(partition2.getPartitionSpec(), partition2.deepCopy());
        }
    }

    @Override
    public void dropPartition(ObjectPath path, CatalogPartition.PartitionSpec partitionSpec, boolean ignoreIfNotExists) throws TableNotExistException, TableNotPartitionedException, PartitionNotExistException {
        if (!this.tableExists(path)) {
            throw new TableNotExistException(this.catalogName, path.getFullName());
        }
        if (!this.isTablePartitioned(path)) {
            throw new TableNotPartitionedException(this.catalogName, path);
        }
        if (this.partitionExists(path, partitionSpec)) {
            this.partitions.get(path).remove(partitionSpec);
        } else if (!ignoreIfNotExists) {
            throw new PartitionNotExistException(this.catalogName, path, partitionSpec);
        }
    }

    @Override
    public void alterPartition(ObjectPath path, CatalogPartition newPartition, boolean ignoreIfNotExists) throws TableNotExistException, TableNotPartitionedException, PartitionNotExistException {
        if (!this.tableExists(path)) {
            throw new TableNotExistException(this.catalogName, path.getFullName());
        }
        if (!this.isTablePartitioned(path)) {
            throw new TableNotPartitionedException(this.catalogName, path);
        }
        CatalogPartition.PartitionSpec partitionSpec = newPartition.getPartitionSpec();
        if (this.partitionExists(path, partitionSpec)) {
            this.partitions.get(path).put(partitionSpec, newPartition.deepCopy());
        } else if (!ignoreIfNotExists) {
            throw new PartitionNotExistException(this.catalogName, path, partitionSpec);
        }
    }

    @Override
    public List<CatalogPartition.PartitionSpec> listPartitions(ObjectPath path) throws TableNotExistException, TableNotPartitionedException {
        return new ArrayList<CatalogPartition.PartitionSpec>(this.partitions.get(path).keySet());
    }

    @Override
    public List<CatalogPartition.PartitionSpec> listPartitions(ObjectPath path, CatalogPartition.PartitionSpec partitionSpecs) throws TableNotExistException, TableNotPartitionedException {
        return this.partitions.get(path).keySet().stream().filter(ps -> ps.contains(partitionSpecs)).collect(Collectors.toList());
    }

    @Override
    public CatalogPartition getPartition(ObjectPath path, CatalogPartition.PartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, PartitionNotExistException {
        CatalogTable table = this.getTable(path);
        if (!table.isPartitioned()) {
            throw new TableNotPartitionedException(this.catalogName, path);
        }
        if (this.partitions.get(new ObjectPath(path.getDbName(), path.getObjectName())).get(partitionSpec) != null) {
            return this.partitions.get(path).get(partitionSpec).deepCopy();
        }
        throw new PartitionNotExistException(this.catalogName, path, partitionSpec);
    }

    @Override
    public boolean partitionExists(ObjectPath tablePath, CatalogPartition.PartitionSpec partitionSpec) {
        return this.tableExists(tablePath) && this.partitions.get(tablePath).containsKey(partitionSpec);
    }

    private boolean isTablePartitioned(ObjectPath tablePath) throws TableNotExistException {
        return this.getTable(tablePath).isPartitioned();
    }
}

