/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.dataformat.util.BinaryRowUtil;
import org.apache.flink.table.dataformat.util.MultiSegUtil;
import org.apache.flink.table.types.GenericType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.Types;
import org.apache.flink.util.InstantiationUtil;

public class BinaryArray
extends BaseArray {
    private MemorySegment[] segments;
    private int baseOffset;
    private int numElements;
    private int sizeInBytes;
    private int elementOffset;

    public static int calculateHeaderInBytes(int numFields) {
        return 4 + (numFields + 31) / 32 * 4;
    }

    public static int calculateElementSize(InternalType type) {
        if (type.equals(Types.BOOLEAN)) {
            return 1;
        }
        if (type.equals(Types.BYTE)) {
            return 1;
        }
        if (type.equals(Types.SHORT)) {
            return 2;
        }
        if (type.equals(Types.INT)) {
            return 4;
        }
        if (type.equals(Types.FLOAT)) {
            return 4;
        }
        if (type.equals(Types.CHAR)) {
            return 2;
        }
        if (type.equals(Types.DATE)) {
            return 4;
        }
        if (type.equals(Types.TIME)) {
            return 4;
        }
        return 8;
    }

    private void assertIndexIsValid(int ordinal) {
        assert (ordinal >= 0) : "ordinal (" + ordinal + ") should >= 0";
        assert (ordinal < this.numElements) : "ordinal (" + ordinal + ") should < " + this.numElements;
    }

    private int getElementOffset(int ordinal, int elementSize) {
        return this.elementOffset + ordinal * elementSize;
    }

    public MemorySegment[] getSegments() {
        return this.segments;
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int numElements() {
        return this.numElements;
    }

    public void setTotalSize(int sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public void pointTo(MemorySegment segment, int baseOffset, int sizeInBytes) {
        this.pointTo(new MemorySegment[]{segment}, baseOffset, sizeInBytes);
    }

    public void pointTo(MemorySegment[] segments, int baseOffset, int sizeInBytes) {
        int numElements = MultiSegUtil.getInt(segments, baseOffset);
        assert (numElements >= 0) : "numElements (" + numElements + ") should >= 0";
        this.numElements = numElements;
        this.segments = segments;
        this.baseOffset = baseOffset;
        this.sizeInBytes = sizeInBytes;
        this.elementOffset = baseOffset + BinaryArray.calculateHeaderInBytes(this.numElements);
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.bitGet(this.segments, this.baseOffset + 4, pos);
    }

    @Override
    public void setNullAt(int pos) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.bitSet(this.segments, this.baseOffset + 4, pos);
    }

    @Override
    public void setNotNullAt(int pos) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.bitUnSet(this.segments, this.baseOffset + 4, pos);
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getLong(this.segments, this.getElementOffset(pos, 8));
    }

    @Override
    public void setLong(int pos, long value) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.setLong(this.segments, this.getElementOffset(pos, 8), value);
    }

    @Override
    public void setNullLong(int pos) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.bitSet(this.segments, this.baseOffset + 4, pos);
        MultiSegUtil.setLong(this.segments, this.getElementOffset(pos, 8), 0L);
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getInt(this.segments, this.getElementOffset(pos, 4));
    }

    @Override
    public void setInt(int pos, int value) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.setInt(this.segments, this.getElementOffset(pos, 4), value);
    }

    @Override
    public void setNullInt(int pos) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.bitSet(this.segments, this.baseOffset + 4, pos);
        MultiSegUtil.setInt(this.segments, this.getElementOffset(pos, 4), 0);
    }

    @Override
    public BinaryString getBinaryString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = MultiSegUtil.getLong(this.segments, fieldOffset);
        BinaryString ret = new BinaryString();
        BinaryRow.getBinaryStringFromSeg(this.segments, this.baseOffset, fieldOffset, offsetAndSize, ret);
        return ret;
    }

    @Override
    public BinaryString getBinaryString(int pos, BinaryString reuse) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = MultiSegUtil.getLong(this.segments, fieldOffset);
        BinaryRow.getBinaryStringFromSeg(this.segments, this.baseOffset, fieldOffset, offsetAndSize, reuse);
        return reuse;
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            long longVal = MultiSegUtil.getLong(this.segments, this.getElementOffset(pos, 8));
            return Decimal.fromUnscaledLong(precision, scale, longVal);
        }
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = MultiSegUtil.getLong(this.segments, fieldOffset);
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        byte[] bytes = BinaryRowUtil.copy(this.segments, this.baseOffset + offset, size);
        return Decimal.fromUnscaledBytes(precision, scale, bytes);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getBoolean(this.segments, this.getElementOffset(pos, 1));
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.setBoolean(this.segments, this.getElementOffset(pos, 1), value);
    }

    @Override
    public void setNullBoolean(int pos) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.bitSet(this.segments, this.baseOffset + 4, pos);
        MultiSegUtil.setBoolean(this.segments, this.getElementOffset(pos, 1), false);
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getByte(this.segments, this.getElementOffset(pos, 1));
    }

    @Override
    public void setByte(int pos, byte value) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.setByte(this.segments, this.getElementOffset(pos, 1), value);
    }

    @Override
    public void setNullByte(int pos) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.bitSet(this.segments, this.baseOffset + 4, pos);
        MultiSegUtil.setByte(this.segments, this.getElementOffset(pos, 1), (byte)0);
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getShort(this.segments, this.getElementOffset(pos, 2));
    }

    @Override
    public void setShort(int pos, short value) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.setShort(this.segments, this.getElementOffset(pos, 2), value);
    }

    @Override
    public void setNullShort(int pos) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.bitSet(this.segments, this.baseOffset + 4, pos);
        MultiSegUtil.setShort(this.segments, this.getElementOffset(pos, 2), (short)0);
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getFloat(this.segments, this.getElementOffset(pos, 4));
    }

    @Override
    public void setFloat(int pos, float value) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.setFloat(this.segments, this.getElementOffset(pos, 4), value);
    }

    @Override
    public void setNullFloat(int pos) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.bitSet(this.segments, this.baseOffset + 4, pos);
        MultiSegUtil.setFloat(this.segments, this.getElementOffset(pos, 4), 0.0f);
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getDouble(this.segments, this.getElementOffset(pos, 8));
    }

    @Override
    public void setDouble(int pos, double value) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.setDouble(this.segments, this.getElementOffset(pos, 8), value);
    }

    @Override
    public void setNullDouble(int pos) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.bitSet(this.segments, this.baseOffset + 4, pos);
        MultiSegUtil.setDouble(this.segments, this.getElementOffset(pos, 8), 0.0);
    }

    @Override
    public char getChar(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getChar(this.segments, this.getElementOffset(pos, 2));
    }

    @Override
    public void setChar(int pos, char value) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.setChar(this.segments, this.getElementOffset(pos, 2), value);
    }

    @Override
    public void setNullChar(int pos) {
        this.assertIndexIsValid(pos);
        MultiSegUtil.bitSet(this.segments, this.baseOffset + 4, pos);
        MultiSegUtil.setChar(this.segments, this.getElementOffset(pos, 2), '\u0000');
    }

    @Override
    public void setDecimal(int pos, Decimal value, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            if (value == null) {
                this.setNullLong(pos);
            } else {
                this.setLong(pos, value.toUnscaledLong());
            }
        } else {
            int fieldOffset = this.getElementOffset(pos, 8);
            int cursor = (int)(MultiSegUtil.getLong(this.segments, fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            MultiSegUtil.setLong(this.segments, this.baseOffset + cursor, 0L);
            MultiSegUtil.setLong(this.segments, this.baseOffset + cursor + 8, 0L);
            if (value == null) {
                MultiSegUtil.bitSet(this.segments, this.baseOffset + 4, pos);
                MultiSegUtil.setLong(this.segments, fieldOffset, (long)cursor << 32);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                BinaryRowUtil.copyFromBytes(this.segments, this.baseOffset + cursor, bytes, 0, bytes.length);
                this.setLong(pos, (long)cursor << 32 | (long)bytes.length);
            }
        }
    }

    public BinaryArray copy() {
        return this.copy(new BinaryArray());
    }

    public BinaryArray copy(BinaryArray reuse) {
        byte[] bytes = BinaryRowUtil.copy(this.segments, this.baseOffset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap(bytes), 0, this.sizeInBytes);
        return reuse;
    }

    public byte[] getBytes() {
        return MultiSegUtil.getBytes(this.segments, this.baseOffset, this.sizeInBytes);
    }

    @Override
    public boolean[] toBooleanArray() {
        boolean[] values = new boolean[this.numElements];
        BinaryRowUtil.copyToUnsafe(this.segments, this.elementOffset, values, BinaryRowUtil.BOOLEAN_ARRAY_OFFSET, this.numElements);
        return values;
    }

    @Override
    public byte[] toByteArray() {
        byte[] values = new byte[this.numElements];
        BinaryRowUtil.copyToUnsafe(this.segments, this.elementOffset, values, BinaryRowUtil.BYTE_ARRAY_BASE_OFFSET, this.numElements);
        return values;
    }

    @Override
    public short[] toShortArray() {
        short[] values = new short[this.numElements];
        BinaryRowUtil.copyToUnsafe(this.segments, this.elementOffset, values, BinaryRowUtil.SHORT_ARRAY_OFFSET, this.numElements * 2);
        return values;
    }

    @Override
    public int[] toIntArray() {
        int[] values = new int[this.numElements];
        BinaryRowUtil.copyToUnsafe(this.segments, this.elementOffset, values, BinaryRowUtil.INT_ARRAY_OFFSET, this.numElements * 4);
        return values;
    }

    @Override
    public long[] toLongArray() {
        long[] values = new long[this.numElements];
        BinaryRowUtil.copyToUnsafe(this.segments, this.elementOffset, values, BinaryRowUtil.LONG_ARRAY_OFFSET, this.numElements * 8);
        return values;
    }

    @Override
    public float[] toFloatArray() {
        float[] values = new float[this.numElements];
        BinaryRowUtil.copyToUnsafe(this.segments, this.elementOffset, values, BinaryRowUtil.FLOAT_ARRAY_OFFSET, this.numElements * 4);
        return values;
    }

    @Override
    public double[] toDoubleArray() {
        double[] values = new double[this.numElements];
        BinaryRowUtil.copyToUnsafe(this.segments, this.elementOffset, values, BinaryRowUtil.DOUBLE_ARRAY_OFFSET, this.numElements * 8);
        return values;
    }

    private static BinaryArray fromPrimitiveArray(Object arr, int offset, int length, int elementSize) {
        long valueRegionInBytes;
        long headerInBytes = BinaryArray.calculateHeaderInBytes(length);
        long totalSize = headerInBytes + (valueRegionInBytes = (long)(elementSize * length));
        if (totalSize > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot convert this array to unsafe format as it's too big.");
        }
        byte[] data = new byte[(int)totalSize];
        BinaryRowUtil.UNSAFE.putInt(data, BinaryRowUtil.BYTE_ARRAY_BASE_OFFSET, length);
        BinaryRowUtil.UNSAFE.copyMemory(arr, offset, data, (long)BinaryRowUtil.BYTE_ARRAY_BASE_OFFSET + headerInBytes, valueRegionInBytes);
        BinaryArray result = new BinaryArray();
        result.pointTo(MemorySegmentFactory.wrap(data), 0, (int)totalSize);
        return result;
    }

    public static BinaryArray fromPrimitiveArray(boolean[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, BinaryRowUtil.BOOLEAN_ARRAY_OFFSET, arr.length, 1);
    }

    public static BinaryArray fromPrimitiveArray(byte[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, BinaryRowUtil.BYTE_ARRAY_BASE_OFFSET, arr.length, 1);
    }

    public static BinaryArray fromPrimitiveArray(short[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, BinaryRowUtil.SHORT_ARRAY_OFFSET, arr.length, 2);
    }

    public static BinaryArray fromPrimitiveArray(int[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, BinaryRowUtil.INT_ARRAY_OFFSET, arr.length, 4);
    }

    public static BinaryArray fromPrimitiveArray(long[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, BinaryRowUtil.LONG_ARRAY_OFFSET, arr.length, 8);
    }

    public static BinaryArray fromPrimitiveArray(float[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, BinaryRowUtil.FLOAT_ARRAY_OFFSET, arr.length, 4);
    }

    public static BinaryArray fromPrimitiveArray(double[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, BinaryRowUtil.DOUBLE_ARRAY_OFFSET, arr.length, 8);
    }

    @Override
    public Object[] toObjectArray(InternalType elementType) {
        int size = this.numElements();
        Object[] values = new Object[size];
        for (int i = 0; i < size; ++i) {
            values[i] = this.isNullAt(i) ? null : TypeGetterSetters.get(this, i, elementType);
        }
        return values;
    }

    @Override
    public <T> T[] toClassArray(InternalType elementType, Class<T> elementClass) {
        int size = this.numElements();
        Object[] values = (Object[])Array.newInstance(elementClass, size);
        for (int i = 0; i < size; ++i) {
            if (this.isNullAt(i)) continue;
            values[i] = TypeGetterSetters.get(this, i, elementType);
        }
        return values;
    }

    @Override
    public byte[] getByteArray(int ordinal) {
        int fieldOffset = this.getElementOffset(ordinal, 8);
        long offsetAndSize = MultiSegUtil.getLong(this.segments, fieldOffset);
        return BinaryRow.getByteArray(this.segments, this.baseOffset, fieldOffset, offsetAndSize);
    }

    @Override
    public BaseRow getBaseRow(int ordinal, int numFields) {
        long offsetAndSize = this.getLong(ordinal);
        return BinaryRow.getBaseRow(this.segments, this.baseOffset, offsetAndSize, numFields);
    }

    @Override
    public BaseArray getBaseArray(int ordinal) {
        long offsetAndSize = this.getLong(ordinal);
        return BinaryRow.getBinaryArray(this.segments, this.baseOffset, offsetAndSize);
    }

    @Override
    public BaseMap getBaseMap(int ordinal) {
        long offsetAndSize = this.getLong(ordinal);
        return BinaryRow.getBinaryMap(this.segments, this.baseOffset, offsetAndSize);
    }

    @Override
    public <T> T getGeneric(int pos, GenericType<T> genericType) {
        return this.getGeneric(pos, genericType.getSerializer());
    }

    @Override
    public <T> T getGeneric(int pos, TypeSerializer<T> serializer) {
        long offsetAndSize = this.getLong(pos);
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        try {
            return InstantiationUtil.deserializeFromByteArray(serializer, BinaryRowUtil.copy(this.segments, this.baseOffset + offset, size));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BinaryArray) {
            BinaryArray other = (BinaryArray)o;
            return this.sizeInBytes == other.sizeInBytes && BinaryRowUtil.equals(this.segments, this.baseOffset, other.segments, other.baseOffset, this.sizeInBytes);
        }
        return false;
    }
}

