/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryWriter;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.util.BitSetUtil;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.table.types.Types;

public class BinaryArrayWriter
extends BinaryWriter {
    private final int nullBitsSizeInBytes;
    private final BinaryArray array;
    private final int numElements;
    private int fixedSize;

    public BinaryArrayWriter(BinaryArray array2, int numElements, int elementSize) {
        this.nullBitsSizeInBytes = BinaryArray.calculateHeaderInBytes(numElements);
        this.cursor = this.fixedSize = BinaryArrayWriter.roundNumberOfBytesToNearestWord(this.nullBitsSizeInBytes + elementSize * numElements);
        this.numElements = numElements;
        this.segment = MemorySegmentFactory.wrap(new byte[this.fixedSize]);
        this.segment.putInt(0, numElements);
        this.array = array2;
    }

    public void reset() {
        this.cursor = this.fixedSize;
        for (int i = 0; i < this.nullBitsSizeInBytes; i += 8) {
            this.segment.putLong(i, 0L);
        }
        this.segment.putInt(0, this.numElements);
    }

    public int getNumElements() {
        return this.numElements;
    }

    private void setNullBit(int ordinal) {
        BitSetUtil.set(this.segment, 4, ordinal);
    }

    public void setNullBoolean(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.putBoolean(this.getElementOffset(ordinal, 1), false);
    }

    public void setNullByte(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.put(this.getElementOffset(ordinal, 1), (byte)0);
    }

    public void setNullShort(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.putShort(this.getElementOffset(ordinal, 2), (short)0);
    }

    public void setNullInt(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.putInt(this.getElementOffset(ordinal, 4), 0);
    }

    public void setNullLong(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.putLong(this.getElementOffset(ordinal, 8), 0L);
    }

    public void setNullFloat(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.putFloat(this.getElementOffset(ordinal, 4), 0.0f);
    }

    public void setNullDouble(int ordinal) {
        this.setNullBit(ordinal);
        this.segment.putDouble(this.getElementOffset(ordinal, 8), 0.0);
    }

    public void setNull(int ordinal) {
        this.setNullLong(ordinal);
    }

    private int getElementOffset(int pos, int elementSize) {
        return this.nullBitsSizeInBytes + elementSize * pos;
    }

    @Override
    public int getFieldOffset(int pos) {
        return this.getElementOffset(pos, 8);
    }

    @Override
    public void setOffsetAndSize(int pos, int offset, long size) {
        long offsetAndSize = (long)offset << 32 | size;
        this.segment.putLong(this.getElementOffset(pos, 8), offsetAndSize);
    }

    public void setNullAt(int pos, InternalType type) {
        if (type.equals(Types.BOOLEAN)) {
            this.setNullBoolean(pos);
        } else if (type.equals(Types.BYTE)) {
            this.setNullByte(pos);
        } else if (type.equals(Types.SHORT)) {
            this.setNullShort(pos);
        } else if (type.equals(Types.INT)) {
            this.setNullInt(pos);
        } else if (type.equals(Types.LONG)) {
            this.setNullLong(pos);
        } else if (type.equals(Types.FLOAT)) {
            this.setNullFloat(pos);
        } else if (type.equals(Types.DOUBLE)) {
            this.setNullDouble(pos);
        } else if (type instanceof DateType) {
            this.setNullInt(pos);
        } else if (type.equals(Types.TIME)) {
            this.setNullInt(pos);
        } else if (type instanceof TimestampType) {
            this.setNullLong(pos);
        } else if (type.equals(Types.CHAR)) {
            this.setNullShort(pos);
        } else {
            this.setNull(pos);
        }
    }

    @Override
    public void writeBoolean(int pos, boolean value) {
        this.segment.putBoolean(this.getElementOffset(pos, 1), value);
    }

    @Override
    public void writeByte(int pos, byte value) {
        this.segment.put(this.getElementOffset(pos, 1), value);
    }

    @Override
    public void writeShort(int pos, short value) {
        this.segment.putShort(this.getElementOffset(pos, 2), value);
    }

    @Override
    public void writeInt(int pos, int value) {
        this.segment.putInt(this.getElementOffset(pos, 4), value);
    }

    @Override
    public void writeLong(int pos, long value) {
        this.segment.putLong(this.getElementOffset(pos, 8), value);
    }

    @Override
    public void writeFloat(int pos, float value) {
        if (Float.isNaN(value)) {
            value = Float.NaN;
        }
        this.segment.putFloat(this.getElementOffset(pos, 4), value);
    }

    @Override
    public void writeDouble(int pos, double value) {
        if (Double.isNaN(value)) {
            value = Double.NaN;
        }
        this.segment.putDouble(this.getElementOffset(pos, 8), value);
    }

    @Override
    public void writeChar(int pos, char value) {
        this.segment.putChar(this.getElementOffset(pos, 2), value);
    }

    @Override
    public void writeDecimal(int pos, Decimal value, int precision, int scale) {
        assert (value.getPrecision() == precision && value.getScale() == scale);
        if (Decimal.isCompact(precision)) {
            this.writeLong(pos, value.toUnscaledLong());
        } else {
            byte[] bytes = value.toUnscaledBytes();
            int numBytes = bytes.length;
            assert (numBytes <= 16);
            int roundedSize = BinaryArrayWriter.roundNumberOfBytesToNearestWord(numBytes);
            this.ensureCapacity(roundedSize);
            this.zeroOutPaddingBytes(numBytes);
            this.segment.put(this.cursor, bytes, 0, bytes.length);
            this.setOffsetAndSize(pos, this.cursor, numBytes);
            this.cursor += roundedSize;
        }
    }

    @Override
    public void afterGrow() {
        this.array.pointTo(this.segment, 0, this.segment.size());
    }

    public void complete() {
        this.array.pointTo(this.segment, 0, this.cursor);
    }
}

