/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Hex;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.util.BinaryRowUtil;
import org.apache.flink.table.dataformat.util.MultiSegUtil;
import org.apache.flink.table.runtime.util.StringUtf8Utils;
import org.apache.flink.table.typeutils.BinaryStringTypeFactory;
import org.apache.flink.table.util.hash.Murmur32;
import org.apache.flink.util.Preconditions;

@TypeInfo(value=BinaryStringTypeFactory.class)
public final class BinaryString
implements Comparable<BinaryString>,
Cloneable,
KryoSerializable {
    public static final BinaryString EMPTY_UTF8 = BinaryString.fromString("");
    static final BinaryString[] EMPTY_STRING_ARRAY;
    private MemorySegment[] segments;
    private int offset;
    private int numBytes;
    private String javaString;
    private static final List<BinaryString> TRUE_STRINGS;
    private static final List<BinaryString> FALSE_STRINGS;

    public BinaryString() {
        this.pointTo((MemorySegment[])null, -1, -1, null);
    }

    private BinaryString(String str) {
        this.pointToString(str);
    }

    private BinaryString(MemorySegment[] segments, int offset, int numBytes) {
        this.pointTo(segments, offset, numBytes);
    }

    private BinaryString(MemorySegment[] segments, int offset, int numBytes, String javaString) {
        this.pointTo(segments, offset, numBytes, javaString);
    }

    public void pointTo(byte[] bytes, int offset, int numBytes) {
        this.pointTo(bytes, offset, numBytes, null);
    }

    public void pointTo(byte[] bytes, int offset, int numBytes, String javaString) {
        MemorySegment[] segments = this.segments;
        if (segments != null && segments.length == 1) {
            segments[0].pointTo(bytes);
        } else {
            segments = new MemorySegment[]{MemorySegmentFactory.wrap(bytes)};
        }
        this.pointTo(segments, offset, numBytes, javaString);
    }

    public void pointTo(MemorySegment[] segments, int offset, int numBytes) {
        this.pointTo(segments, offset, numBytes, null);
    }

    private void pointToString(String javaString) {
        this.pointTo((MemorySegment[])null, -1, -1, javaString);
    }

    private void pointTo(MemorySegment[] segments, int offset, int numBytes, String javaString) {
        this.segments = segments;
        this.offset = offset;
        this.numBytes = numBytes;
        this.javaString = javaString;
    }

    public static BinaryString fromAddress(MemorySegment[] segments, int offset, int numBytes) {
        return new BinaryString(segments, offset, numBytes);
    }

    public static BinaryString fromString(String str) {
        if (str == null) {
            return null;
        }
        return BinaryString.fromNonNullString(str);
    }

    private static BinaryString fromNonNullString(String str) {
        return new BinaryString(str);
    }

    public static BinaryString fromString(BinaryString str) {
        return str;
    }

    public static BinaryString fromString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return BinaryString.fromNonNullString((String)obj);
        }
        if (obj instanceof BinaryString) {
            return (BinaryString)obj;
        }
        return BinaryString.fromNonNullString(obj.toString());
    }

    public static BinaryString fromBytes(byte[] bytes) {
        if (bytes != null) {
            return BinaryString.fromBytes(bytes, 0, bytes.length);
        }
        return null;
    }

    public static BinaryString fromBytes(byte[] bytes, int offset, int numBytes) {
        return BinaryString.fromBytes(bytes, offset, numBytes, null);
    }

    public static BinaryString fromBytes(byte[] bytes, int offset, int numBytes, String javaString) {
        return new BinaryString(new MemorySegment[]{MemorySegmentFactory.wrap(bytes)}, offset, numBytes, javaString);
    }

    public static BinaryString blankString(int length) {
        byte[] spaces = new byte[length];
        Arrays.fill(spaces, (byte)32);
        return BinaryString.fromBytes(spaces);
    }

    private static int numBytesForFirstByte(byte b) {
        if (b >= 0) {
            return 1;
        }
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return 2;
        }
        if (b >> 4 == -2) {
            return 3;
        }
        if (b >> 3 == -2) {
            return 4;
        }
        return 1;
    }

    public boolean isSpaceString() {
        if (this.javaString != null) {
            return this.javaString.equals(" ");
        }
        return this.getByte(0) == 32;
    }

    public void ensureEncoded() {
        if (!this.isEncoded()) {
            this.encodeToBytes();
        }
    }

    private void encodeToBytes() {
        if (this.javaString != null) {
            byte[] bytes = StringUtf8Utils.encodeUTF8(this.javaString);
            this.pointTo(bytes, 0, bytes.length, this.javaString);
        }
    }

    public int getOffset() {
        this.ensureEncoded();
        return this.offset;
    }

    public MemorySegment[] getSegments() {
        this.ensureEncoded();
        return this.segments;
    }

    public int numBytes() {
        this.ensureEncoded();
        return this.numBytes;
    }

    public int numChars() {
        this.ensureEncoded();
        if (this.inOneSeg()) {
            int len = 0;
            for (int i = 0; i < this.numBytes; i += BinaryString.numBytesForFirstByte(this.getByteOneSeg(i))) {
                ++len;
            }
            return len;
        }
        return this.numCharsSlow();
    }

    private int numCharsSlow() {
        int len = 0;
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        int i = 0;
        while (i < this.numBytes) {
            int charBytes = BinaryString.numBytesForFirstByte(index.value());
            i += charBytes;
            ++len;
            index.skipBytes(charBytes, segSize);
        }
        return len;
    }

    public byte getByte(int i) {
        this.ensureEncoded();
        int globalOffset = this.offset + i;
        int size = this.segments[0].size();
        if (globalOffset < size) {
            return this.segments[0].get(globalOffset);
        }
        return this.segments[globalOffset / size].get(globalOffset % size);
    }

    private byte getByteOneSeg(int i) {
        return this.segments[0].get(this.offset + i);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof BinaryString) {
            BinaryString other = (BinaryString)o;
            if (this.javaString != null && other.javaString != null) {
                return this.javaString.equals(other.javaString);
            }
            this.ensureEncoded();
            other.ensureEncoded();
            return this.numBytes == other.numBytes && BinaryRowUtil.equals(this.segments, this.offset, other.segments, other.offset, this.numBytes);
        }
        return false;
    }

    @Override
    public int compareTo(BinaryString other) {
        if (this.javaString != null && other.javaString != null) {
            return this.javaString.compareTo(other.javaString);
        }
        this.ensureEncoded();
        other.ensureEncoded();
        if (this.segments.length == 1 && other.segments.length == 1) {
            int len = Math.min(this.numBytes, other.numBytes);
            MemorySegment seg1 = this.segments[0];
            MemorySegment seg2 = other.segments[0];
            for (int i = 0; i < len; ++i) {
                int res = (seg1.get(this.offset + i) & 0xFF) - (seg2.get(other.offset + i) & 0xFF);
                if (res == 0) continue;
                return res;
            }
            return this.numBytes - other.numBytes;
        }
        return this.compareComplex(other);
    }

    private int compareComplex(BinaryString other) {
        int sizeOfFirst1;
        if (this.numBytes == 0 || other.numBytes == 0) {
            return this.numBytes - other.numBytes;
        }
        int len = Math.min(this.numBytes, other.numBytes);
        MemorySegment seg1 = this.segments[0];
        MemorySegment seg2 = other.segments[0];
        int segmentSize = this.segments[0].size();
        int otherSegmentSize = other.segments[0].size();
        int sizeOfFirst2 = otherSegmentSize - other.offset;
        int varSegIndex1 = 1;
        int varSegIndex2 = 1;
        for (sizeOfFirst1 = segmentSize - this.offset; sizeOfFirst1 <= 0; sizeOfFirst1 += segmentSize) {
            seg1 = this.segments[varSegIndex1++];
        }
        while (sizeOfFirst2 <= 0) {
            sizeOfFirst2 += otherSegmentSize;
            seg2 = other.segments[varSegIndex2++];
        }
        int offset1 = segmentSize - sizeOfFirst1;
        int offset2 = otherSegmentSize - sizeOfFirst2;
        int needCompare = Math.min(Math.min(sizeOfFirst1, sizeOfFirst2), len);
        while (needCompare > 0) {
            for (int i = 0; i < needCompare; ++i) {
                int res = (seg1.get(offset1 + i) & 0xFF) - (seg2.get(offset2 + i) & 0xFF);
                if (res == 0) continue;
                return res;
            }
            if (needCompare == len) break;
            len -= needCompare;
            if (sizeOfFirst1 < sizeOfFirst2) {
                seg1 = this.segments[varSegIndex1++];
                offset1 = 0;
                offset2 += needCompare;
                sizeOfFirst1 = segmentSize;
                sizeOfFirst2 -= needCompare;
            } else if (sizeOfFirst1 > sizeOfFirst2) {
                seg2 = other.segments[varSegIndex2++];
                offset2 = 0;
                offset1 += needCompare;
                sizeOfFirst2 = otherSegmentSize;
                sizeOfFirst1 -= needCompare;
            } else {
                seg1 = this.segments[varSegIndex1++];
                seg2 = other.segments[varSegIndex2++];
                offset1 = 0;
                offset2 = 0;
                sizeOfFirst1 = segmentSize;
                sizeOfFirst2 = otherSegmentSize;
            }
            needCompare = Math.min(Math.min(sizeOfFirst1, sizeOfFirst2), len);
        }
        Preconditions.checkArgument(needCompare == len);
        return this.numBytes - other.numBytes;
    }

    public String toString() {
        String str;
        if (this.javaString != null) {
            return this.javaString;
        }
        if (this.segments.length == 1) {
            str = StringUtf8Utils.decodeUTF8(this.segments[0], this.offset, this.numBytes);
        } else {
            byte[] bytes = StringUtf8Utils.allocateBytes(this.numBytes);
            this.copyTo(bytes);
            str = StringUtf8Utils.decodeUTF8(bytes, 0, this.numBytes);
        }
        this.javaString = str;
        return str;
    }

    public byte[] getBytes() {
        this.ensureEncoded();
        return MultiSegUtil.getBytes(this.segments, this.offset, this.numBytes);
    }

    public int hashCode() {
        this.ensureEncoded();
        if (this.segments.length == 1) {
            return Murmur32.hashBytes(this.segments[0], this.offset, this.numBytes, 42);
        }
        return this.hashSlow();
    }

    private int hashSlow() {
        return Murmur32.hashBytes(MemorySegmentFactory.wrap(this.getBytes()), 0, this.numBytes, 42);
    }

    public long hash64() {
        this.ensureEncoded();
        if (this.segments.length == 1) {
            return Murmur32.hash64(this.segments[0], this.offset, this.numBytes, 42);
        }
        return this.hash64Slow();
    }

    private long hash64Slow() {
        return Murmur32.hash64(MemorySegmentFactory.wrap(this.getBytes()), 0, this.numBytes, 42);
    }

    public BinaryString copy() {
        if (this.segments == null) {
            return new BinaryString(this.javaString);
        }
        byte[] copy2 = BinaryRowUtil.copy(this.segments, this.offset, this.numBytes);
        return BinaryString.fromBytes(copy2, 0, copy2.length, this.javaString);
    }

    public BinaryString copy(BinaryString reuse) {
        if (this.segments == null) {
            reuse.pointToString(this.javaString);
        } else {
            byte[] copy2 = BinaryRowUtil.copy(this.segments, this.offset, this.numBytes);
            reuse.pointTo(copy2, 0, copy2.length, this.javaString);
        }
        return reuse;
    }

    public BinaryString cloneReference() {
        if (this.segments == null) {
            return new BinaryString(this.javaString);
        }
        MemorySegment[] cloneSegs = new MemorySegment[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            cloneSegs[i] = this.segments[i].cloneReference();
        }
        return new BinaryString(cloneSegs, this.offset, this.numBytes, this.javaString);
    }

    public boolean isEncoded() {
        return this.segments != null;
    }

    public void copyTo(byte[] bytes) {
        this.ensureEncoded();
        BinaryRowUtil.copy(this.segments, this.offset, bytes, 0, this.numBytes);
    }

    public void write(Kryo kryo, Output output2) {
        this.ensureEncoded();
        byte[] copy2 = BinaryRowUtil.copy(this.segments, this.offset, this.numBytes);
        output2.writeInt(this.numBytes);
        output2.writeBytes(copy2);
    }

    public void read(Kryo kryo, Input input) {
        int numBytes = input.readInt();
        byte[] bytes = input.readBytes(numBytes);
        this.pointTo(bytes, 0, numBytes);
    }

    public static String safeToString(BinaryString str) {
        if (str == null) {
            return null;
        }
        return str.toString();
    }

    private boolean inOneSeg() {
        return this.numBytes + this.offset <= this.segments[0].size();
    }

    public BinaryString substringSQL(int pos) {
        return this.substringSQL(pos, Integer.MAX_VALUE);
    }

    public BinaryString substringSQL(int pos, int length) {
        int start;
        if (length < 0) {
            return null;
        }
        this.ensureEncoded();
        if (this.equals(EMPTY_UTF8)) {
            return EMPTY_UTF8;
        }
        int numChars = this.numChars();
        if (pos > 0) {
            start = pos - 1;
            if (start >= numChars) {
                return EMPTY_UTF8;
            }
        } else if (pos < 0) {
            start = numChars + pos;
            if (start < 0) {
                return EMPTY_UTF8;
            }
        } else {
            start = 0;
        }
        int end = numChars - start < length ? numChars : start + length;
        return this.substring(start, end);
    }

    public BinaryString substring(int start, int until) {
        this.ensureEncoded();
        if (until <= start || start >= this.numBytes()) {
            return EMPTY_UTF8;
        }
        if (this.inOneSeg()) {
            int c;
            MemorySegment segment = this.segments[0];
            int i = 0;
            for (c = 0; i < this.numBytes && c < start; i += BinaryString.numBytesForFirstByte(segment.get(i + this.offset)), ++c) {
            }
            int j2 = i;
            while (i < this.numBytes && c < until) {
                i += BinaryString.numBytesForFirstByte(segment.get(i + this.offset));
                ++c;
            }
            if (i > j2) {
                byte[] bytes = new byte[i - j2];
                segment.get(this.offset + j2, bytes, 0, i - j2);
                return BinaryString.fromBytes(bytes);
            }
            return EMPTY_UTF8;
        }
        return this.substringSlow(start, until);
    }

    private BinaryString substringSlow(int start, int until) {
        int c;
        int charSize;
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        int i = 0;
        for (c = 0; i < this.numBytes && c < start; i += charSize, ++c) {
            charSize = BinaryString.numBytesForFirstByte(index.value());
            index.skipBytes(charSize, segSize);
        }
        int j2 = i;
        while (i < this.numBytes && c < until) {
            int charSize2 = BinaryString.numBytesForFirstByte(index.value());
            i += charSize2;
            index.skipBytes(charSize2, segSize);
            ++c;
        }
        if (i > j2) {
            return BinaryString.fromBytes(BinaryRowUtil.copy(this.segments, this.offset + j2, i - j2));
        }
        return EMPTY_UTF8;
    }

    public static BinaryString concat(BinaryString ... inputs) {
        return BinaryString.concat(Arrays.asList(inputs));
    }

    public static BinaryString concat(Iterable<BinaryString> inputs) {
        int totalLength = 0;
        for (BinaryString input : inputs) {
            if (input == null) continue;
            input.ensureEncoded();
            totalLength += input.numBytes();
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (BinaryString input : inputs) {
            if (input == null) continue;
            int len = input.numBytes;
            BinaryRowUtil.copy(input.segments, input.offset, result, offset, len);
            offset += len;
        }
        return BinaryString.fromBytes(result);
    }

    public static BinaryString concatWs(BinaryString separator, BinaryString ... inputs) {
        return BinaryString.concatWs(separator, Arrays.asList(inputs));
    }

    public static BinaryString concatWs(BinaryString separator, Iterable<BinaryString> inputs) {
        if (null == separator || EMPTY_UTF8.equals(separator)) {
            return BinaryString.concat(inputs);
        }
        separator.ensureEncoded();
        int numInputBytes = 0;
        int numInputs = 0;
        for (BinaryString input : inputs) {
            if (input == null) continue;
            input.ensureEncoded();
            numInputBytes += input.numBytes;
            ++numInputs;
        }
        if (numInputs == 0) {
            return EMPTY_UTF8;
        }
        byte[] result = new byte[numInputBytes + (numInputs - 1) * separator.numBytes];
        int offset = 0;
        int j2 = 0;
        for (BinaryString input : inputs) {
            if (input == null) continue;
            int len = input.numBytes;
            BinaryRowUtil.copy(input.segments, input.offset, result, offset, len);
            offset += len;
            if (++j2 >= numInputs) continue;
            BinaryRowUtil.copy(separator.segments, separator.offset, result, offset, separator.numBytes);
            offset += separator.numBytes;
        }
        return BinaryString.fromBytes(result);
    }

    public boolean contains(BinaryString substring) {
        this.ensureEncoded();
        substring.ensureEncoded();
        if (substring.numBytes == 0) {
            return true;
        }
        int find = BinaryRowUtil.find(this.segments, this.offset, this.numBytes, substring.segments, substring.offset, substring.numBytes);
        return find != -1;
    }

    private boolean matchAt(BinaryString s, int pos) {
        return this.inOneSeg() && s.inOneSeg() ? this.matchAtOneSeg(s, pos) : this.matchAtVarSeg(s, pos);
    }

    private boolean matchAtOneSeg(BinaryString s, int pos) {
        return s.numBytes + pos <= this.numBytes && pos >= 0 && this.segments[0].equalTo(s.segments[0], this.offset + pos, s.offset, s.numBytes);
    }

    private boolean matchAtVarSeg(BinaryString s, int pos) {
        return s.numBytes + pos <= this.numBytes && pos >= 0 && BinaryRowUtil.equalsSlow(this.segments, this.offset + pos, s.segments, s.offset, s.numBytes);
    }

    public boolean startsWith(BinaryString prefix) {
        this.ensureEncoded();
        prefix.ensureEncoded();
        return this.matchAt(prefix, 0);
    }

    public boolean endsWith(BinaryString suffix) {
        this.ensureEncoded();
        suffix.ensureEncoded();
        return this.matchAt(suffix, this.numBytes - suffix.numBytes);
    }

    private BinaryString copyBinaryStringInOneSeg(int start, int end) {
        int len = end - start + 1;
        byte[] newBytes = new byte[len];
        this.segments[0].get(this.offset + start, newBytes, 0, len);
        return BinaryString.fromBytes(newBytes);
    }

    private BinaryString copyBinaryString(int start, int end) {
        int len = end - start + 1;
        byte[] newBytes = new byte[len];
        BinaryRowUtil.copy(this.segments, this.offset + start, newBytes, 0, len);
        return BinaryString.fromBytes(newBytes);
    }

    public BinaryString trim() {
        this.ensureEncoded();
        if (this.inOneSeg()) {
            int s;
            int e2 = this.numBytes - 1;
            for (s = 0; s < this.numBytes && this.getByteOneSeg(s) == 32; ++s) {
            }
            while (e2 >= s && this.getByteOneSeg(e2) == 32) {
                --e2;
            }
            if (s > e2) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(s, e2);
        }
        return this.trimSlow();
    }

    private BinaryString trimSlow() {
        int s;
        int e2 = this.numBytes - 1;
        int segSize = this.segments[0].size();
        SegmentAndOffset front = this.firstSegmentAndOffset(segSize);
        for (s = 0; s < this.numBytes && front.value() == 32; ++s) {
            front.nextByte(segSize);
        }
        SegmentAndOffset behind = this.lastSegmentAndOffset(segSize);
        while (e2 >= s && behind.value() == 32) {
            --e2;
            behind.previousByte(segSize);
        }
        if (s > e2) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(s, e2);
    }

    public BinaryString trim(BinaryString trimStr) {
        if (trimStr == null) {
            return null;
        }
        return this.trimLeft(trimStr).trimRight(trimStr);
    }

    public BinaryString trimLeft() {
        this.ensureEncoded();
        if (this.inOneSeg()) {
            int s;
            for (s = 0; s < this.numBytes && this.getByteOneSeg(s) == 32; ++s) {
            }
            if (s == this.numBytes) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(s, this.numBytes - 1);
        }
        return this.trimLeftSlow();
    }

    private BinaryString trimLeftSlow() {
        int s;
        int segSize = this.segments[0].size();
        SegmentAndOffset front = this.firstSegmentAndOffset(segSize);
        for (s = 0; s < this.numBytes && front.value() == 32; ++s) {
            front.nextByte(segSize);
        }
        if (s == this.numBytes) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(s, this.numBytes - 1);
    }

    public BinaryString trimLeft(BinaryString trimStr) {
        this.ensureEncoded();
        if (trimStr == null) {
            return null;
        }
        trimStr.ensureEncoded();
        if (trimStr.isSpaceString()) {
            return this.trimLeft();
        }
        if (this.inOneSeg()) {
            BinaryString currentChar;
            int searchIdx;
            int charBytes;
            for (searchIdx = 0; searchIdx < this.numBytes && trimStr.contains(currentChar = this.copyBinaryStringInOneSeg(searchIdx, searchIdx + (charBytes = BinaryString.numBytesForFirstByte(this.getByteOneSeg(searchIdx))) - 1)); searchIdx += charBytes) {
            }
            if (searchIdx >= this.numBytes) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(searchIdx, this.numBytes - 1);
        }
        return this.trimLeftSlow(trimStr);
    }

    private BinaryString trimLeftSlow(BinaryString trimStr) {
        BinaryString currentChar;
        int searchIdx;
        int charBytes;
        int segSize = this.segments[0].size();
        SegmentAndOffset front = this.firstSegmentAndOffset(segSize);
        for (searchIdx = 0; searchIdx < this.numBytes && trimStr.contains(currentChar = this.copyBinaryString(searchIdx, searchIdx + (charBytes = BinaryString.numBytesForFirstByte(front.value())) - 1)); searchIdx += charBytes) {
            front.skipBytes(charBytes, segSize);
        }
        if (searchIdx == this.numBytes) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(searchIdx, this.numBytes - 1);
    }

    public BinaryString trimRight() {
        this.ensureEncoded();
        if (this.inOneSeg()) {
            int e2;
            for (e2 = this.numBytes - 1; e2 >= 0 && this.getByteOneSeg(e2) == 32; --e2) {
            }
            if (e2 < 0) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(0, e2);
        }
        return this.trimRightSlow();
    }

    private BinaryString trimRightSlow() {
        int e2;
        int segSize = this.segments[0].size();
        SegmentAndOffset behind = this.lastSegmentAndOffset(segSize);
        for (e2 = this.numBytes - 1; e2 >= 0 && behind.value() == 32; --e2) {
            behind.previousByte(segSize);
        }
        if (e2 < 0) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(0, e2);
    }

    public BinaryString trimRight(BinaryString trimStr) {
        this.ensureEncoded();
        if (trimStr == null) {
            return null;
        }
        trimStr.ensureEncoded();
        if (trimStr.isSpaceString()) {
            return this.trimRight();
        }
        if (this.inOneSeg()) {
            BinaryString currentChar;
            int charIdx = 0;
            int byteIdx = 0;
            int[] charLens = new int[this.numBytes];
            int[] charStartPos = new int[this.numBytes];
            while (byteIdx < this.numBytes) {
                charStartPos[charIdx] = byteIdx;
                charLens[charIdx] = BinaryString.numBytesForFirstByte(this.getByteOneSeg(byteIdx));
                byteIdx += charLens[charIdx];
                ++charIdx;
            }
            int searchIdx = this.numBytes - 1;
            --charIdx;
            while (charIdx >= 0 && trimStr.contains(currentChar = this.copyBinaryStringInOneSeg(charStartPos[charIdx], charStartPos[charIdx] + charLens[charIdx] - 1))) {
                searchIdx -= charLens[charIdx];
                --charIdx;
            }
            if (searchIdx < 0) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(0, searchIdx);
        }
        return this.trimRightSlow(trimStr);
    }

    private BinaryString trimRightSlow(BinaryString trimStr) {
        BinaryString currentChar;
        int charIdx = 0;
        int byteIdx = 0;
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        int[] charLens = new int[this.numBytes];
        int[] charStartPos = new int[this.numBytes];
        while (byteIdx < this.numBytes) {
            int charBytes;
            charStartPos[charIdx] = byteIdx;
            charLens[charIdx] = charBytes = BinaryString.numBytesForFirstByte(index.value());
            byteIdx += charBytes;
            ++charIdx;
            index.skipBytes(charBytes, segSize);
        }
        int searchIdx = this.numBytes - 1;
        --charIdx;
        while (charIdx >= 0 && trimStr.contains(currentChar = this.copyBinaryString(charStartPos[charIdx], charStartPos[charIdx] + charLens[charIdx] - 1))) {
            searchIdx -= charLens[charIdx];
            --charIdx;
        }
        if (searchIdx < 0) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(0, searchIdx);
    }

    public BinaryString trim(boolean leading, boolean trailing, BinaryString seek) {
        this.ensureEncoded();
        if (seek == null) {
            return null;
        }
        if (leading && trailing) {
            return this.trim(seek);
        }
        if (leading) {
            return this.trimLeft(seek);
        }
        if (trailing) {
            return this.trimRight(seek);
        }
        return this;
    }

    public BinaryString keyValue(byte split1, byte split2, BinaryString keyName) {
        this.ensureEncoded();
        if (keyName == null || keyName.numBytes() == 0) {
            return null;
        }
        if (this.inOneSeg() && keyName.inOneSeg()) {
            BinaryString value;
            int currentKeyIdx;
            int lastSplit1Idx = -1;
            for (int byteIdx = 0; byteIdx < this.numBytes; ++byteIdx) {
                if (this.segments[0].get(this.offset + byteIdx) != split1) continue;
                currentKeyIdx = lastSplit1Idx + 1;
                value = this.findValueOfKey(split2, keyName, currentKeyIdx, byteIdx);
                if (value != null) {
                    return value;
                }
                lastSplit1Idx = byteIdx;
            }
            currentKeyIdx = lastSplit1Idx + 1;
            value = this.findValueOfKey(split2, keyName, currentKeyIdx, this.numBytes);
            return value;
        }
        return this.keyValueSlow(split1, split2, keyName);
    }

    private BinaryString findValueOfKey(byte split, BinaryString keyName, int start, int end) {
        int keyNameLen = keyName.numBytes;
        for (int idx = start; idx < end; ++idx) {
            if (this.segments[0].get(this.offset + idx) != split) continue;
            if (idx == start + keyNameLen && this.segments[0].equalTo(keyName.segments[0], this.offset + start, keyName.offset, keyNameLen)) {
                int valueIdx = idx + 1;
                int valueLen = end - valueIdx;
                byte[] bytes = new byte[valueLen];
                this.segments[0].get(this.offset + valueIdx, bytes, 0, valueLen);
                return BinaryString.fromBytes(bytes, 0, valueLen);
            }
            return null;
        }
        return null;
    }

    private BinaryString keyValueSlow(byte split1, byte split2, BinaryString keyName) {
        BinaryString value;
        int currentKeyIdx;
        int lastSplit1Idx = -1;
        for (int byteIdx = 0; byteIdx < this.numBytes; ++byteIdx) {
            if (this.getByte(byteIdx) != split1) continue;
            currentKeyIdx = lastSplit1Idx + 1;
            value = this.findValueOfKeySlow(split2, keyName, currentKeyIdx, byteIdx);
            if (value != null) {
                return value;
            }
            lastSplit1Idx = byteIdx;
        }
        currentKeyIdx = lastSplit1Idx + 1;
        value = this.findValueOfKeySlow(split2, keyName, currentKeyIdx, this.numBytes);
        return value;
    }

    private BinaryString findValueOfKeySlow(byte split, BinaryString keyName, int start, int end) {
        int keyNameLen = keyName.numBytes;
        for (int idx = start; idx < end; ++idx) {
            if (this.getByte(idx) != split) continue;
            if (idx == start + keyNameLen && BinaryRowUtil.equals(this.segments, this.offset + start, keyName.segments, keyName.offset, keyNameLen)) {
                int valueIdx = idx + 1;
                byte[] bytes = BinaryRowUtil.copy(this.segments, this.offset + valueIdx, end - valueIdx);
                return BinaryString.fromBytes(bytes);
            }
            return null;
        }
        return null;
    }

    public int indexOf(BinaryString subStr, int start) {
        this.ensureEncoded();
        subStr.ensureEncoded();
        if (subStr.numBytes == 0) {
            return 0;
        }
        if (this.inOneSeg()) {
            int charIdx;
            int byteIdx = 0;
            for (charIdx = 0; byteIdx < this.numBytes && charIdx < start; byteIdx += BinaryString.numBytesForFirstByte(this.getByteOneSeg(byteIdx)), ++charIdx) {
            }
            do {
                if (byteIdx + subStr.numBytes > this.numBytes) {
                    return -1;
                }
                if (BinaryRowUtil.equals(this.segments, this.offset + byteIdx, subStr.segments, subStr.offset, subStr.numBytes)) {
                    return charIdx;
                }
                byteIdx += BinaryString.numBytesForFirstByte(this.getByteOneSeg(byteIdx));
                ++charIdx;
            } while (byteIdx < this.numBytes);
            return -1;
        }
        return this.indexOfSlow(subStr, start);
    }

    private int indexOfSlow(BinaryString subStr, int start) {
        int charIdx;
        int charBytes;
        int byteIdx = 0;
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        for (charIdx = 0; byteIdx < this.numBytes && charIdx < start; byteIdx += charBytes, ++charIdx) {
            charBytes = BinaryString.numBytesForFirstByte(index.value());
            index.skipBytes(charBytes, segSize);
        }
        do {
            if (byteIdx + subStr.numBytes > this.numBytes) {
                return -1;
            }
            if (BinaryRowUtil.equals(this.segments, this.offset + byteIdx, subStr.segments, subStr.offset, subStr.numBytes)) {
                return charIdx;
            }
            charBytes = BinaryString.numBytesForFirstByte(index.segment.get(index.offset));
            ++charIdx;
            index.skipBytes(charBytes, segSize);
        } while ((byteIdx += charBytes) < this.numBytes);
        return -1;
    }

    public BinaryString reverse() {
        this.ensureEncoded();
        if (this.inOneSeg()) {
            int charBytes;
            byte[] result = new byte[this.numBytes];
            for (int byteIdx = 0; byteIdx < this.numBytes; byteIdx += charBytes) {
                charBytes = BinaryString.numBytesForFirstByte(this.getByteOneSeg(byteIdx));
                this.segments[0].get(this.offset + byteIdx, result, result.length - byteIdx - charBytes, charBytes);
            }
            return BinaryString.fromBytes(result);
        }
        return this.reverseSlow();
    }

    private BinaryString reverseSlow() {
        int charBytes;
        byte[] result = new byte[this.numBytes];
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        for (int byteIdx = 0; byteIdx < this.numBytes; byteIdx += charBytes) {
            charBytes = BinaryString.numBytesForFirstByte(index.value());
            BinaryRowUtil.copySlow(this.segments, this.offset + byteIdx, result, result.length - byteIdx - charBytes, charBytes);
            index.skipBytes(charBytes, segSize);
        }
        return BinaryString.fromBytes(result);
    }

    private SegmentAndOffset firstSegmentAndOffset(int segSize) {
        int segIndex = this.offset / segSize;
        return new SegmentAndOffset(segIndex, this.offset % segSize);
    }

    private SegmentAndOffset lastSegmentAndOffset(int segSize) {
        int lastOffset = this.offset + this.numBytes - 1;
        int segIndex = lastOffset / segSize;
        return new SegmentAndOffset(segIndex, lastOffset % segSize);
    }

    private SegmentAndOffset startSegmentAndOffset(int segSize) {
        if (this.inOneSeg()) {
            return new SegmentAndOffset(0, this.offset);
        }
        return this.firstSegmentAndOffset(segSize);
    }

    public Long toLong() {
        boolean negative;
        this.ensureEncoded();
        if (this.numBytes == 0) {
            return null;
        }
        int size = this.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        int totalOffset = 0;
        byte b = segmentAndOffset.value();
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            segmentAndOffset.nextByte(size);
            ++totalOffset;
            if (this.numBytes == 1) {
                return null;
            }
        }
        long result = 0L;
        int separator = 46;
        int radix = 10;
        long stopValue = -922337203685477580L;
        while (totalOffset < this.numBytes) {
            b = segmentAndOffset.value();
            ++totalOffset;
            segmentAndOffset.nextByte(size);
            if (b == 46) break;
            if (b < 48 || b > 57) {
                return null;
            }
            int digit = b - 48;
            if (result < -922337203685477580L) {
                return null;
            }
            if ((result = result * 10L - (long)digit) <= 0L) continue;
            return null;
        }
        while (totalOffset < this.numBytes) {
            byte currentByte = segmentAndOffset.value();
            if (currentByte < 48 || currentByte > 57) {
                return null;
            }
            ++totalOffset;
            segmentAndOffset.nextByte(size);
        }
        if (!negative && (result = -result) < 0L) {
            return null;
        }
        return result;
    }

    public Integer toInt() {
        boolean negative;
        this.ensureEncoded();
        if (this.numBytes == 0) {
            return null;
        }
        int size = this.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        int totalOffset = 0;
        byte b = segmentAndOffset.value();
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            segmentAndOffset.nextByte(size);
            ++totalOffset;
            if (this.numBytes == 1) {
                return null;
            }
        }
        int result = 0;
        int separator = 46;
        int radix = 10;
        long stopValue = -214748364L;
        while (totalOffset < this.numBytes) {
            b = segmentAndOffset.value();
            ++totalOffset;
            segmentAndOffset.nextByte(size);
            if (b == 46) break;
            if (b < 48 || b > 57) {
                return null;
            }
            int digit = b - 48;
            if ((long)result < -214748364L) {
                return null;
            }
            if ((result = result * 10 - digit) <= 0) continue;
            return null;
        }
        while (totalOffset < this.numBytes) {
            byte currentByte = segmentAndOffset.value();
            if (currentByte < 48 || currentByte > 57) {
                return null;
            }
            ++totalOffset;
            segmentAndOffset.nextByte(size);
        }
        if (!negative && (result = -result) < 0) {
            return null;
        }
        return result;
    }

    public Short toShort() {
        short result;
        Integer intValue = this.toInt();
        if (intValue != null && (result = intValue.shortValue()) == intValue) {
            return result;
        }
        return null;
    }

    public Byte toByte() {
        byte result;
        Integer intValue = this.toInt();
        if (intValue != null && (result = intValue.byteValue()) == intValue) {
            return result;
        }
        return null;
    }

    public Double toDouble() {
        try {
            return Double.valueOf(this.toString());
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    public Float toFloat() {
        try {
            return Float.valueOf(this.toString());
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    public Decimal toDecimal(int precision, int scale) {
        boolean negative;
        int totalOffset;
        this.ensureEncoded();
        if (precision > 18 || this.numBytes > 18) {
            return this.toDecimalSlow(precision, scale);
        }
        int size = this.getSegments()[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        byte b = 0;
        for (totalOffset = 0; totalOffset < this.numBytes && ((b = segmentAndOffset.value()) == 32 || b == 10 || b == 9); ++totalOffset) {
            segmentAndOffset.nextByte(size);
        }
        if (totalOffset == this.numBytes) {
            return null;
        }
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            segmentAndOffset.nextByte(size);
            if (++totalOffset == this.numBytes) {
                return null;
            }
        }
        long significand = 0L;
        int exp = 0;
        int significandLen = 0;
        int pointPos = -1;
        while (totalOffset < this.numBytes) {
            b = segmentAndOffset.value();
            ++totalOffset;
            segmentAndOffset.nextByte(size);
            if (b >= 48 && b <= 57) {
                significand = significand * 10L + (long)(b - 48);
                ++significandLen;
                continue;
            }
            if (b != 46) break;
            if (pointPos >= 0) {
                return null;
            }
            pointPos = significandLen;
        }
        if (pointPos < 0) {
            pointPos = significandLen;
        }
        if (negative) {
            significand = -significand;
        }
        if ((b == 101 || b == 69) && totalOffset < this.numBytes) {
            boolean expNegative;
            b = segmentAndOffset.value();
            boolean bl2 = expNegative = b == 45;
            if (expNegative || b == 43) {
                segmentAndOffset.nextByte(size);
                if (++totalOffset == this.numBytes) {
                    return null;
                }
            }
            int expDigits = 0;
            int expStopValue = 40;
            while (totalOffset < this.numBytes) {
                b = segmentAndOffset.value();
                ++totalOffset;
                segmentAndOffset.nextByte(size);
                if (b < 48 || b > 57) break;
                if (expDigits >= 40) continue;
                expDigits = expDigits * 10 + (b - 48);
            }
            if (expNegative) {
                expDigits = -expDigits;
            }
            exp += expDigits;
        }
        exp -= significandLen - pointPos;
        while (totalOffset < this.numBytes) {
            b = segmentAndOffset.value();
            ++totalOffset;
            segmentAndOffset.nextByte(size);
            if (b == 32 || b == 10 || b == 9) continue;
            return null;
        }
        int change = exp + scale;
        if (significandLen + change > precision) {
            return null;
        }
        if (change >= 0) {
            significand *= Decimal.POW10[change];
        } else {
            int k = negative ? -5 : 5;
            significand = (significand + (long)k * Decimal.POW10[-change - 1]) / Decimal.POW10[-change];
        }
        return Decimal.fromLong(significand, precision, scale);
    }

    private Decimal toDecimalSlow(int precision, int scale) {
        int i;
        int len;
        char[] chars = StringUtf8Utils.allocateChars(this.numBytes);
        if (this.segments.length == 1) {
            len = StringUtf8Utils.decodeUTF8Strict(this.segments[0], this.offset, this.numBytes, chars);
        } else {
            byte[] bytes = StringUtf8Utils.allocateBytes(this.numBytes);
            this.copyTo(bytes);
            len = StringUtf8Utils.decodeUTF8Strict(bytes, 0, this.numBytes, chars);
        }
        if (len < 0) {
            return null;
        }
        int start = 0;
        int end = len;
        for (i = 0; i < len; ++i) {
            if (chars[i] == ' ' || chars[i] == '\n' || chars[i] == '\t') continue;
            start = i;
            break;
        }
        for (i = len - 1; i >= 0; --i) {
            if (chars[i] == ' ' || chars[i] == '\n' || chars[i] == '\t') continue;
            end = i + 1;
            break;
        }
        try {
            BigDecimal bd = new BigDecimal(chars, start, end - start);
            return Decimal.fromBigDecimal(bd, precision, scale);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public BinaryString toUpperCase() {
        if (this.javaString != null) {
            return this.toUpperCaseSlow();
        }
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        int size = this.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        byte[] bytes = new byte[this.numBytes];
        bytes[0] = (byte)Character.toTitleCase(segmentAndOffset.value());
        for (int i = 0; i < this.numBytes; ++i) {
            byte b = segmentAndOffset.value();
            if (BinaryString.numBytesForFirstByte(b) != 1) {
                return this.toUpperCaseSlow();
            }
            int upper = Character.toUpperCase(b);
            if (upper > 127) {
                return this.toUpperCaseSlow();
            }
            bytes[i] = (byte)upper;
            segmentAndOffset.nextByte(size);
        }
        return BinaryString.fromBytes(bytes);
    }

    private BinaryString toUpperCaseSlow() {
        return BinaryString.fromString(this.toString().toUpperCase());
    }

    public BinaryString toLowerCase() {
        if (this.javaString != null) {
            return this.toLowerCaseSlow();
        }
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        int size = this.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        byte[] bytes = new byte[this.numBytes];
        bytes[0] = (byte)Character.toTitleCase(segmentAndOffset.value());
        for (int i = 0; i < this.numBytes; ++i) {
            byte b = segmentAndOffset.value();
            if (BinaryString.numBytesForFirstByte(b) != 1) {
                return this.toLowerCaseSlow();
            }
            int lower = Character.toLowerCase(b);
            if (lower > 127) {
                return this.toLowerCaseSlow();
            }
            bytes[i] = (byte)lower;
            segmentAndOffset.nextByte(size);
        }
        return BinaryString.fromBytes(bytes);
    }

    private BinaryString toLowerCaseSlow() {
        return BinaryString.fromString(this.toString().toLowerCase());
    }

    public BinaryString[] splitByWholeSeparatorPreserveAllTokens(BinaryString separator) {
        this.ensureEncoded();
        int len = this.numBytes;
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        if (separator == null || EMPTY_UTF8.equals(separator)) {
            return this.splitByWholeSeparatorPreserveAllTokens(BinaryString.fromString(" "));
        }
        separator.ensureEncoded();
        int separatorLength = separator.numBytes;
        ArrayList<BinaryString> substrings = new ArrayList<BinaryString>();
        int beg = 0;
        int end = 0;
        while (end < len) {
            end = BinaryRowUtil.find(this.segments, this.offset + beg, this.numBytes - beg, separator.segments, separator.offset, separator.numBytes) - this.offset;
            if (end > -1) {
                if (end > beg) {
                    substrings.add(BinaryString.fromAddress(this.segments, this.offset + beg, end - beg));
                    beg = end + separatorLength;
                    continue;
                }
                substrings.add(EMPTY_UTF8);
                beg = end + separatorLength;
                continue;
            }
            substrings.add(BinaryString.fromAddress(this.segments, this.offset + beg, this.numBytes - beg));
            end = len;
        }
        return substrings.toArray(new BinaryString[substrings.size()]);
    }

    public BinaryString hash(MessageDigest md) {
        return BinaryString.fromString(Hex.encodeHexString((byte[])md.digest(this.getBytes())));
    }

    public BinaryString hash(String algorithm) throws NoSuchAlgorithmException {
        return this.hash(MessageDigest.getInstance(algorithm));
    }

    public Boolean toBooleanSQL() {
        if (TRUE_STRINGS.contains(this.toLowerCase())) {
            return true;
        }
        if (FALSE_STRINGS.contains(this.toLowerCase())) {
            return false;
        }
        return null;
    }

    static {
        EMPTY_UTF8.ensureEncoded();
        EMPTY_STRING_ARRAY = new BinaryString[0];
        TRUE_STRINGS = Stream.of("t", "true", "y", "yes", "1").map(BinaryString::fromString).peek(BinaryString::ensureEncoded).collect(Collectors.toList());
        FALSE_STRINGS = Stream.of("f", "false", "n", "no", "0").map(BinaryString::fromString).peek(BinaryString::ensureEncoded).collect(Collectors.toList());
    }

    private class SegmentAndOffset {
        int segIndex;
        MemorySegment segment;
        int offset;

        private SegmentAndOffset(int segIndex, int offset) {
            this.segIndex = segIndex;
            this.segment = BinaryString.this.segments[segIndex];
            this.offset = offset;
        }

        private void assignSegment() {
            this.segment = this.segIndex >= 0 && this.segIndex < BinaryString.this.segments.length ? BinaryString.this.segments[this.segIndex] : null;
        }

        private void previousByte(int segSize) {
            --this.offset;
            if (this.offset == -1) {
                --this.segIndex;
                this.assignSegment();
                this.offset = segSize - 1;
            }
        }

        private void nextByte(int segSize) {
            ++this.offset;
            this.checkAdvance(segSize);
        }

        private void checkAdvance(int segSize) {
            if (this.offset == segSize) {
                this.advance();
            }
        }

        private void advance() {
            ++this.segIndex;
            this.assignSegment();
            this.offset = 0;
        }

        private void skipBytes(int n, int segSize) {
            int remaining = segSize - this.offset;
            if (remaining > n) {
                this.offset += n;
            } else {
                while (true) {
                    int toSkip;
                    if ((n -= (toSkip = Math.min(remaining, n))) <= 0) {
                        this.offset += toSkip;
                        this.checkAdvance(segSize);
                        return;
                    }
                    this.advance();
                    remaining = segSize - this.offset;
                }
            }
        }

        private byte value() {
            return this.segment.get(this.offset);
        }
    }
}

