/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.vector.VectorizedColumnBatch;
import org.apache.flink.table.runtime.util.StringUtf8Utils;
import org.apache.flink.table.types.GenericType;

public final class ColumnarRow
implements BaseRow {
    private byte header;
    private VectorizedColumnBatch vectorizedColumnBatch;
    private int rowId;

    public ColumnarRow() {
    }

    public ColumnarRow(VectorizedColumnBatch vectorizedColumnBatch) {
        this(vectorizedColumnBatch, 0);
    }

    public ColumnarRow(VectorizedColumnBatch vectorizedColumnBatch, int rowId) {
        this.vectorizedColumnBatch = vectorizedColumnBatch;
        this.rowId = rowId;
    }

    public void setVectorizedColumnBatch(VectorizedColumnBatch vectorizedColumnBatch) {
        this.vectorizedColumnBatch = vectorizedColumnBatch;
    }

    public void setRowId(int rowId) {
        this.rowId = rowId;
    }

    @Override
    public byte getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(byte header) {
        this.header = header;
    }

    @Override
    public int getArity() {
        return this.vectorizedColumnBatch.getArity();
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.vectorizedColumnBatch.isNullAt(this.rowId, ordinal);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return this.vectorizedColumnBatch.getBoolean(this.rowId, ordinal);
    }

    @Override
    public byte getByte(int ordinal) {
        return this.vectorizedColumnBatch.getByte(this.rowId, ordinal);
    }

    @Override
    public short getShort(int ordinal) {
        return this.vectorizedColumnBatch.getShort(this.rowId, ordinal);
    }

    @Override
    public int getInt(int ordinal) {
        return this.vectorizedColumnBatch.getInt(this.rowId, ordinal);
    }

    @Override
    public long getLong(int ordinal) {
        return this.vectorizedColumnBatch.getLong(this.rowId, ordinal);
    }

    @Override
    public float getFloat(int ordinal) {
        return this.vectorizedColumnBatch.getFloat(this.rowId, ordinal);
    }

    @Override
    public double getDouble(int ordinal) {
        return this.vectorizedColumnBatch.getDouble(this.rowId, ordinal);
    }

    @Override
    public char getChar(int ordinal) {
        throw new UnsupportedOperationException("char is not supported.");
    }

    @Override
    public byte[] getByteArray(int ordinal) {
        VectorizedColumnBatch.ByteArray byteArray = this.vectorizedColumnBatch.getByteArray(this.rowId, ordinal);
        if (byteArray.len == byteArray.data.length) {
            return byteArray.data;
        }
        byte[] ret = new byte[byteArray.len];
        System.arraycopy(byteArray.data, byteArray.offset, ret, 0, byteArray.len);
        return ret;
    }

    @Override
    public BinaryString getBinaryString(int ordinal) {
        VectorizedColumnBatch.ByteArray byteArray = this.vectorizedColumnBatch.getByteArray(this.rowId, ordinal);
        MemorySegment memorySegment = MemorySegmentFactory.wrap(byteArray.data);
        return BinaryString.fromAddress(new MemorySegment[]{memorySegment}, byteArray.offset, byteArray.len);
    }

    @Override
    public BinaryString getBinaryString(int ordinal, BinaryString reuse) {
        VectorizedColumnBatch.ByteArray byteArray = this.vectorizedColumnBatch.getByteArray(this.rowId, ordinal);
        reuse.pointTo(byteArray.data, byteArray.offset, byteArray.len);
        return reuse;
    }

    @Override
    public String getString(int ordinal) {
        VectorizedColumnBatch.ByteArray byteArray = this.vectorizedColumnBatch.getByteArray(this.rowId, ordinal);
        return StringUtf8Utils.decodeUTF8(byteArray.data, byteArray.offset, byteArray.len);
    }

    @Override
    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return this.vectorizedColumnBatch.getDecimal(this.rowId, ordinal);
    }

    @Override
    public <T> T getGeneric(int pos, TypeSerializer<T> serializer) {
        throw new UnsupportedOperationException(serializer.toString() + " is not supported.");
    }

    @Override
    public <T> T getGeneric(int pos, GenericType<T> type) {
        throw new UnsupportedOperationException(type.toString() + " is not supported.");
    }

    @Override
    public BaseRow getBaseRow(int ordinal, int numFields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BaseArray getBaseArray(int ordinal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BaseMap getBaseMap(int ordinal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNullAt(int ordinal) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setBoolean(int ordinal, boolean value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setByte(int ordinal, byte value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setShort(int ordinal, short value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setInt(int ordinal, int value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setLong(int ordinal, long value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setFloat(int pos, float value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setDouble(int ordinal, double value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setChar(int ordinal, char value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setDecimal(int ordinal, Decimal value, int precision, int scale) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    private Object internalObject(int ordinal) {
        return this.vectorizedColumnBatch.getInternalObject(this.rowId, ordinal);
    }

    @Override
    public boolean equalsWithoutHeader(BaseRow other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof ColumnarRow)) {
            return false;
        }
        ColumnarRow row2 = (ColumnarRow)other;
        for (int i = 0; i < row2.getArity(); ++i) {
            if (!this.internalObject(i).equals(row2.internalObject(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        return other != null && other instanceof BaseRow && this.equalsWithoutHeader((BaseRow)other) && this.getHeader() == ((BaseRow)other).getHeader();
    }
}

