/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.types.GenericType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.util.Preconditions;

public class GenericArray
extends BaseArray {
    private final Object arr;
    private final int numElements;
    private final boolean isPrimitive;

    public <T> GenericArray(int numElements, boolean isPrimitive, Class<T> eleClass) {
        this.arr = Array.newInstance(eleClass, numElements);
        this.numElements = numElements;
        this.isPrimitive = isPrimitive;
    }

    public GenericArray(Object arr, int numElements, boolean isPrimitive) {
        this.arr = arr;
        this.numElements = numElements;
        this.isPrimitive = isPrimitive;
    }

    @Override
    public int numElements() {
        return this.numElements;
    }

    @Override
    public boolean isNullAt(int pos) {
        return !this.isPrimitive && ((Object[])this.arr)[pos] == null;
    }

    @Override
    public void setNullAt(int pos) {
        Preconditions.checkState(!this.isPrimitive, "Can't set null for primitive array");
        ((Object[])this.arr)[pos] = null;
    }

    @Override
    public void setNotNullAt(int pos) {
    }

    @Override
    public void setNullLong(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullInt(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullBoolean(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullByte(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullShort(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullFloat(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullDouble(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public void setNullChar(int pos) {
        this.setNullAt(pos);
    }

    @Override
    public boolean[] toBooleanArray() {
        return (boolean[])this.arr;
    }

    @Override
    public byte[] toByteArray() {
        return (byte[])this.arr;
    }

    @Override
    public short[] toShortArray() {
        return (short[])this.arr;
    }

    @Override
    public int[] toIntArray() {
        return (int[])this.arr;
    }

    @Override
    public long[] toLongArray() {
        return (long[])this.arr;
    }

    @Override
    public float[] toFloatArray() {
        return (float[])this.arr;
    }

    @Override
    public double[] toDoubleArray() {
        return (double[])this.arr;
    }

    @Override
    public Object[] toObjectArray(InternalType elementType) {
        return (Object[])this.arr;
    }

    @Override
    public <T> T[] toClassArray(InternalType elementType, Class<T> clazz) {
        return (Object[])this.arr;
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.isPrimitive ? ((boolean[])this.arr)[pos] : ((Boolean[])this.arr)[pos];
    }

    @Override
    public byte getByte(int pos) {
        return this.isPrimitive ? ((byte[])this.arr)[pos] : ((Byte[])this.arr)[pos];
    }

    @Override
    public short getShort(int pos) {
        return this.isPrimitive ? ((short[])this.arr)[pos] : ((Short[])this.arr)[pos];
    }

    @Override
    public int getInt(int pos) {
        return this.isPrimitive ? ((int[])this.arr)[pos] : ((Integer[])this.arr)[pos];
    }

    @Override
    public long getLong(int pos) {
        return this.isPrimitive ? ((long[])this.arr)[pos] : ((Long[])this.arr)[pos];
    }

    @Override
    public float getFloat(int pos) {
        return this.isPrimitive ? ((float[])this.arr)[pos] : ((Float[])this.arr)[pos].floatValue();
    }

    @Override
    public double getDouble(int pos) {
        return this.isPrimitive ? ((double[])this.arr)[pos] : ((Double[])this.arr)[pos];
    }

    @Override
    public char getChar(int pos) {
        return this.isPrimitive ? ((char[])this.arr)[pos] : ((Character[])this.arr)[pos].charValue();
    }

    @Override
    public byte[] getByteArray(int pos) {
        return (byte[])((Object[])this.arr)[pos];
    }

    @Override
    public String getString(int pos) {
        Object value = ((Object[])this.arr)[pos];
        if (value instanceof BinaryString) {
            return value.toString();
        }
        return (String)value;
    }

    @Override
    public BinaryString getBinaryString(int pos) {
        Object value = ((Object[])this.arr)[pos];
        if (value instanceof BinaryString) {
            return (BinaryString)value;
        }
        return BinaryString.fromString((String)value);
    }

    @Override
    public BinaryString getBinaryString(int pos, BinaryString reuseRef) {
        return this.getBinaryString(pos);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        Object value = ((Object[])this.arr)[pos];
        if (value instanceof Decimal) {
            return (Decimal)value;
        }
        return Decimal.fromBigDecimal((BigDecimal)value, precision, scale);
    }

    @Override
    public <T> T getGeneric(int pos, TypeSerializer<T> serializer) {
        return (T)((Object[])this.arr)[pos];
    }

    @Override
    public <T> T getGeneric(int pos, GenericType<T> type) {
        return (T)((Object[])this.arr)[pos];
    }

    @Override
    public BaseRow getBaseRow(int pos, int numFields) {
        return (BaseRow)((Object[])this.arr)[pos];
    }

    @Override
    public BaseArray getBaseArray(int pos) {
        return (BaseArray)((Object[])this.arr)[pos];
    }

    @Override
    public BaseMap getBaseMap(int pos) {
        return (BaseMap)((Object[])this.arr)[pos];
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        ((boolean[])this.arr)[pos] = value;
    }

    @Override
    public void setByte(int pos, byte value) {
        ((byte[])this.arr)[pos] = value;
    }

    @Override
    public void setShort(int pos, short value) {
        ((short[])this.arr)[pos] = value;
    }

    @Override
    public void setInt(int pos, int value) {
        ((int[])this.arr)[pos] = value;
    }

    @Override
    public void setLong(int pos, long value) {
        ((long[])this.arr)[pos] = value;
    }

    @Override
    public void setFloat(int pos, float value) {
        ((float[])this.arr)[pos] = value;
    }

    @Override
    public void setDouble(int pos, double value) {
        ((double[])this.arr)[pos] = value;
    }

    @Override
    public void setChar(int pos, char value) {
        ((char[])this.arr)[pos] = value;
    }

    @Override
    public void setDecimal(int pos, Decimal value, int precision, int scale) {
        ((Object[])this.arr)[pos] = value;
    }

    public void setObject(int pos, Object value) {
        ((Object[])this.arr)[pos] = value;
    }
}

