/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.types.GenericType;

public final class JoinedRow
implements BaseRow {
    private BaseRow row1;
    private BaseRow row2;
    private byte header;

    public JoinedRow() {
    }

    public JoinedRow(BaseRow row1, BaseRow row2) {
        this.row1 = row1;
        this.row2 = row2;
    }

    public JoinedRow replace(BaseRow row1, BaseRow row2) {
        this.row1 = row1;
        this.row2 = row2;
        return this;
    }

    @Override
    public int getArity() {
        return this.row1.getArity() + this.row2.getArity();
    }

    @Override
    public byte getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(byte header) {
        this.header = header;
    }

    @Override
    public boolean isNullAt(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.isNullAt(i);
        }
        return this.row2.isNullAt(i - this.row1.getArity());
    }

    @Override
    public boolean getBoolean(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getBoolean(i);
        }
        return this.row2.getBoolean(i - this.row1.getArity());
    }

    @Override
    public byte getByte(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getByte(i);
        }
        return this.row2.getByte(i - this.row1.getArity());
    }

    @Override
    public short getShort(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getShort(i);
        }
        return this.row2.getShort(i - this.row1.getArity());
    }

    @Override
    public int getInt(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getInt(i);
        }
        return this.row2.getInt(i - this.row1.getArity());
    }

    @Override
    public long getLong(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getLong(i);
        }
        return this.row2.getLong(i - this.row1.getArity());
    }

    @Override
    public float getFloat(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getFloat(i);
        }
        return this.row2.getFloat(i - this.row1.getArity());
    }

    @Override
    public double getDouble(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getDouble(i);
        }
        return this.row2.getDouble(i - this.row1.getArity());
    }

    @Override
    public char getChar(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getChar(i);
        }
        return this.row2.getChar(i - this.row1.getArity());
    }

    @Override
    public byte[] getByteArray(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getByteArray(i);
        }
        return this.row2.getByteArray(i - this.row1.getArity());
    }

    @Override
    public BinaryString getBinaryString(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getBinaryString(i);
        }
        return this.row2.getBinaryString(i - this.row1.getArity());
    }

    @Override
    public BinaryString getBinaryString(int i, BinaryString reuse) {
        if (i < this.row1.getArity()) {
            return this.row1.getBinaryString(i, reuse);
        }
        return this.row2.getBinaryString(i - this.row1.getArity(), reuse);
    }

    @Override
    public Decimal getDecimal(int i, int precision, int scale) {
        if (i < this.row1.getArity()) {
            return this.row1.getDecimal(i, precision, scale);
        }
        return this.row2.getDecimal(i - this.row1.getArity(), precision, scale);
    }

    @Override
    public String getString(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getString(i);
        }
        return this.row2.getString(i - this.row1.getArity());
    }

    @Override
    public <T> T getGeneric(int i, TypeSerializer<T> serializer) {
        if (i < this.row1.getArity()) {
            return this.row1.getGeneric(i, serializer);
        }
        return this.row2.getGeneric(i - this.row1.getArity(), serializer);
    }

    @Override
    public <T> T getGeneric(int i, GenericType<T> type) {
        if (i < this.row1.getArity()) {
            return this.row1.getGeneric(i, type);
        }
        return this.row2.getGeneric(i - this.row1.getArity(), type);
    }

    @Override
    public BaseRow getBaseRow(int i, int numFields) {
        if (i < this.row1.getArity()) {
            return this.row1.getBaseRow(i, numFields);
        }
        return this.row2.getBaseRow(i - this.row1.getArity(), numFields);
    }

    @Override
    public BaseArray getBaseArray(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getBaseArray(i);
        }
        return this.row2.getBaseArray(i - this.row1.getArity());
    }

    @Override
    public BaseMap getBaseMap(int i) {
        if (i < this.row1.getArity()) {
            return this.row1.getBaseMap(i);
        }
        return this.row2.getBaseMap(i - this.row1.getArity());
    }

    @Override
    public void setNullAt(int i) {
        if (i < this.row1.getArity()) {
            this.row1.setNullAt(i);
        } else {
            this.row2.setNullAt(i - this.row1.getArity());
        }
    }

    @Override
    public void setBoolean(int i, boolean value) {
        if (i < this.row1.getArity()) {
            this.row1.setBoolean(i, value);
        } else {
            this.row2.setBoolean(i - this.row1.getArity(), value);
        }
    }

    @Override
    public void setByte(int i, byte value) {
        if (i < this.row1.getArity()) {
            this.row1.setByte(i, value);
        } else {
            this.row2.setByte(i - this.row1.getArity(), value);
        }
    }

    @Override
    public void setShort(int i, short value) {
        if (i < this.row1.getArity()) {
            this.row1.setShort(i, value);
        } else {
            this.row2.setShort(i - this.row1.getArity(), value);
        }
    }

    @Override
    public void setInt(int i, int value) {
        if (i < this.row1.getArity()) {
            this.row1.setInt(i, value);
        } else {
            this.row2.setInt(i - this.row1.getArity(), value);
        }
    }

    @Override
    public void setLong(int i, long value) {
        if (i < this.row1.getArity()) {
            this.row1.setLong(i, value);
        } else {
            this.row2.setLong(i - this.row1.getArity(), value);
        }
    }

    @Override
    public void setFloat(int i, float value) {
        if (i < this.row1.getArity()) {
            this.row1.setFloat(i, value);
        } else {
            this.row2.setFloat(i - this.row1.getArity(), value);
        }
    }

    @Override
    public void setDouble(int i, double value) {
        if (i < this.row1.getArity()) {
            this.row1.setDouble(i, value);
        } else {
            this.row2.setDouble(i - this.row1.getArity(), value);
        }
    }

    @Override
    public void setChar(int i, char value) {
        if (i < this.row1.getArity()) {
            this.row1.setChar(i, value);
        } else {
            this.row2.setChar(i - this.row1.getArity(), value);
        }
    }

    @Override
    public void setDecimal(int i, Decimal value, int precision, int scale) {
        if (i < this.row1.getArity()) {
            this.row1.setDecimal(i, value, precision, scale);
        } else {
            this.row2.setDecimal(i - this.row1.getArity(), value, precision, scale);
        }
    }

    @Override
    public boolean equalsWithoutHeader(BaseRow o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof JoinedRow)) {
            return false;
        }
        JoinedRow row2 = (JoinedRow)o;
        return this.row1.equalsWithoutHeader(row2.row1) && this.row2.equalsWithoutHeader(row2.row2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof JoinedRow)) {
            return false;
        }
        JoinedRow row2 = (JoinedRow)o;
        return this.header == row2.header && this.row1.equalsWithoutHeader(row2.row1) && this.row2.equalsWithoutHeader(row2.row2);
    }

    public int hashCode() {
        int res = 31 * Byte.hashCode(this.header) + this.row1.hashCode();
        return 31 * res + this.row2.hashCode();
    }
}

