/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.util.BinaryRowUtil;
import org.apache.flink.table.dataformat.util.MultiSegUtil;
import org.apache.flink.table.types.GenericType;
import org.apache.flink.table.util.hash.Murmur32;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public final class NestedRow
implements BaseRow {
    private final int arity;
    private final int nullBitsSizeInBytes;
    private MemorySegment[] segments;
    private int baseOffset;
    private int sizeInBytes;

    public NestedRow(int arity) {
        Preconditions.checkArgument(arity >= 0);
        this.arity = arity;
        this.nullBitsSizeInBytes = BinaryRow.calculateBitSetWidthInBytes(arity);
    }

    private int getFieldOffset(int pos) {
        return this.baseOffset + this.nullBitsSizeInBytes + pos * 8;
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.arity) : "index (" + index + ") should < " + this.arity;
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public MemorySegment[] getSegments() {
        return this.segments;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public byte getHeader() {
        return MultiSegUtil.getByte(this.segments, this.baseOffset);
    }

    @Override
    public void setHeader(byte header) {
        throw new UnsupportedOperationException();
    }

    public void pointTo(MemorySegment segment, int baseOffset, int sizeInBytes) {
        this.pointTo(new MemorySegment[]{segment}, baseOffset, sizeInBytes);
    }

    public void pointTo(MemorySegment[] segments, int baseOffset, int sizeInBytes) {
        this.segments = segments;
        this.baseOffset = baseOffset;
        this.sizeInBytes = sizeInBytes;
    }

    private void setNotNullAt(int i) {
        this.assertIndexIsValid(i);
        MultiSegUtil.bitUnSet(this.segments, this.baseOffset, i + 8);
    }

    @Override
    public void setNullAt(int i) {
        this.assertIndexIsValid(i);
        MultiSegUtil.bitSet(this.segments, this.baseOffset, i + 8);
        MultiSegUtil.setLong(this.segments, this.getFieldOffset(i), 0L);
    }

    @Override
    public void setInt(int pos, int value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MultiSegUtil.setInt(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setLong(int pos, long value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MultiSegUtil.setLong(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setDouble(int pos, double value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MultiSegUtil.setDouble(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setChar(int pos, char value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MultiSegUtil.setChar(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setDecimal(int pos, Decimal value, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            if (value == null) {
                this.setNullAt(pos);
            } else {
                this.setLong(pos, value.toUnscaledLong());
            }
        } else {
            int fieldOffset = this.getFieldOffset(pos);
            int cursor = (int)(MultiSegUtil.getLong(this.segments, fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            MultiSegUtil.setLong(this.segments, this.baseOffset + cursor, 0L);
            MultiSegUtil.setLong(this.segments, this.baseOffset + cursor + 8, 0L);
            if (value == null) {
                this.setNullAt(pos);
                MultiSegUtil.setLong(this.segments, fieldOffset, (long)cursor << 32);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                BinaryRowUtil.copyFromBytes(this.segments, this.baseOffset + cursor, bytes, 0, bytes.length);
                this.setLong(pos, (long)cursor << 32 | (long)bytes.length);
            }
        }
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MultiSegUtil.setBoolean(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setShort(int pos, short value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MultiSegUtil.setShort(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setByte(int pos, byte value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MultiSegUtil.setByte(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setFloat(int pos, float value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MultiSegUtil.setFloat(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.bitGet(this.segments, this.baseOffset, pos + 8);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getBoolean(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getByte(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getShort(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getInt(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getLong(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getFloat(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getDouble(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public char getChar(int pos) {
        this.assertIndexIsValid(pos);
        return MultiSegUtil.getChar(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public BinaryString getBinaryString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndSize = MultiSegUtil.getLong(this.segments, fieldOffset);
        BinaryString ret = new BinaryString();
        BinaryRow.getBinaryStringFromSeg(this.segments, this.baseOffset, fieldOffset, offsetAndSize, ret);
        return ret;
    }

    @Override
    public BinaryString getBinaryString(int pos, BinaryString reuse) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndSize = MultiSegUtil.getLong(this.segments, fieldOffset);
        BinaryRow.getBinaryStringFromSeg(this.segments, this.baseOffset, fieldOffset, offsetAndSize, reuse);
        return reuse;
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            long longVal = MultiSegUtil.getLong(this.segments, this.getFieldOffset(pos));
            return Decimal.fromUnscaledLong(precision, scale, longVal);
        }
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndSize = MultiSegUtil.getLong(this.segments, fieldOffset);
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        byte[] bytes = BinaryRowUtil.copy(this.segments, this.baseOffset + offset, size);
        return Decimal.fromUnscaledBytes(precision, scale, bytes);
    }

    @Override
    public <T> T getGeneric(int pos, TypeSerializer<T> serializer) {
        long offsetAndSize = this.getLong(pos);
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        try {
            return InstantiationUtil.deserializeFromByteArray(serializer, BinaryRowUtil.copy(this.segments, this.baseOffset + offset, size));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public <T> T getGeneric(int pos, GenericType<T> type) {
        return this.getGeneric(pos, type.getSerializer());
    }

    @Override
    public BaseRow getBaseRow(int ordinal, int numFields) {
        long offsetAndSize = this.getLong(ordinal);
        return BinaryRow.getBaseRow(this.segments, this.baseOffset, offsetAndSize, numFields);
    }

    @Override
    public BaseArray getBaseArray(int ordinal) {
        long offsetAndSize = this.getLong(ordinal);
        return BinaryRow.getBinaryArray(this.segments, this.baseOffset, offsetAndSize);
    }

    @Override
    public BaseMap getBaseMap(int ordinal) {
        long offsetAndSize = this.getLong(ordinal);
        return BinaryRow.getBinaryMap(this.segments, this.baseOffset, offsetAndSize);
    }

    @Override
    public byte[] getByteArray(int ordinal) {
        int fieldOffset = this.getFieldOffset(ordinal);
        long offsetAndSize = MultiSegUtil.getLong(this.segments, fieldOffset);
        return BinaryRow.getByteArray(this.segments, this.baseOffset, fieldOffset, offsetAndSize);
    }

    public NestedRow copy() {
        return this.copy(new NestedRow(this.arity));
    }

    public NestedRow copy(BaseRow reuse) {
        return this.copyInternal((NestedRow)reuse);
    }

    private NestedRow copyInternal(NestedRow reuse) {
        byte[] bytes = BinaryRowUtil.copy(this.segments, this.baseOffset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap(bytes), 0, this.sizeInBytes);
        return reuse;
    }

    public boolean equals(Object o) {
        return this.equalsFrom(o, 0);
    }

    @Override
    public boolean equalsWithoutHeader(BaseRow o) {
        throw new UnsupportedOperationException();
    }

    private boolean equalsFrom(Object o, int startIndex) {
        if (o != null && o instanceof NestedRow) {
            NestedRow other = (NestedRow)o;
            return this.sizeInBytes == other.sizeInBytes && BinaryRowUtil.equals(this.segments, this.baseOffset + startIndex, other.segments, other.baseOffset + startIndex, this.sizeInBytes - startIndex);
        }
        return false;
    }

    public int hashCode() {
        if (this.segments.length == 1) {
            return Murmur32.hashBytesByWords(this.segments[0], this.baseOffset, this.sizeInBytes, 42);
        }
        return this.hashSlow();
    }

    private int hashSlow() {
        byte[] bytes = new byte[this.sizeInBytes];
        BinaryRowUtil.copySlow(this.segments, this.baseOffset, bytes, this.sizeInBytes);
        return Murmur32.hashBytesByWords(MemorySegmentFactory.wrap(bytes), 0, this.sizeInBytes, 42);
    }
}

