/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.types.GenericType;

public final class UpdatableRow
implements BaseRow {
    private BaseRow row;
    private final Object[] fields;
    private final boolean[] updated;

    public UpdatableRow(BaseRow row2, int arity) {
        this.row = row2;
        this.fields = new Object[arity];
        this.updated = new boolean[arity];
    }

    public BaseRow getRow() {
        return this.row;
    }

    @Override
    public int getArity() {
        return this.fields.length;
    }

    @Override
    public byte getHeader() {
        return this.row.getHeader();
    }

    @Override
    public void setHeader(byte header) {
        this.row.setHeader(header);
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.updated[ordinal] ? this.fields[ordinal] == null : this.row.isNullAt(ordinal);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return this.updated[ordinal] ? ((Boolean)this.fields[ordinal]).booleanValue() : this.row.getBoolean(ordinal);
    }

    @Override
    public byte getByte(int ordinal) {
        return this.updated[ordinal] ? ((Byte)this.fields[ordinal]).byteValue() : this.row.getByte(ordinal);
    }

    @Override
    public short getShort(int ordinal) {
        return this.updated[ordinal] ? ((Short)this.fields[ordinal]).shortValue() : this.row.getShort(ordinal);
    }

    @Override
    public int getInt(int ordinal) {
        return this.updated[ordinal] ? ((Integer)this.fields[ordinal]).intValue() : this.row.getInt(ordinal);
    }

    @Override
    public long getLong(int ordinal) {
        return this.updated[ordinal] ? ((Long)this.fields[ordinal]).longValue() : this.row.getLong(ordinal);
    }

    @Override
    public float getFloat(int ordinal) {
        return this.updated[ordinal] ? ((Float)this.fields[ordinal]).floatValue() : this.row.getFloat(ordinal);
    }

    @Override
    public double getDouble(int ordinal) {
        return this.updated[ordinal] ? ((Double)this.fields[ordinal]).doubleValue() : this.row.getDouble(ordinal);
    }

    @Override
    public char getChar(int ordinal) {
        return this.updated[ordinal] ? ((Character)this.fields[ordinal]).charValue() : this.row.getChar(ordinal);
    }

    @Override
    public byte[] getByteArray(int ordinal) {
        return this.updated[ordinal] ? (byte[])this.fields[ordinal] : this.row.getByteArray(ordinal);
    }

    @Override
    public BinaryString getBinaryString(int ordinal) {
        return this.updated[ordinal] ? (BinaryString)this.fields[ordinal] : this.row.getBinaryString(ordinal);
    }

    @Override
    public BinaryString getBinaryString(int ordinal, BinaryString reuse) {
        return this.updated[ordinal] ? (BinaryString)this.fields[ordinal] : this.row.getBinaryString(ordinal, reuse);
    }

    @Override
    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return this.updated[ordinal] ? (Decimal)this.fields[ordinal] : this.row.getDecimal(ordinal, precision, scale);
    }

    @Override
    public <T> T getGeneric(int ordinal, TypeSerializer<T> serializer) {
        return (T)(this.updated[ordinal] ? this.fields[ordinal] : this.row.getGeneric(ordinal, serializer));
    }

    @Override
    public <T> T getGeneric(int pos, GenericType<T> type) {
        return (T)(this.updated[pos] ? this.fields[pos] : this.row.getGeneric(pos, type));
    }

    @Override
    public BaseRow getBaseRow(int ordinal, int numFields) {
        return this.updated[ordinal] ? (BaseRow)this.fields[ordinal] : this.row.getBaseRow(ordinal, numFields);
    }

    @Override
    public BaseArray getBaseArray(int ordinal) {
        return this.updated[ordinal] ? (BaseArray)this.fields[ordinal] : this.row.getBaseArray(ordinal);
    }

    @Override
    public BaseMap getBaseMap(int ordinal) {
        return this.updated[ordinal] ? (BaseMap)this.fields[ordinal] : this.row.getBaseMap(ordinal);
    }

    @Override
    public void setNullAt(int ordinal) {
        this.update(ordinal, null);
    }

    @Override
    public void setBoolean(int ordinal, boolean value) {
        this.update(ordinal, value);
    }

    @Override
    public void setByte(int ordinal, byte value) {
        this.update(ordinal, value);
    }

    @Override
    public void setShort(int ordinal, short value) {
        this.update(ordinal, value);
    }

    @Override
    public void setInt(int ordinal, int value) {
        this.update(ordinal, value);
    }

    @Override
    public void setLong(int ordinal, long value) {
        this.update(ordinal, value);
    }

    @Override
    public void setFloat(int ordinal, float value) {
        this.update(ordinal, Float.valueOf(value));
    }

    @Override
    public void setDouble(int ordinal, double value) {
        this.update(ordinal, value);
    }

    @Override
    public void setChar(int ordinal, char value) {
        this.update(ordinal, Character.valueOf(value));
    }

    @Override
    public void setDecimal(int ordinal, Decimal value, int precision, int scale) {
        this.update(ordinal, value);
    }

    public void update(int ordinal, Object value) {
        this.updated[ordinal] = true;
        this.fields[ordinal] = value;
    }

    @Override
    public boolean equalsWithoutHeader(BaseRow other) {
        throw new UnsupportedOperationException();
    }
}

