/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.vector;

import org.apache.flink.table.dataformat.vector.ColumnVector;

public class BinaryColumnVector
extends ColumnVector {
    private static final long serialVersionUID = -8529155738773478597L;
    public byte[][] vector;
    private int nextFree;

    public BinaryColumnVector(int size) {
        super(size);
        this.vector = new byte[size][];
    }

    @Override
    public Object get(int index) {
        return this.vector[index];
    }

    @Override
    public void reset() {
        super.reset();
    }

    public void setRef(int elementNum, byte[] sourceBuf, int start, int length) {
        this.vector[elementNum] = sourceBuf;
    }

    public void setVal(int elementNum, byte[] sourceBuf) {
        this.vector[elementNum] = sourceBuf;
    }

    @Override
    public void copySelected(boolean selectedInUse, int[] sel, int size, ColumnVector output2) {
        output2.noNulls = this.noNulls;
        if (selectedInUse) {
            for (int j2 = 0; j2 < size; ++j2) {
                int i = sel[j2];
                ((BinaryColumnVector)output2).setVal(i, this.vector[i]);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                ((BinaryColumnVector)output2).setVal(i, this.vector[i]);
            }
        }
        super.copySelected(selectedInUse, sel, size, output2);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.noNulls || !inputVector.isNull[inputElementNum]) {
            this.isNull[outElementNum] = false;
            BinaryColumnVector in = (BinaryColumnVector)inputVector;
            this.setVal(outElementNum, in.vector[inputElementNum]);
        } else {
            this.isNull[outElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        BinaryColumnVector other = (BinaryColumnVector)otherCv;
        super.shallowCopyTo(other);
        other.nextFree = this.nextFree;
        other.vector = this.vector;
    }
}

