/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.vector;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.table.dataformat.vector.Dictionary;
import org.apache.flink.table.dataformat.vector.IntegerColumnVector;

public abstract class ColumnVector
implements Serializable {
    private static final long serialVersionUID = 5340018531388047747L;
    public boolean[] isNull;
    public boolean noNulls;
    protected Dictionary dictionary;
    protected IntegerColumnVector dictionaryIds;

    public ColumnVector(int len) {
        this.isNull = new boolean[len];
        this.noNulls = true;
    }

    public abstract Object get(int var1);

    public void reset() {
        if (!this.noNulls) {
            Arrays.fill(this.isNull, false);
        }
        this.noNulls = true;
    }

    public abstract void setElement(int var1, int var2, ColumnVector var3);

    public void init() {
    }

    public void copySelected(boolean selectedInUse, int[] sel, int size, ColumnVector output2) {
        if (!this.noNulls) {
            if (selectedInUse) {
                for (int j2 = 0; j2 < size; ++j2) {
                    int i = sel[j2];
                    output2.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output2.isNull, 0, size);
            }
        }
    }

    public void shallowCopyTo(ColumnVector otherCv) {
        otherCv.isNull = this.isNull;
        otherCv.noNulls = this.noNulls;
    }

    public IntegerColumnVector reserveDictionaryIds(int capacity) {
        if (this.dictionaryIds == null) {
            this.dictionaryIds = new IntegerColumnVector(capacity);
        } else {
            this.dictionaryIds.reset();
        }
        return this.dictionaryIds;
    }

    public void setDictionary(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    public boolean hasDictionary() {
        return this.dictionary != null;
    }

    public IntegerColumnVector getDictionaryIds() {
        return this.dictionaryIds;
    }
}

