/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.vector;

import org.apache.flink.table.dataformat.vector.ColumnVector;

public class LongColumnVector
extends ColumnVector {
    private static final long serialVersionUID = 8534925169458006397L;
    public long[] vector;

    public LongColumnVector(int len) {
        super(len);
        this.vector = new long[len];
    }

    @Override
    public Object get(int index) {
        return this.vector[index];
    }

    @Override
    public void copySelected(boolean selectedInUse, int[] sel, int size, ColumnVector output2) {
        output2.noNulls = this.noNulls;
        if (selectedInUse) {
            for (int j2 = 0; j2 < size; ++j2) {
                int i = sel[j2];
                ((LongColumnVector)output2).vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, ((LongColumnVector)output2).vector, 0, size);
        }
        super.copySelected(selectedInUse, sel, size, output2);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.noNulls || !inputVector.isNull[inputElementNum]) {
            this.isNull[outElementNum] = false;
            this.vector[outElementNum] = ((LongColumnVector)inputVector).vector[inputElementNum];
        } else {
            this.isNull[outElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        LongColumnVector other = (LongColumnVector)otherCv;
        super.shallowCopyTo(other);
        other.vector = this.vector;
    }
}

