/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.vector;

import org.apache.flink.table.dataformat.vector.ColumnVector;

public class ShortColumnVector
extends ColumnVector {
    private static final long serialVersionUID = -8278486456144676292L;
    public short[] vector;

    public ShortColumnVector(int len) {
        super(len);
        this.vector = new short[len];
    }

    @Override
    public Object get(int index) {
        return this.vector[index];
    }

    @Override
    public void copySelected(boolean selectedInUse, int[] sel, int size, ColumnVector output2) {
        output2.noNulls = this.noNulls;
        if (selectedInUse) {
            for (int j2 = 0; j2 < size; ++j2) {
                int i = sel[j2];
                ((ShortColumnVector)output2).vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, ((ShortColumnVector)output2).vector, 0, size);
        }
        super.copySelected(selectedInUse, sel, size, output2);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.noNulls || !inputVector.isNull[inputElementNum]) {
            this.isNull[outElementNum] = false;
            this.vector[outElementNum] = ((ShortColumnVector)inputVector).vector[inputElementNum];
        } else {
            this.isNull[outElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        ShortColumnVector other = (ShortColumnVector)otherCv;
        super.shallowCopyTo(other);
        other.vector = this.vector;
    }
}

