/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.vector;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.vector.BooleanColumnVector;
import org.apache.flink.table.dataformat.vector.ByteColumnVector;
import org.apache.flink.table.dataformat.vector.BytesColumnVector;
import org.apache.flink.table.dataformat.vector.ColumnVector;
import org.apache.flink.table.dataformat.vector.DateColumnVector;
import org.apache.flink.table.dataformat.vector.DoubleColumnVector;
import org.apache.flink.table.dataformat.vector.FloatColumnVector;
import org.apache.flink.table.dataformat.vector.IntegerColumnVector;
import org.apache.flink.table.dataformat.vector.LongColumnVector;
import org.apache.flink.table.dataformat.vector.ShortColumnVector;
import org.apache.flink.table.dataformat.vector.StringColumnVector;
import org.apache.flink.table.dataformat.vector.TimeColumnVector;
import org.apache.flink.table.dataformat.vector.TimestampColumnVector;
import org.apache.flink.table.dataformat.vector.TypeGetVector;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.Types;
import org.apache.flink.util.TimeConvertUtils;

public class VectorizedColumnBatch
implements Serializable {
    private static final long serialVersionUID = 8180323238728166155L;
    public static final int MAX_SIZE = 2048;
    protected InternalType[] fieldTypes;
    private final int capacity;
    private int numRows;
    public final ColumnVector[] columns;
    private final boolean copyToInternal;

    public static VectorizedColumnBatch allocate(InternalType[] fieldTypes2) {
        return new VectorizedColumnBatch(fieldTypes2, 2048);
    }

    private VectorizedColumnBatch(InternalType[] fieldTypes2, int maxRows) {
        this.fieldTypes = fieldTypes2;
        this.capacity = maxRows;
        this.columns = new ColumnVector[fieldTypes2.length];
        for (int i = 0; i < fieldTypes2.length; ++i) {
            this.createColumn(this.columns, i, fieldTypes2[i], maxRows);
        }
        this.copyToInternal = true;
    }

    public VectorizedColumnBatch(InternalType[] fieldTypes2, int maxRows, ColumnVector[] columns) {
        this.fieldTypes = fieldTypes2;
        this.capacity = maxRows;
        this.columns = columns;
        this.copyToInternal = false;
    }

    private void createColumn(ColumnVector[] columns, int index, InternalType fieldType, int maxRows) {
        if (fieldType.equals(Types.BOOLEAN)) {
            columns[index] = new BooleanColumnVector(maxRows);
        } else if (fieldType.equals(Types.BYTE)) {
            columns[index] = new ByteColumnVector(maxRows);
        } else if (fieldType.equals(Types.DOUBLE)) {
            columns[index] = new DoubleColumnVector(maxRows);
        } else if (fieldType.equals(Types.FLOAT)) {
            columns[index] = new FloatColumnVector(maxRows);
        } else if (fieldType.equals(Types.INT) || fieldType instanceof DecimalType && Decimal.is32BitDecimal(((DecimalType)fieldType).precision())) {
            columns[index] = new IntegerColumnVector(maxRows);
        } else if (fieldType.equals(Types.LONG) || fieldType instanceof DecimalType && Decimal.is64BitDecimal(((DecimalType)fieldType).precision())) {
            columns[index] = new LongColumnVector(maxRows);
        } else if (fieldType.equals(Types.SHORT)) {
            columns[index] = new ShortColumnVector(maxRows);
        } else if (fieldType.equals(Types.STRING)) {
            columns[index] = new StringColumnVector(maxRows);
        } else if (fieldType.equals(Types.BYTE_ARRAY) || fieldType instanceof DecimalType && Decimal.isByteArrayDecimal(((DecimalType)fieldType).precision())) {
            columns[index] = new BytesColumnVector(maxRows);
        } else if (fieldType.equals(Types.DATE)) {
            columns[index] = new DateColumnVector(maxRows);
        } else if (fieldType.equals(Types.TIME)) {
            columns[index] = new TimeColumnVector(maxRows);
        } else if (fieldType.equals(Types.TIMESTAMP)) {
            columns[index] = new TimestampColumnVector(maxRows);
        } else {
            throw new UnsupportedOperationException(fieldType + " is not supported now.");
        }
    }

    public void close() {
    }

    public void reset() {
        for (ColumnVector column : this.columns) {
            column.reset();
        }
        this.numRows = 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getArity() {
        return this.columns.length;
    }

    public boolean isNullAt(int rowId, int colId) {
        return !this.columns[colId].noNulls && this.columns[colId].isNull[rowId];
    }

    public boolean getBoolean(int rowId, int colId) {
        if (!this.copyToInternal) {
            return ((TypeGetVector)this.columns[colId]).getBoolean(rowId);
        }
        ColumnVector columnVector = this.columns[colId];
        if (columnVector.dictionary == null) {
            BooleanColumnVector booleanColumnVector = (BooleanColumnVector)columnVector;
            return booleanColumnVector.vector[rowId];
        }
        return columnVector.dictionary.decodeToBoolean(columnVector.dictionaryIds.vector[rowId]);
    }

    public byte getByte(int rowId, int colId) {
        if (!this.copyToInternal) {
            return ((TypeGetVector)this.columns[colId]).getByte(rowId);
        }
        ColumnVector columnVector = this.columns[colId];
        if (columnVector.dictionary == null) {
            ByteColumnVector byteColumnVector = (ByteColumnVector)columnVector;
            return byteColumnVector.vector[rowId];
        }
        return (byte)columnVector.dictionary.decodeToInt(columnVector.dictionaryIds.vector[rowId]);
    }

    public short getShort(int rowId, int colId) {
        if (!this.copyToInternal) {
            return ((TypeGetVector)this.columns[colId]).getShort(rowId);
        }
        ColumnVector columnVector = this.columns[colId];
        if (columnVector.dictionary == null) {
            ShortColumnVector shortColumnVector = (ShortColumnVector)columnVector;
            return shortColumnVector.vector[rowId];
        }
        return (short)columnVector.dictionary.decodeToInt(columnVector.dictionaryIds.vector[rowId]);
    }

    public int getInt(int rowId, int colId) {
        if (!this.copyToInternal) {
            return ((TypeGetVector)this.columns[colId]).getInt(rowId);
        }
        ColumnVector columnVector = this.columns[colId];
        if (columnVector.dictionary == null) {
            IntegerColumnVector integerColumnVector = (IntegerColumnVector)this.columns[colId];
            return integerColumnVector.vector[rowId];
        }
        return columnVector.dictionary.decodeToInt(columnVector.dictionaryIds.vector[rowId]);
    }

    public long getLong(int rowId, int colId) {
        if (!this.copyToInternal) {
            return ((TypeGetVector)this.columns[colId]).getLong(rowId);
        }
        ColumnVector columnVector = this.columns[colId];
        if (columnVector.dictionary == null) {
            LongColumnVector longColumnVector = (LongColumnVector)this.columns[colId];
            return longColumnVector.vector[rowId];
        }
        return columnVector.dictionary.decodeToLong(columnVector.dictionaryIds.vector[rowId]);
    }

    public float getFloat(int rowId, int colId) {
        if (!this.copyToInternal) {
            return ((TypeGetVector)this.columns[colId]).getFloat(rowId);
        }
        ColumnVector columnVector = this.columns[colId];
        if (this.columns[colId].dictionary == null) {
            FloatColumnVector floatColumnVector = (FloatColumnVector)this.columns[colId];
            return floatColumnVector.vector[rowId];
        }
        return columnVector.dictionary.decodeToFloat(columnVector.dictionaryIds.vector[rowId]);
    }

    public double getDouble(int rowId, int colId) {
        if (!this.copyToInternal) {
            return ((TypeGetVector)this.columns[colId]).getDouble(rowId);
        }
        ColumnVector columnVector = this.columns[colId];
        if (this.columns[colId].dictionary == null) {
            DoubleColumnVector doubleColumnVector = (DoubleColumnVector)this.columns[colId];
            return doubleColumnVector.vector[rowId];
        }
        return columnVector.dictionary.decodeToDouble(columnVector.dictionaryIds.vector[rowId]);
    }

    public ByteArray getByteArray(int rowId, int colId) {
        if (!this.copyToInternal) {
            return ((TypeGetVector)this.columns[colId]).getByteArray(rowId);
        }
        ColumnVector columnVector = this.columns[colId];
        if (this.columns[colId].dictionary == null) {
            BytesColumnVector bytesColumnVector = (BytesColumnVector)this.columns[colId];
            return new ByteArray(bytesColumnVector.buffer, bytesColumnVector.start[rowId], bytesColumnVector.length[rowId]);
        }
        byte[] bytes = columnVector.dictionary.decodeToBinary(columnVector.dictionaryIds.vector[rowId]);
        return new ByteArray(bytes, 0, bytes.length);
    }

    private byte[] getBytes(int rowId, int colId) {
        ByteArray byteArray = this.getByteArray(rowId, colId);
        if (byteArray.len == byteArray.data.length) {
            return byteArray.data;
        }
        return byteArray.getBytes();
    }

    public String getString(int rowId, int colId) {
        ByteArray byteArray = this.getByteArray(rowId, colId);
        return new String(byteArray.data, byteArray.offset, byteArray.len);
    }

    public Date getDate(int rowId, int colId) {
        return TimeConvertUtils.internalToDate(this.getInt(rowId, colId));
    }

    public Time getTime(int rowId, int colId) {
        return TimeConvertUtils.internalToTime(this.getInt(rowId, colId));
    }

    public Timestamp getTimestamp(int rowId, int colId) {
        return TimeConvertUtils.internalToTimestamp(this.getLong(rowId, colId));
    }

    public Decimal getDecimal(int rowId, int colId) {
        if (this.isNullAt(rowId, colId)) {
            return null;
        }
        DecimalType decimalTypeInfo = (DecimalType)this.fieldTypes[colId];
        int precision = decimalTypeInfo.precision();
        int scale = decimalTypeInfo.scale();
        if (!this.copyToInternal) {
            return ((TypeGetVector)this.columns[colId]).getDecimal(rowId, precision, scale);
        }
        if (Decimal.is32BitDecimal(precision)) {
            return Decimal.fromUnscaledLong(precision, scale, this.getInt(rowId, colId));
        }
        if (Decimal.is64BitDecimal(precision)) {
            return Decimal.fromUnscaledLong(precision, scale, this.getLong(rowId, colId));
        }
        byte[] bytes = this.getBytes(rowId, colId);
        return Decimal.fromUnscaledBytes(precision, scale, bytes);
    }

    public Object getInternalObject(int rowId, int colId) {
        if (!this.columns[colId].noNulls && this.columns[colId].isNull[rowId]) {
            return null;
        }
        if (Types.INT.equals(this.fieldTypes[colId])) {
            return this.getInt(rowId, colId);
        }
        if (Types.SHORT.equals(this.fieldTypes[colId])) {
            return this.getShort(rowId, colId);
        }
        if (Types.BOOLEAN.equals(this.fieldTypes[colId])) {
            return this.getBoolean(rowId, colId);
        }
        if (Types.BYTE.equals(this.fieldTypes[colId])) {
            return this.getByte(rowId, colId);
        }
        if (Types.DOUBLE.equals(this.fieldTypes[colId])) {
            return this.getDouble(rowId, colId);
        }
        if (Types.FLOAT.equals(this.fieldTypes[colId])) {
            return Float.valueOf(this.getFloat(rowId, colId));
        }
        if (Types.LONG.equals(this.fieldTypes[colId])) {
            return this.getLong(rowId, colId);
        }
        if (Types.STRING.equals(this.fieldTypes[colId])) {
            return BinaryString.fromBytes(this.getBytes(rowId, colId));
        }
        if (Types.TIMESTAMP.equals(this.fieldTypes[colId])) {
            return this.getLong(rowId, colId);
        }
        if (Types.DATE.equals(this.fieldTypes[colId])) {
            return this.getInt(rowId, colId);
        }
        if (Types.TIME.equals(this.fieldTypes[colId])) {
            return this.getInt(rowId, colId);
        }
        if (Types.BYTE_ARRAY.equals(this.fieldTypes[colId])) {
            return this.getBytes(rowId, colId);
        }
        if (this.fieldTypes[colId] instanceof DecimalType) {
            return this.getDecimal(rowId, colId);
        }
        throw new RuntimeException(this.fieldTypes[colId] + " is not supported.");
    }

    public Object getObject(int rowId, int colId) {
        if (!this.columns[colId].noNulls && this.columns[colId].isNull[rowId]) {
            return null;
        }
        if (Types.INT.equals(this.fieldTypes[colId])) {
            return this.getInt(rowId, colId);
        }
        if (Types.SHORT.equals(this.fieldTypes[colId])) {
            return this.getShort(rowId, colId);
        }
        if (Types.BOOLEAN.equals(this.fieldTypes[colId])) {
            return this.getBoolean(rowId, colId);
        }
        if (Types.BYTE.equals(this.fieldTypes[colId])) {
            return this.getByte(rowId, colId);
        }
        if (Types.DOUBLE.equals(this.fieldTypes[colId])) {
            return this.getDouble(rowId, colId);
        }
        if (Types.FLOAT.equals(this.fieldTypes[colId])) {
            return Float.valueOf(this.getFloat(rowId, colId));
        }
        if (Types.LONG.equals(this.fieldTypes[colId])) {
            return this.getLong(rowId, colId);
        }
        if (Types.STRING.equals(this.fieldTypes[colId])) {
            return this.getString(rowId, colId);
        }
        if (Types.TIMESTAMP.equals(this.fieldTypes[colId])) {
            return this.getTimestamp(rowId, colId);
        }
        if (Types.DATE.equals(this.fieldTypes[colId])) {
            return this.getDate(rowId, colId);
        }
        if (Types.TIME.equals(this.fieldTypes[colId])) {
            return this.getTime(rowId, colId);
        }
        if (Types.BYTE_ARRAY.equals(this.fieldTypes[colId])) {
            return this.getBytes(rowId, colId);
        }
        if (this.fieldTypes[colId] instanceof DecimalType) {
            return this.getDecimal(rowId, colId);
        }
        throw new RuntimeException(this.fieldTypes[colId] + " is not supported.");
    }

    public static class ByteArray {
        public final byte[] data;
        public final int offset;
        public final int len;

        public ByteArray(byte[] data, int offset, int len) {
            this.data = data;
            this.offset = offset;
            this.len = len;
        }

        public byte[] getBytes() {
            byte[] res = new byte[this.len];
            System.arraycopy(this.data, this.offset, res, 0, this.len);
            return res;
        }
    }
}

