/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataview;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class NullAwareMapIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final Iterator<Map.Entry<K, V>> mapIterator;
    private final NullMapEntry<K, V> nullMapEntry;
    private final boolean nullExisted;
    private boolean nullVisited = false;

    public NullAwareMapIterator(Iterator<Map.Entry<K, V>> mapIterator, NullMapEntry<K, V> nullMapEntry) {
        this.mapIterator = mapIterator;
        this.nullMapEntry = nullMapEntry;
        this.nullExisted = nullMapEntry.getValue() != null;
    }

    @Override
    public boolean hasNext() {
        return this.mapIterator.hasNext() || this.nullExisted && !this.nullVisited;
    }

    @Override
    public Map.Entry<K, V> next() {
        if (this.mapIterator.hasNext()) {
            return this.mapIterator.next();
        }
        if (this.nullExisted && !this.nullVisited) {
            this.nullVisited = true;
            return this.nullMapEntry;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.nullExisted && this.nullVisited) {
            this.nullMapEntry.remove();
        } else {
            this.mapIterator.remove();
        }
    }

    public static interface NullMapEntry<K, V>
    extends Map.Entry<K, V> {
        @Override
        default public K getKey() {
            return null;
        }

        public void remove();
    }
}

