/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.errorcode;

import java.util.regex.Pattern;
import org.apache.flink.table.errorcode.TableErrors;

public class CalciteErrorClassifier {
    public static String classify(String expMsg) {
        for (CalciteErrTypes type : CalciteErrTypes.values()) {
            if (!type.getPattern().matcher(expMsg).find()) continue;
            switch (type) {
                case columnNotFound: {
                    return TableErrors.INST.sqlColumnNotFoundByCalcite(expMsg);
                }
                case tableNotFound: {
                    return TableErrors.INST.sqlTableNotFoundByCalcite(expMsg);
                }
                case objNotFound: {
                    return TableErrors.INST.sqlObjNotFoundByCalcite(expMsg);
                }
                case unknownIdentifiler: {
                    return TableErrors.INST.sqlUnknownIdentifierByCalcite(expMsg);
                }
                case argNumberInvalid: {
                    return TableErrors.INST.sqlArgNumberInvalidByCalcite(expMsg);
                }
                case argTypeInvalid: {
                    return TableErrors.INST.sqlArgTypeInvalidByCalcite(expMsg);
                }
                case funcSignatureNoMatch: {
                    return TableErrors.INST.sqlFuncSignatureNoMatchByCalcite(expMsg);
                }
                case exprNotGrounded: {
                    return TableErrors.INST.sqlExprNotGroundedByCalcite(expMsg);
                }
                case nonQueryExpr: {
                    return TableErrors.INST.sqlNonQueryExprByCalcite(expMsg);
                }
                case illegalUseOfNull: {
                    return TableErrors.INST.sqlIllegalUseOfNullByCalcite(expMsg);
                }
                case unknownDataType: {
                    return TableErrors.INST.sqlUnknownDataTypeByCalcite(expMsg);
                }
            }
        }
        return TableErrors.INST.sqlUnclassifiedExpByCalcite(expMsg);
    }

    public static enum CalciteErrTypes {
        columnNotFound(Pattern.compile("Column '.*' not found", 2)),
        tableNotFound(Pattern.compile("Table '.*' not found", 2)),
        objNotFound(Pattern.compile("Object '.*' not found", 2)),
        unknownIdentifiler(Pattern.compile("Unknown identifier '.*'", 2)),
        argNumberInvalid(Pattern.compile("Invalid number of arguments to function '.*'", 2)),
        argTypeInvalid(Pattern.compile("Cannot apply '.*' to arguments of type '.*'", 2)),
        funcSignatureNoMatch(Pattern.compile("(No match found for function signature)|(Given parameters of function '.*' do not match any signature)", 2)),
        exprNotGrounded(Pattern.compile("Expression '.*' is not being grouped", 2)),
        nonQueryExpr(Pattern.compile("Non-query expression encountered in illegal context", 2)),
        illegalUseOfNull(Pattern.compile("Illegal use of 'NULL'", 2)),
        unknownDataType(Pattern.compile("Unknown datatype name '.*'", 2));

        private Pattern pattern;

        private CalciteErrTypes(Pattern pattern) {
            this.pattern = pattern;
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

