/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.errorcode;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public interface TableErrorCode {
    @ErrCode(codeId="SQL-00000001", cause="No output table have been created yet. A program needs at least one output table that consumes data.", details="", action="Please create output table(s) for your program")
    public String sqlCompileNoSinkTblError();

    @ErrCode(codeId="SQL-00000002", cause="Internal error #1 in sql compile", details="SinkNode required here", action="Normally, this happens unlikely. Please contact customer support for this.")
    public String sqlCompileSinkNodeRequired();

    @ErrCode(codeId="SQL-00000003", cause="There are both Distinct AggCall and Approximate Distinct AggCall \nin one sql statement, it is not supported yet.", details="", action="Please choose one of them.")
    public String sqlDistinctConflict();

    @ErrCode(codeId="SQL-00010001", cause="Name of target table must not be null or empty.", details="Name of TableSink must not be null or empty.", action="re-check target table definition in your sql")
    public String sqlInvalidSinkTblName();

    @ErrCode(codeId="SQL-00010002", cause="{0} Not a state table.", details="", action="This happens unlikely. Please contact customer support for this.")
    public String sqlNotStateTableError(String var1);

    @ErrCode(codeId="SQL-00010003", cause="No table was registered under the name {0}", details="", action="Please confirm if the table with that name is defined already.\nNormally, this is mostly caused by typo.\nIf need more help, please contact customer support.")
    public String sqlTableNotRegistered(String var1);

    @ErrCode(codeId="SQL-00010004", cause="The table registered as {0} is not a TableSink.You can only emit query results to a registered TableSink.", details="", action="This happens unlikely. Please contact customer support for this.")
    public String sqlNotTableSinkError(String var1);

    @ErrCode(codeId="SQL-00010005", cause="Insert into: Query result and target table ''{0}'' field length not match:\nQuery Result: {1}\nTarget Table: {2}", details="", action="Please make sure the field count of the query result is the same with the target table")
    public String sqlInsertIntoMismatchedFieldLen(String var1, String var2, String var3);

    @ErrCode(codeId="SQL-00010006", cause="Insert into: Query result and target table ''{0}'' field type(s) not match.\nQuery Result diff fields: {1}\nTarget Table diff fields: {2}", details="", action="Please make sure the field type(s) of the query result is the same with the target table")
    public String sqlInsertIntoMismatchedFieldTypes(String var1, String var2, String var3);

    @ErrCode(codeId="SQL-00010007", cause="Could not create table ''{0}'' as source table", details="{1}", action="Please refer to details section for hint.\nIf it doesn't help, please contact customer support")
    public String sqlRegisterTableErrorAsSource(String var1, String var2);

    @ErrCode(codeId="SQL-00010008", cause="Could not create table ''{0}'' as target table", details="{1}", action="Please refer to details section for hint.\nIf it doesn't help, please contact customer support")
    public String sqlRegisterTableErrorAsSink(String var1, String var2);

    @ErrCode(codeId="SQL-00010009", cause="Could not create table ''{0}'' as dim table", details="{1}", action="Please refer to details section for hint.\nIf it doesn't help, please contact customer support")
    public String sqlRegisterTableErrorAsDim(String var1, String var2);

    @ErrCode(codeId="SQL-00010010", cause="Failed to create schema for table ''{0}'':\n{1} table does not support WATERMARK and PROCTIME().", details="", action="Please double check the sql statement and remove watermark definition from table definition.")
    public String sqlTableTypeNotSupportWaterMark(String var1, String var2);

    @ErrCode(codeId="SQL-00010011", cause="Failed to create schema for table ''{0}'':\n{1} table do not support computed column.", details="", action="please double check the sql statement and remove computed column definition from the table definition.")
    public String sqlTableTypeNotSupportComputedCol(String var1, String var2);

    @ErrCode(codeId="SQL-00010012", cause="Table ''{0}'' Column ''{1}'': Unsupported column type: ''{2}''", details="", action="Please refer to the blink user manual for the currently supported column types")
    public String sqlUnSupportedColumnType(String var1, String var2, String var3);

    @ErrCode(codeId="SQL-00020001", cause="Failed to register view ''{0}'' because registering view table to environment failed.", details="", action="Normally this happens unlikely. Please contact customer support for this")
    public String sqlRegisterViewErrorDueToViewTblRegExp(String var1);

    @ErrCode(codeId="SQL-00020002", cause="View ''{0}'' definition and input fields not match!\nDef Fields:   {1}\nInput Fields: {2}", details="", action="Please re-check create view statement.")
    public String sqlRegisterViewErrorFieldsMismatch(String var1, String var2, String var3);

    @ErrCode(codeId="SQL-00030001", cause="Group Window Agg: Retraction on windowed GroupBy aggregation is not supported yet. ", details="", action="please re-check sql grammar. \nNote: Windowed GroupBy aggregation should not follow anon-windowed GroupBy aggregation.")
    public String sqlGroupWindowAggTranslateRetractNotSupported();

    @ErrCode(codeId="SQL-00030002", cause="Group Window Agg: Time attribute could not be found.", details="", action="Time attribute could not be found. This is a bug.\nplease contact customer support for this")
    public String sqlGroupWindowAggTranslateTimeAttrNotFound();

    @ErrCode(codeId="SQL-00030003", cause="{0} aggregate function does not support type: ''{1}''.", details="", action="Please re-check the data type.")
    public String sqlAggFunctionDataTypeNotSupported(String var1, String var2);

    @ErrCode(codeId="SQL-00040001", cause="Over Agg: Unsupported use of OVER windows. {0}", details="", action="please re-check the over window statement")
    public String sqlOverAggInvalidUseOfOverWindow(String var1);

    @ErrCode(codeId="SQL-00040002", cause="Over Agg: The window rank function without order by.", details="", action="please re-check the over window statement")
    public String sqlOverRankWithoutOrderByInvalid();

    @ErrCode(codeId="SQL-00050001", cause="Joins should have at least one equality condition.\n{0}", details="", action="please re-check the join statement and make sure there's equality condition for join.")
    public String sqlJoinEqualConditionNotFound(String var1);

    @ErrCode(codeId="SQL-00050002", cause="Join[type: {0}] requires an equality condition on table's key field.", details="", action="please re-check the join statement and make sure there's equality condition on table's key field.")
    public String sqlJoinRequireEqCondOnKey(String var1);

    @ErrCode(codeId="SQL-00050003", cause="Dimension table require to define an primary key or unique key or index.", details="", action="please re-check your dim table definition and make sure there's primary or unique key or index defined.")
    public String sqlDimTableRequiresIndex();

    @ErrCode(codeId="SQL-00050004", cause="Join: Equality join predicate on incompatible types. {0}", details="", action="please re-check the join statement.")
    public String sqlJoinEqualJoinOnIncompatibleTypes(String var1);

    @ErrCode(codeId="SQL-00050005", cause="Join[type: {0}] only support LEFT JOIN or INNER JOIN, but was {1}", details="", action="please re-check your join statement.")
    public String sqlJoinTypeNotSupported(String var1, String var2);

    @ErrCode(codeId="SQL-00050006", cause="Stream to table join only support Row type returned dimension table, but was {0}", details="", action="please modify your dim table definition accordingly.")
    public String sqlStreamToTblJoinDimTypeNotSupported(String var1);

    @ErrCode(codeId="SQL-00050007", cause="{0}", details="", action="please modify your temporal table definition accordingly.")
    public String sqlJoinTemporalTableError(String var1);

    @ErrCode(codeId="SQL-00050008", cause="Join Internal Error: {0}", details="", action="Normally, this happens unlikely. please contact customer support for this")
    public String sqlJoinInternalError(String var1);

    @ErrCode(codeId="SQL-00050009", cause="Window Join: Windowed stream join does not support updates.", details="", action="please re-check window join statement according to description above")
    public String sqlWindowJoinUpdateNotSupported();

    @ErrCode(codeId="SQL-00050010", cause="Window Join: RowTime inner join between stream and stream is not supported yet.", details="", action="please re-check window join statement according to description above")
    public String sqlWindowJoinRowTimeInnerJoinBetweenStreamNotSupported();

    @ErrCode(codeId="SQL-00050011", cause="Window Join: {0} between stream and stream is not supported yet.", details="", action="please re-check window join statement according to description above")
    public String sqlWindowJoinBetweenStreamNotSupported(String var1);

    @ErrCode(codeId="SQL-00050012", cause="Join Dimension table requires an equality condition on ALL of table's primary key(s) or unique key(s) or index field(s).", details="", action="please re-check the join statement and make sure there's equality condition on table's index field.")
    public String sqlDimJoinRequireEqCondOnIndex();

    @ErrCode(codeId="SQL-00060001", cause="Union All: Cannot union streams of different type length.\nFirst:  {0}\nMismatch: {1}\n", details="", action="please re-check union all statement according to the description above")
    public String sqlUnionAllFieldsCntMismatch(String var1, String var2);

    @ErrCode(codeId="SQL-00060002", cause="Union All: Cannot union streams of different type(s).\nFirst different type(s):  {0}\nMismatch different type(s): {1}\n", details="", action="please re-check union all statement according to the description above")
    public String sqlUnionAllFieldsTypeMismatch(String var1, String var2);

    @ErrCode(codeId="SQL-00070001", cause="Sort: Primary sort order of a streaming table must be ascending on time.", details="", action="please re-check sort statement according to the description above")
    public String sqlSortOrderError();

    @ErrCode(codeId="SQL-00070002", cause="Sort: Streaming tables do not support sort with offset and fetch.", details="", action="please re-check sql grammar")
    public String sqlSortOffsetAndFetchNotSupported();

    @ErrCode(codeId="SQL-00070003", cause="Sort: Streaming tables do not support sort with offset.", details="", action="please re-check sort statement according to the description above")
    public String sqlSortOffsetNotSupported();

    @ErrCode(codeId="SQL-00070004", cause="Sort: Streaming tables do not support sort with fetch.", details="", action="please re-check sort statement according to the description above")
    public String sqlSortFetchNotSupported();

    @ErrCode(codeId="SQL-00070005", cause="Sort: Internal Error", details="", action="Normally, this happens unlikely. please contact customer support for this")
    public String sqlSortInternalError();

    @ErrCode(codeId="SQL-00080001", cause="FirstLastRow: Retraction on FirstLastRow is not supported yet. ", details="", action="please re-check sql grammar. \nNote: FirstLastRow should not follow a non-windowed GroupBy aggregation.")
    public String sqlFirstLastRowTranslateRetractNotSupported();

    @ErrCode(codeId="SQL-00100001", cause="{1} param error: {0}", details="", action="Please re-check param type(s) of the mentioned operator")
    public String sqlCodeGenOperatorParamError(String var1, String var2);

    @ErrCode(codeId="SQL-00100002", cause="Unsupported call: {0}", details="", action="This indicates that there's build-in function usage in sql statement that is, however, unsupported now.\nIn some scenarios, this is caused by TYPO errors.\nIn other cases, If you think this function should be supported, you can create an issue and start a discussion for it.")
    public String sqlCodeGenUnsupportedCall(String var1);

    @ErrCode(codeId="SQL-00100003", cause="Unsupported call: {0}", details="", action="This call is unsupported now.\nIn some cases, if you were sure the function name is correct, this is often caused by unmatched parameter(s)\nIn other cases, If you think this function should be supported, you can create an issue and start a discussion for it.")
    public String sqlCodeGenUnsupportedScalaFunc(String var1);

    @ErrCode(codeId="SQL-00100004", cause="Expect an array or a map.", details="", action="This indicates that Array or Map is expected but not present in your sql statement.")
    public String sqlCodeGenItemOperatorError();

    @ErrCode(codeId="SQL-00110001", cause="creating user defined function fails, functionName = {0}, className = {1}\n{2}", details="", action="Normally, this is caused by not uploading and/or referring\njar file containing udf definitions. Please double check your job resource")
    public String sqlCreateUserDefinedFuncError(String var1, String var2, String var3);

    @ErrCode(codeId="SQL-00110002", cause="registering user defined function failed, functionName = {0}, className = {1}\n{2}", details="", action="Normally, this is caused by not implementing\nudf correctly. Please double check your udf code")
    public String sqlRegisterUserDefinedFuncError(String var1, String var2, String var3);

    @ErrCode(codeId="SQL-00111000", cause="Can't start python process and connect to it.\n", details="{0}", action="Normally, this is caused by not uploading and/or referring\npython zip file containing udf definitions. Please double check your job resource")
    public String sqlPythonProcessError(String var1);

    @ErrCode(codeId="SQL-00111001", cause="Can't create socket and connect to python process.\n", details="{0}", action="Normally, this is caused by python process which was killed.")
    public String sqlPythonCreateSocketError(String var1);

    @ErrCode(codeId="SQL-00111002", cause="Can't connect to Python process now for UDF {0} {1}\n", details="{2}", action="Normally, it was caused by an exception or the socket or python processwas closed.")
    public String sqlPythonUDFSocketIOError(String var1, String var2, String var3);

    @ErrCode(codeId="SQL-00111003", cause="Error was raised in python UDF {0} {1}: \n", details="{2}", action="Normally, it was caused by python UDF error, please double check your python code")
    public String sqlPythonUDFRunTimeError(String var1, String var2, String var3);

    @ErrCode(codeId="SQL-00120001", cause="{0}", details="", action="Please see descriptions above. If it doesn't help, please contact customer support for this.")
    public String sqlUnclassifiedExpByCalcite(String var1);

    @ErrCode(codeId="SQL-00120002", cause="{0}", details="", action="Might use undefined column(s) in sql statement? Please double-check relevant table definitions")
    public String sqlColumnNotFoundByCalcite(String var1);

    @ErrCode(codeId="SQL-00120003", cause="{0}", details="", action="Might refer undefined table(s) in sql statement? Please make sure table(s) in question are already defined.")
    public String sqlTableNotFoundByCalcite(String var1);

    @ErrCode(codeId="SQL-00120004", cause="{0}", details="", action="It indicates that there's unidentified item in your sql statement. Might be TYPO, might be other stuff that's not defined or supported. \nAnyway, please double-check sql statement following hints given above")
    public String sqlObjNotFoundByCalcite(String var1);

    @ErrCode(codeId="SQL-00120005", cause="{0}", details="", action="It indicates there exists unknown identifier in sql statement. Might be TYPO, or undefined item, or unsupported semantic. \nAnyway, please double-check sql statement following hints given above")
    public String sqlUnknownIdentifierByCalcite(String var1);

    @ErrCode(codeId="SQL-00120006", cause="{0}", details="", action="Please re-check your sql statement as well as function definition and make sure argument number are the same in actual call and definition")
    public String sqlArgNumberInvalidByCalcite(String var1);

    @ErrCode(codeId="SQL-00120007", cause="{0}", details="", action="Please re-check your sql statement as well as function definition and make sure argument type(s) are the same in actual call and definition")
    public String sqlArgTypeInvalidByCalcite(String var1);

    @ErrCode(codeId="SQL-00120008", cause="{0}", details="", action="Please re-check your sql statement as well as function definition and make sure function parameters are the same in actual call and definition")
    public String sqlFuncSignatureNoMatchByCalcite(String var1);

    @ErrCode(codeId="SQL-00120009", cause="{0}", details="", action="Please re-check sql statement according to the description above")
    public String sqlExprNotGroundedByCalcite(String var1);

    @ErrCode(codeId="SQL-00120010", cause="{0}", details="", action="It indicates your sql statement contains no query expression. \nA valid sql for Blink Job must contains query expression.")
    public String sqlNonQueryExprByCalcite(String var1);

    @ErrCode(codeId="SQL-00120011", cause="{0}", details="", action="It indicates null is used in places that doesn't allow it to appear in your sql statement")
    public String sqlIllegalUseOfNullByCalcite(String var1);

    @ErrCode(codeId="SQL-00120012", cause="{0}", details="", action="Might indicates unsupported dataType is present in your table definition. Please note that it might also be caused by TYPO.")
    public String sqlUnknownDataTypeByCalcite(String var1);

    @ErrCode(codeId="SQL-01000001", cause="Sql optimization: Cannot generate a valid execution plan for the given query: \n {0} \n", details="{1}", action="Please check the documentation for the set of currently supported SQL features")
    public String sqlVolcanoOptimizeError(String var1, String var2);

    @ErrCode(codeId="SQL-01000002", cause="Sql optimization: Cannot generate a valid execution plan for the given query: \n {0} \n This exception indicates that the query uses an unsupported SQL feature.", details="{1}", action="Please check the documentation for the set of currently supported SQL features")
    public String sqlVolcanoOptimizeUnsupportedSQLFeature(String var1, String var2);

    @ErrCode(codeId="SQL-01000003", cause="sql optimization: Assertion error", details="{0}", action="please contact customer support for this")
    public String sqlVolcanoOptimizeAssertionExp(String var1);

    @ErrCode(codeId="SQL-02030001", cause="{0} aggregate execution does not support type: ''{1}''.", details="", action="Please re-check the data type.")
    public String sqlAggExecDataTypeNotSupported(String var1, String var2);

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ErrCode {
        public String codeId();

        public String cause();

        public String details();

        public String action();
    }
}

