/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Map;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.NoMatchingTableFactoryException;
import org.apache.flink.table.api.StreamTableEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ToolConnectorDescriptor;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.factories.BatchCompatibleTableSinkFactory;
import org.apache.flink.table.factories.BatchTableSinkFactory;
import org.apache.flink.table.factories.BatchTableSourceFactory;
import org.apache.flink.table.factories.StreamTableSinkFactory;
import org.apache.flink.table.factories.StreamTableSourceFactory;
import org.apache.flink.table.factories.TableFactoryService$;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.util.TableProperties;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;

public final class TableFactoryUtil$ {
    public static final TableFactoryUtil$ MODULE$;

    static {
        new TableFactoryUtil$();
    }

    public <T> TableSource findAndCreateTableSource(TableEnvironment tableEnvironment, Descriptor descriptor) {
        return this.findAndCreateTableSource(tableEnvironment, descriptor, null);
    }

    public <T> TableSource findAndCreateTableSource(TableEnvironment tableEnvironment, Descriptor descriptor, ClassLoader classLoader) {
        TableEnvironment tableEnvironment2;
        block4: {
            TableSource tableSource;
            block3: {
                Map<String, String> javaMap;
                block2: {
                    javaMap = descriptor.toProperties();
                    tableEnvironment2 = tableEnvironment;
                    if (!(tableEnvironment2 instanceof BatchTableEnvironment)) break block2;
                    tableSource = TableFactoryService$.MODULE$.find(BatchTableSourceFactory.class, javaMap, classLoader).createBatchTableSource(javaMap);
                    break block3;
                }
                if (!(tableEnvironment2 instanceof StreamTableEnvironment)) break block4;
                tableSource = TableFactoryService$.MODULE$.find(StreamTableSourceFactory.class, javaMap, classLoader).createStreamTableSource(javaMap);
            }
            return tableSource;
        }
        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported table environment: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableEnvironment2.getClass().getName()})));
    }

    public <T> ClassLoader findAndCreateTableSource$default$3() {
        return null;
    }

    public <T> TableSink<T> findAndCreateTableSink(TableEnvironment tableEnvironment, Descriptor descriptor) {
        return this.findAndCreateTableSink(tableEnvironment, descriptor, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> TableSink<T> findAndCreateTableSink(TableEnvironment tableEnvironment, Descriptor descriptor, ClassLoader classLoader) {
        Map<String, String> javaMap = descriptor.toProperties();
        TableEnvironment tableEnvironment2 = tableEnvironment;
        if (tableEnvironment2 instanceof BatchTableEnvironment) {
            TableSink tableSink;
            try {
                tableSink = TableFactoryService$.MODULE$.find(BatchTableSinkFactory.class, javaMap, classLoader).createBatchTableSink(javaMap);
                return tableSink;
            }
            catch (NoMatchingTableFactoryException noMatchingTableFactoryException) {
                tableSink = TableFactoryService$.MODULE$.find(BatchCompatibleTableSinkFactory.class, javaMap, classLoader).createBatchCompatibleTableSink(javaMap);
            }
            return tableSink;
        } else {
            if (!(tableEnvironment2 instanceof StreamTableEnvironment)) throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported table environment: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableEnvironment2.getClass().getName()})));
            return TableFactoryService$.MODULE$.find(StreamTableSinkFactory.class, javaMap, classLoader).createStreamTableSink(javaMap);
        }
    }

    public <T> ClassLoader findAndCreateTableSink$default$3() {
        return null;
    }

    public ToolConnectorDescriptor getDiscriptorFromTableProperties(TableProperties tableProperties) {
        String typeName = tableProperties.getString("connector.type", "");
        tableProperties.remove("connector.type");
        if (typeName.trim().length() == 0) {
            throw new TableException("Connector type should not be null!");
        }
        return new ToolConnectorDescriptor(typeName, tableProperties.toMap());
    }

    private TableFactoryUtil$() {
        MODULE$ = this;
    }
}

