/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories.csv;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.table.api.RichTableSchema;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.factories.BatchCompatibleTableSinkFactory;
import org.apache.flink.table.factories.BatchTableSourceFactory;
import org.apache.flink.table.factories.StreamTableSinkFactory;
import org.apache.flink.table.factories.StreamTableSourceFactory;
import org.apache.flink.table.factories.csv.CsvOptions;
import org.apache.flink.table.sinks.BatchCompatibleStreamTableSink;
import org.apache.flink.table.sinks.StreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.csv.CsvTableSink;
import org.apache.flink.table.sinks.csv.RetractCsvTableSink;
import org.apache.flink.table.sinks.csv.UpsertCsvTableSink;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.csv.CsvTableSource;
import org.apache.flink.table.util.TableProperties;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;

public class CsvTableFactory
implements StreamTableSourceFactory<BaseRow>,
BatchTableSourceFactory<BaseRow>,
StreamTableSinkFactory<Object>,
BatchCompatibleTableSinkFactory<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(CsvTableFactory.class);

    @Override
    public BatchCompatibleStreamTableSink<Object> createBatchCompatibleTableSink(Map<String, String> properties) {
        return (BatchCompatibleStreamTableSink)this.createCsvTableSink(properties, false);
    }

    @Override
    public BatchTableSource<BaseRow> createBatchTableSource(Map<String, String> properties) {
        return this.createCsvTableSource(properties);
    }

    @Override
    public StreamTableSink<Object> createStreamTableSink(Map<String, String> properties) {
        return (StreamTableSink)this.createCsvTableSink(properties, true);
    }

    @Override
    public StreamTableSource<BaseRow> createStreamTableSource(Map<String, String> properties) {
        return this.createCsvTableSource(properties);
    }

    @Override
    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", "CSV");
        context.put("connector.property-version", "1");
        return context;
    }

    @Override
    public List<String> supportedProperties() {
        return CsvOptions.SUPPORTED_KEYS;
    }

    private CsvTableSource createCsvTableSource(Map<String, String> props) {
        String commentsPrefix;
        boolean firstLineAsHeader;
        TableProperties properties = new TableProperties();
        properties.putProperties(props);
        RichTableSchema schema2 = properties.readSchemaFromProperties(null);
        String path = properties.getString(CsvOptions.PATH);
        if (StringUtils.isNullOrWhitespaceOnly(path)) {
            throw new IllegalArgumentException(CsvOptions.PARAMS_HELP_MSG);
        }
        String fieldDelim = CsvTableFactory.getJavaEscapedDelim(properties.getString(CsvOptions.OPTIONAL_FIELD_DELIM));
        String lineDelim = CsvTableFactory.getJavaEscapedDelim(properties.getString(CsvOptions.OPTIONAL_LINE_DELIM));
        String charset = properties.getString(CsvOptions.OPTIONAL_CHARSET);
        boolean emptyColumnAsNull = properties.getBoolean(CsvOptions.EMPTY_COLUMN_AS_NULL);
        boolean lenient = properties.getBoolean(CsvOptions.LENIENT);
        String timeZone = properties.getString(CsvOptions.OPTIONAL_TIME_ZONE);
        TimeZone tz = timeZone == null ? TimeZone.getTimeZone("UTC") : TimeZone.getTimeZone(timeZone);
        boolean enumerateNestedFiles = properties.getBoolean(CsvOptions.OPTIONAL_ENUMERATE_NESTED_FILES);
        CsvTableSource.Builder builder = CsvTableSource.builder().path(path).fieldDelimiter(fieldDelim).lineDelimiter(lineDelim).charset(charset).fields(schema2.getColumnNames(), schema2.getColumnTypes(), schema2.getNullables()).timezone(tz).setNestedFileEnumerate(enumerateNestedFiles);
        HashSet<Set<String>> uniqueKeys = new HashSet<Set<String>>();
        HashSet<Set<String>> normalIndexes = new HashSet<Set<String>>();
        if (!schema2.getPrimaryKeys().isEmpty()) {
            uniqueKeys.add(new HashSet<String>(schema2.getPrimaryKeys()));
        }
        for (List<String> uniqueKey : schema2.getUniqueKeys()) {
            uniqueKeys.add(new HashSet<String>(uniqueKey));
        }
        for (RichTableSchema.Index index : schema2.getIndexes()) {
            if (index.unique) {
                uniqueKeys.add(new HashSet<String>(index.keyList));
                continue;
            }
            normalIndexes.add(new HashSet<String>(index.keyList));
        }
        if (!uniqueKeys.isEmpty()) {
            builder.uniqueKeys(uniqueKeys);
        }
        if (!normalIndexes.isEmpty()) {
            builder.indexKeys(normalIndexes);
        }
        if (emptyColumnAsNull) {
            builder.enableEmptyColumnAsNull();
        }
        builder.setLenient(lenient);
        String quoteCharacter = CsvTableFactory.getJavaEscapedDelim(properties.getString(CsvOptions.OPTIONAL_QUOTE_CHARACTER));
        if (quoteCharacter != null) {
            Preconditions.checkArgument(quoteCharacter.length() == 1, "quote character should be a single character, " + quoteCharacter + " found.");
            builder.quoteCharacter(Character.valueOf(quoteCharacter.charAt(0)));
        }
        if (firstLineAsHeader = properties.getBoolean(CsvOptions.OPTIONAL_FIRST_LINE_AS_HEADER)) {
            builder.ignoreFirstLine();
        }
        if ((commentsPrefix = properties.getString(CsvOptions.OPTIONAL_COMMENTS_PREFIX)) != null) {
            builder.commentPrefix(commentsPrefix);
        }
        return builder.build();
    }

    private TableSink createCsvTableSink(Map<String, String> props, boolean isStreaming) {
        int parallelism;
        TableProperties properties = new TableProperties();
        properties.putProperties(props);
        RichTableSchema schema2 = properties.readSchemaFromProperties(null);
        String path = properties.getString(CsvOptions.PATH);
        if (StringUtils.isNullOrWhitespaceOnly(path)) {
            throw new IllegalArgumentException(CsvOptions.PARAMS_HELP_MSG);
        }
        boolean writeModeFlag = properties.getBoolean(CsvOptions.OPTIONAL_OVER_RIDE_MODE);
        FileSystem.WriteMode writeMode = writeModeFlag ? FileSystem.WriteMode.OVERWRITE : FileSystem.WriteMode.NO_OVERWRITE;
        String fieldDelim = CsvTableFactory.getJavaEscapedDelim(properties.getString(CsvOptions.OPTIONAL_FIELD_DELIM));
        String lineDelim = CsvTableFactory.getJavaEscapedDelim(properties.getString(CsvOptions.OPTIONAL_LINE_DELIM));
        String quoteCharacter = CsvTableFactory.getJavaEscapedDelim(properties.getString(CsvOptions.OPTIONAL_QUOTE_CHARACTER));
        if (quoteCharacter != null) {
            Preconditions.checkArgument(quoteCharacter.length() == 1, "quote character should be a single character, " + quoteCharacter + " found.");
        }
        Option numFiles = (parallelism = properties.getInteger(CsvOptions.PARALLELISM, -1)) == -1 ? Option.apply(null) : new Some((Object)parallelism);
        String timeZone = properties.getString(CsvOptions.OPTIONAL_TIME_ZONE);
        TimeZone tz = timeZone == null ? TimeZone.getTimeZone("UTC") : TimeZone.getTimeZone(timeZone);
        String updateMode = properties.getString(CsvOptions.OPTIONAL_UPDATE_MODE);
        switch (updateMode.toLowerCase()) {
            case "append": {
                return new CsvTableSink(path, (Option<String>)Option.apply((Object)fieldDelim), (Option<String>)Option.apply((Object)lineDelim), (Option<String>)Option.apply((Object)quoteCharacter), (Option<Object>)numFiles, (Option<FileSystem.WriteMode>)Option.apply((Object)((Object)writeMode)), (Option<Object>)Option.empty(), (Option<TimeZone>)Option.apply((Object)tz)).configure(schema2.getColumnNames(), schema2.getColumnTypes());
            }
            case "retract": {
                return new RetractCsvTableSink(path, (Option<String>)Option.apply((Object)fieldDelim), (Option<String>)Option.apply((Object)lineDelim), (Option<String>)Option.apply((Object)quoteCharacter), (Option<Object>)numFiles, (Option<FileSystem.WriteMode>)Option.apply((Object)((Object)writeMode)), (Option<Object>)Option.empty(), (Option<TimeZone>)Option.apply((Object)tz)).configure(schema2.getColumnNames(), schema2.getColumnTypes());
            }
            case "upsert": {
                return new UpsertCsvTableSink(path, (Option<String>)Option.apply((Object)fieldDelim), (Option<String>)Option.apply((Object)lineDelim), (Option<String>)Option.apply((Object)quoteCharacter), (Option<Object>)numFiles, (Option<FileSystem.WriteMode>)Option.apply((Object)((Object)writeMode)), (Option<Object>)Option.empty(), (Option<TimeZone>)Option.apply((Object)tz)).configure(schema2.getColumnNames(), schema2.getColumnTypes());
            }
        }
        throw new RuntimeException("Unsupported updateMode: " + updateMode + " for CSV sink.");
    }

    public static String getJavaEscapedDelim(String fieldDelim) {
        String unescapedFieldDelim = StringEscapeUtils.unescapeJava((String)fieldDelim);
        if (fieldDelim != null && !fieldDelim.equals(unescapedFieldDelim)) {
            LOG.info("Field delimiter unescaped from {} to {}.", (Object)fieldDelim, (Object)unescapedFieldDelim);
        }
        return unescapedFieldDelim;
    }
}

