/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.hive.functions;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.UDF;

public class HiveFunctionWrapper<UDFType>
implements Serializable {
    private String className;
    private List<Boolean> constants;
    private transient UDFType instance = null;

    public HiveFunctionWrapper(String className) {
        this.className = className;
    }

    public HiveFunctionWrapper(Class<?> clazz) {
        this.className = clazz.getName();
    }

    public UDFType createFunction() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (null != this.instance) {
            return this.instance;
        }
        Object func = HiveFunctionWrapper.getClassLoader().loadClass(this.className).newInstance();
        if (!(func instanceof UDF)) {
            this.instance = func;
        }
        return (UDFType)func;
    }

    public Class<UDFType> getUDFClass() throws ClassNotFoundException {
        return Class.forName(this.className);
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public void setConstants(List<Boolean> constants2) {
        this.constants = constants2;
    }

    public List<Boolean> getConstants() {
        return this.constants;
    }
}

