/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.hive.functions;

import java.util.ArrayList;
import org.apache.flink.table.api.functions.FunctionContext;
import org.apache.flink.table.api.functions.ScalarFunction;
import org.apache.flink.table.hive.functions.DeferredObjectAdapter;
import org.apache.flink.table.hive.functions.HiveFunctionWrapper;
import org.apache.flink.table.hive.functions.HiveInspectors;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class HiveGenericUDF
extends ScalarFunction {
    private final HiveFunctionWrapper<GenericUDF> hiveFunctionWrapper;
    private transient GenericUDF function;
    private transient ObjectInspector returnInspector;
    private transient GenericUDF.DeferredObject[] deferredObjects;
    private transient boolean initialized = false;

    public HiveGenericUDF(HiveFunctionWrapper<GenericUDF> hiveFunctionWrapper) {
        this.hiveFunctionWrapper = hiveFunctionWrapper;
        this.initialized = false;
    }

    @Override
    public void open(FunctionContext context) throws Exception {
        this.function = this.hiveFunctionWrapper.createFunction();
        this.initialized = false;
    }

    @Override
    public void close() {
        this.initialized = false;
    }

    private void initialize(Object ... args) throws UDFArgumentException {
        ObjectInspector[] argumentInspectors = HiveInspectors.toInspectors(args, this.hiveFunctionWrapper.getConstants());
        this.returnInspector = this.function.initializeAndFoldConstants(argumentInspectors);
        this.deferredObjects = new GenericUDF.DeferredObject[args.length];
        for (int i = 0; i < this.deferredObjects.length; ++i) {
            this.deferredObjects[i] = new DeferredObjectAdapter();
        }
        this.initialized = true;
    }

    public Object eval(Object ... args) throws HiveException {
        if (!this.initialized) {
            this.initialize(args);
        }
        for (int i = 0; i < args.length; ++i) {
            ((DeferredObjectAdapter)this.deferredObjects[i]).set(args[i]);
        }
        Object obj = this.function.evaluate(this.deferredObjects);
        return HiveInspectors.unwrap(obj, this.returnInspector);
    }

    @Override
    public DataType getResultType(Object[] arguments, Class[] argTypes) {
        try {
            if (null == this.function) {
                this.function = this.hiveFunctionWrapper.createFunction();
            }
            ArrayList<Boolean> contants = new ArrayList<Boolean>();
            for (Object argument : arguments) {
                if (argument == null) {
                    contants.add(false);
                    continue;
                }
                contants.add(true);
            }
            this.hiveFunctionWrapper.setConstants(contants);
            this.initialize(arguments);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UDFArgumentException e2) {
            throw new RuntimeException(e2);
        }
        return HiveInspectors.inspectorToDataType(this.returnInspector);
    }

    @Override
    public boolean isDeterministic() {
        try {
            UDFType udfType = this.hiveFunctionWrapper.getUDFClass().getAnnotation(UDFType.class);
            return udfType != null && udfType.deterministic() && !udfType.stateful();
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }
}

