/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.hive.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.functions.FunctionContext;
import org.apache.flink.table.api.functions.TableFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.hive.functions.HiveFunctionWrapper;
import org.apache.flink.table.hive.functions.HiveInspectors;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.Collector;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class HiveGenericUDTF
extends TableFunction<BaseRow> {
    private final HiveFunctionWrapper<GenericUDTF> hiveFunctionWrapper;
    private final UDTFCollector collector = new UDTFCollector();
    private transient GenericUDTF function;
    private transient boolean initialized;
    private transient StructObjectInspector returnInspector;

    public HiveGenericUDTF(HiveFunctionWrapper<GenericUDTF> hiveFunctionWrapper) {
        this.hiveFunctionWrapper = hiveFunctionWrapper;
        this.initialized = false;
    }

    @Override
    public void open(FunctionContext context) throws Exception {
        this.function = this.hiveFunctionWrapper.createFunction();
        this.function.setCollector((Collector)this.collector);
        this.initialized = false;
    }

    @Override
    public void close() {
        this.initialized = false;
    }

    private void initialize(Object ... args) throws UDFArgumentException {
        ObjectInspector[] argumentInspectors = HiveInspectors.toInspectors(args, this.hiveFunctionWrapper.getConstants());
        this.returnInspector = this.function.initialize(argumentInspectors);
        this.collector.setReturnInspector(this.returnInspector);
        this.initialized = true;
    }

    public void eval(Object ... args) throws HiveException {
        if (!this.initialized) {
            this.initialize(args);
        }
        this.function.process(args);
        this.collector.collectRows(this);
    }

    @Override
    public DataType getResultType(Object[] arguments, Class[] argTypes) {
        try {
            if (null == this.function) {
                this.function = this.hiveFunctionWrapper.createFunction();
                this.function.setCollector((Collector)this.collector);
                this.collector.setReturnInspector(this.returnInspector);
            }
            ArrayList<Boolean> constants2 = new ArrayList<Boolean>();
            for (Object argument : arguments) {
                if (null == argument) {
                    constants2.add(false);
                    continue;
                }
                constants2.add(true);
            }
            this.hiveFunctionWrapper.setConstants(constants2);
            this.initialize(arguments);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UDFArgumentException e2) {
            throw new RuntimeException(e2);
        }
        return HiveInspectors.inspectorToDataType((ObjectInspector)this.returnInspector);
    }

    public static class UDTFCollector
    implements Collector {
        private List<BaseRow> baseRows = new ArrayList<BaseRow>();
        private transient StructObjectInspector returnInspector;

        public void setReturnInspector(StructObjectInspector returnInspector) {
            this.returnInspector = returnInspector;
        }

        public void collect(Object input) {
            BaseRow row2 = (BaseRow)HiveInspectors.unwrap(input, (ObjectInspector)this.returnInspector);
            this.baseRows.add(row2);
        }

        public void collectRows(TableFunction<BaseRow> tableFunction) {
            Iterator<BaseRow> i = this.baseRows.iterator();
            while (i.hasNext()) {
                tableFunction.collect(i.next());
                i.remove();
            }
        }
    }
}

