/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.hive.functions;

import java.util.ArrayList;
import org.apache.flink.table.api.functions.AggregateFunction;
import org.apache.flink.table.api.functions.FunctionContext;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.hive.functions.HiveFunctionWrapper;
import org.apache.flink.table.hive.functions.HiveInspectors;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

public class HiveUDAFFunction
extends AggregateFunction<BaseRow, GenericUDAFEvaluator.AggregationBuffer> {
    private final HiveFunctionWrapper<?> hiveFunctionWrapper;
    private final boolean isUDAFBridgeRequired;
    private transient GenericUDAFResolver2 resolver;
    private transient GenericUDAFEvaluator finalEvaluator;
    private transient boolean finalEvaluatorByVoid;
    private transient GenericUDAFEvaluator partial1Evaluator;
    private transient boolean partial1EvaluatorByVoid;
    private transient GenericUDAFEvaluator partial2Evaluator;
    private transient boolean partial2EvaluatorByVoid;
    private transient ObjectInspector[] inputInspectors;
    private transient ObjectInspector returnInspector;
    private transient ObjectInspector partialResultInspector;

    public HiveUDAFFunction(HiveFunctionWrapper<?> hiveFunctionWrapper) throws ClassNotFoundException {
        this.hiveFunctionWrapper = hiveFunctionWrapper;
        this.isUDAFBridgeRequired = hiveFunctionWrapper.getUDFClass().equals(UDAF.class);
        this.finalEvaluatorByVoid = true;
        this.partial1EvaluatorByVoid = true;
        this.partial2EvaluatorByVoid = true;
        this.inputInspectors = null;
    }

    private GenericUDAFResolver2 newResolver() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.isUDAFBridgeRequired) {
            return new GenericUDAFBridge((UDAF)this.hiveFunctionWrapper.createFunction());
        }
        return (GenericUDAFResolver2)this.hiveFunctionWrapper.createFunction();
    }

    public void accumulate(GenericUDAFEvaluator.AggregationBuffer acc, Object ... params) {
        if (null == this.inputInspectors || this.finalEvaluatorByVoid || this.partial1EvaluatorByVoid || this.partial2EvaluatorByVoid) {
            ArrayList<Boolean> constans = new ArrayList<Boolean>(params.length);
            for (Object ignored : params) {
                constans.add(false);
            }
            this.inputInspectors = HiveInspectors.toInspectors(params, constans);
            try {
                if (this.finalEvaluatorByVoid) {
                    this.finalEvaluator = null;
                    this.getFinalEvaluator();
                }
                if (this.partial1EvaluatorByVoid) {
                    this.partial1Evaluator = null;
                    this.getPartial1Evaluator();
                }
                if (this.partial2EvaluatorByVoid) {
                    this.partial2Evaluator = null;
                    this.getPartial2Evaluator();
                }
            }
            catch (HiveException e2) {
                throw new RuntimeException(e2);
            }
        }
        try {
            this.getPartial1Evaluator().iterate(acc, params);
        }
        catch (HiveException e3) {
            throw new RuntimeException(e3);
        }
    }

    public void resetAccumulator(GenericUDAFEvaluator.AggregationBuffer acc) {
        try {
            this.getPartial1Evaluator().reset(acc);
            this.getPartial2Evaluator().reset(acc);
            this.getFinalEvaluator().reset(acc);
        }
        catch (HiveException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void open(FunctionContext context) throws Exception {
        this.resolver = this.newResolver();
        this.partial1Evaluator = null;
        this.partial2Evaluator = null;
        this.finalEvaluator = null;
    }

    private GenericUDAFEvaluator getFinalEvaluator() throws HiveException {
        if (this.finalEvaluatorByVoid) {
            this.finalEvaluator = null;
        }
        if (null == this.finalEvaluator) {
            if (null == this.inputInspectors) {
                SimpleGenericUDAFParameterInfo paramInfo = this.getLazyVoidOneParam();
                this.finalEvaluator = this.resolver.getEvaluator((GenericUDAFParameterInfo)paramInfo);
                this.inputInspectors = paramInfo.getParameterObjectInspectors();
                this.finalEvaluatorByVoid = true;
            } else {
                SimpleGenericUDAFParameterInfo paramInfo = new SimpleGenericUDAFParameterInfo(this.inputInspectors, false, false, false);
                this.finalEvaluator = this.resolver.getEvaluator((GenericUDAFParameterInfo)paramInfo);
                this.finalEvaluatorByVoid = false;
            }
            this.returnInspector = this.finalEvaluator.init(GenericUDAFEvaluator.Mode.FINAL, this.inputInspectors);
        }
        return this.finalEvaluator;
    }

    private GenericUDAFEvaluator getPartial1Evaluator() throws HiveException {
        if (this.partial1EvaluatorByVoid) {
            this.partial1Evaluator = null;
        }
        if (null == this.partial1Evaluator) {
            if (null == this.inputInspectors) {
                SimpleGenericUDAFParameterInfo paramInfo = this.getLazyVoidOneParam();
                this.partial1Evaluator = this.resolver.getEvaluator((GenericUDAFParameterInfo)paramInfo);
                this.inputInspectors = paramInfo.getParameterObjectInspectors();
                this.partial1EvaluatorByVoid = true;
            } else {
                SimpleGenericUDAFParameterInfo paramInfo = new SimpleGenericUDAFParameterInfo(this.inputInspectors, false, false, false);
                this.partial1Evaluator = this.resolver.getEvaluator((GenericUDAFParameterInfo)paramInfo);
                this.partial1EvaluatorByVoid = false;
            }
            this.partialResultInspector = this.partial1Evaluator.init(GenericUDAFEvaluator.Mode.PARTIAL1, this.inputInspectors);
        }
        return this.partial1Evaluator;
    }

    private GenericUDAFEvaluator getPartial2Evaluator() throws HiveException {
        if (this.partial2EvaluatorByVoid) {
            this.partial2Evaluator = null;
        }
        if (null == this.partial2Evaluator) {
            if (null == this.partialResultInspector) {
                SimpleGenericUDAFParameterInfo parameterInfo = this.getLazyVoidOneParam();
                this.partial2Evaluator = this.resolver.getEvaluator((GenericUDAFParameterInfo)parameterInfo);
                this.partialResultInspector = parameterInfo.getParameterObjectInspectors()[0];
                this.partial2EvaluatorByVoid = true;
            } else {
                SimpleGenericUDAFParameterInfo paramInfo = new SimpleGenericUDAFParameterInfo(this.inputInspectors, false, false, false);
                this.partial2Evaluator = this.resolver.getEvaluator((GenericUDAFParameterInfo)paramInfo);
                this.partial2EvaluatorByVoid = false;
            }
            ObjectInspector[] partial1Types = new ObjectInspector[]{this.partialResultInspector};
            this.partial2Evaluator.init(GenericUDAFEvaluator.Mode.PARTIAL2, partial1Types);
        }
        return this.partial2Evaluator;
    }

    private SimpleGenericUDAFParameterInfo getLazyVoidOneParam() {
        ObjectInspector[] objectInspectors = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG)};
        return new SimpleGenericUDAFParameterInfo(objectInspectors, false, false, false);
    }

    @Override
    public GenericUDAFEvaluator.AggregationBuffer createAccumulator() {
        try {
            if (null == this.resolver) {
                this.resolver = this.newResolver();
            }
            return this.getPartial1Evaluator().getNewAggregationBuffer();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | HiveException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public BaseRow getValue(GenericUDAFEvaluator.AggregationBuffer accumulator) {
        try {
            Object result = this.getFinalEvaluator().terminate(accumulator);
            Object flinkResult = HiveInspectors.unwrap(result, this.returnInspector);
            GenericRow value = new GenericRow(1);
            value.update(0, flinkResult);
            return value;
        }
        catch (HiveException e2) {
            throw new RuntimeException(e2);
        }
    }
}

