/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan;

import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.SemiJoin;

public enum FlinkJoinRelType {
    INNER,
    LEFT,
    RIGHT,
    FULL,
    SEMI,
    ANTI;


    public boolean isOuter() {
        switch (this) {
            case LEFT: 
            case RIGHT: 
            case FULL: {
                return true;
            }
        }
        return false;
    }

    public boolean isLeftOuter() {
        switch (this) {
            case LEFT: 
            case FULL: {
                return true;
            }
        }
        return false;
    }

    public boolean isRightOuter() {
        switch (this) {
            case RIGHT: 
            case FULL: {
                return true;
            }
        }
        return false;
    }

    public static FlinkJoinRelType toFlinkJoinRelType(JoinRelType joinType) {
        switch (joinType) {
            case INNER: {
                return INNER;
            }
            case LEFT: {
                return LEFT;
            }
            case RIGHT: {
                return RIGHT;
            }
            case FULL: {
                return FULL;
            }
        }
        throw new IllegalArgumentException("invalid: " + (Object)((Object)joinType));
    }

    public static FlinkJoinRelType getFlinkJoinRelType(Join join) {
        if (join instanceof SemiJoin) {
            return ((SemiJoin)join).isAnti ? ANTI : SEMI;
        }
        return FlinkJoinRelType.toFlinkJoinRelType(join.getJoinType());
    }

    public static JoinRelType toJoinRelType(FlinkJoinRelType joinType) {
        switch (joinType) {
            case INNER: {
                return JoinRelType.INNER;
            }
            case LEFT: {
                return JoinRelType.LEFT;
            }
            case RIGHT: {
                return JoinRelType.RIGHT;
            }
            case FULL: {
                return JoinRelType.FULL;
            }
        }
        throw new IllegalArgumentException("invalid: " + (Object)((Object)joinType));
    }
}

