/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.physical.batch;

import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.runtime.operators.DamBehavior;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.codegen.CodeGenUtils$;
import org.apache.flink.table.codegen.CodeGeneratorContext;
import org.apache.flink.table.codegen.CodeGeneratorContext$;
import org.apache.flink.table.codegen.ExprCodeGenerator;
import org.apache.flink.table.codegen.GeneratedExpression;
import org.apache.flink.table.codegen.GeneratedOperator;
import org.apache.flink.table.codegen.operator.OperatorCodeGenerator$;
import org.apache.flink.table.plan.cost.FlinkBatchCost$;
import org.apache.flink.table.plan.cost.FlinkCostFactory;
import org.apache.flink.table.plan.nodes.ExpressionFormat$;
import org.apache.flink.table.plan.nodes.exec.batch.BatchExecNodeVisitor;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecNestedLoopJoinBase;
import org.apache.flink.table.runtime.TwoInputSubstituteStreamOperator;
import org.apache.flink.table.runtime.TwoInputSubstituteStreamOperator$;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.util.NodeResourceUtil;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public abstract class BatchExecNestedLoopJoinBase$class {
    public static RelWriter explainTerms(BatchExecNestedLoopJoinBase $this, RelWriter pw) {
        return $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$$super$explainTerms(pw).item("build", $this.leftIsBuild() ? "left" : "right").itemIf("singleRowJoin", BoxesRunTime.boxToBoolean((boolean)$this.singleRowJoin()), $this.singleRowJoin());
    }

    public static RelNode satisfyTraitsByInput(BatchExecNestedLoopJoinBase $this, RelTraitSet requiredTraitSet) {
        return $this.pushDownTraitsIntoBroadcastJoin(requiredTraitSet, $this.leftIsBuild());
    }

    public static RelOptCost computeSelfCost(BatchExecNestedLoopJoinBase $this, RelOptPlanner planner, RelMetadataQuery mq) {
        Double leftRowCnt = mq.getRowCount(((BiRel)((Object)$this)).getLeft());
        Double rightRowCnt = mq.getRowCount(((BiRel)((Object)$this)).getRight());
        if (leftRowCnt == null || rightRowCnt == null) {
            return null;
        }
        RelNode buildRel = $this.leftIsBuild() ? ((BiRel)((Object)$this)).getLeft() : ((BiRel)((Object)$this)).getRight();
        double memoryCost = Predef$.MODULE$.Double2double(mq.getRowCount(buildRel)) * (Predef$.MODULE$.Double2double(mq.getAverageRowSize(buildRel)) + (double)4) * (double)$this.shuffleBuildCount(mq);
        double cpuCost = Predef$.MODULE$.Double2double(leftRowCnt) * Predef$.MODULE$.Double2double(rightRowCnt);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        return costFactory.makeCost(Predef$.MODULE$.Double2double(mq.getRowCount($this)), cpuCost, 0.0, 0.0, memoryCost);
    }

    public static int shuffleBuildCount(BatchExecNestedLoopJoinBase $this, RelMetadataQuery mq) {
        RelNode probeRel = $this.leftIsBuild() ? ((BiRel)((Object)$this)).getRight() : ((BiRel)((Object)$this)).getLeft();
        Double rowCount = mq.getRowCount(probeRel);
        return rowCount == null ? 1 : Math.max(1, (int)(Predef$.MODULE$.Double2double(rowCount) * Predef$.MODULE$.Double2double(mq.getAverageRowSize(probeRel)) / (double)FlinkBatchCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE()));
    }

    public static DamBehavior getDamBehavior(BatchExecNestedLoopJoinBase $this) {
        return DamBehavior.PIPELINED;
    }

    public static void accept(BatchExecNestedLoopJoinBase $this, BatchExecNodeVisitor visitor) {
        visitor.visit($this);
    }

    public static StreamTransformation translateToPlanInternal(BatchExecNestedLoopJoinBase $this, BatchTableEnvironment tableEnv) {
        TableConfig config = tableEnv.getConfig();
        StreamTransformation<?> leftInput = $this.getInputNodes().get(0).translateToPlan(tableEnv);
        StreamTransformation<?> rightInput = $this.getInputNodes().get(1).translateToPlan(tableEnv);
        RowType leftType = (RowType)TypeConverters$.MODULE$.createInternalTypeFromTypeInfo(leftInput.getOutputType());
        RowType rightType = (RowType)TypeConverters$.MODULE$.createInternalTypeFromTypeInfo(rightInput.getOutputType());
        CodeGeneratorContext ctx = CodeGeneratorContext$.MODULE$.apply(config, CodeGeneratorContext$.MODULE$.apply$default$2());
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, $this.flinkJoinType().isOuter(), config.getNullCheck());
        RowType x$4 = leftType;
        String x$5 = $this.input1Term();
        Option<int[]> x$6 = qual$1.bindInput$default$3();
        ExprCodeGenerator qual$2 = qual$1.bindInput(x$4, x$5, x$6);
        RowType x$7 = rightType;
        String x$8 = $this.input2Term();
        Option<int[]> x$9 = qual$2.bindSecondInput$default$3();
        ExprCodeGenerator exprGenerator = qual$2.bindSecondInput(x$7, x$8, x$9);
        String buffer = CodeGenUtils$.MODULE$.newName("resettableExternalBuffer");
        String iter = CodeGenUtils$.MODULE$.newName("iter");
        String isFirstRow = CodeGenUtils$.MODULE$.newName("isFirstRow");
        String isBinaryRow = CodeGenUtils$.MODULE$.newName("isBinaryRow");
        long externalBufferMemorySize = (long)$this.getResource().getReservedManagedMem() * NodeResourceUtil.SIZE_IN_MB;
        if ($this.singleRowJoin()) {
            ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = null;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.BASE_ROW(), $this.buildRow()})), ctx.addReusableMember$default$2());
        } else {
            ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"boolean ", " = true;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{isFirstRow})), ctx.addReusableMember$default$2());
            ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"boolean ", " = false;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{isBinaryRow})), ctx.addReusableMember$default$2());
            String serializer = CodeGenUtils$.MODULE$.newName("serializer");
            if ($this.leftIsBuild()) {
                BatchExecNestedLoopJoinBase$class.initSerializer$1($this, 1, ctx, serializer);
            } else {
                BatchExecNestedLoopJoinBase$class.initSerializer$1($this, 2, ctx, serializer);
            }
            ctx.addReusableResettableExternalBuffer(buffer, externalBufferMemorySize, serializer);
            ctx.addReusableCloseStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".close();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer})));
            String iterTerm = ResettableExternalBuffer.BufferIterator.class.getCanonicalName();
            ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = null;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iterTerm, iter})), ctx.addReusableMember$default$2());
        }
        GeneratedExpression condExpr = exprGenerator.generateExpression(((Join)((Object)$this)).getCondition());
        String buildRowSer = ctx.addReusableTypeSerializer($this.leftIsBuild() ? leftType : rightType);
        String buildProcessCode = $this.singleRowJoin() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this.", " = (", ") ", ".copy(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.buildRow(), CodeGeneratorContext$.MODULE$.BASE_ROW(), buildRowSer, $this.buildRow()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".add((", ") ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer, CodeGeneratorContext$.MODULE$.BASE_ROW(), $this.buildRow()}));
        Tuple3<String, String, String> tuple3 = $this.genProcessAndEndCode(ctx, condExpr, iter, buffer);
        if (tuple3 != null) {
            Tuple5 tuple5;
            Tuple3 tuple32;
            String probeProcessCode = (String)tuple3._1();
            String buildEndCode = (String)tuple3._2();
            String probeEndCode = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)probeProcessCode, (Object)buildEndCode, (Object)probeEndCode);
            String probeProcessCode2 = (String)tuple33._1();
            String buildEndCode2 = (String)tuple33._2();
            String probeEndCode2 = (String)tuple33._3();
            Tuple5 tuple52 = tuple5 = $this.leftIsBuild() ? new Tuple5((Object)OperatorCodeGenerator$.MODULE$.FIRST(), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n               |return ", ";\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buildProcessCode, OperatorCodeGenerator$.MODULE$.FIRST()})))).stripMargin(), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buildEndCode2})))).stripMargin(), (Object)probeProcessCode2, (Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{probeEndCode2})))).stripMargin()) : new Tuple5((Object)OperatorCodeGenerator$.MODULE$.SECOND(), (Object)probeProcessCode2, (Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{probeEndCode2})))).stripMargin(), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n               |return ", ";\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buildProcessCode, OperatorCodeGenerator$.MODULE$.SECOND()})))).stripMargin(), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |", "\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buildEndCode2})))).stripMargin());
            if (tuple5 != null) {
                Tuple5 tuple53;
                String firstInputCode = (String)tuple5._1();
                String processCode1 = (String)tuple5._2();
                String endInputCode1 = (String)tuple5._3();
                String processCode2 = (String)tuple5._4();
                String endInputCode2 = (String)tuple5._5();
                Tuple5 tuple54 = tuple53 = new Tuple5((Object)firstInputCode, (Object)processCode1, (Object)endInputCode1, (Object)processCode2, (Object)endInputCode2);
                String firstInputCode2 = (String)tuple54._1();
                String processCode12 = (String)tuple54._2();
                String endInputCode12 = (String)tuple54._3();
                String processCode22 = (String)tuple54._4();
                String endInputCode22 = (String)tuple54._5();
                GeneratedOperator operatorExpression = OperatorCodeGenerator$.MODULE$.generateTwoInputStreamOperator(ctx, $this.description(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"return ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstInputCode2})), processCode12, endInputCode12, processCode22, endInputCode22, leftType, rightType, $this.input1Term(), $this.input2Term(), OperatorCodeGenerator$.MODULE$.generateTwoInputStreamOperator$default$12());
                TwoInputSubstituteStreamOperator substituteStreamOperator = new TwoInputSubstituteStreamOperator(operatorExpression.name(), operatorExpression.code(), TwoInputSubstituteStreamOperator$.MODULE$.$lessinit$greater$default$3());
                TwoInputTransformation transformation = new TwoInputTransformation(leftInput, rightInput, BatchExecNestedLoopJoinBase$class.getOperatorName($this), substituteStreamOperator, (TypeInformation)FlinkTypeFactory$.MODULE$.toInternalBaseRowTypeInfo(((AbstractRelNode)((Object)$this)).getRowType()), $this.getResource().getParallelism());
                tableEnv.getRUKeeper().addTransformation($this, (StreamTransformation<?>)transformation);
                transformation.setReadOrderHint($this.leftIsBuild() ? TwoInputTransformation.ReadOrder.INPUT1_FIRST : TwoInputTransformation.ReadOrder.INPUT2_FIRST);
                transformation.setResources($this.getResource().getReservedResourceSpec(), $this.getResource().getPreferResourceSpec());
                return transformation;
            }
            throw new MatchError((Object)tuple5);
        }
        throw new MatchError(tuple3);
    }

    private static String getOperatorName(BatchExecNestedLoopJoinBase $this) {
        String string;
        if (((Join)((Object)$this)).getCondition() == null) {
            string = "";
        } else {
            List inFields = JavaConversions$.MODULE$.asScalaBuffer($this.inputDataType().getFieldNames()).toList();
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"where: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.getExpressionString(((Join)((Object)$this)).getCondition(), (List<String>)inFields, (Option<List<RexNode>>)None$.MODULE$, ExpressionFormat$.MODULE$.Infix())}));
        }
        String joinExpressionStr = string;
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NestedLoopJoin(", "", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{joinExpressionStr, $this.leftIsBuild() ? "buildLeft" : "buildRight"}));
    }

    public static String newIter(BatchExecNestedLoopJoinBase $this, String iter, String buffer) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |if (", " == null) {\n       |  ", " = ", ".newIterator();\n       |} else {\n       |  ", ".reset();\n       |}\n       |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iter, iter, buffer, iter})))).stripMargin();
    }

    private static final void initSerializer$1(BatchExecNestedLoopJoinBase $this, int i, CodeGeneratorContext ctx$1, String serializer$1) {
        ctx$1.addReusableOpenStatement(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " ", " =\n             |  (", ") getOperatorConfig()\n             |    .getTypeSerializerIn", "(getUserCodeClassloader());\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneratorContext$.MODULE$.ABSTRACT_ROW_SERIALIZER(), serializer$1, CodeGeneratorContext$.MODULE$.ABSTRACT_ROW_SERIALIZER(), BoxesRunTime.boxToInteger((int)i)})))).stripMargin());
    }

    public static void $init$(BatchExecNestedLoopJoinBase $this) {
        Tuple5 tuple5;
        $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$_setter_$input1Term_$eq(CodeGeneratorContext$.MODULE$.DEFAULT_INPUT1_TERM());
        $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$_setter_$input2Term_$eq(CodeGeneratorContext$.MODULE$.DEFAULT_INPUT2_TERM());
        int leftArity = ((BiRel)((Object)$this)).getLeft().getRowType().getFieldCount();
        int rightArity = ((BiRel)((Object)$this)).getRight().getRowType().getFieldCount();
        Tuple5 tuple52 = tuple5 = $this.leftIsBuild() ? new Tuple5((Object)$this.input1Term(), (Object)BoxesRunTime.boxToInteger((int)leftArity), (Object)$this.input2Term(), (Object)BoxesRunTime.boxToInteger((int)rightArity), (Object)OperatorCodeGenerator$.MODULE$.SECOND()) : new Tuple5((Object)$this.input2Term(), (Object)BoxesRunTime.boxToInteger((int)rightArity), (Object)$this.input1Term(), (Object)BoxesRunTime.boxToInteger((int)leftArity), (Object)OperatorCodeGenerator$.MODULE$.FIRST());
        if (tuple5 != null) {
            String buildRow = (String)tuple5._1();
            int buildArity = BoxesRunTime.unboxToInt((Object)tuple5._2());
            String probeRow = (String)tuple5._3();
            int probeArity = BoxesRunTime.unboxToInt((Object)tuple5._4());
            String probeSelection = (String)tuple5._5();
            Tuple5 tuple53 = new Tuple5((Object)buildRow, (Object)BoxesRunTime.boxToInteger((int)buildArity), (Object)probeRow, (Object)BoxesRunTime.boxToInteger((int)probeArity), (Object)probeSelection);
            $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$_setter_$org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$$x$1_$eq(tuple53);
            $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$_setter_$buildRow_$eq((String)$this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$$x$1()._1());
            $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$_setter_$buildArity_$eq(BoxesRunTime.unboxToInt((Object)$this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$$x$1()._2()));
            $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$_setter_$probeRow_$eq((String)$this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$$x$1()._3());
            $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$_setter_$probeArity_$eq(BoxesRunTime.unboxToInt((Object)$this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$$x$1()._4()));
            $this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$_setter_$probeSelection_$eq((String)$this.org$apache$flink$table$plan$nodes$physical$batch$BatchExecNestedLoopJoinBase$$x$1()._5());
            return;
        }
        throw new MatchError((Object)tuple5);
    }
}

