/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.physical.stream;

import java.time.Duration;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.table.api.StreamTableEnvironment;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.window.CountWindow;
import org.apache.flink.table.api.window.TimeWindow;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.codegen.CodeGeneratorContext;
import org.apache.flink.table.codegen.CodeGeneratorContext$;
import org.apache.flink.table.codegen.EqualiserCodeGenerator;
import org.apache.flink.table.codegen.GeneratedRecordEqualiser;
import org.apache.flink.table.codegen.GeneratedSubKeyedAggsHandleFunction;
import org.apache.flink.table.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.errorcode.TableErrors;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils$;
import org.apache.flink.table.expressions.WindowProperty;
import org.apache.flink.table.plan.logical.LogicalWindow;
import org.apache.flink.table.plan.logical.SessionGroupWindow;
import org.apache.flink.table.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.plan.nodes.FlinkRelNode$class;
import org.apache.flink.table.plan.nodes.exec.BaseStreamExecNode$class;
import org.apache.flink.table.plan.nodes.exec.ExecNode;
import org.apache.flink.table.plan.nodes.exec.ExecNode$class;
import org.apache.flink.table.plan.nodes.exec.ExecNodeVisitor;
import org.apache.flink.table.plan.nodes.exec.ExecNodeWriter;
import org.apache.flink.table.plan.nodes.exec.NodeResource;
import org.apache.flink.table.plan.nodes.exec.RowStreamExecNode;
import org.apache.flink.table.plan.nodes.exec.StreamExecNode$class;
import org.apache.flink.table.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.plan.nodes.physical.FlinkPhysicalRel$class;
import org.apache.flink.table.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.plan.nodes.physical.stream.StreamPhysicalRel$class;
import org.apache.flink.table.plan.rules.physical.stream.StreamExecRetractionRules$;
import org.apache.flink.table.plan.schema.BaseRowSchema;
import org.apache.flink.table.plan.util.AggregateInfo;
import org.apache.flink.table.plan.util.AggregateInfoList;
import org.apache.flink.table.plan.util.AggregateNameUtil$;
import org.apache.flink.table.plan.util.AggregateUtil$;
import org.apache.flink.table.plan.util.EmitStrategy;
import org.apache.flink.table.plan.util.StreamExecUtil$;
import org.apache.flink.table.runtime.BaseRowKeySelector;
import org.apache.flink.table.runtime.window.AlignedWindowOperator;
import org.apache.flink.table.runtime.window.WindowOperator;
import org.apache.flink.table.runtime.window.WindowOperatorBuilder;
import org.apache.flink.table.runtime.window.aligned.AlignedWindowTrigger;
import org.apache.flink.table.runtime.window.aligned.BufferedAlignedWindowAggregator;
import org.apache.flink.table.runtime.window.aligned.InternalAlignedWindowTriggers;
import org.apache.flink.table.runtime.window.assigners.SlidingWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.TumblingWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.WindowAssigner;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.util.Logging$class;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\teh\u0001B\u0001\u0003\u0001M\u0011ad\u0015;sK\u0006lW\t_3d\u000fJ|W\u000f],j]\u0012|w/Q4he\u0016<\u0017\r^3\u000b\u0005\r!\u0011AB:ue\u0016\fWN\u0003\u0002\u0006\r\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002\b\u0011\u0005)an\u001c3fg*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!B\u0004\t\t\u0003+ii\u0011A\u0006\u0006\u0003/a\t1A]3m\u0015\tIb\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005m1\"!C*j]\u001edWMU3m!\tib$D\u0001\u0003\u0013\ty\"AA\tTiJ,\u0017-\u001c)isNL7-\u00197SK2\u0004\"!\t\u0013\u000e\u0003\tR!a\t\u0004\u0002\t\u0015DXmY\u0005\u0003K\t\u0012\u0011CU8x'R\u0014X-Y7Fq\u0016\u001cgj\u001c3f\u0011!9\u0003A!b\u0001\n\u0003A\u0013AB<j]\u0012|w/F\u0001*!\tQS&D\u0001,\u0015\ta\u0003\"A\u0004m_\u001eL7-\u00197\n\u00059Z#!\u0004'pO&\u001c\u0017\r\\,j]\u0012|w\u000f\u0003\u00051\u0001\t\u0005\t\u0015!\u0003*\u0003\u001d9\u0018N\u001c3po\u0002B\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u0010]\u0006lW\r\u001a)s_B,'\u000f^5fgB\u0019AGP!\u000f\u0005UZdB\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0013\u0003\u0019a$o\\8u}%\t!(A\u0003tG\u0006d\u0017-\u0003\u0002={\u00059\u0001/Y2lC\u001e,'\"\u0001\u001e\n\u0005}\u0002%aA*fc*\u0011A(\u0010\t\u0003\u0005Bs!aQ'\u000f\u0005\u0011ceBA#L\u001d\t1%J\u0004\u0002H\u0013:\u0011a\u0007S\u0005\u0002#%\u0011q\u0002E\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005eQ\u0011B\u0001(P\u0003=1E.\u001b8l%\u0016d')^5mI\u0016\u0014(BA\r\u000b\u0013\t\t&KA\nOC6,GmV5oI><\bK]8qKJ$\u0018P\u0003\u0002O\u001f\"AA\u000b\u0001B\u0001B\u0003%Q+A\u0004dYV\u001cH/\u001a:\u0011\u0005YCV\"A,\u000b\u0005%A\u0012BA-X\u00055\u0011V\r\\(qi\u000ecWo\u001d;fe\"A1\f\u0001B\u0001B\u0003%A,\u0001\u0005ue\u0006LGoU3u!\t1V,\u0003\u0002_/\nY!+\u001a7Ue\u0006LGoU3u\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0017!C5oaV$hj\u001c3f!\t)\"-\u0003\u0002d-\t9!+\u001a7O_\u0012,\u0007\u0002C3\u0001\u0005\u000b\u0007I\u0011\u00014\u0002\u0011\u0005<wmQ1mYN,\u0012a\u001a\t\u0004iyB\u0007CA5m\u001b\u0005Q'BA6\u0017\u0003\u0011\u0019wN]3\n\u00055T'!D!hOJ,w-\u0019;f\u0007\u0006dG\u000e\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003h\u0003%\twmZ\"bY2\u001c\b\u0005\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003s\u00031yW\u000f\u001e9viN\u001b\u0007.Z7b!\t\u0019h/D\u0001u\u0015\t)\b\"\u0001\u0004tG\",W.Y\u0005\u0003oR\u0014QBQ1tKJ{woU2iK6\f\u0007\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\u0002\u0017%t\u0007/\u001e;TG\",W.\u0019\u0005\tw\u0002\u0011\t\u0011)A\u0005y\u0006AqM]8va&tw\r\u0005\u0003~}\u0006\u0005Q\"A\u001f\n\u0005}l$!B!se\u0006L\bcA?\u0002\u0004%\u0019\u0011QA\u001f\u0003\u0007%sG\u000f\u0003\u0006\u0002\n\u0001\u0011\t\u0011)A\u0005\u0003\u0003\t1#\u001b8qkR$\u0016.\\3ti\u0006l\u0007/\u00138eKbD!\"!\u0004\u0001\u0005\u000b\u0007I\u0011AA\b\u00031)W.\u001b;TiJ\fG/Z4z+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9\u0002C\u0001\u0005kRLG.\u0003\u0003\u0002\u001c\u0005U!\u0001D#nSR\u001cFO]1uK\u001eL\bBCA\u0010\u0001\t\u0005\t\u0015!\u0003\u0002\u0012\u0005iQ-\\5u'R\u0014\u0018\r^3hs\u0002Bq!a\t\u0001\t\u0003\t)#\u0001\u0004=S:LGO\u0010\u000b\u0019\u0003O\tI#a\u000b\u0002.\u0005=\u0012\u0011GA\u001a\u0003k\t9$!\u000f\u0002<\u0005u\u0002CA\u000f\u0001\u0011\u00199\u0013\u0011\u0005a\u0001S!1!'!\tA\u0002MBa\u0001VA\u0011\u0001\u0004)\u0006BB.\u0002\"\u0001\u0007A\f\u0003\u0004a\u0003C\u0001\r!\u0019\u0005\u0007K\u0006\u0005\u0002\u0019A4\t\rE\f\t\u00031\u0001s\u0011\u0019I\u0018\u0011\u0005a\u0001e\"110!\tA\u0002qD\u0001\"!\u0003\u0002\"\u0001\u0007\u0011\u0011\u0001\u0005\t\u0003\u001b\t\t\u00031\u0001\u0002\u0012!9\u0011\u0011\t\u0001\u0005B\u0005\r\u0013!\u00043fe&4XMU8x)f\u0004X\r\u0006\u0002\u0002FA!\u0011qIA'\u001b\t\tIEC\u0002\u0002LY\tA\u0001^=qK&!\u0011qJA%\u0005-\u0011V\r\u001c#bi\u0006$\u0016\u0010]3\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V\u0005y\u0001O]8ek\u000e,7/\u00169eCR,7/\u0006\u0002\u0002XA\u0019Q0!\u0017\n\u0007\u0005mSHA\u0004C_>dW-\u00198\t\u000f\u0005}\u0003\u0001\"\u0011\u0002V\u0005\u00192m\u001c8tk6,7OU3ue\u0006\u001cG/[8og\"9\u00111\r\u0001\u0005B\u0005\u0015\u0014\u0001\u00078fK\u0012\u001cX\u000b\u001d3bi\u0016\u001c\u0018i\u001d*fiJ\f7\r^5p]R!\u0011qKA4\u0011\u001d\tI'!\u0019A\u0002\u0005\fQ!\u001b8qkRDq!!\u001c\u0001\t\u0003\n)&\u0001\tsKF,\u0018N]3XCR,'/\\1sW\"9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0014\u0001D4fi\u001e\u0013x.\u001e9j]\u001e\u001cX#\u0001?\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z\u0005\u0019r-\u001a;XS:$wn\u001e)s_B,'\u000f^5fgV\t1\u0007C\u0004\u0002~\u0001!\t%a \u0002\t\r|\u0007/\u001f\u000b\u0006C\u0006\u0005\u00151\u0011\u0005\u00077\u0006m\u0004\u0019\u0001/\t\u0011\u0005\u0015\u00151\u0010a\u0001\u0003\u000f\u000ba!\u001b8qkR\u001c\b#BAE\u0003#\u000bWBAAF\u0015\u0011\t9\"!$\u000b\u0005\u0005=\u0015\u0001\u00026bm\u0006LA!a%\u0002\f\n!A*[:u\u0011\u001d\t9\n\u0001C!\u00033\u000bA\"\u001a=qY\u0006Lg\u000eV3s[N$B!a'\u0002\"B\u0019Q#!(\n\u0007\u0005}eCA\u0005SK2<&/\u001b;fe\"A\u00111UAK\u0001\u0004\tY*\u0001\u0002qo\"9\u0011q\u0015\u0001\u0005B\u0005U\u0013aD5t\t\u0016$XM]7j]&\u001cH/[2\t\u000f\u0005-\u0006\u0001\"\u0011\u0002.\u0006\u0019r-\u001a;GY&t7\u000e\u00155zg&\u001c\u0017\r\u001c*fYV\u0011\u0011q\u0016\t\u0005\u0003c\u000b\u0019,D\u0001\u0005\u0013\r\t)\f\u0002\u0002\u0011\r2Lgn\u001b)isNL7-\u00197SK2Dq!!/\u0001\t\u0003\nY,\u0001\bhKR\u001cF/\u0019;f\t&<Wm\u001d;\u0015\t\u0005u\u00161\u0019\t\u0004C\u0005}\u0016bAAaE\tqQ\t_3d\u001d>$Wm\u0016:ji\u0016\u0014\b\u0002CAR\u0003o\u0003\r!!0\t\u000f\u0005\u001d\u0007\u0001\"\u0011\u0002J\u00069BO]1og2\fG/\u001a+p!2\fg.\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003\u0017\fY\u000f\u0005\u0004\u0002N\u0006m\u0017q\\\u0007\u0003\u0003\u001fTA!!5\u0002T\u0006yAO]1og\u001a|'/\\1uS>t7O\u0003\u0003\u0002V\u0006]\u0017aA1qS*\u0019\u0011\u0011\u001c\u0007\u0002\u0013M$(/Z1nS:<\u0017\u0002BAo\u0003\u001f\u0014Ac\u0015;sK\u0006lGK]1og\u001a|'/\\1uS>t\u0007\u0003BAq\u0003Ol!!a9\u000b\u0007\u0005\u0015(\"\u0001\u0006eCR\fgm\u001c:nCRLA!!;\u0002d\n9!)Y:f%><\b\u0002CAw\u0003\u000b\u0004\r!a<\u0002\u0011Q\f'\r\\3F]Z\u0004B!!=\u0002v6\u0011\u00111\u001f\u0006\u0004\u0003+T\u0011\u0002BA|\u0003g\u0014ac\u0015;sK\u0006lG+\u00192mK\u0016sg/\u001b:p]6,g\u000e\u001e\u0005\b\u0003w\u0004A\u0011BA\u007f\u0003aI7oV5oI><X*\u001b8j\u0005\u0006$8\r[#oC\ndW\r\u001a\u000b\u0005\u0003/\ny\u0010\u0003\u0005\u0003\u0002\u0005e\b\u0019\u0001B\u0002\u0003\u0019\u0019wN\u001c4jOB!\u0011\u0011\u001fB\u0003\u0013\u0011\u00119!a=\u0003\u0017Q\u000b'\r\\3D_:4\u0017n\u001a\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0003E\u0019'/Z1uK\u0006;wm\u001d%b]\u0012dWM\u001d\u000b\u000f\u0005\u001f\u0011\u0019D!\u0010\u0003@\t=#\u0011\rB3a\u0011\u0011\tB!\t\u0011\r\tM!\u0011\u0004B\u000f\u001b\t\u0011)BC\u0002\u0003\u0018)\tqaY8eK\u001e,g.\u0003\u0003\u0003\u001c\tU!aI$f]\u0016\u0014\u0018\r^3e'V\u00147*Z=fI\u0006;wm\u001d%b]\u0012dWMR;oGRLwN\u001c\t\u0005\u0005?\u0011\t\u0003\u0004\u0001\u0005\u0019\t\r\"\u0011BA\u0001\u0002\u0003\u0015\tA!\n\u0003\u0007}#\u0013'\u0005\u0003\u0003(\t5\u0002cA?\u0003*%\u0019!1F\u001f\u0003\u000f9{G\u000f[5oOB\u0019QPa\f\n\u0007\tERHA\u0002B]fD\u0001B!\u000e\u0003\n\u0001\u0007!qG\u0001\fC\u001e<\u0017J\u001c4p\u0019&\u001cH\u000f\u0005\u0003\u0002\u0014\te\u0012\u0002\u0002B\u001e\u0003+\u0011\u0011#Q4he\u0016<\u0017\r^3J]\u001a|G*[:u\u0011!\u0011\tA!\u0003A\u0002\t\r\u0001\u0002\u0003B!\u0005\u0013\u0001\rAa\u0011\u0002\u0015I,GNQ;jY\u0012,'\u000f\u0005\u0003\u0003F\t-SB\u0001B$\u0015\r\u0011I\u0005G\u0001\u0006i>|Gn]\u0005\u0005\u0005\u001b\u00129E\u0001\u0006SK2\u0014U/\u001b7eKJD\u0001B!\u0015\u0003\n\u0001\u0007!1K\u0001\u000fM&,G\u000e\u001a+za\u0016LeNZ8t!\u0011!dH!\u0016\u0011\t\t]#QL\u0007\u0003\u00053R1Aa\u0017\u000b\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0011yF!\u0017\u0003\u0019%sG/\u001a:oC2$\u0016\u0010]3\t\u0011\t\r$\u0011\u0002a\u0001\u0003/\naB\\3fIJ+GO]1di&|g\u000e\u0003\u0005\u0003h\t%\u0001\u0019AA,\u0003%i\u0017N\\5cCR\u001c\u0007\u000eC\u0004\u0003l\u0001!IA!\u001c\u0002\u001f\r\u0014X-\u0019;f\u000bF,\u0018\r\\5tKJ$bAa\u001c\u0003v\tm\u0004\u0003\u0002B\n\u0005cJAAa\u001d\u0003\u0016\tAr)\u001a8fe\u0006$X\r\u001a*fG>\u0014H-R9vC2L7/\u001a:\t\u0011\t]$\u0011\u000ea\u0001\u0005s\na\"Y4h%\u0016\u001cX\u000f\u001c;UsB,7\u000f\u0005\u0003~}\nU\u0003\u0002\u0003B?\u0005S\u0002\rA!\u001f\u0002']Lg\u000eZ8x!J|\u0007/\u001a:usRK\b/Z:\t\u000f\u0005m\b\u0001\"\u0003\u0003\u0002R1\u0011q\u000bBB\u0005\u000bC\u0001B!\u0001\u0003\u0000\u0001\u0007!1\u0001\u0005\t\u0005\u000f\u0013y\b1\u0001\u0003\n\u0006A\u0011mZ4J]\u001a|7\u000f\u0005\u0003~}\n-\u0005\u0003BA\n\u0005\u001bKAAa$\u0002\u0016\ti\u0011iZ4sK\u001e\fG/Z%oM>DqAa%\u0001\t\u0013\u0011)*A\u000fde\u0016\fG/Z'j]&\u0014\u0015\r^2i/&tGm\\<Pa\u0016\u0014\u0018\r^8s)A\u00119J!*\u0003(\nU&\u0011\u0018B_\u0005\u007f\u0013\u0019\r\u0005\u0003\u0003\u001a\n\u0005VB\u0001BN\u0015\r9#Q\u0014\u0006\u0004\u0005?S\u0011a\u0002:v]RLW.Z\u0005\u0005\u0005G\u0013YJA\u000bBY&<g.\u001a3XS:$wn^(qKJ\fGo\u001c:\t\u0011\t\u0005!\u0011\u0013a\u0001\u0005\u0007A\u0001B!+\u0003\u0012\u0002\u0007!1V\u0001\fC\u001e<7\u000fS1oI2,'\u000f\r\u0003\u0003.\nE\u0006C\u0002B\n\u00053\u0011y\u000b\u0005\u0003\u0003 \tEF\u0001\u0004BZ\u0005O\u000b\t\u0011!A\u0003\u0002\t\u0015\"aA0%e!A!q\u0017BI\u0001\u0004\u0011y'A\bsK\u000e|'\u000fZ#rk\u0006d\u0017n]3s\u0011!\u0011YL!%A\u0002\te\u0014\u0001C1dGRK\b/Z:\t\u0011\tu$\u0011\u0013a\u0001\u0005sB\u0001B!1\u0003\u0012\u0002\u0007!\u0011P\u0001\u000eC\u001e<g+\u00197vKRK\b/Z:\t\u0011\t\u0015'\u0011\u0013a\u0001\u0003\u0003\tq\u0001^5nK&#\u0007\u0010C\u0004\u0003J\u0002!IAa3\u0002)\r\u0014X-\u0019;f/&tGm\\<Pa\u0016\u0014\u0018\r^8s)A\u0011iM!9\u0003d\n=(\u0011\u001fBz\u0005k\u00149\u0010\r\u0004\u0003P\n]'Q\u001c\t\t\u00053\u0013\tN!6\u0003\\&!!1\u001bBN\u000599\u0016N\u001c3po>\u0003XM]1u_J\u0004BAa\b\u0003X\u0012a!\u0011\u001cBd\u0003\u0003\u0005\tQ!\u0001\u0003&\t\u0019q\f\n\u001b\u0011\t\t}!Q\u001c\u0003\r\u0005?\u00149-!A\u0001\u0002\u000b\u0005!Q\u0005\u0002\u0004?\u0012*\u0004\u0002\u0003B\u0001\u0005\u000f\u0004\rAa\u0001\t\u0011\t%&q\u0019a\u0001\u0005K\u0004DAa:\u0003lB1!1\u0003B\r\u0005S\u0004BAa\b\u0003l\u0012a!Q\u001eBr\u0003\u0003\u0005\tQ!\u0001\u0003&\t\u0019q\fJ\u001a\t\u0011\t]&q\u0019a\u0001\u0005_B\u0001Ba/\u0003H\u0002\u0007!\u0011\u0010\u0005\t\u0005{\u00129\r1\u0001\u0003z!A!\u0011\u0019Bd\u0001\u0004\u0011I\b\u0003\u0005\u0003F\n\u001d\u0007\u0019AA\u0001\u0001")
public class StreamExecGroupWindowAggregate
extends SingleRel
implements StreamPhysicalRel,
RowStreamExecNode {
    private final LogicalWindow window;
    private final Seq<FlinkRelBuilder.NamedWindowProperty> namedProperties;
    private final RelOptCluster cluster;
    private final Seq<AggregateCall> aggCalls;
    private final BaseRowSchema outputSchema;
    private final BaseRowSchema inputSchema;
    private final int[] grouping;
    private final int inputTimestampIndex;
    private final EmitStrategy emitStrategy;
    private final java.util.List<ExecNode<StreamTableEnvironment, ?>> org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes;
    private final transient Logger LOG;
    private final NodeResource org$apache$flink$table$plan$nodes$exec$ExecNode$$resource;
    private StreamTransformation<Object> org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    private java.util.List org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes$lzycompute() {
        StreamExecGroupWindowAggregate streamExecGroupWindowAggregate = this;
        synchronized (streamExecGroupWindowAggregate) {
            if (!this.bitmap$0) {
                this.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes = BaseStreamExecNode$class.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes(this);
                this.bitmap$0 = true;
            }
            return this.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes;
        }
    }

    @Override
    public java.util.List<ExecNode<StreamTableEnvironment, ?>> org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes() {
        return this.bitmap$0 ? this.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes : this.org$apache$flink$table$plan$nodes$exec$BaseStreamExecNode$$inputNodes$lzycompute();
    }

    @Override
    public java.util.List<ExecNode<StreamTableEnvironment, ?>> getInputNodes() {
        return BaseStreamExecNode$class.getInputNodes(this);
    }

    @Override
    public void replaceInputNode(int ordinalInParent, ExecNode<StreamTableEnvironment, ?> newInputNode) {
        BaseStreamExecNode$class.replaceInputNode(this, ordinalInParent, newInputNode);
    }

    private Logger LOG$lzycompute() {
        StreamExecGroupWindowAggregate streamExecGroupWindowAggregate = this;
        synchronized (streamExecGroupWindowAggregate) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public /* synthetic */ StreamTransformation org$apache$flink$table$plan$nodes$exec$StreamExecNode$$super$translateToPlan(StreamTableEnvironment tableEnv) {
        return ExecNode$class.translateToPlan(this, tableEnv);
    }

    @Override
    public StreamTransformation<BaseRow> translateToPlan(StreamTableEnvironment tableEnv) {
        return StreamExecNode$class.translateToPlan(this, tableEnv);
    }

    @Override
    public NodeResource org$apache$flink$table$plan$nodes$exec$ExecNode$$resource() {
        return this.org$apache$flink$table$plan$nodes$exec$ExecNode$$resource;
    }

    @Override
    public StreamTransformation<BaseRow> org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation() {
        return this.org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation;
    }

    @Override
    @TraitSetter
    public void org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation_$eq(StreamTransformation<BaseRow> x$1) {
        this.org$apache$flink$table$plan$nodes$exec$ExecNode$$transformation = x$1;
    }

    @Override
    public void org$apache$flink$table$plan$nodes$exec$ExecNode$_setter_$org$apache$flink$table$plan$nodes$exec$ExecNode$$resource_$eq(NodeResource x$1) {
        this.org$apache$flink$table$plan$nodes$exec$ExecNode$$resource = x$1;
    }

    @Override
    public NodeResource getResource() {
        return ExecNode$class.getResource(this);
    }

    @Override
    public void accept(ExecNodeVisitor visitor) {
        ExecNode$class.accept(this, visitor);
    }

    @Override
    public boolean producesRetractions() {
        return StreamPhysicalRel$class.producesRetractions(this);
    }

    @Override
    public RelNode satisfyTraitsByInput(RelTraitSet requiredTraitSet) {
        return FlinkPhysicalRel$class.satisfyTraitsByInput(this, requiredTraitSet);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable, expressionFormat);
    }

    public LogicalWindow window() {
        return this.window;
    }

    public Seq<AggregateCall> aggCalls() {
        return this.aggCalls;
    }

    public EmitStrategy emitStrategy() {
        return this.emitStrategy;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.outputSchema.relDataType();
    }

    @Override
    public boolean producesUpdates() {
        return this.emitStrategy().produceUpdates();
    }

    @Override
    public boolean consumesRetractions() {
        return true;
    }

    @Override
    public boolean needsUpdatesAsRetraction(RelNode input) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean requireWatermark() {
        LogicalWindow logicalWindow = this.window();
        if (logicalWindow instanceof TumblingGroupWindow) {
            TumblingGroupWindow tumblingGroupWindow = (TumblingGroupWindow)logicalWindow;
            Expression timeField = tumblingGroupWindow.timeField();
            Expression size = tumblingGroupWindow.size();
            if (ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) {
                return true;
            }
        }
        if (logicalWindow instanceof SlidingGroupWindow) {
            SlidingGroupWindow slidingGroupWindow = (SlidingGroupWindow)logicalWindow;
            Expression timeField = slidingGroupWindow.timeField();
            Expression size = slidingGroupWindow.size();
            if (ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) {
                return true;
            }
        }
        if (!(logicalWindow instanceof SessionGroupWindow)) return false;
        SessionGroupWindow sessionGroupWindow = (SessionGroupWindow)logicalWindow;
        Expression timeField = sessionGroupWindow.timeField();
        if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField)) return false;
        return true;
    }

    public int[] getGroupings() {
        return this.grouping;
    }

    public Seq<FlinkRelBuilder.NamedWindowProperty> getWindowProperties() {
        return this.namedProperties;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, java.util.List<RelNode> inputs) {
        return new StreamExecGroupWindowAggregate(this.window(), this.namedProperties, this.cluster, traitSet, inputs.get(0), this.aggCalls(), this.outputSchema, this.inputSchema, this.grouping, this.inputTimestampIndex, this.emitStrategy());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("groupBy", AggregateNameUtil$.MODULE$.groupingToString(this.inputSchema.relDataType(), this.grouping), Predef$.MODULE$.intArrayOps(this.grouping).nonEmpty()).item("window", this.window()).itemIf("properties", ((TraversableOnce)this.namedProperties.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FlinkRelBuilder.NamedWindowProperty x$1) {
                return x$1.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", "), this.namedProperties.nonEmpty()).item("select", AggregateNameUtil$.MODULE$.aggregationToString(this.inputSchema.relDataType(), this.grouping, this.outputSchema.relDataType(), this.aggCalls(), this.namedProperties, true)).itemIf("emit", this.emitStrategy(), !this.emitStrategy().toString().isEmpty());
    }

    @Override
    public boolean isDeterministic() {
        return AggregateUtil$.MODULE$.isDeterministic(JavaConversions$.MODULE$.seqAsJavaList(this.aggCalls()));
    }

    @Override
    public FlinkPhysicalRel getFlinkPhysicalRel() {
        return this;
    }

    @Override
    public ExecNodeWriter getStateDigest(ExecNodeWriter pw) {
        TableConfig tableConfig = this.cluster.getPlanner().getContext().unwrap(TableConfig.class);
        boolean isMiniBatchEnabled = this.isWindowMiniBatchEnabled(tableConfig);
        return pw.item("inputType", this.input.getRowType()).item("isMiniBatchEnabled", BoxesRunTime.boxToBoolean((boolean)isMiniBatchEnabled)).itemIf("groupBy", AggregateNameUtil$.MODULE$.groupingToString(this.inputSchema.relDataType(), this.grouping), Predef$.MODULE$.intArrayOps(this.grouping).nonEmpty()).item("window", this.window()).itemIf("properties", ((TraversableOnce)this.namedProperties.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FlinkRelBuilder.NamedWindowProperty x$2) {
                return x$2.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", "), this.namedProperties.nonEmpty()).item("select", AggregateNameUtil$.MODULE$.aggregationToString(this.inputSchema.relDataType(), this.grouping, this.outputSchema.relDataType(), this.aggCalls(), this.namedProperties, false)).itemIf("emit", this.emitStrategy(), !this.emitStrategy().toString().isEmpty());
    }

    @Override
    public StreamTransformation<BaseRow> translateToPlanInternal(StreamTableEnvironment tableEnv) {
        int n;
        SlidingGroupWindow slidingGroupWindow;
        Expression size;
        TumblingGroupWindow tumblingGroupWindow;
        Expression size2;
        TableConfig config = tableEnv.getConfig();
        StreamTransformation<?> inputTransform = this.getInputNodes().get(0).translateToPlan(tableEnv);
        boolean inputIsAccRetract = StreamExecRetractionRules$.MODULE$.isAccRetract(this.input);
        if (inputIsAccRetract) {
            throw new TableException(TableErrors.INST.sqlGroupWindowAggTranslateRetractNotSupported());
        }
        LogicalWindow logicalWindow = this.window();
        boolean bl = logicalWindow instanceof TumblingGroupWindow && ExpressionUtils$.MODULE$.isRowCountLiteral(size2 = (tumblingGroupWindow = (TumblingGroupWindow)logicalWindow).size()) ? true : logicalWindow instanceof SlidingGroupWindow && ExpressionUtils$.MODULE$.isRowCountLiteral(size = (slidingGroupWindow = (SlidingGroupWindow)logicalWindow).size());
        boolean isCountWindow = bl;
        if (isCountWindow && this.grouping.length > 0 && tableEnv.getConfig().getMinIdleStateRetentionTime() < 0L) {
            this.LOG().warn("No state retention interval configured for a query which accumulates state. Please provide a query configuration with valid retention interval to prevent excessive state size. You may specify a retention time of 0 to not clean up the state.");
        }
        this.emitStrategy().checkValidation();
        String aggString = AggregateNameUtil$.MODULE$.aggregationToString(this.inputSchema.relDataType(), this.grouping, this.outputSchema.relDataType(), this.aggCalls(), this.namedProperties, true);
        if (ExpressionUtils$.MODULE$.isRowtimeAttribute(this.window().timeAttribute())) {
            if (this.inputTimestampIndex < 0) {
                throw new TableException(TableErrors.INST.sqlGroupWindowAggTranslateTimeAttrNotFound());
            }
            n = this.inputTimestampIndex;
        } else {
            n = -1;
        }
        int timeIdx = n;
        boolean needRetraction = StreamExecRetractionRules$.MODULE$.isAccRetract(this.getInput());
        AggregateInfoList aggInfoList = AggregateUtil$.MODULE$.transformToStreamAggregateInfoList(this.aggCalls(), this.inputSchema.relDataType(), (boolean[])Array$.MODULE$.fill(this.aggCalls().size(), (Function0)new Serializable(this, needRetraction){
            public static final long serialVersionUID = 0L;
            private final boolean needRetraction$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.needRetraction$1;
            }
            {
                this.needRetraction$1 = needRetraction$1;
            }
        }, ClassTag$.MODULE$.Boolean()), needRetraction, true, AggregateUtil$.MODULE$.transformToStreamAggregateInfoList$default$6());
        boolean isMiniBatchEnabled = this.isWindowMiniBatchEnabled(config, aggInfoList.aggInfos());
        GeneratedSubKeyedAggsHandleFunction<?> aggsHandler = this.createAggsHandler(aggInfoList, config, tableEnv.getRelBuilder(), this.inputSchema.fieldTypes(), needRetraction, isMiniBatchEnabled);
        InternalType[] accTypes = (InternalType[])Predef$.MODULE$.refArrayOps((Object[])aggInfoList.getAccTypes()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalType apply(DataType x$3) {
                return x$3.toInternalType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)));
        InternalType[] aggResultTypes = (InternalType[])Predef$.MODULE$.refArrayOps((Object[])aggInfoList.getActualValueTypes()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalType apply(DataType x$4) {
                return x$4.toInternalType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)));
        InternalType[] windowPropertyTypes = (InternalType[])((TraversableOnce)this.namedProperties.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalType apply(FlinkRelBuilder.NamedWindowProperty x$5) {
                return x$5.property().resultType();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InternalType.class));
        GeneratedRecordEqualiser equaliser = this.createEqualiser(aggResultTypes, windowPropertyTypes);
        InternalType[] aggValueTypes = (InternalType[])Predef$.MODULE$.refArrayOps((Object[])aggInfoList.getActualValueTypes()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalType apply(DataType x$6) {
                return x$6.toInternalType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)));
        AbstractStreamOperator operator = isMiniBatchEnabled ? this.createMiniBatchWindowOperator(config, aggsHandler, equaliser, accTypes, windowPropertyTypes, aggValueTypes, timeIdx) : this.createWindowOperator(config, aggsHandler, equaliser, accTypes, windowPropertyTypes, aggValueTypes, timeIdx);
        String windowPrefix = isMiniBatchEnabled ? "minibatch-window" : "window";
        String operatorName = Predef$.MODULE$.intArrayOps(this.grouping).nonEmpty() ? new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{windowPrefix, this.window()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"groupBy: (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AggregateNameUtil$.MODULE$.groupingToString(this.inputSchema.relDataType(), this.grouping)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select: (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aggString}))).toString() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": (", "), select: (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{windowPrefix, this.window(), aggString}));
        BaseRowTypeInfo inputRowType = (BaseRowTypeInfo)inputTransform.getOutputType();
        BaseRowKeySelector selector = StreamExecUtil$.MODULE$.getKeySelector(this.grouping, inputRowType);
        BaseRowTypeInfo outRowType = this.outputSchema.typeInfo();
        OneInputTransformation transformation = new OneInputTransformation(inputTransform, operatorName, (OneInputStreamOperator)operator, (TypeInformation)outRowType, inputTransform.getParallelism());
        if (Predef$.MODULE$.intArrayOps(this.grouping).isEmpty()) {
            transformation.setParallelism(1);
            transformation.setMaxParallelism(1);
        }
        transformation.setResources(this.getResource().getReservedResourceSpec(), this.getResource().getPreferResourceSpec());
        transformation.setStateKeySelector((KeySelector)selector);
        transformation.setStateKeyType(selector.getProducedType());
        return transformation;
    }

    private boolean isWindowMiniBatchEnabled(TableConfig config) {
        boolean needRetraction = StreamExecRetractionRules$.MODULE$.isAccRetract(this.getInput());
        AggregateInfoList aggInfoList = AggregateUtil$.MODULE$.transformToStreamAggregateInfoList(this.aggCalls(), this.inputSchema.relDataType(), (boolean[])Array$.MODULE$.fill(this.aggCalls().size(), (Function0)new Serializable(this, needRetraction){
            public static final long serialVersionUID = 0L;
            private final boolean needRetraction$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.needRetraction$2;
            }
            {
                this.needRetraction$2 = needRetraction$2;
            }
        }, ClassTag$.MODULE$.Boolean()), needRetraction, true, AggregateUtil$.MODULE$.transformToStreamAggregateInfoList$default$6());
        return this.isWindowMiniBatchEnabled(config, aggInfoList.aggInfos());
    }

    private GeneratedSubKeyedAggsHandleFunction<?> createAggsHandler(AggregateInfoList aggInfoList, TableConfig config, RelBuilder relBuilder, Seq<InternalType> fieldTypeInfos, boolean needRetraction, boolean minibatch) {
        SlidingGroupWindow slidingGroupWindow;
        Expression size;
        TumblingGroupWindow tumblingGroupWindow;
        Expression size2;
        SlidingGroupWindow slidingGroupWindow2;
        Expression size3;
        CodeGeneratorContext ctx = CodeGeneratorContext$.MODULE$.apply(config, true);
        LogicalWindow logicalWindow = this.window();
        boolean bl = logicalWindow instanceof SlidingGroupWindow && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size3 = (slidingGroupWindow2 = (SlidingGroupWindow)logicalWindow).size()) ? true : logicalWindow instanceof SessionGroupWindow;
        boolean mergingWindow = bl;
        LogicalWindow logicalWindow2 = this.window();
        Class clazz = logicalWindow2 instanceof TumblingGroupWindow && ExpressionUtils$.MODULE$.isRowCountLiteral(size2 = (tumblingGroupWindow = (TumblingGroupWindow)logicalWindow2).size()) ? CountWindow.class : (logicalWindow2 instanceof SlidingGroupWindow && ExpressionUtils$.MODULE$.isRowCountLiteral(size = (slidingGroupWindow = (SlidingGroupWindow)logicalWindow2).size()) ? CountWindow.class : TimeWindow.class);
        Class<TimeWindow> windowClass = clazz;
        AggsHandlerCodeGenerator aggsGenerator = new AggsHandlerCodeGenerator(ctx, relBuilder, this.inputSchema.fieldTypes(), needRetraction, mergingWindow || minibatch, config.getNullCheck(), false);
        Object object = minibatch ? aggsGenerator.withMerging(0, true, aggInfoList.getAccTypes()) : BoxedUnit.UNIT;
        return aggsGenerator.generateSubKeyedAggsHandler("GroupingWindowAggsHandler", aggInfoList, (Seq<WindowProperty>)((Seq)this.namedProperties.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final WindowProperty apply(FlinkRelBuilder.NamedWindowProperty x$7) {
                return x$7.property();
            }
        }, Seq$.MODULE$.canBuildFrom())), windowClass);
    }

    private GeneratedRecordEqualiser createEqualiser(InternalType[] aggResultTypes, InternalType[] windowPropertyTypes) {
        EqualiserCodeGenerator generator = new EqualiserCodeGenerator((Seq<InternalType>)((Seq)Predef$.MODULE$.refArrayOps((Object[])aggResultTypes).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])windowPropertyTypes), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        return generator.generateRecordEqualiser("WindowValueEqualiser");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isWindowMiniBatchEnabled(TableConfig config, AggregateInfo[] aggInfos) {
        if (!config.getConf().getBoolean(TableConfigOptions.SQL_EXEC_MINI_BATCH_WINDOW_ENABLED)) return false;
        if (!AggregateUtil$.MODULE$.doAllSupportPartialMerge(aggInfos)) return false;
        LogicalWindow logicalWindow = this.window();
        if (logicalWindow instanceof TumblingGroupWindow) {
            TumblingGroupWindow tumblingGroupWindow = (TumblingGroupWindow)logicalWindow;
            Expression timeField = tumblingGroupWindow.timeField();
            Expression size = tumblingGroupWindow.size();
            if (ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) && ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) {
                return true;
            }
        }
        if (!(logicalWindow instanceof SlidingGroupWindow)) return false;
        SlidingGroupWindow slidingGroupWindow = (SlidingGroupWindow)logicalWindow;
        Expression timeField = slidingGroupWindow.timeField();
        Expression size = slidingGroupWindow.size();
        Expression slide = slidingGroupWindow.slide();
        if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField)) return false;
        if (!ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) return false;
        Duration sizeDuration = ExpressionUtils$.MODULE$.toDuration(size);
        Duration slideDuration = ExpressionUtils$.MODULE$.toDuration(slide);
        if (sizeDuration.toMillis() % slideDuration.toMillis() != 0L) return false;
        return true;
    }

    private AlignedWindowOperator createMiniBatchWindowOperator(TableConfig config, GeneratedSubKeyedAggsHandleFunction<?> aggsHandler, GeneratedRecordEqualiser recordEqualiser, InternalType[] accTypes, InternalType[] windowPropertyTypes, InternalType[] aggValueTypes, int timeIdx) {
        LogicalWindow logicalWindow;
        block6: {
            Tuple2 tuple2;
            BufferedAlignedWindowAggregator windowRunner;
            block5: {
                Duration tzOffsetDuration;
                block4: {
                    TypeInformation<?> accTypeInfo = TypeConverters$.MODULE$.createInternalTypeInfoFromDataType(DataTypes.createRowType(accTypes));
                    RowType aggResultType = DataTypes.createRowType((InternalType[])Predef$.MODULE$.refArrayOps((Object[])aggValueTypes).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])windowPropertyTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class))));
                    TypeInformation<?> aggResultTypeInfo = TypeConverters$.MODULE$.createInternalTypeInfoFromDataType(aggResultType);
                    long minibatchSize = config.getConf().getLong(TableConfigOptions.SQL_EXEC_MINIBATCH_SIZE);
                    windowRunner = new BufferedAlignedWindowAggregator((BaseRowTypeInfo)accTypeInfo, (BaseRowTypeInfo)aggResultTypeInfo, aggsHandler, minibatchSize, false);
                    int tzOffset = config.getTimeZone().getOffset(config.getTimeZone().getOffset(15L));
                    tzOffsetDuration = Duration.ofMillis(-tzOffset);
                    logicalWindow = this.window();
                    if (!(logicalWindow instanceof TumblingGroupWindow)) break block4;
                    TumblingGroupWindow tumblingGroupWindow = (TumblingGroupWindow)logicalWindow;
                    Expression timeField = tumblingGroupWindow.timeField();
                    Expression size = tumblingGroupWindow.size();
                    if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) break block4;
                    Duration sizeDuration = ExpressionUtils$.MODULE$.toDuration(size);
                    TumblingWindowAssigner assigner = TumblingWindowAssigner.of(sizeDuration).withOffset(tzOffsetDuration);
                    AlignedWindowTrigger trigger = InternalAlignedWindowTriggers.tumbling(sizeDuration, tzOffsetDuration);
                    tuple2 = new Tuple2((Object)assigner, (Object)trigger);
                    break block5;
                }
                if (!(logicalWindow instanceof SlidingGroupWindow)) break block6;
                SlidingGroupWindow slidingGroupWindow = (SlidingGroupWindow)logicalWindow;
                Expression timeField = slidingGroupWindow.timeField();
                Expression size = slidingGroupWindow.size();
                Expression slide = slidingGroupWindow.slide();
                if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) break block6;
                Duration sizeDuration = ExpressionUtils$.MODULE$.toDuration(size);
                Duration slideDuration = ExpressionUtils$.MODULE$.toDuration(slide);
                SlidingWindowAssigner assigner = SlidingWindowAssigner.of(sizeDuration, slideDuration).withOffset(tzOffsetDuration);
                AlignedWindowTrigger trigger = InternalAlignedWindowTriggers.sliding(sizeDuration, slideDuration, tzOffsetDuration);
                tuple2 = new Tuple2((Object)assigner, (Object)trigger);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                WindowAssigner windowAssigner = (WindowAssigner)tuple22._1();
                AlignedWindowTrigger windowTrigger = (AlignedWindowTrigger)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)windowAssigner, (Object)windowTrigger);
                WindowAssigner windowAssigner2 = (WindowAssigner)tuple24._1();
                AlignedWindowTrigger windowTrigger2 = (AlignedWindowTrigger)tuple24._2();
                return new AlignedWindowOperator(windowRunner, windowAssigner2, windowTrigger2, timeIdx);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)logicalWindow);
    }

    private WindowOperator<?, ?> createWindowOperator(TableConfig config, GeneratedSubKeyedAggsHandleFunction<?> aggsHandler, GeneratedRecordEqualiser recordEqualiser, InternalType[] accTypes, InternalType[] windowPropertyTypes, InternalType[] aggValueTypes, int timeIdx) {
        LogicalWindow logicalWindow;
        block13: {
            WindowOperatorBuilder windowOperatorBuilder;
            block6: {
                SessionGroupWindow sessionGroupWindow;
                boolean bl;
                WindowOperatorBuilder builder;
                block12: {
                    boolean bl2;
                    block11: {
                        SlidingGroupWindow slidingGroupWindow;
                        block10: {
                            block9: {
                                boolean bl3;
                                block8: {
                                    TumblingGroupWindow tumblingGroupWindow;
                                    block7: {
                                        block5: {
                                            builder = WindowOperatorBuilder.builder().withInputFields((InternalType[])this.inputSchema.fieldTypes().toArray(ClassTag$.MODULE$.apply(InternalType.class)));
                                            bl3 = false;
                                            tumblingGroupWindow = null;
                                            bl2 = false;
                                            slidingGroupWindow = null;
                                            bl = false;
                                            sessionGroupWindow = null;
                                            logicalWindow = this.window();
                                            if (!(logicalWindow instanceof TumblingGroupWindow)) break block5;
                                            bl3 = true;
                                            tumblingGroupWindow = (TumblingGroupWindow)logicalWindow;
                                            Expression timeField = tumblingGroupWindow.timeField();
                                            Expression size = tumblingGroupWindow.size();
                                            if (!ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) break block5;
                                            windowOperatorBuilder = builder.tumble(ExpressionUtils$.MODULE$.toDuration(size), config.getTimeZone().getOffset(15L)).withProcessingTime();
                                            break block6;
                                        }
                                        if (!bl3) break block7;
                                        Expression timeField = tumblingGroupWindow.timeField();
                                        Expression size = tumblingGroupWindow.size();
                                        if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) break block7;
                                        windowOperatorBuilder = builder.tumble(ExpressionUtils$.MODULE$.toDuration(size), config.getTimeZone().getOffset(15L)).withEventTime(timeIdx);
                                        break block6;
                                    }
                                    if (!bl3) break block8;
                                    Expression timeField = tumblingGroupWindow.timeField();
                                    Expression size = tumblingGroupWindow.size();
                                    if (!ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isRowCountLiteral(size)) break block8;
                                    windowOperatorBuilder = builder.countWindow(ExpressionUtils$.MODULE$.toLong(size));
                                    break block6;
                                }
                                if (bl3) {
                                    throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
                                }
                                if (!(logicalWindow instanceof SlidingGroupWindow)) break block9;
                                bl2 = true;
                                slidingGroupWindow = (SlidingGroupWindow)logicalWindow;
                                Expression timeField = slidingGroupWindow.timeField();
                                Expression size = slidingGroupWindow.size();
                                Expression slide = slidingGroupWindow.slide();
                                if (!ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isTimeIntervalLiteral(slide)) break block9;
                                windowOperatorBuilder = builder.sliding(ExpressionUtils$.MODULE$.toDuration(size), ExpressionUtils$.MODULE$.toDuration(slide), config.getTimeZone().getOffset(15L)).withProcessingTime();
                                break block6;
                            }
                            if (!bl2) break block10;
                            Expression timeField = slidingGroupWindow.timeField();
                            Expression size = slidingGroupWindow.size();
                            Expression slide = slidingGroupWindow.slide();
                            if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) break block10;
                            windowOperatorBuilder = builder.sliding(ExpressionUtils$.MODULE$.toDuration(size), ExpressionUtils$.MODULE$.toDuration(slide), config.getTimeZone().getOffset(15L)).withEventTime(timeIdx);
                            break block6;
                        }
                        if (!bl2) break block11;
                        Expression timeField = slidingGroupWindow.timeField();
                        Expression size = slidingGroupWindow.size();
                        Expression slide = slidingGroupWindow.slide();
                        if (!ExpressionUtils$.MODULE$.isProctimeAttribute(timeField) || !ExpressionUtils$.MODULE$.isRowCountLiteral(size)) break block11;
                        windowOperatorBuilder = builder.countWindow(ExpressionUtils$.MODULE$.toLong(size), ExpressionUtils$.MODULE$.toLong(slide));
                        break block6;
                    }
                    if (bl2) {
                        throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
                    }
                    if (!(logicalWindow instanceof SessionGroupWindow)) break block12;
                    bl = true;
                    sessionGroupWindow = (SessionGroupWindow)logicalWindow;
                    Expression timeField = sessionGroupWindow.timeField();
                    Expression gap = sessionGroupWindow.gap();
                    if (!ExpressionUtils$.MODULE$.isProctimeAttribute(timeField)) break block12;
                    windowOperatorBuilder = builder.session(ExpressionUtils$.MODULE$.toDuration(gap)).withProcessingTime();
                    break block6;
                }
                if (!bl) break block13;
                Expression timeField = sessionGroupWindow.timeField();
                Expression gap = sessionGroupWindow.gap();
                if (!ExpressionUtils$.MODULE$.isRowtimeAttribute(timeField)) break block13;
                windowOperatorBuilder = builder.session(ExpressionUtils$.MODULE$.toDuration(gap)).withEventTime(timeIdx);
            }
            WindowOperatorBuilder newBuilder = windowOperatorBuilder;
            Object object = this.emitStrategy().produceUpdates() ? newBuilder.withSendRetraction().triggering(this.emitStrategy().getTrigger()) : BoxedUnit.UNIT;
            return newBuilder.aggregate(aggsHandler, recordEqualiser, accTypes, aggValueTypes, windowPropertyTypes).withAllowedLateness(Duration.ofMillis(this.emitStrategy().getAllowLateness())).build();
        }
        throw new MatchError((Object)logicalWindow);
    }

    public StreamExecGroupWindowAggregate(LogicalWindow window, Seq<FlinkRelBuilder.NamedWindowProperty> namedProperties, RelOptCluster cluster, RelTraitSet traitSet, RelNode inputNode, Seq<AggregateCall> aggCalls, BaseRowSchema outputSchema, BaseRowSchema inputSchema, int[] grouping, int inputTimestampIndex, EmitStrategy emitStrategy) {
        this.window = window;
        this.namedProperties = namedProperties;
        this.cluster = cluster;
        this.aggCalls = aggCalls;
        this.outputSchema = outputSchema;
        this.inputSchema = inputSchema;
        this.grouping = grouping;
        this.inputTimestampIndex = inputTimestampIndex;
        this.emitStrategy = emitStrategy;
        super(cluster, traitSet, inputNode);
        FlinkRelNode$class.$init$(this);
        FlinkPhysicalRel$class.$init$(this);
        StreamPhysicalRel$class.$init$(this);
        ExecNode$class.$init$(this);
        StreamExecNode$class.$init$(this);
        Logging$class.$init$(this);
        BaseStreamExecNode$class.$init$(this);
    }
}

