/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.tools.RelBuilderFactory;

public class AggregateCalcMergeRule
extends RelOptRule {
    public static final AggregateCalcMergeRule INSTANCE = new AggregateCalcMergeRule(Aggregate.class, Calc.class, RelFactories.LOGICAL_BUILDER);

    public AggregateCalcMergeRule(Class<? extends Aggregate> aggregateClass, Class<? extends Calc> calcClass, RelBuilderFactory relBuilderFactory) {
        super(AggregateCalcMergeRule.operand(aggregateClass, AggregateCalcMergeRule.operand(calcClass, AggregateCalcMergeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Calc calc = (Calc)call.rel(1);
        return calc.getProgram().getCondition() == null;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Calc calc = (Calc)call.rel(1);
        RexProgram program = calc.getProgram();
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (RexLocalRef localRef : program.getProjectList()) {
            projects.add(program.expandLocalRef(localRef));
        }
        LogicalProject project = LogicalProject.create(calc.getInput(), projects, calc.getRowType());
        RelNode x = AggregateProjectMergeRule.apply(call, aggregate, project);
        if (x != null) {
            call.transformTo(x);
        }
    }
}

