/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SemiJoinType;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.TableSourceParser;
import org.apache.flink.table.api.functions.TableFunction;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.functions.utils.TableSqlFunction;
import org.apache.flink.table.functions.utils.UserDefinedFunctionUtils$;
import org.apache.flink.table.plan.rules.logical.CatalogTableToBatchTableSourceRule;
import org.apache.flink.table.plan.rules.logical.CatalogTableToStreamTableSourceRule;
import org.apache.flink.table.plan.schema.CatalogCalciteTable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;

public final class CatalogTableRules$ {
    public static final CatalogTableRules$ MODULE$;
    private final CatalogTableToStreamTableSourceRule STREAM_TABLE_SCAN_RULE;
    private final CatalogTableToBatchTableSourceRule BATCH_TABLE_SCAN_RULE;

    static {
        new CatalogTableRules$();
    }

    public CatalogTableToStreamTableSourceRule STREAM_TABLE_SCAN_RULE() {
        return this.STREAM_TABLE_SCAN_RULE;
    }

    public CatalogTableToBatchTableSourceRule BATCH_TABLE_SCAN_RULE() {
        return this.BATCH_TABLE_SCAN_RULE;
    }

    public RelNode appendParserNode(CatalogCalciteTable catalogTable, RelNode inputNode, RelBuilder relBuilder) {
        RelNode relNode;
        TableSourceParser parser = catalogTable.tableSourceParser();
        if (parser == null) {
            relNode = inputNode;
        } else {
            CorrelationId colId = inputNode.getCluster().createCorrel();
            relBuilder.push(inputNode);
            Buffer params = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(parser.getParameters()).map((Function1)new Serializable(relBuilder){
                public static final long serialVersionUID = 0L;
                private final RelBuilder relBuilder$1;

                public final RexInputRef apply(String x0$3) {
                    String string = x0$3;
                    if (string != null) {
                        String string2 = string;
                        RexInputRef rexInputRef = this.relBuilder$1.field(string2);
                        return rexInputRef;
                    }
                    throw new MatchError((Object)string);
                }
                {
                    this.relBuilder$1 = relBuilder$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            TableFunction<?> tf = parser.getParser();
            FlinkTypeFactory typeFactory = (FlinkTypeFactory)inputNode.getCluster().getTypeFactory();
            TableSqlFunction parserSqlFunction = UserDefinedFunctionUtils$.MODULE$.createTableSqlFunction("parser", "parser", tf, typeFactory);
            RexNode rexCall = relBuilder.call((SqlOperator)parserSqlFunction, JavaConversions$.MODULE$.bufferAsJavaList(params));
            LogicalTableFunctionScan tableFunctionScan = LogicalTableFunctionScan.create(inputNode.getCluster(), ImmutableList.<RelNode>of(), rexCall, parserSqlFunction.getElementType(typeFactory, JavaConversions$.MODULE$.seqAsJavaList((Seq)params.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final SqlLiteral apply(RexInputRef x$1) {
                    return SqlLiteral.createNull(new SqlParserPos(0, 0));
                }
            }, Buffer$.MODULE$.canBuildFrom()))), parserSqlFunction.getRowType(typeFactory, JavaConversions$.MODULE$.seqAsJavaList((Seq)params.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final SqlLiteral apply(RexInputRef x$2) {
                    return SqlLiteral.createNull(new SqlParserPos(0, 0));
                }
            }, Buffer$.MODULE$.canBuildFrom())), JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(parser.getParameters()).map((Function1)new Serializable(inputNode){
                public static final long serialVersionUID = 0L;
                private final RelNode inputNode$1;

                public final RelDataType apply(String name) {
                    return this.inputNode$1.getRowType().getField(name, true, false).getType();
                }
                {
                    this.inputNode$1 = inputNode$1;
                }
            }, Buffer$.MODULE$.canBuildFrom()))), null);
            RelDataType outputDataType = tableFunctionScan.getRowType();
            ImmutableBitSet.Builder columnSetBuilder = ImmutableBitSet.builder();
            params.foreach((Function1)new Serializable(columnSetBuilder){
                public static final long serialVersionUID = 0L;
                private final ImmutableBitSet.Builder columnSetBuilder$1;

                public final ImmutableBitSet.Builder apply(RexInputRef param) {
                    return this.columnSetBuilder$1.set(param.getIndex());
                }
                {
                    this.columnSetBuilder$1 = columnSetBuilder$1;
                }
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), outputDataType.getFieldCount()).foreach((Function1)new Serializable(inputNode, columnSetBuilder){
                public static final long serialVersionUID = 0L;
                private final RelNode inputNode$1;
                private final ImmutableBitSet.Builder columnSetBuilder$1;

                public final ImmutableBitSet.Builder apply(int idx) {
                    return this.columnSetBuilder$1.set(this.inputNode$1.getRowType().getFieldCount() + idx);
                }
                {
                    this.inputNode$1 = inputNode$1;
                    this.columnSetBuilder$1 = columnSetBuilder$1;
                }
            });
            LogicalCorrelate correlate = LogicalCorrelate.create(inputNode, tableFunctionScan, colId, columnSetBuilder.build(), SemiJoinType.INNER);
            relBuilder.push(correlate);
            Buffer projects = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(outputDataType.getFieldList()).map((Function1)new Serializable(inputNode, relBuilder){
                public static final long serialVersionUID = 0L;
                private final RelNode inputNode$1;
                private final RelBuilder relBuilder$1;

                public final RexInputRef apply(RelDataTypeField field) {
                    return this.relBuilder$1.field(this.inputNode$1.getRowType().getFieldCount() + field.getIndex());
                }
                {
                    this.inputNode$1 = inputNode$1;
                    this.relBuilder$1 = relBuilder$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            relNode = LogicalProject.create((RelNode)correlate, (List<? extends RexNode>)JavaConversions$.MODULE$.bufferAsJavaList(projects), outputDataType);
        }
        return relNode;
    }

    public RelNode appendComputedColumns(RelBuilder relBuilder, RelNode node, TableSchema schema2, Map<String, RexNode> expression2) {
        RelNode relNode;
        Map<String, RexNode> map2;
        Map<String, RexNode> map3 = expression2;
        if (map3 != null && !(map2 = map3).isEmpty()) {
            relBuilder.push(node);
            ArrayList<String> nameList = new ArrayList<String>(map2.size());
            ArrayList nodeList = new ArrayList(map2.size());
            Predef$.MODULE$.refArrayOps((Object[])schema2.getColumnNames()).map((Function1)new Serializable(expression2, nameList, nodeList){
                public static final long serialVersionUID = 0L;
                private final Map expression$1;
                private final ArrayList nameList$1;
                private final ArrayList nodeList$1;

                public final boolean apply(String x0$4) {
                    String string = x0$4;
                    if (string != null) {
                        String string2 = string;
                        if (JavaConversions$.MODULE$.mapAsScalaMap(this.expression$1).contains((Object)string2)) {
                            this.nameList$1.add(string2);
                            boolean bl = this.nodeList$1.add(this.expression$1.get(string2));
                            return bl;
                        }
                    }
                    if (string != null) {
                        String string3 = string;
                        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not existed in computed column expressions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string3})));
                    }
                    throw new MatchError((Object)string);
                }
                {
                    this.expression$1 = expression$1;
                    this.nameList$1 = nameList$1;
                    this.nodeList$1 = nodeList$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
            relNode = relBuilder.project(nodeList, nameList).build();
        } else {
            relNode = node;
        }
        return relNode;
    }

    private CatalogTableRules$() {
        MODULE$ = this;
        this.STREAM_TABLE_SCAN_RULE = new CatalogTableToStreamTableSourceRule();
        this.BATCH_TABLE_SCAN_RULE = new CatalogTableToBatchTableSourceRule();
    }
}

