/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.physical.batch;

import java.util.Collections;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.api.functions.UserDefinedFunction;
import org.apache.flink.table.plan.FlinkJoinRelType;
import org.apache.flink.table.plan.nodes.FlinkConventions$;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalSemiJoin;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecLocalHashAggregate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchPhysicalRel$;
import org.apache.flink.table.plan.rules.physical.batch.BatchExecJoinRuleBase;
import org.apache.flink.table.plan.util.FlinkRelOptUtil$;
import scala.Array$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;

public abstract class BatchExecJoinRuleBase$class {
    public static RelNode addLocalDistinctAgg(BatchExecJoinRuleBase $this, RelNode node, Seq distinctKeys, RelBuilder relBuilder) {
        RelTraitSet localRequiredTraitSet = node.getTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL());
        RelNode newInput = RelOptRule.convert(node, localRequiredTraitSet);
        RelTraitSet providedTraitSet = localRequiredTraitSet;
        return new BatchExecLocalHashAggregate(node.getCluster(), relBuilder, providedTraitSet, newInput, (Seq<Tuple2<AggregateCall, UserDefinedFunction>>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), node.getRowType(), node.getRowType(), (int[])distinctKeys.toArray(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()));
    }

    public static boolean chooseSemiBuildDistinct(BatchExecJoinRuleBase $this, RelNode buildRel, Seq distinctKeys) {
        TableConfig tableConfig = FlinkRelOptUtil$.MODULE$.getTableConfig(buildRel);
        RelMetadataQuery mq = buildRel.getCluster().getMetadataQuery();
        double ratioConf = tableConfig.getConf().getDouble(TableConfigOptions.SQL_OPTIMIZER_SEMI_JOIN_BUILD_DISTINCT_NDV_RATIO);
        Double inputRows = mq.getRowCount(buildRel);
        Double ndvOfGroupKey = mq.getDistinctRowCount(buildRel, ImmutableBitSet.of((int[])distinctKeys.toArray(ClassTag$.MODULE$.Int())), null);
        return ndvOfGroupKey == null ? false : Predef$.MODULE$.Double2double(ndvOfGroupKey) / Predef$.MODULE$.Double2double(inputRows) < ratioConf;
    }

    public static FlinkJoinRelType getFlinkJoinRelType(BatchExecJoinRuleBase $this, Join join) {
        block4: {
            FlinkJoinRelType flinkJoinRelType;
            block3: {
                Join join2;
                block2: {
                    join2 = join;
                    if (!(join2 instanceof FlinkLogicalJoin)) break block2;
                    FlinkLogicalJoin flinkLogicalJoin = (FlinkLogicalJoin)join2;
                    flinkJoinRelType = FlinkJoinRelType.toFlinkJoinRelType(flinkLogicalJoin.getJoinType());
                    break block3;
                }
                if (!(join2 instanceof FlinkLogicalSemiJoin)) break block4;
                FlinkLogicalSemiJoin flinkLogicalSemiJoin = (FlinkLogicalSemiJoin)join2;
                flinkJoinRelType = flinkLogicalSemiJoin.isAnti ? FlinkJoinRelType.ANTI : FlinkJoinRelType.SEMI;
            }
            return flinkJoinRelType;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal join node: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{join.getClass().getName()})));
    }

    public static RelDataType getInputRowType(BatchExecJoinRuleBase $this, Join join) {
        block4: {
            RelDataType relDataType;
            block3: {
                Join join2;
                block2: {
                    join2 = join;
                    if (!(join2 instanceof FlinkLogicalJoin)) break block2;
                    FlinkLogicalJoin flinkLogicalJoin = (FlinkLogicalJoin)join2;
                    relDataType = flinkLogicalJoin.getRowType();
                    break block3;
                }
                if (!(join2 instanceof FlinkLogicalSemiJoin)) break block4;
                FlinkLogicalSemiJoin flinkLogicalSemiJoin = (FlinkLogicalSemiJoin)join2;
                relDataType = SqlValidatorUtil.deriveJoinRowType(flinkLogicalSemiJoin.getLeft().getRowType(), flinkLogicalSemiJoin.getRight().getRowType(), flinkLogicalSemiJoin.getJoinType(), flinkLogicalSemiJoin.getCluster().getTypeFactory(), null, Collections.<RelDataTypeField>emptyList());
            }
            return relDataType;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal join node: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{join.getClass().getName()})));
    }

    public static Double binaryRowRelNodeSize(BatchExecJoinRuleBase $this, RelNode relNode) {
        RelMetadataQuery mq = relNode.getCluster().getMetadataQuery();
        Double rowCount = mq.getRowCount(relNode);
        return rowCount == null ? null : Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(rowCount) * BatchPhysicalRel$.MODULE$.binaryRowAverageSize(relNode));
    }

    public static void $init$(BatchExecJoinRuleBase $this) {
    }
}

