/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.physical.batch.runtimefilter;

import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecCalc;
import org.apache.flink.table.plan.rules.physical.batch.runtimefilter.UselessRuntimeFilterRemoveRule;
import org.apache.flink.table.runtime.util.BloomFilter;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;

public final class UselessRuntimeFilterRemoveRule$ {
    public static final UselessRuntimeFilterRemoveRule$ MODULE$;
    private final UselessRuntimeFilterRemoveRule INSTANCE;

    static {
        new UselessRuntimeFilterRemoveRule$();
    }

    public UselessRuntimeFilterRemoveRule INSTANCE() {
        return this.INSTANCE;
    }

    public boolean org$apache$flink$table$plan$rules$physical$batch$runtimefilter$UselessRuntimeFilterRemoveRule$$ndvRowCountSuitable(TableConfig conf, Double probeRowCount, Double buildNdv, Double probeNdv) {
        double minProbeFilter = conf.getConf().getDouble(TableConfigOptions.SQL_EXEC_RUNTIME_FILTER_PROBE_FILTER_DEGREE_MIN);
        double minFpp2 = this.getMinSuitableFpp(conf, probeRowCount, buildNdv);
        return (1.0 - Predef$.MODULE$.Double2double(buildNdv) / Predef$.MODULE$.Double2double(probeNdv)) * (1.0 - minFpp2) >= minProbeFilter;
    }

    public double getMinSuitableFpp(TableConfig conf, Double probeRowCount, Double buildNdv) {
        int ratioOfRowAndBits = conf.getConf().getInteger(TableConfigOptions.SQL_EXEC_RUNTIME_FILTER_ROW_COUNT_NUM_BITS_RATIO);
        long confMaxNumOfBits = (long)conf.getConf().getInteger(TableConfigOptions.SQL_EXEC_RUNTIME_FILTER_SIZE_MAX) * 1024L * 1024L * 8L;
        double maxNumOfBits = Math.min(Predef$.MODULE$.Double2double(probeRowCount) / (double)ratioOfRowAndBits, (double)confMaxNumOfBits);
        return BloomFilter.findSuitableFpp(buildNdv.longValue(), maxNumOfBits);
    }

    public Calc removeFilters(BatchExecCalc calc, SqlOperator[] toBeRemove) {
        RexBuilder rexBuilder = calc.getCluster().getRexBuilder();
        RexProgram program = calc.getProgram();
        RexProgramBuilder pBuilder = RexProgramBuilder.forProgram(program, rexBuilder, true);
        pBuilder.clearCondition();
        List<RexNode> filters = RelOptUtil.conjunctions(program.expandLocalRef(program.getCondition()));
        ((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(filters).filter((Function1)new Serializable(toBeRemove){
            public static final long serialVersionUID = 0L;
            private final SqlOperator[] toBeRemove$1;

            public final boolean apply(RexNode x0$1) {
                boolean bl;
                RexNode rexNode = x0$1;
                if (rexNode instanceof RexCall) {
                    RexCall rexCall = (RexCall)rexNode;
                    bl = !Predef$.MODULE$.refArrayOps((Object[])this.toBeRemove$1).contains((Object)rexCall.getOperator());
                } else {
                    bl = true;
                }
                return bl;
            }
            {
                this.toBeRemove$1 = toBeRemove$1;
            }
        })).foreach((Function1)new Serializable(pBuilder){
            public static final long serialVersionUID = 0L;
            private final RexProgramBuilder pBuilder$1;

            public final void apply(RexNode x$1) {
                this.pBuilder$1.addCondition(x$1);
            }
            {
                this.pBuilder$1 = pBuilder$1;
            }
        });
        return calc.copy(calc.getTraitSet(), calc.getInput(), pBuilder.getProgram());
    }

    private UselessRuntimeFilterRemoveRule$() {
        MODULE$ = this;
        this.INSTANCE = new UselessRuntimeFilterRemoveRule();
    }
}

