/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.util;

import java.time.Duration;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.window.TimeWindow;
import org.apache.flink.table.plan.logical.LogicalWindow;
import org.apache.flink.table.plan.util.EmitStrategy$;
import org.apache.flink.table.runtime.window.triggers.Element;
import org.apache.flink.table.runtime.window.triggers.EventTime;
import org.apache.flink.table.runtime.window.triggers.ProcessingTime;
import org.apache.flink.table.runtime.window.triggers.Trigger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001=\u0011A\"R7jiN#(/\u0019;fOfT!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001B\u0001B\u0003%\u0001$A\u0006jg\u00163XM\u001c;US6,\u0007CA\t\u001a\u0013\tQ\"CA\u0004C_>dW-\u00198\t\u0011q\u0001!\u0011!Q\u0001\na\tq\"[:TKN\u001c\u0018n\u001c8XS:$wn\u001e\u0005\t=\u0001\u0011)\u0019!C\u0001?\u0005\tR-\u0019:ms\u001aK'/Z%oi\u0016\u0014h/\u00197\u0016\u0003\u0001\u0002\"!E\u0011\n\u0005\t\u0012\"\u0001\u0002'p]\u001eD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0013K\u0006\u0014H.\u001f$je\u0016Le\u000e^3sm\u0006d\u0007\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0001 \u0003Aa\u0017\r^3GSJ,\u0017J\u001c;feZ\fG\u000e\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003!\u0003Ea\u0017\r^3GSJ,\u0017J\u001c;feZ\fG\u000e\t\u0005\tU\u0001\u0011\t\u0011)A\u0005A\u0005i\u0011\r\u001c7po2\u000bG/\u001a8fgNDQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtDC\u0002\u00181cI\u001aD\u0007\u0005\u00020\u00015\t!\u0001C\u0003\u0018W\u0001\u0007\u0001\u0004C\u0003\u001dW\u0001\u0007\u0001\u0004C\u0003\u001fW\u0001\u0007\u0001\u0005C\u0003'W\u0001\u0007\u0001\u0005C\u0003+W\u0001\u0007\u0001\u0005C\u00037\u0001\u0011\u0005q$\u0001\thKR\fE\u000e\\8x\u0019\u0006$XM\\3tg\")\u0001\b\u0001C\u0001s\u0005y1\r[3dWZ\u000bG.\u001b3bi&|g\u000eF\u0001;!\t\t2(\u0003\u0002=%\t!QK\\5u\u0011\u0015q\u0004\u0001\"\u0001@\u00039\u0001(o\u001c3vG\u0016,\u0006\u000fZ1uKN,\u0012\u0001\u0007\u0005\u0006\u0003\u0002!\tAQ\u0001\u000bO\u0016$HK]5hO\u0016\u0014X#A\"\u0011\u0007\u0011[U*D\u0001F\u0015\t1u)\u0001\u0005ue&<w-\u001a:t\u0015\tA\u0015*\u0001\u0004xS:$wn\u001e\u0006\u0003\u0015\u001a\tqA];oi&lW-\u0003\u0002M\u000b\n9AK]5hO\u0016\u0014\bC\u0001(S\u001b\u0005y%B\u0001%Q\u0015\t\tf!A\u0002ba&L!aU(\u0003\u0015QKW.Z,j]\u0012|w\u000fC\u0003V\u0001\u0011\u0005c+\u0001\u0005u_N#(/\u001b8h)\u00059\u0006C\u0001-\\\u001d\t\t\u0012,\u0003\u0002[%\u00051\u0001K]3eK\u001aL!\u0001X/\u0003\rM#(/\u001b8h\u0015\tQ&\u0003C\u0003`\u0001\u0011%\u0001-A\rde\u0016\fG/\u001a+sS\u001e<WM\u001d$s_6Le\u000e^3sm\u0006dGCA1e!\r\t\"mQ\u0005\u0003GJ\u0011aa\u00149uS>t\u0007\"B3_\u0001\u0004\u0001\u0013\u0001C5oi\u0016\u0014h/\u00197\t\u000b\u001d\u0004A\u0011\u00025\u0002!%tG/\u001a:wC2$vn\u0015;sS:<GCA,j\u0011\u0015)g\r1\u0001!\u000f\u0015Y'\u0001#\u0001m\u00031)U.\u001b;TiJ\fG/Z4z!\tySNB\u0003\u0002\u0005!\u0005an\u0005\u0002n!!)A&\u001cC\u0001aR\tA\u000eC\u0003s[\u0012\u00051/A\u0003baBd\u0017\u0010F\u0002/ijDQ!^9A\u0002Y\f1\u0002^1cY\u0016\u001cuN\u001c4jOB\u0011q\u000f_\u0007\u0002!&\u0011\u0011\u0010\u0015\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\rC\u0003Ic\u0002\u00071\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f\t\u00059An\\4jG\u0006d\u0017bAA\u0001{\niAj\\4jG\u0006dw+\u001b8e_^\u0004")
public class EmitStrategy {
    private final boolean isEventTime;
    private final boolean isSessionWindow;
    private final long earlyFireInterval;
    private final long lateFireInterval;
    private final long allowLateness;

    public static EmitStrategy apply(TableConfig tableConfig, LogicalWindow logicalWindow) {
        return EmitStrategy$.MODULE$.apply(tableConfig, logicalWindow);
    }

    public long earlyFireInterval() {
        return this.earlyFireInterval;
    }

    public long lateFireInterval() {
        return this.lateFireInterval;
    }

    public long getAllowLateness() {
        return this.allowLateness;
    }

    public void checkValidation() {
        if (this.isSessionWindow && (this.earlyFireInterval() >= 0L || this.lateFireInterval() >= 0L)) {
            throw new TableException("Session window doesn't support EMIT strategy currently.");
        }
        if (this.isEventTime && this.lateFireInterval() >= 0L && this.allowLateness <= 0L) {
            throw new TableException("The 'AFTER WATERMARK' emit strategy requires 'sql.exec.state.ttl.ms' config in job config.");
        }
    }

    public boolean produceUpdates() {
        return this.isEventTime ? this.allowLateness > 0L || this.earlyFireInterval() >= 0L || this.lateFireInterval() >= 0L : this.earlyFireInterval() >= 0L;
    }

    public Trigger<TimeWindow> getTrigger() {
        Option<Trigger<TimeWindow>> option;
        block11: {
            Trigger trigger;
            block8: {
                Trigger trigger2;
                block10: {
                    ProcessingTime.AfterEndOfWindow<TimeWindow> trigger3;
                    block9: {
                        Option<Trigger<TimeWindow>> earlyTrigger;
                        block2: {
                            Tuple2 tuple2;
                            block7: {
                                Trigger trigger4;
                                block4: {
                                    EventTime.AfterEndOfWindow trigger5;
                                    block6: {
                                        block5: {
                                            block3: {
                                                earlyTrigger = this.createTriggerFromInterval(this.earlyFireInterval());
                                                Option<Trigger<TimeWindow>> lateTrigger = this.createTriggerFromInterval(this.lateFireInterval());
                                                if (!this.isEventTime) break block2;
                                                trigger5 = EventTime.afterEndOfWindow();
                                                tuple2 = new Tuple2(earlyTrigger, lateTrigger);
                                                if (tuple2 == null) break block3;
                                                Option option2 = (Option)tuple2._1();
                                                Option option3 = (Option)tuple2._2();
                                                if (!(option2 instanceof Some)) break block3;
                                                Some some = (Some)option2;
                                                Trigger early = (Trigger)some.x();
                                                if (!(option3 instanceof Some)) break block3;
                                                Some some2 = (Some)option3;
                                                Trigger late = (Trigger)some2.x();
                                                trigger4 = trigger5.withEarlyFirings(early).withLateFirings(late);
                                                break block4;
                                            }
                                            if (tuple2 == null) break block5;
                                            Option option4 = (Option)tuple2._1();
                                            Option option5 = (Option)tuple2._2();
                                            if (!(option4 instanceof Some)) break block5;
                                            Some some = (Some)option4;
                                            Trigger early = (Trigger)some.x();
                                            if (!None$.MODULE$.equals(option5)) break block5;
                                            trigger4 = trigger5.withEarlyFirings(early);
                                            break block4;
                                        }
                                        if (tuple2 == null) break block6;
                                        Option option6 = (Option)tuple2._1();
                                        Option option7 = (Option)tuple2._2();
                                        if (!None$.MODULE$.equals(option6) || !(option7 instanceof Some)) break block6;
                                        Some some = (Some)option7;
                                        Trigger late = (Trigger)some.x();
                                        trigger4 = trigger5.withLateFirings(late);
                                        break block4;
                                    }
                                    if (tuple2 == null) break block7;
                                    Option option8 = (Option)tuple2._1();
                                    Option option9 = (Option)tuple2._2();
                                    if (!None$.MODULE$.equals(option8) || !None$.MODULE$.equals(option9)) break block7;
                                    trigger4 = trigger5;
                                }
                                trigger = trigger4;
                                break block8;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        trigger3 = ProcessingTime.afterEndOfWindow();
                        option = earlyTrigger;
                        if (!(option instanceof Some)) break block9;
                        Some some = (Some)option;
                        Trigger early = (Trigger)some.x();
                        trigger2 = trigger3.withEarlyFirings(early);
                        break block10;
                    }
                    if (!None$.MODULE$.equals(option)) break block11;
                    trigger2 = trigger3;
                }
                trigger = trigger2;
            }
            return trigger;
        }
        throw new MatchError(option);
    }

    public String toString() {
        BoxedUnit boxedUnit;
        StringBuilder builder = new StringBuilder();
        String earlyString = this.intervalToString(this.earlyFireInterval());
        String lateString = this.intervalToString(this.lateFireInterval());
        Object object = earlyString == null ? BoxedUnit.UNIT : builder.append("early ").append(earlyString);
        if (lateString == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Object object2 = earlyString == null ? BoxedUnit.UNIT : builder.append(", ");
            boxedUnit = builder.append("late ").append(lateString);
        }
        return builder.toString();
    }

    private Option<Trigger<TimeWindow>> createTriggerFromInterval(long interval) {
        return interval > 0L ? new Some(ProcessingTime.every(Duration.ofMillis(interval))) : (interval == 0L ? new Some(Element.every()) : None$.MODULE$);
    }

    private String intervalToString(long interval) {
        return interval > 0L ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delay ", " millisecond"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)interval)})) : (interval == 0L ? "no delay" : null);
    }

    public EmitStrategy(boolean isEventTime, boolean isSessionWindow, long earlyFireInterval, long lateFireInterval, long allowLateness) {
        this.isEventTime = isEventTime;
        this.isSessionWindow = isSessionWindow;
        this.earlyFireInterval = earlyFireInterval;
        this.lateFireInterval = lateFireInterval;
        this.allowLateness = allowLateness;
    }
}

