/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.util;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.flink.streaming.api.bundle.CountCoBundleTrigger;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableConfigOptions;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.errorcode.TableErrors;
import org.apache.flink.table.plan.FlinkJoinRelType;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class JoinUtil$ {
    public static final JoinUtil$ MODULE$;

    static {
        new JoinUtil$();
    }

    public String joinSelectionToString(RelDataType inputType) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(inputType.getFieldNames()).asScala()).toList().mkString(", ");
    }

    public String joinConditionToString(RelDataType inputType, RexNode joinCondition, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression2) {
        List inFields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(inputType.getFieldNames()).asScala()).toList();
        return (String)expression2.apply((Object)joinCondition, (Object)inFields, (Object)None$.MODULE$);
    }

    public String joinTypeToString(FlinkJoinRelType joinType) {
        FlinkJoinRelType flinkJoinRelType;
        block8: {
            String string;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    flinkJoinRelType = joinType;
                                    if (!((Object)((Object)FlinkJoinRelType.INNER)).equals((Object)flinkJoinRelType)) break block2;
                                    string = "InnerJoin";
                                    break block3;
                                }
                                if (!((Object)((Object)FlinkJoinRelType.LEFT)).equals((Object)flinkJoinRelType)) break block4;
                                string = "LeftOuterJoin";
                                break block3;
                            }
                            if (!((Object)((Object)FlinkJoinRelType.RIGHT)).equals((Object)flinkJoinRelType)) break block5;
                            string = "RightOuterJoin";
                            break block3;
                        }
                        if (!((Object)((Object)FlinkJoinRelType.FULL)).equals((Object)flinkJoinRelType)) break block6;
                        string = "FullOuterJoin";
                        break block3;
                    }
                    if (!((Object)((Object)FlinkJoinRelType.SEMI)).equals((Object)flinkJoinRelType)) break block7;
                    string = "LeftSemiJoin";
                    break block3;
                }
                if (!((Object)((Object)FlinkJoinRelType.ANTI)).equals((Object)flinkJoinRelType)) break block8;
                string = "LeftAntiJoin";
            }
            return string;
        }
        throw new MatchError((Object)flinkJoinRelType);
    }

    public String joinToString(RelDataType inputType, RexNode joinCondition, FlinkJoinRelType joinType, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression2) {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.joinTypeToString(joinType)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(where: (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.joinConditionToString(inputType, joinCondition, expression2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"join: (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.joinSelectionToString(inputType)}))).toString();
    }

    public RelWriter joinExplainTerms(RelWriter pw, RelDataType inputType, RexNode joinCondition, FlinkJoinRelType joinType, RelDataType joinRowType, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression2) {
        return pw.item("where", this.joinConditionToString(inputType, joinCondition, expression2)).item("join", this.joinSelectionToString(joinRowType)).item("joinType", this.joinTypeToString(joinType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<ArrayBuffer<Object>, ArrayBuffer<Object>> checkAndGetKeys(List<IntPair> keyPairs, RelNode left, RelNode right, boolean allowEmpty) {
        Tuple2 tuple2;
        ArrayBuffer leftKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer rightKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        if (keyPairs.isEmpty()) {
            if (!allowEmpty) throw new TableException(TableErrors.INST.sqlJoinEqualConditionNotFound(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tleft: ", "\\n\\tright: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.toString(), right.toString()}))));
            tuple2 = new Tuple2((Object)leftKeys, (Object)rightKeys);
            return tuple2;
        } else {
            java.util.List<RelDataTypeField> leftFields = left.getRowType().getFieldList();
            java.util.List<RelDataTypeField> rightFields = right.getRowType().getFieldList();
            keyPairs.foreach((Function1)new Serializable(left, right, leftKeys, rightKeys, leftFields, rightFields){
                public static final long serialVersionUID = 0L;
                private final RelNode left$1;
                private final RelNode right$1;
                private final ArrayBuffer leftKeys$1;
                private final ArrayBuffer rightKeys$1;
                private final java.util.List leftFields$1;
                private final java.util.List rightFields$1;

                public final boolean apply(IntPair pair) {
                    SqlTypeName leftKeyType = ((RelDataTypeField)this.leftFields$1.get(pair.source)).getType().getSqlTypeName();
                    SqlTypeName rightKeyType = ((RelDataTypeField)this.rightFields$1.get(pair.target)).getType().getSqlTypeName();
                    SqlTypeName sqlTypeName = leftKeyType;
                    SqlTypeName sqlTypeName2 = rightKeyType;
                    if (!(sqlTypeName != null ? !((Object)((Object)sqlTypeName)).equals((Object)((Object)sqlTypeName2)) : sqlTypeName2 != null)) {
                        JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.leftKeys$1).add(BoxesRunTime.boxToInteger((int)pair.source));
                        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.rightKeys$1).add(BoxesRunTime.boxToInteger((int)pair.target));
                    }
                    throw new TableException(TableErrors.INST.sqlJoinEqualJoinOnIncompatibleTypes(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tLeft: ", "\\n\\tright: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left$1.toString(), this.right$1.toString()}))));
                }
                {
                    this.left$1 = left$1;
                    this.right$1 = right$1;
                    this.leftKeys$1 = leftKeys$1;
                    this.rightKeys$1 = rightKeys$1;
                    this.leftFields$1 = leftFields$1;
                    this.rightFields$1 = rightFields$1;
                }
            });
            tuple2 = new Tuple2((Object)leftKeys, (Object)rightKeys);
        }
        return tuple2;
    }

    public boolean checkAndGetKeys$default$4() {
        return false;
    }

    public CountCoBundleTrigger<BaseRow, BaseRow> getMiniBatchTrigger(TableConfig tableConfig) {
        return new CountCoBundleTrigger(tableConfig.getConf().getLong(TableConfigOptions.SQL_EXEC_MINIBATCH_SIZE));
    }

    private JoinUtil$() {
        MODULE$ = this;
    }
}

