/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.flink.table.plan.util.FlinkRexUtil$;
import org.apache.flink.table.plan.util.OverAggregateUtil$;
import org.apache.flink.table.plan.util.SortUtil$;
import org.apache.flink.table.runtime.aggregate.RelFieldCollations$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class OverAggregateUtil$ {
    public static final OverAggregateUtil$ MODULE$;

    static {
        new OverAggregateUtil$();
    }

    public String partitionToString(RelDataType inputType, int[] partition2) {
        Buffer inFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(inputType.getFieldNames()).asScala();
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(partition2).map((Function1)new Serializable(inFields){
            public static final long serialVersionUID = 0L;
            private final Buffer inFields$1;

            public final String apply(int x$1) {
                return (String)this.inFields$1.apply(x$1);
            }
            {
                this.inFields$1 = inFields$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ");
    }

    public String orderingToString(RelDataType inputType, List<RelFieldCollation> orderFields) {
        Buffer inFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(inputType.getFieldList()).asScala();
        String orderingString = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(orderFields).asScala()).map((Function1)new Serializable(inFields){
            public static final long serialVersionUID = 0L;
            private final Buffer inFields$2;

            public final String apply(RelFieldCollation x) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((RelDataTypeField)this.inFields$2.apply(x.getFieldIndex())).getName(), x.direction.shortString}));
            }
            {
                this.inFields$2 = inFields$2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(", ");
        return orderingString;
    }

    public String windowRangeToString(Window logicWindow, Window.Group groupWindow) {
        Object object;
        StringBuilder buf = new StringBuilder();
        buf.append(groupWindow.isRows ? " ROWS " : " RANG ");
        RexWindowBound lowerBound = groupWindow.lowerBound;
        RexWindowBound upperBound = groupWindow.upperBound;
        if (lowerBound == null) {
            object = upperBound == null ? BoxedUnit.UNIT : buf.append(this.boundString$1(upperBound, logicWindow));
        } else if (upperBound == null) {
            object = buf.append(this.boundString$1(lowerBound, logicWindow));
        } else {
            buf.append("BETWEEN ");
            buf.append(this.boundString$1(lowerBound, logicWindow));
            buf.append(" AND ");
            object = buf.append(this.boundString$1(upperBound, logicWindow));
        }
        return buf.toString();
    }

    public String aggregationToString(RelDataType inputType, Seq<RexLiteral> constants2, RelDataType rowType, Seq<Pair<AggregateCall, String>> namedAggregates, boolean outputInputName, boolean withOutputFieldNames, int rowTypeOffset) {
        Buffer inFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(inputType.getFieldNames()).asScala();
        Buffer outFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldNames()).asScala();
        Seq aggStrings = (Seq)((TraversableLike)namedAggregates.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AggregateCall apply(Pair<AggregateCall, String> x$2) {
                return x$2.getKey();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(inputType, constants2, inFields){
            public static final long serialVersionUID = 0L;
            public final RelDataType inputType$1;
            public final Seq constants$1;
            public final Buffer inFields$3;

            public final String apply(AggregateCall a) {
                Object[] objectArray = new Object[2];
                objectArray[0] = a.getAggregation();
                String prefix = a.isDistinct() ? "DISTINCT " : "";
                objectArray[1] = new StringBuilder().append((Object)prefix).append((Object)(a.getArgList().size() > 0 ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(a.getArgList()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;

                    public final Object apply(Integer arg) {
                        return Predef$.MODULE$.Integer2int(arg) >= this.$outer.inputType$1.getFieldCount() ? this.$outer.constants$1.apply(Predef$.MODULE$.Integer2int(arg) - this.$outer.inputType$1.getFieldCount()) : this.$outer.inFields$3.apply(Predef$.MODULE$.Integer2int(arg));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).mkString(", ") : "*")).toString();
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
            }
            {
                this.inputType$1 = inputType$1;
                this.constants$1 = constants$1;
                this.inFields$3 = inFields$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq output2 = outputInputName ? inFields.$plus$plus((GenTraversableOnce)aggStrings) : aggStrings;
        return ((TraversableOnce)((TraversableLike)output2.zip((GenIterable)outFields.drop(rowTypeOffset), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(withOutputFieldNames){
            public static final long serialVersionUID = 0L;
            private final boolean withOutputFieldNames$1;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String f = (String)tuple2._1();
                    String o = (String)tuple2._2();
                    String string = f;
                    String string2 = o;
                    String string3 = !(string != null ? !string.equals(string2) : string2 != null) ? f : (this.withOutputFieldNames$1 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " AS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f, o})) : f);
                    return string3;
                }
                throw new MatchError(tuple2);
            }
            {
                this.withOutputFieldNames$1 = withOutputFieldNames$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public boolean aggregationToString$default$5() {
        return true;
    }

    public boolean aggregationToString$default$6() {
        return true;
    }

    public int aggregationToString$default$7() {
        return 0;
    }

    public int calcOriginInputRows(Window logicWindow) {
        return logicWindow.getRowType().getFieldCount() - ((SeqLike)JavaConversions$.MODULE$.asScalaBuffer(logicWindow.groups).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Buffer<Window.RexWinAggCall> apply(Window.Group x$3) {
                return JavaConversions$.MODULE$.asScalaBuffer(x$3.aggCalls);
            }
        }, Buffer$.MODULE$.canBuildFrom())).size();
    }

    public Object getBoundary(Window logicWindow, RexWindowBound windowBound) {
        Number number;
        if (windowBound.isCurrentRow()) {
            number = BoxesRunTime.boxToLong((long)0L);
        } else {
            RexInputRef ref = (RexInputRef)windowBound.getOffset();
            int boundIndex = ref.getIndex() - this.calcOriginInputRows(logicWindow);
            int flag = windowBound.isPreceding() ? -1 : 1;
            RexLiteral literal = (RexLiteral)logicWindow.constants.get(boundIndex);
            SqlTypeName sqlTypeName = literal.getType().getSqlTypeName();
            Number number2 = ((Object)((Object)SqlTypeName.DECIMAL)).equals((Object)sqlTypeName) ? ((BigDecimal)literal.getValue3()).multiply(new BigDecimal(flag)) : BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(literal.getValueAs(Long.class)) * (long)flag));
            number = number2;
        }
        return number;
    }

    public RelCollation createFlinkRelCollation(Window.Group group) {
        int[] groupSet = group.keys.toArray();
        List<RelFieldCollation> collections = group.orderKeys.getFieldCollations();
        Tuple3<int[], boolean[], boolean[]> tuple3 = SortUtil$.MODULE$.getKeysAndOrders((Seq<RelFieldCollation>)JavaConversions$.MODULE$.asScalaBuffer(collections));
        if (tuple3 != null) {
            RelCollation relCollation;
            int[] orderKeyIdxs;
            int[] nArray;
            int[] orderKeyIdxs2 = nArray = (orderKeyIdxs = (int[])tuple3._1());
            if (Predef$.MODULE$.intArrayOps(groupSet).nonEmpty() || Predef$.MODULE$.intArrayOps(orderKeyIdxs2).nonEmpty()) {
                Buffer collectionIndexes = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(collections).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(RelFieldCollation x$4) {
                        return x$4.getFieldIndex();
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                int[] intersectIds = (int[])Predef$.MODULE$.intArrayOps(orderKeyIdxs2).intersect((GenSeq)Predef$.MODULE$.wrapIntArray(groupSet));
                Tuple3[] groupCollation = (Tuple3[])Predef$.MODULE$.intArrayOps(groupSet).map((Function1)new Serializable(collections, collectionIndexes, intersectIds){
                    public static final long serialVersionUID = 0L;
                    private final List collections$1;
                    private final Buffer collectionIndexes$1;
                    private final int[] intersectIds$1;

                    public final Tuple3<Object, RelFieldCollation.Direction, RelFieldCollation.NullDirection> apply(int idx) {
                        Tuple3 tuple3;
                        if (Predef$.MODULE$.intArrayOps(this.intersectIds$1).contains((Object)BoxesRunTime.boxToInteger((int)idx))) {
                            int index = this.collectionIndexes$1.indexOf((Object)BoxesRunTime.boxToInteger((int)idx));
                            tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)((RelFieldCollation)this.collections$1.get(index)).getFieldIndex()), (Object)((Object)((RelFieldCollation)this.collections$1.get(index)).getDirection()), (Object)((Object)((RelFieldCollation)this.collections$1.get((int)index)).nullDirection));
                        } else {
                            tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)idx), (Object)((Object)RelFieldCollation.Direction.ASCENDING), (Object)((Object)RelFieldCollation.NullDirection.FIRST));
                        }
                        return tuple3;
                    }
                    {
                        this.collections$1 = collections$1;
                        this.collectionIndexes$1 = collectionIndexes$1;
                        this.intersectIds$1 = intersectIds$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
                Buffer orderCollation = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(collections).filter((Function1)new Serializable(intersectIds){
                    public static final long serialVersionUID = 0L;
                    private final int[] intersectIds$1;

                    public final boolean apply(RelFieldCollation collection) {
                        return !Predef$.MODULE$.intArrayOps(this.intersectIds$1).contains((Object)BoxesRunTime.boxToInteger((int)collection.getFieldIndex()));
                    }
                    {
                        this.intersectIds$1 = intersectIds$1;
                    }
                })).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Object, RelFieldCollation.Direction, RelFieldCollation.NullDirection> apply(RelFieldCollation collo) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)collo.getFieldIndex()), (Object)((Object)collo.getDirection()), (Object)((Object)collo.nullDirection));
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                ArrayList<RelFieldCollation> fields2 = new ArrayList<RelFieldCollation>();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])groupCollation).$plus$plus((GenTraversableOnce)orderCollation, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)))).foreach((Function1)new Serializable(fields2){
                    public static final long serialVersionUID = 0L;
                    private final ArrayList fields$1;

                    public final boolean apply(Tuple3<Object, RelFieldCollation.Direction, RelFieldCollation.NullDirection> field) {
                        return this.fields$1.add(RelFieldCollations$.MODULE$.of(BoxesRunTime.unboxToInt((Object)field._1()), (RelFieldCollation.Direction)((Object)field._2()), (RelFieldCollation.NullDirection)((Object)field._3())));
                    }
                    {
                        this.fields$1 = fields$1;
                    }
                });
                relCollation = RelCollations.of(fields2);
            } else {
                relCollation = RelCollations.EMPTY;
            }
            return relCollation;
        }
        throw new MatchError(tuple3);
    }

    public boolean needCollationTrait(RelNode input, Window overWindow, Window.Group group) {
        boolean bl;
        if (!group.lowerBound.isPreceding() && !group.upperBound.isFollowing() && group.isRows) {
            long offsetLower = BoxesRunTime.unboxToLong((Object)this.getBoundary(overWindow, group.lowerBound));
            long offsetUpper = BoxesRunTime.unboxToLong((Object)this.getBoundary(overWindow, group.upperBound));
            bl = offsetLower != 0L || offsetUpper != 0L || !group.orderKeys.getFieldCollations().isEmpty();
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean isDeterministic(List<Window.Group> groups) {
        return JavaConversions$.MODULE$.asScalaBuffer(groups).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Window.Group g) {
                return JavaConversions$.MODULE$.asScalaBuffer(g.aggCalls).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(RexNode rex) {
                        return FlinkRexUtil$.MODULE$.isDeterministicOperator(rex);
                    }
                });
            }
        });
    }

    private final String boundString$1(RexWindowBound bound, Window logicWindow$1) {
        String string;
        if (bound.getOffset() == null) {
            string = bound.toString();
        } else {
            RexInputRef ref = (RexInputRef)bound.getOffset();
            int boundIndex = ref.getIndex() - this.calcOriginInputRows(logicWindow$1);
            Object offset = ((RexLiteral)logicWindow$1.constants.get(boundIndex)).getValue2();
            String offsetKind = bound.isPreceding() ? "PRECEDING" : "FOLLOWING";
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offset, offsetKind}));
        }
        return string;
    }

    private OverAggregateUtil$() {
        MODULE$ = this;
    }
}

