/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.resource.batch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.table.plan.nodes.exec.BatchExecNode;
import org.apache.flink.table.plan.util.FlinkRelOptUtil;
import org.apache.flink.table.resource.batch.NodeRunningUnit;

public class BatchExecNodeStage
implements Serializable {
    private final transient BatchExecNode<?> batchExecNode;
    private final Set<NodeRunningUnit> runningUnitSet = new LinkedHashSet<NodeRunningUnit>();
    private int stageID;
    private final Map<DependType, List<BatchExecNodeStage>> dependStagesMap = new LinkedHashMap<DependType, List<BatchExecNodeStage>>();
    private final List<Integer> transformationIDList = new LinkedList<Integer>();
    private final String nodeName;

    public BatchExecNodeStage(BatchExecNode<?> batchExecNode, int stageID) {
        this.batchExecNode = batchExecNode;
        this.stageID = stageID;
        this.nodeName = FlinkRelOptUtil.getDigest(batchExecNode.getFlinkPhysicalRel(), false);
    }

    public void addTransformation(StreamTransformation<?> transformation) {
        this.transformationIDList.add(transformation.getId());
    }

    public List<Integer> getTransformationIDList() {
        return this.transformationIDList;
    }

    public List<BatchExecNodeStage> getDependStageList(DependType type) {
        return this.dependStagesMap.computeIfAbsent(type, k -> new LinkedList());
    }

    public void removeDependStage(BatchExecNodeStage toRemove) {
        for (List<BatchExecNodeStage> stageList : this.dependStagesMap.values()) {
            stageList.remove(toRemove);
        }
    }

    public void addDependStage(BatchExecNodeStage nodeStage, DependType type) {
        this.dependStagesMap.computeIfAbsent(type, k -> new LinkedList()).add(nodeStage);
    }

    public BatchExecNode<?> getBatchExecNode() {
        return this.batchExecNode;
    }

    public Set<NodeRunningUnit> getRunningUnitList() {
        return this.runningUnitSet;
    }

    public void addRunningUnit(NodeRunningUnit nodeRunningUnit) {
        this.runningUnitSet.add(nodeRunningUnit);
    }

    public List<BatchExecNodeStage> getAllDependStageList() {
        ArrayList<BatchExecNodeStage> allStageList = new ArrayList<BatchExecNodeStage>();
        this.dependStagesMap.values().forEach(allStageList::addAll);
        return allStageList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchExecNodeStage stage = (BatchExecNodeStage)o;
        if (this.stageID != stage.stageID) {
            return false;
        }
        return this.batchExecNode != null ? this.batchExecNode.equals(stage.batchExecNode) : stage.batchExecNode == null;
    }

    public int hashCode() {
        int result = this.batchExecNode != null ? this.batchExecNode.hashCode() : 0;
        result = 31 * result + this.stageID;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("nodeStage(");
        sb.append("batchExecNode=").append(this.nodeName).append(", stageID=").append(this.stageID);
        this.dependStagesMap.forEach((k, v) -> {
            sb.append(", depend type: ").append(k).append(" =[");
            for (BatchExecNodeStage nodeStage : v) {
                sb.append("batchExecNode=").append(nodeStage.nodeName).append(", stageID=").append(nodeStage.stageID).append(";");
            }
            sb.append("]");
        });
        return sb.toString();
    }

    public static enum DependType {
        DATA_TRIGGER,
        PRIORITY;

    }
}

