/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.resource.batch.parallelism;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.plan.nodes.exec.BatchExecNode;
import org.apache.flink.table.plan.nodes.exec.ExecNode;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecScan;
import org.apache.flink.table.resource.batch.parallelism.BatchShuffleStageParallelismCalculator;
import org.apache.flink.table.resource.batch.parallelism.ShuffleStage;
import org.apache.flink.table.util.NodeResourceUtil;

public class BatchParallelismCalculatorOnStatistics
extends BatchShuffleStageParallelismCalculator {
    private final Map<ExecNode<?, ?>, Integer> calculatedResultMap = new HashMap();

    public BatchParallelismCalculatorOnStatistics(Configuration tableConf, int envParallelism) {
        super(tableConf, envParallelism);
    }

    @Override
    protected void calculate(ShuffleStage shuffleStage) {
        if (shuffleStage.isFinalParallelism()) {
            return;
        }
        Set<ExecNode<?, ?>> nodeSet = shuffleStage.getExecNodeSet();
        for (ExecNode<?, ?> node : nodeSet) {
            shuffleStage.setParallelism(this.calculate(node), false);
        }
    }

    private int calculate(ExecNode<?, ?> execNode) {
        int result;
        if (this.calculatedResultMap.containsKey(execNode)) {
            return this.calculatedResultMap.get(execNode);
        }
        if (execNode instanceof BatchExecScan) {
            result = this.calculateSource((BatchExecScan)execNode);
        } else if (execNode.getInputNodes().size() == 1) {
            result = this.calculateSingleNode(execNode);
        } else if (execNode.getInputNodes().size() == 2) {
            result = this.calculateBiNode(execNode);
        } else {
            throw new TableException("could not reach here. " + execNode.getClass());
        }
        this.calculatedResultMap.put(execNode, result);
        return result;
    }

    private int calculateSingleNode(ExecNode<?, ?> singleNode) {
        double rowCount = ((BatchExecNode)singleNode.getInputNodes().get(0)).getEstimatedRowCount();
        return NodeResourceUtil.calOperatorParallelism(rowCount, this.getTableConf());
    }

    private int calculateBiNode(ExecNode<?, ?> twoInputNode) {
        double maxRowCount = Math.max(((BatchExecNode)twoInputNode.getInputNodes().get(0)).getEstimatedRowCount(), ((BatchExecNode)twoInputNode.getInputNodes().get(1)).getEstimatedRowCount());
        return NodeResourceUtil.calOperatorParallelism(maxRowCount, this.getTableConf());
    }
}

