/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.resource.batch.parallelism;

import java.util.Collection;
import java.util.HashSet;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecScan;
import org.apache.flink.table.resource.batch.parallelism.ShuffleStage;
import org.apache.flink.table.util.NodeResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchShuffleStageParallelismCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(BatchShuffleStageParallelismCalculator.class);
    private final Configuration tableConf;
    protected final int envParallelism;

    public BatchShuffleStageParallelismCalculator(Configuration tableConf, int envParallelism) {
        this.tableConf = tableConf;
        this.envParallelism = envParallelism;
    }

    public void calculate(Collection<ShuffleStage> shuffleStages) {
        HashSet<ShuffleStage> shuffleStageSet = new HashSet<ShuffleStage>(shuffleStages);
        shuffleStageSet.forEach(this::calculate);
    }

    protected abstract void calculate(ShuffleStage var1);

    protected int calculateSource(BatchExecScan scanBatchExec) {
        boolean infer = !NodeResourceUtil.getInferMode(this.tableConf).equals((Object)NodeResourceUtil.InferMode.NONE);
        LOG.info("infer source partitions num: " + infer);
        if (infer) {
            double rowCount = scanBatchExec.getEstimatedRowCount();
            double io = rowCount * scanBatchExec.getEstimatedAverageRowSize();
            LOG.info("source row count is : " + rowCount);
            LOG.info("source data size is : " + io);
            long rowsPerPartition = NodeResourceUtil.getRelCountPerPartition(this.tableConf);
            long sizePerPartition = NodeResourceUtil.getSourceSizePerPartition(this.tableConf);
            int maxNum = NodeResourceUtil.getSourceMaxParallelism(this.tableConf);
            return Math.min(maxNum, Math.max((int)Math.max(io / (double)sizePerPartition / 1048576.0, rowCount / (double)rowsPerPartition), 1));
        }
        return NodeResourceUtil.getSourceParallelism(this.tableConf, this.envParallelism);
    }

    protected Configuration getTableConf() {
        return this.tableConf;
    }
}

