/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.resource.batch.schedule;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.table.resource.batch.schedule.LogicalJobVertexRunningUnit;

public class LogicalJobVertex {
    private final JobVertex jobVertex;
    private final AtomicInteger deployedNum = new AtomicInteger();
    private Set<LogicalJobVertexRunningUnit> runningUnitSet = new LinkedHashSet<LogicalJobVertexRunningUnit>();

    public LogicalJobVertex(JobVertex jobVertex) {
        this.jobVertex = jobVertex;
    }

    public void deployingTask() {
        this.deployedNum.incrementAndGet();
    }

    public boolean allTasksDeploying() {
        return this.deployedNum.get() >= this.jobVertex.getParallelism();
    }

    public int getParallelism() {
        return this.jobVertex.getParallelism();
    }

    public JobVertexID getJobVertexID() {
        return this.jobVertex.getID();
    }

    public void addRunningUnit(LogicalJobVertexRunningUnit runningUnit) {
        this.runningUnitSet.add(runningUnit);
    }

    public Set<LogicalJobVertexRunningUnit> getRunningUnitSet() {
        return this.runningUnitSet;
    }

    public void failoverTask() {
        this.deployedNum.decrementAndGet();
    }

    public String toString() {
        return this.jobVertex.getName();
    }
}

