/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.resource.batch.schedule;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.table.resource.batch.schedule.LogicalJobVertex;

public class LogicalJobVertexRunningUnit {
    private final Set<LogicalJobVertex> jobVertexSet = new LinkedHashSet<LogicalJobVertex>();
    private final Set<JobVertexID> inputDependSet = new HashSet<JobVertexID>();
    private final Set<JobVertexID> receivedInputDependSet = new HashSet<JobVertexID>();
    private final Set<LogicalJobVertexRunningUnit> joinDependSet = new HashSet<LogicalJobVertexRunningUnit>();
    private final Set<LogicalJobVertexRunningUnit> haveJoinedDependSet = new HashSet<LogicalJobVertexRunningUnit>();

    public void addJoinDepend(LogicalJobVertexRunningUnit runningUnit) {
        this.joinDependSet.add(runningUnit);
    }

    public void addInputDepend(JobVertexID jobVertexID) {
        this.inputDependSet.add(jobVertexID);
    }

    public LogicalJobVertexRunningUnit(Set<LogicalJobVertex> jobVertexSet) {
        this.jobVertexSet.addAll(jobVertexSet);
    }

    public List<LogicalJobVertex> getToScheduleJobVertices() {
        return this.jobVertexSet.stream().filter(j2 -> !j2.allTasksDeploying()).collect(Collectors.toList());
    }

    public boolean allTasksDeploying() {
        for (LogicalJobVertex job : this.jobVertexSet) {
            if (job.allTasksDeploying()) continue;
            return false;
        }
        return true;
    }

    public void receiveInput(JobVertexID jobVertexID) {
        this.receivedInputDependSet.add(jobVertexID);
    }

    public void joinDependDeploying(LogicalJobVertexRunningUnit runningUnit) {
        this.haveJoinedDependSet.add(runningUnit);
    }

    public Set<LogicalJobVertex> getJobVertexSet() {
        return this.jobVertexSet;
    }

    public boolean allDependReady() {
        return this.receivedInputDependSet.size() == this.inputDependSet.size() && this.haveJoinedDependSet.size() == this.joinDependSet.size();
    }

    public void reset() {
        this.receivedInputDependSet.clear();
        this.haveJoinedDependSet.clear();
    }
}

