/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.codegen.GeneratedAggsHandleFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.functions.AggsHandleFunction;
import org.apache.flink.table.runtime.functions.ExecutionContext;
import org.apache.flink.table.runtime.functions.ProcessFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.table.util.StateUtil;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001B\u0001\u0003\u0001=\u0011qCU8x)&lWMQ8v]\u0012,GMU1oO\u0016|e/\u001a:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\u000e\u0011\tE\u0011B\u0003F\u0007\u0002\u0005%\u00111C\u0001\u0002 !J|7-Z:t\rVt7\r^5p]^KG\u000f[\"mK\u0006tW\u000f]*uCR,\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003)!\u0017\r^1g_Jl\u0017\r^\u0005\u00033Y\u0011qAQ1tKJ{w\u000f\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\r\u0005!Q\u000f^5m\u0013\tyBDA\u0004M_\u001e<\u0017N\\4\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\nabZ3o\u0003\u001e<7\u000fS1oI2,'\u000f\u0005\u0002$M5\tAE\u0003\u0002&\r\u000591m\u001c3fO\u0016t\u0017BA\u0014%\u0005m9UM\\3sCR,G-Q4hg\"\u000bg\u000e\u001a7f\rVt7\r^5p]\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\u0005bG\u000e$\u0016\u0010]3t!\rYS\u0007\u000f\b\u0003YIr!!\f\u0019\u000e\u00039R!a\f\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0014!B:dC2\f\u0017BA\u001a5\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!M\u0005\u0003m]\u00121aU3r\u0015\t\u0019D\u0007\u0005\u0002:y5\t!H\u0003\u0002<\r\u0005)A/\u001f9fg&\u0011QH\u000f\u0002\r\u0013:$XM\u001d8bYRK\b/\u001a\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005U\u0005y\u0011N\u001c9vi\u001aKW\r\u001c3UsB,7\u000f\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0003=\u0001(/Z2fI&twm\u00144gg\u0016$\bCA\"E\u001b\u0005!\u0014BA#5\u0005\u0011auN\\4\t\u0011\u001d\u0003!\u0011!Q\u0001\n!\u000b!B]8x)&lW-\u00133y!\t\u0019\u0015*\u0003\u0002Ki\t\u0019\u0011J\u001c;\t\u00111\u0003!\u0011!Q\u0001\n5\u000b1\u0002^1cY\u0016\u001cuN\u001c4jOB\u0011a*U\u0007\u0002\u001f*\u0011\u0001KB\u0001\u0004CBL\u0017B\u0001*P\u0005-!\u0016M\u00197f\u0007>tg-[4\t\u000bQ\u0003A\u0011A+\u0002\rqJg.\u001b;?)\u001d1v\u000bW-[7r\u0003\"!\u0005\u0001\t\u000b\u0005\u001a\u0006\u0019\u0001\u0012\t\u000b%\u001a\u0006\u0019\u0001\u0016\t\u000b}\u001a\u0006\u0019\u0001\u0016\t\u000b\u0005\u001b\u0006\u0019\u0001\"\t\u000b\u001d\u001b\u0006\u0019\u0001%\t\u000b1\u001b\u0006\u0019A'\t\u0013y\u0003\u0001\u0019!a\u0001\n\u0013y\u0016AB8viB,H/F\u0001a!\t)\u0012-\u0003\u0002c-\tI!j\\5oK\u0012\u0014vn\u001e\u0005\nI\u0002\u0001\r\u00111A\u0005\n\u0015\f!b\\;uaV$x\fJ3r)\t1\u0017\u000e\u0005\u0002DO&\u0011\u0001\u000e\u000e\u0002\u0005+:LG\u000fC\u0004kG\u0006\u0005\t\u0019\u00011\u0002\u0007a$\u0013\u0007\u0003\u0004m\u0001\u0001\u0006K\u0001Y\u0001\b_V$\b/\u001e;!\u0011%q\u0007\u00011AA\u0002\u0013%q.A\u000bmCN$HK]5hO\u0016\u0014\u0018N\\4UgN#\u0018\r^3\u0016\u0003A\u0004B!]<\u0015s6\t!O\u0003\u0002ti\u0006)1.Z=fI*\u0011QO^\u0001\u0006gR\fG/\u001a\u0006\u0003\u000b!I!\u0001\u001f:\u0003\u001f-+\u00170\u001a3WC2,Xm\u0015;bi\u0016\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\t1\fgn\u001a\u0006\u0002}\u0006!!.\u0019<b\u0013\t)5\u0010C\u0006\u0002\u0004\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0011!\u00077bgR$&/[4hKJLgn\u001a+t'R\fG/Z0%KF$2AZA\u0004\u0011!Q\u0017\u0011AA\u0001\u0002\u0004\u0001\bbBA\u0006\u0001\u0001\u0006K\u0001]\u0001\u0017Y\u0006\u001cH\u000f\u0016:jO\u001e,'/\u001b8h)N\u001cF/\u0019;fA!Y\u0011q\u0002\u0001A\u0002\u0003\u0007I\u0011BA\t\u0003!\t7mY*uCR,WCAA\n!\u0011\tx\u000f\u0006\u000b\t\u0017\u0005]\u0001\u00011AA\u0002\u0013%\u0011\u0011D\u0001\rC\u000e\u001c7\u000b^1uK~#S-\u001d\u000b\u0004M\u0006m\u0001\"\u00036\u0002\u0016\u0005\u0005\t\u0019AA\n\u0011!\ty\u0002\u0001Q!\n\u0005M\u0011!C1dGN#\u0018\r^3!\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0004%I!!\n\u0002\u0015%t\u0007/\u001e;Ti\u0006$X-\u0006\u0002\u0002(A9\u0011/!\u000b\u0015s\u00065\u0012bAA\u0016e\ni1*Z=fI6\u000b\u0007o\u0015;bi\u0016\u0004R!a\f\u00024Qi!!!\r\u000b\u0005ui\u0018\u0002BA\u001b\u0003c\u0011A\u0001T5ti\"Y\u0011\u0011\b\u0001A\u0002\u0003\u0007I\u0011BA\u001e\u00039Ig\u000e];u'R\fG/Z0%KF$2AZA\u001f\u0011%Q\u0017qGA\u0001\u0002\u0004\t9\u0003\u0003\u0005\u0002B\u0001\u0001\u000b\u0015BA\u0014\u0003-Ig\u000e];u'R\fG/\u001a\u0011\t\u0017\u0005\u0015\u0003\u00011AA\u0002\u0013%\u0011qI\u0001\tMVt7\r^5p]V\u0011\u0011\u0011\n\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011q\n\u0003\u0002\u0013\u0019,hn\u0019;j_:\u001c\u0018\u0002BA*\u0003\u001b\u0012!#Q4hg\"\u000bg\u000e\u001a7f\rVt7\r^5p]\"Y\u0011q\u000b\u0001A\u0002\u0003\u0007I\u0011BA-\u000311WO\\2uS>tw\fJ3r)\r1\u00171\f\u0005\nU\u0006U\u0013\u0011!a\u0001\u0003\u0013B\u0001\"a\u0018\u0001A\u0003&\u0011\u0011J\u0001\nMVt7\r^5p]\u0002Bq!a\u0019\u0001\t\u0003\n)'\u0001\u0003pa\u0016tGc\u00014\u0002h!A\u0011\u0011NA1\u0001\u0004\tY'A\u0002dib\u0004B!a\u0013\u0002n%!\u0011qNA'\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0004\u0002t\u0001!\t%!\u001e\u0002\u001dA\u0014xnY3tg\u0016cW-\\3oiR9a-a\u001e\u0002|\u0005\r\u0006bBA=\u0003c\u0002\r\u0001F\u0001\u0006S:\u0004X\u000f\u001e\u0005\t\u0003S\n\t\b1\u0001\u0002~A!\u0011qPAO\u001d\u0011\t\t)!'\u000f\t\u0005\r\u0015q\u0013\b\u0005\u0003\u000b\u000b)J\u0004\u0003\u0002\b\u0006Me\u0002BAE\u0003#sA!a#\u0002\u0010:\u0019Q&!$\n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!C\u0002\u0002P\u0011IA!a'\u0002N\u0005y\u0001K]8dKN\u001ch)\u001e8di&|g.\u0003\u0003\u0002 \u0006\u0005&aB\"p]R,\u0007\u0010\u001e\u0006\u0005\u00037\u000bi\u0005\u0003\u0005\u0002&\u0006E\u0004\u0019AAT\u0003\ryW\u000f\u001e\t\u0006\u0003S\u000bi\u000bF\u0007\u0003\u0003WS!!\b\u0005\n\t\u0005=\u00161\u0016\u0002\n\u0007>dG.Z2u_JDq!a-\u0001\t\u0003\n),A\u0004p]RKW.\u001a:\u0015\u000f\u0019\f9,a/\u0002D\"9\u0011\u0011XAY\u0001\u0004\u0011\u0015!\u0003;j[\u0016\u001cH/Y7q\u0011!\tI'!-A\u0002\u0005u\u0006\u0003BA@\u0003\u007fKA!!1\u0002\"\nqqJ\u001c+j[\u0016\u00148i\u001c8uKb$\b\u0002CAS\u0003c\u0003\r!a*\t\u000f\u0005\u001d\u0007\u0001\"\u0011\u0002J\u0006)1\r\\8tKR\ta\r")
public class RowTimeBoundedRangeOver
extends ProcessFunctionWithCleanupState<BaseRow, BaseRow>
implements Logging {
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final Seq<InternalType> accTypes;
    private final Seq<InternalType> inputFieldTypes;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private JoinedRow output;
    private KeyedValueState<BaseRow, Long> lastTriggeringTsState;
    private KeyedValueState<BaseRow, BaseRow> accState;
    private KeyedMapState<BaseRow, Long, List<BaseRow>> inputState;
    private AggsHandleFunction function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        RowTimeBoundedRangeOver rowTimeBoundedRangeOver = this;
        synchronized (rowTimeBoundedRangeOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    private JoinedRow output() {
        return this.output;
    }

    private void output_$eq(JoinedRow x$1) {
        this.output = x$1;
    }

    private KeyedValueState<BaseRow, Long> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(KeyedValueState<BaseRow, Long> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private KeyedValueState<BaseRow, BaseRow> accState() {
        return this.accState;
    }

    private void accState_$eq(KeyedValueState<BaseRow, BaseRow> x$1) {
        this.accState = x$1;
    }

    private KeyedMapState<BaseRow, Long, List<BaseRow>> inputState() {
        return this.inputState;
    }

    private void inputState_$eq(KeyedMapState<BaseRow, Long, List<BaseRow>> x$1) {
        this.inputState = x$1;
    }

    private AggsHandleFunction function() {
        return this.function;
    }

    private void function_$eq(AggsHandleFunction x$1) {
        this.function = x$1;
    }

    @Override
    public void open(ExecutionContext ctx) {
        super.open(ctx);
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggsHandler.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggsHandler.code()}))).toString());
        this.function_$eq((AggsHandleFunction)this.genAggsHandler.newInstance(ctx.getRuntimeContext().getUserCodeClassLoader()));
        this.function().open(ctx);
        this.output_$eq(new JoinedRow());
        ValueStateDescriptor<Long> lastTriggeringTsDescriptor = new ValueStateDescriptor<Long>("lastTriggeringTsState", Types$.MODULE$.LONG());
        this.lastTriggeringTsState_$eq(ctx.getKeyedValueState(lastTriggeringTsDescriptor));
        BaseRowTypeInfo accTypeInfo = new BaseRowTypeInfo((TypeInformation[])((TraversableOnce)this.accTypes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(DataType t) {
                return TypeConverters$.MODULE$.createExternalTypeInfoFromDataType(t);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeInformation.class)));
        ValueStateDescriptor<BaseRow> accStateDesc = new ValueStateDescriptor<BaseRow>("accState", accTypeInfo);
        this.accState_$eq(ctx.getKeyedValueState(accStateDesc));
        BaseRowTypeInfo inputType = new BaseRowTypeInfo((TypeInformation[])((TraversableOnce)this.inputFieldTypes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(DataType t) {
                return TypeConverters$.MODULE$.createExternalTypeInfoFromDataType(t);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeInformation.class)));
        ListTypeInfo<BaseRow> rowListTypeInfo = new ListTypeInfo<BaseRow>(inputType);
        MapStateDescriptor<Long, BaseRow> inputStateDesc = new MapStateDescriptor<Long, BaseRow>("inputState", Types$.MODULE$.LONG(), (TypeInformation<BaseRow>)rowListTypeInfo);
        this.inputState_$eq(ctx.getKeyedMapState(inputStateDesc));
        this.initCleanupTimeState("RowTimeBoundedRangeOverCleanupTime");
    }

    @Override
    public void processElement(BaseRow input, ProcessFunction.Context ctx, Collector<BaseRow> out) {
        BaseRow currentKey = this.executionContext.currentKey();
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long triggeringTs = input.getLong(this.rowTimeIdx);
        Long lastTriggeringTs = (Long)this.lastTriggeringTsState().get((Object)currentKey);
        if (lastTriggeringTs == null) {
            lastTriggeringTs = Predef$.MODULE$.long2Long(0L);
        }
        if (triggeringTs > Predef$.MODULE$.Long2long(lastTriggeringTs)) {
            List data = (List)this.inputState().get((Object)currentKey, (Object)Predef$.MODULE$.long2Long(triggeringTs));
            if (data == null) {
                ArrayList<BaseRow> data2 = new ArrayList<BaseRow>();
                data2.add(input);
                this.inputState().add((Object)currentKey, (Object)Predef$.MODULE$.long2Long(triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            } else {
                data.add(input);
                this.inputState().add((Object)currentKey, (Object)Predef$.MODULE$.long2Long(triggeringTs), (Object)data);
            }
        }
    }

    @Override
    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<BaseRow> out) {
        BaseRow currentKey = this.executionContext.currentKey();
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.needToCleanupState(timestamp)) {
                Iterator keysIt = this.inputState().iterator((Object)currentKey);
                Long lastProcessedTime = (Long)this.lastTriggeringTsState().get((Object)currentKey);
                if (lastProcessedTime == null) {
                    lastProcessedTime = Predef$.MODULE$.long2Long(0L);
                }
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (Predef$.MODULE$.Long2long((Long)((Map.Entry)keysIt.next()).getKey()) <= Predef$.MODULE$.Long2long(lastProcessedTime)) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<KeyedState<BaseRow, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new KeyedState[]{this.inputState(), this.accState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        List inputs = (List)this.inputState().get((Object)currentKey, (Object)Predef$.MODULE$.long2Long(timestamp));
        if (inputs != null) {
            int dataListIndex = 0;
            BaseRow accumulators = (BaseRow)this.accState().get((Object)currentKey);
            if (accumulators == null) {
                accumulators = this.function().createAccumulators();
            }
            this.function().setAccumulators(accumulators);
            ArrayList<Long> retractTsList = new ArrayList<Long>();
            Iterator dataTimestampIt = this.inputState().iterator((Object)currentKey);
            while (dataTimestampIt.hasNext()) {
                Object object;
                Long dataTs = (Long)((Map.Entry)dataTimestampIt.next()).getKey();
                long offset = timestamp - Predef$.MODULE$.Long2long(dataTs);
                if (offset > this.precedingOffset) {
                    List retractDataList = (List)this.inputState().get((Object)currentKey, (Object)dataTs);
                    if (retractDataList == null) {
                        this.LOG().warn(StateUtil.STATE_CLEARED_WARN_MSG);
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    for (dataListIndex = 0; dataListIndex < retractDataList.size(); ++dataListIndex) {
                        BaseRow retractRow = (BaseRow)retractDataList.get(dataListIndex);
                        this.function().retract(retractRow);
                    }
                    object = BoxesRunTime.boxToBoolean((boolean)retractTsList.add(dataTs));
                    continue;
                }
                object = BoxedUnit.UNIT;
            }
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                BaseRow curRow = (BaseRow)inputs.get(dataListIndex);
                this.function().accumulate(curRow);
            }
            BaseRow aggValue = this.function().getValue();
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                BaseRow curRow = (BaseRow)inputs.get(dataListIndex);
                this.output().replace(curRow, aggValue);
                out.collect(this.output());
            }
            for (dataListIndex = 0; dataListIndex < retractTsList.size(); ++dataListIndex) {
                this.inputState().remove((Object)currentKey, retractTsList.get(dataListIndex));
            }
            accumulators = this.function().getAccumulators();
            this.accState().put((Object)currentKey, (Object)accumulators);
        }
        this.lastTriggeringTsState().put((Object)currentKey, (Object)Predef$.MODULE$.long2Long(timestamp));
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
    }

    @Override
    public void close() {
        this.function().close();
    }

    public RowTimeBoundedRangeOver(GeneratedAggsHandleFunction genAggsHandler, Seq<InternalType> accTypes, Seq<InternalType> inputFieldTypes, long precedingOffset, int rowTimeIdx, TableConfig tableConfig) {
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(tableConfig);
        Logging$class.$init$(this);
        Preconditions.checkNotNull(BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

