/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.codegen.GeneratedAggsHandleFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.functions.AggsHandleFunction;
import org.apache.flink.table.runtime.functions.ExecutionContext;
import org.apache.flink.table.runtime.functions.ProcessFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.table.util.StateUtil;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}g!B\u0001\u0003\u0003\u0003y!\u0001\u0006*poRKW.Z+oE>,h\u000eZ3e\u001fZ,'O\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001\"\u0004\u0005\u0003\u0012%Q!R\"\u0001\u0002\n\u0005M\u0011!a\b)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8XSRD7\t\\3b]V\u00048\u000b^1uKB\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u000bI\u0006$\u0018MZ8s[\u0006$\u0018BA\r\u0017\u0005\u001d\u0011\u0015m]3S_^\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0004\u0002\tU$\u0018\u000e\\\u0005\u0003?q\u0011q\u0001T8hO&tw\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u000399WM\\!hOND\u0015M\u001c3mKJ\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u0004\u0002\u000f\r|G-Z4f]&\u0011q\u0005\n\u0002\u001c\u000f\u0016tWM]1uK\u0012\fumZ:IC:$G.\u001a$v]\u000e$\u0018n\u001c8\t\u0011%\u0002!\u0011!Q\u0001\n)\n\u0001\"Y2d)f\u0004Xm\u001d\t\u0004WUBdB\u0001\u00173\u001d\ti\u0003'D\u0001/\u0015\tyc\"\u0001\u0004=e>|GOP\u0005\u0002c\u0005)1oY1mC&\u00111\u0007N\u0001\ba\u0006\u001c7.Y4f\u0015\u0005\t\u0014B\u0001\u001c8\u0005\r\u0019V-\u001d\u0006\u0003gQ\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0004\u0002\u000bQL\b/Z:\n\u0005uR$\u0001D%oi\u0016\u0014h.\u00197UsB,\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u001f%t\u0007/\u001e;GS\u0016dG\rV=qKND\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u000be><H+[7f\u0013\u0012D\bCA\"E\u001b\u0005!\u0014BA#5\u0005\rIe\u000e\u001e\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\u0006YA/\u00192mK\u000e{gNZ5h!\tIE*D\u0001K\u0015\tYe!A\u0002ba&L!!\u0014&\u0003\u0017Q\u000b'\r\\3D_:4\u0017n\u001a\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u0007y%t\u0017\u000e\u001e \u0015\rE\u00136\u000bV+W!\t\t\u0002\u0001C\u0003\"\u001d\u0002\u0007!\u0005C\u0003*\u001d\u0002\u0007!\u0006C\u0003@\u001d\u0002\u0007!\u0006C\u0003B\u001d\u0002\u0007!\tC\u0003H\u001d\u0002\u0007\u0001\nC\u0005Y\u0001\u0001\u0007\t\u0019!C\t3\u00061q.\u001e;qkR,\u0012A\u0017\t\u0003+mK!\u0001\u0018\f\u0003\u0013){\u0017N\\3e%><\b\"\u00030\u0001\u0001\u0004\u0005\r\u0011\"\u0005`\u0003)yW\u000f\u001e9vi~#S-\u001d\u000b\u0003A\u000e\u0004\"aQ1\n\u0005\t$$\u0001B+oSRDq\u0001Z/\u0002\u0002\u0003\u0007!,A\u0002yIEBaA\u001a\u0001!B\u0013Q\u0016aB8viB,H\u000f\t\u0005\nQ\u0002\u0001\r\u00111A\u0005\n%\f\u0001\"Y2d'R\fG/Z\u000b\u0002UB!1.\u001d\u000b\u0015\u001b\u0005a'BA7o\u0003\u0015YW-_3e\u0015\ty\u0007/A\u0003ti\u0006$XM\u0003\u0002\u0006\u0011%\u0011!\u000f\u001c\u0002\u0010\u0017\u0016LX\r\u001a,bYV,7\u000b^1uK\"IA\u000f\u0001a\u0001\u0002\u0004%I!^\u0001\rC\u000e\u001c7\u000b^1uK~#S-\u001d\u000b\u0003AZDq\u0001Z:\u0002\u0002\u0003\u0007!\u000e\u0003\u0004y\u0001\u0001\u0006KA[\u0001\nC\u000e\u001c7\u000b^1uK\u0002B\u0011B\u001f\u0001A\u0002\u0003\u0007I\u0011B>\u0002\u0015%t\u0007/\u001e;Ti\u0006$X-F\u0001}!\u0019YW\u0010F@\u0002\u0010%\u0011a\u0010\u001c\u0002\u000e\u0017\u0016LX\rZ'baN#\u0018\r^3\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005!A.\u00198h\u0015\t\tI!\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003\u0007\u0011A\u0001T8oOB)\u0011\u0011CA\u000b)5\u0011\u00111\u0003\u0006\u0004;\u0005\u001d\u0011\u0002BA\f\u0003'\u0011A\u0001T5ti\"Y\u00111\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000f\u00039Ig\u000e];u'R\fG/Z0%KF$2\u0001YA\u0010\u0011!!\u0017\u0011DA\u0001\u0002\u0004a\bbBA\u0012\u0001\u0001\u0006K\u0001`\u0001\fS:\u0004X\u000f^*uCR,\u0007\u0005C\u0006\u0002(\u0001\u0001\r\u00111A\u0005\n\u0005%\u0012\u0001E:peR,G\rV5nKN$\u0018-\u001c9t+\t\tY\u0003E\u0003\u0002\u0012\u00055r0\u0003\u0003\u00020\u0005M!A\u0003'j].,G\rT5ti\"Y\u00111\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001b\u0003Q\u0019xN\u001d;fIRKW.Z:uC6\u00048o\u0018\u0013fcR\u0019\u0001-a\u000e\t\u0013\u0011\f\t$!AA\u0002\u0005-\u0002\u0002CA\u001e\u0001\u0001\u0006K!a\u000b\u0002#M|'\u000f^3e)&lWm\u001d;b[B\u001c\b\u0005C\u0006\u0002@\u0001\u0001\r\u00111A\u0005\u0012\u0005\u0005\u0013\u0001\u00034v]\u000e$\u0018n\u001c8\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%C!A\u0005gk:\u001cG/[8og&!\u0011QJA$\u0005I\tumZ:IC:$G.\u001a$v]\u000e$\u0018n\u001c8\t\u0017\u0005E\u0003\u00011AA\u0002\u0013E\u00111K\u0001\rMVt7\r^5p]~#S-\u001d\u000b\u0004A\u0006U\u0003\"\u00033\u0002P\u0005\u0005\t\u0019AA\"\u0011!\tI\u0006\u0001Q!\n\u0005\r\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011\u001d\ti\u0006\u0001C!\u0003?\nAa\u001c9f]R\u0019\u0001-!\u0019\t\u0011\u0005\r\u00141\fa\u0001\u0003K\n1a\u0019;y!\u0011\t)%a\u001a\n\t\u0005%\u0014q\t\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDq!!\u001c\u0001\t\u0003\ny'\u0001\bqe>\u001cWm]:FY\u0016lWM\u001c;\u0015\u000f\u0001\f\t(!\u001e\u0002\u001e\"9\u00111OA6\u0001\u0004!\u0012!B5oaV$\b\u0002CA2\u0003W\u0002\r!a\u001e\u0011\t\u0005e\u0014q\u0013\b\u0005\u0003w\n\u0019J\u0004\u0003\u0002~\u0005Ee\u0002BA@\u0003\u001fsA!!!\u0002\u000e:!\u00111QAF\u001d\u0011\t))!#\u000f\u00075\n9)C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I1!!\u0013\u0005\u0013\u0011\t)*a\u0012\u0002\u001fA\u0013xnY3tg\u001a+hn\u0019;j_:LA!!'\u0002\u001c\n91i\u001c8uKb$(\u0002BAK\u0003\u000fB\u0001\"a(\u0002l\u0001\u0007\u0011\u0011U\u0001\u0004_V$\b#BAR\u0003O#RBAAS\u0015\ti\u0002\"\u0003\u0003\u0002*\u0006\u0015&!C\"pY2,7\r^8s\u0011\u001d\ti\u000b\u0001C!\u0003_\u000bqa\u001c8US6,'\u000fF\u0004a\u0003c\u000bI,!1\t\u0011\u0005M\u00161\u0016a\u0001\u0003k\u000b\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0007\r\u000b9,C\u0002\u0002\u000eQB\u0001\"a\u0019\u0002,\u0002\u0007\u00111\u0018\t\u0005\u0003s\ni,\u0003\u0003\u0002@\u0006m%AD(o)&lWM]\"p]R,\u0007\u0010\u001e\u0005\t\u0003?\u000bY\u000b1\u0001\u0002\"\"9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0017AE5og\u0016\u0014H\u000fV8T_J$X\r\u001a'jgR$2\u0001YAe\u0011!\tY-a1A\u0002\u0005U\u0016a\u0004:fG>\u0014H\rV5nKN$\u0018-\u001c9\t\u000f\u0005=\u0007A\"\u0001\u0002R\u0006\u0001\u0003O]8dKN\u001cX\t\\3nK:$8oV5uQN\u000bW.\u001a+j[\u0016\u001cH/Y7q)\u0015\u0001\u00171[Al\u0011!\t).!4A\u0002\u0005=\u0011AC2veJ{w\u000fT5ti\"A\u0011qTAg\u0001\u0004\t\t\u000bC\u0004\u0002\\\u0002!\t%!8\u0002\u000b\rdwn]3\u0015\u0003\u0001\u0004")
public abstract class RowTimeUnboundedOver
extends ProcessFunctionWithCleanupState<BaseRow, BaseRow>
implements Logging {
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final Seq<InternalType> accTypes;
    private final Seq<InternalType> inputFieldTypes;
    private final int rowTimeIdx;
    private JoinedRow output;
    private KeyedValueState<BaseRow, BaseRow> accState;
    private KeyedMapState<BaseRow, Long, List<BaseRow>> inputState;
    private LinkedList<Long> sortedTimestamps;
    private AggsHandleFunction function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        RowTimeUnboundedOver rowTimeUnboundedOver = this;
        synchronized (rowTimeUnboundedOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    public JoinedRow output() {
        return this.output;
    }

    public void output_$eq(JoinedRow x$1) {
        this.output = x$1;
    }

    private KeyedValueState<BaseRow, BaseRow> accState() {
        return this.accState;
    }

    private void accState_$eq(KeyedValueState<BaseRow, BaseRow> x$1) {
        this.accState = x$1;
    }

    private KeyedMapState<BaseRow, Long, List<BaseRow>> inputState() {
        return this.inputState;
    }

    private void inputState_$eq(KeyedMapState<BaseRow, Long, List<BaseRow>> x$1) {
        this.inputState = x$1;
    }

    private LinkedList<Long> sortedTimestamps() {
        return this.sortedTimestamps;
    }

    private void sortedTimestamps_$eq(LinkedList<Long> x$1) {
        this.sortedTimestamps = x$1;
    }

    public AggsHandleFunction function() {
        return this.function;
    }

    public void function_$eq(AggsHandleFunction x$1) {
        this.function = x$1;
    }

    @Override
    public void open(ExecutionContext ctx) {
        super.open(ctx);
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggsHandler.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggsHandler.code()}))).toString());
        this.function_$eq((AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader()));
        this.function().open(ctx);
        this.output_$eq(new JoinedRow());
        this.sortedTimestamps_$eq(new LinkedList<Long>());
        ValueStateDescriptor<BaseRow> accStateDesc = new ValueStateDescriptor<BaseRow>("accState", TypeConverters$.MODULE$.toBaseRowTypeInfo(new RowType((DataType[])this.accTypes.toArray(ClassTag$.MODULE$.apply(InternalType.class)))));
        this.accState_$eq(ctx.getKeyedValueState(accStateDesc));
        ListTypeInfo<BaseRow> rowListTypeInfo = new ListTypeInfo<BaseRow>(TypeConverters$.MODULE$.toBaseRowTypeInfo(new RowType((DataType[])this.inputFieldTypes.toArray(ClassTag$.MODULE$.apply(InternalType.class)))));
        MapStateDescriptor<Long, BaseRow> inputStateDesc = new MapStateDescriptor<Long, BaseRow>("inputState", Types$.MODULE$.LONG(), (TypeInformation<BaseRow>)rowListTypeInfo);
        this.inputState_$eq(ctx.getKeyedMapState(inputStateDesc));
        this.initCleanupTimeState("RowTimeUnboundedOverCleanupTime");
    }

    @Override
    public void processElement(BaseRow input, ProcessFunction.Context ctx, Collector<BaseRow> out) {
        BaseRow currentKey = this.executionContext.currentKey();
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long timestamp = input.getLong(this.rowTimeIdx);
        long curWatermark = ctx.timerService().currentWatermark();
        if (timestamp > curWatermark) {
            long triggerTs = curWatermark < 0L ? 0L : curWatermark + 1L;
            ctx.timerService().registerEventTimeTimer(triggerTs);
            ArrayList<BaseRow> rowList = (ArrayList<BaseRow>)this.inputState().get((Object)currentKey, (Object)Predef$.MODULE$.long2Long(timestamp));
            if (rowList == null) {
                rowList = new ArrayList<BaseRow>();
            }
            rowList.add(input);
            this.inputState().add((Object)currentKey, (Object)Predef$.MODULE$.long2Long(timestamp), rowList);
        }
    }

    @Override
    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<BaseRow> out) {
        BaseRow currentKey = this.executionContext.currentKey();
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.needToCleanupState(timestamp)) {
                boolean noRecordsToProcess;
                boolean bl = noRecordsToProcess = !this.inputState().contains((Object)currentKey);
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<KeyedState<BaseRow, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new KeyedState[]{this.inputState(), this.accState()}));
                    this.function().cleanup();
                } else {
                    this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        Iterator keyIterator = this.inputState().iterator((Object)currentKey);
        if (keyIterator != null && keyIterator.hasNext()) {
            long curWatermark = ctx.timerService().currentWatermark();
            boolean existEarlyRecord = false;
            do {
                Long recordTime;
                if (Predef$.MODULE$.Long2long(recordTime = (Long)((Map.Entry)keyIterator.next()).getKey()) <= curWatermark) {
                    this.insertToSortedList(Predef$.MODULE$.Long2long(recordTime));
                    continue;
                }
                existEarlyRecord = true;
            } while (keyIterator.hasNext());
            BaseRow lastAccumulator = (BaseRow)this.accState().get((Object)currentKey);
            if (lastAccumulator == null) {
                lastAccumulator = this.function().createAccumulators();
            }
            this.function().setAccumulators(lastAccumulator);
            while (true) {
                if (this.sortedTimestamps().isEmpty()) {
                    lastAccumulator = this.function().getAccumulators();
                    this.accState().put((Object)currentKey, (Object)lastAccumulator);
                    if (!existEarlyRecord) break;
                    ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
                    break;
                }
                Long curTimestamp = this.sortedTimestamps().removeFirst();
                List curRowList = (List)this.inputState().get((Object)currentKey, (Object)curTimestamp);
                if (curRowList == null) {
                    this.LOG().warn(StateUtil.STATE_CLEARED_WARN_MSG);
                } else {
                    this.processElementsWithSameTimestamp(curRowList, out);
                }
                this.inputState().remove((Object)currentKey, (Object)curTimestamp);
            }
        }
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
    }

    private void insertToSortedList(long recordTimestamp) {
        ListIterator<Long> listIterator = this.sortedTimestamps().listIterator(this.sortedTimestamps().size());
        boolean bl = true;
        while (listIterator.hasPrevious() && bl) {
            Long timestamp = listIterator.previous();
            if (recordTimestamp < Predef$.MODULE$.Long2long(timestamp)) continue;
            listIterator.next();
            listIterator.add(Predef$.MODULE$.long2Long(recordTimestamp));
            bl = false;
        }
        if (bl) {
            this.sortedTimestamps().addFirst(Predef$.MODULE$.long2Long(recordTimestamp));
        }
    }

    public abstract void processElementsWithSameTimestamp(List<BaseRow> var1, Collector<BaseRow> var2);

    @Override
    public void close() {
        this.function().close();
    }

    public RowTimeUnboundedOver(GeneratedAggsHandleFunction genAggsHandler, Seq<InternalType> accTypes, Seq<InternalType> inputFieldTypes, int rowTimeIdx, TableConfig tableConfig) {
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.rowTimeIdx = rowTimeIdx;
        super(tableConfig);
        Logging$class.$init$(this);
    }
}

