/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.runtime.functions.ThreadLocalCache;
import org.apache.flink.table.runtime.functions.utils.ParseUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class ScalarFunctions$ {
    public static final ScalarFunctions$ MODULE$;
    private final Logger LOG;
    private final ThreadLocalCache<String, Pattern> regexpPatternCache;
    private final ThreadLocalCache<String, SimpleDateFormat> dateFormatterCache;
    private final ThreadLocalCache<String, Calendar> calendarCache;

    static {
        new ScalarFunctions$();
    }

    public String concat(String ... args) {
        return this.concat((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
    }

    public String concat_ws(String separator, String ... args) {
        return this.concat_ws(separator, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
    }

    public Logger LOG() {
        return this.LOG;
    }

    public ThreadLocalCache<String, Pattern> regexpPatternCache() {
        return this.regexpPatternCache;
    }

    public ThreadLocalCache<String, SimpleDateFormat> dateFormatterCache() {
        return this.dateFormatterCache;
    }

    public ThreadLocalCache<String, Calendar> calendarCache() {
        return this.calendarCache;
    }

    public double exp(Decimal b) {
        return Math.exp(b.doubleValue());
    }

    public double power(double a, Decimal b) {
        return Math.pow(a, b.doubleValue());
    }

    public double power(Decimal a, Decimal b) {
        return Math.pow(a.doubleValue(), b.doubleValue());
    }

    public double power(Decimal a, double b) {
        return Math.pow(a.doubleValue(), b);
    }

    public double cosh(Decimal x) {
        return Math.cosh(x.doubleValue());
    }

    public double acos(Decimal b0) {
        return Math.acos(b0.doubleValue());
    }

    public double asin(Decimal b0) {
        return Math.asin(b0.doubleValue());
    }

    public double atan(Decimal b0) {
        return Math.atan(b0.doubleValue());
    }

    public double atan2(Decimal b0, Decimal b1) {
        return Math.atan2(b0.doubleValue(), b1.doubleValue());
    }

    public double sin(Decimal b0) {
        return Math.sin(b0.doubleValue());
    }

    public double cos(Decimal b0) {
        return Math.cos(b0.doubleValue());
    }

    public double tan(Decimal b0) {
        return Math.tan(b0.doubleValue());
    }

    public double cot(Decimal b0) {
        return 1.0 / Math.tan(b0.doubleValue());
    }

    public double degrees(Decimal b0) {
        return Math.toDegrees(b0.doubleValue());
    }

    public double radians(Decimal b0) {
        return Math.toRadians(b0.doubleValue());
    }

    public Decimal abs(Decimal b0) {
        return b0.abs();
    }

    public Decimal floor(Decimal b0) {
        return b0.floor();
    }

    public Decimal ceil(Decimal b0) {
        return b0.ceil();
    }

    public String concat(Seq<String> args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length(); ++i) {
            Object object = args.apply(i) == null ? BoxedUnit.UNIT : sb.append((String)args.apply(i));
        }
        return sb.toString();
    }

    public String concat_ws(String separator, Seq<String> args) {
        if (separator == null || "".equals(separator)) {
            return this.concat(args);
        }
        StringBuilder sb = new StringBuilder();
        boolean hasValueAppended = false;
        for (int i = 0; i < args.length(); ++i) {
            if (args.apply(i) == null) continue;
            Object object = hasValueAppended ? sb.append(separator) : BoxedUnit.UNIT;
            sb.append((String)args.apply(i));
            hasValueAppended = true;
        }
        return sb.toString();
    }

    public double log(double x) {
        return Math.log(x);
    }

    public double log(Decimal x) {
        return this.log(x.doubleValue());
    }

    public double tanh(Decimal x) {
        return Math.tanh(x.doubleValue());
    }

    public double log(double base, double x) {
        return Math.log(x) / Math.log(base);
    }

    public double log(double base, Decimal x) {
        return this.log(base, x.doubleValue());
    }

    public double log(Decimal base, double x) {
        return this.log(base.doubleValue(), x);
    }

    public double log(Decimal base, Decimal x) {
        return this.log(base.doubleValue(), x.doubleValue());
    }

    public double log2(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    public double log2(Decimal x) {
        return this.log2(x.doubleValue());
    }

    public double log10(double x) {
        return Math.log10(x);
    }

    public double log10(Decimal x) {
        return this.log10(x.doubleValue());
    }

    public String lpad(String s, int n, String pad) {
        block7: {
            block6: {
                String string = s;
                String string2 = "";
                if (!(string == null ? string2 != null : !string.equals(string2)) || n < 0) break block6;
                String string3 = pad;
                String string4 = "";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block7;
            }
            if (n < 0) {
                return null;
            }
            String string = pad;
            String string5 = "";
            if (!(string != null ? !string.equals(string5) : string5 != null) && s.length() < n) {
                return null;
            }
        }
        if (s.length() > n) {
            return s.substring(0, n);
        }
        return StringUtils.leftPad((String)s, (int)n, (String)pad);
    }

    public String rpad(String s, int n, String pad) {
        block7: {
            block6: {
                String string = s;
                String string2 = "";
                if (!(string == null ? string2 != null : !string.equals(string2)) || n < 0) break block6;
                String string3 = pad;
                String string4 = "";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block7;
            }
            if (n < 0) {
                return null;
            }
            String string = pad;
            String string5 = "";
            if (!(string != null ? !string.equals(string5) : string5 != null) && s.length() < n) {
                return null;
            }
        }
        if (s.length() > n) {
            return s.substring(0, n);
        }
        return StringUtils.rightPad((String)s, (int)n, (String)pad);
    }

    public double sinh(Decimal x) {
        return Math.sinh(x.doubleValue());
    }

    public String repeat(String s, int n) {
        if (BoxesRunTime.boxToInteger((int)n) == null || s == null) {
            return null;
        }
        return StringUtils.repeat((String)s, (int)n);
    }

    public String reverse(String s) {
        if (s == null) {
            return null;
        }
        return StringUtils.reverse((String)s);
    }

    public String replace(String s, String search, String replace) {
        return s == null || search == null || replace == null ? s : s.replace(search, replace);
    }

    public String splitIndex(String str, String separator, int index) {
        if (str == null || separator == null || BoxesRunTime.boxToInteger((int)index) == null || index < 0) {
            return null;
        }
        String[] values = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)str, (String)separator);
        if (index >= values.length) {
            return null;
        }
        return values[index];
    }

    public String splitIndex(String str, int ascii, int index) {
        if (BoxesRunTime.boxToInteger((int)ascii) == null || ascii > 255 || ascii < 1) {
            return null;
        }
        String separator = new String((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{Predef$.MODULE$.int2Integer(ascii).byteValue()}), ClassTag$.MODULE$.Byte()));
        return this.splitIndex(str, separator, index);
    }

    public String regExpReplace(String s, String regex, String replacement) {
        String string;
        if (s == null || regex == null || replacement == null) {
            return null;
        }
        String string2 = regex;
        String string3 = "";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return s;
        }
        try {
            StringBuffer sb = new StringBuffer();
            Matcher m = this.regexpPatternCache().get(regex).matcher(s);
            while (m.find()) {
                m.appendReplacement(sb, replacement);
            }
            m.appendTail(sb);
            string = sb.toString();
        }
        catch (Exception exception) {
            this.LOG().error("Exception in regExpReplace", (Throwable)exception);
            string = null;
        }
        return string;
    }

    public String regExpExtract(String s, String regex, long extractIndex) {
        Object v0;
        if (s == null || StringUtils.isEmpty((CharSequence)regex) || BoxesRunTime.boxToLong((long)extractIndex) == null) {
            this.LOG().error("regexp_extract(s, p, o) return NULL when met NULL parameter.");
            return null;
        }
        if (extractIndex < 0L) {
            this.LOG().error(new scala.collection.mutable.StringBuilder().append((Object)"o of 'regexp_extract(s, p, o)' must >= 0, but o == ").append((Object)BoxesRunTime.boxToLong((long)extractIndex)).toString());
            return null;
        }
        try {
            Pattern p = this.regexpPatternCache().get(regex);
            Matcher m = p.matcher(s);
            if (m.find()) {
                MatchResult mr = m.toMatchResult();
                return mr.group((int)extractIndex);
            }
            v0 = null;
        }
        catch (Exception exception) {
            this.LOG().error("Exception when compile and match", (Throwable)exception);
            v0 = null;
        }
        return v0;
    }

    public String regExpExtract(String str, String regex) {
        return this.regExpExtract(str, regex, 0L);
    }

    public BinaryString keyValue(BinaryString str, BinaryString split1, BinaryString split2, BinaryString keyName) {
        if (str == null || str.numBytes() == 0) {
            return null;
        }
        return split1 != null && split1.numBytes() == 1 && split2 != null && split2.numBytes() == 1 ? str.keyValue(split1.getByte(0), split2.getByte(0), keyName) : BinaryString.fromString(this.keyValue(BinaryString.safeToString(str), BinaryString.safeToString(split1), BinaryString.safeToString(split2), BinaryString.safeToString(keyName)));
    }

    public String keyValue(String str, String split1, String split2, String keyName) {
        Object v1;
        try {
            if (StringUtils.isEmpty((CharSequence)str)) {
                return null;
            }
            String[] values1 = StringUtils.split((String)str, (String)split1);
            for (int i = 0; i < values1.length; ++i) {
                String[] keyValueArr;
                if (values1[i] == null || "".equals(values1[i]) || (keyValueArr = StringUtils.split((String)values1[i], (String)split2)) == null || keyValueArr.length != 2) continue;
                String string = keyValueArr[0];
                String string2 = keyName;
                if (string != null ? !string.equals(string2) : string2 != null) continue;
                return keyValueArr[1];
            }
            v1 = null;
        }
        catch (Exception exception) {
            this.LOG().error("exception when parse keyvalue", (Throwable)exception);
            v1 = null;
        }
        return v1;
    }

    public String hash(String algorithm, String str) {
        return this.hash(algorithm, str, "");
    }

    public String hash(String algorithm, String str, String charsetName) {
        return Hex.encodeHexString((byte[])MessageDigest.getInstance(algorithm).digest(this.strToBytesWithCharset(str, charsetName)));
    }

    public String hash(MessageDigest md, String str) {
        return this.hash(md, str, "");
    }

    public String hash(MessageDigest md, String str, String charsetName) {
        return Hex.encodeHexString((byte[])md.digest(this.strToBytesWithCharset(str, charsetName)));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] strToBytesWithCharset(String str, String charsetName) {
        void var3_3;
        byte[] bArr = null;
        if (!StringUtils.isEmpty((CharSequence)charsetName)) {
            try {
                bArr = str.getBytes(charsetName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.LOG().error(new scala.collection.mutable.StringBuilder().append((Object)"Unsupported encoding:").append((Object)charsetName).append((Object)",use system default").toString(), (Throwable)unsupportedEncodingException);
                bArr = null;
            }
        }
        if (bArr == null) {
            bArr = str.getBytes();
        }
        return var3_3;
    }

    public String parseUrl(String urlStr, String partToExtract) {
        return ParseUrlUtils.parseUrl(urlStr, partToExtract);
    }

    public String parseUrl(String urlStr, String partToExtract, String key) {
        return ParseUrlUtils.parseUrl(urlStr, partToExtract, key);
    }

    public long now() {
        Date date = new Date();
        return date.getTime() / 1000L;
    }

    public long now(long offset) {
        Date date = new Date();
        return date.getTime() / 1000L + offset;
    }

    public String fromUnixtime(long unixtime, String format2) {
        String string;
        if (BoxesRunTime.boxToLong((long)unixtime) == null || format2 == null) {
            return null;
        }
        try {
            SimpleDateFormat formatter = this.dateFormatterCache().get(format2);
            Date date = new Date(unixtime * 1000L);
            string = formatter.format(date);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.LOG().error(new scala.collection.mutable.StringBuilder().append((Object)"exception when parse format string: ").append((Object)format2).toString(), (Throwable)illegalArgumentException);
            string = null;
        }
        catch (ParseException parseException) {
            this.LOG().error(new scala.collection.mutable.StringBuilder().append((Object)"exception when formatting string: ").append((Object)BoxesRunTime.boxToLong((long)unixtime)).toString(), (Throwable)parseException);
            string = null;
        }
        return string;
    }

    public String fromUnixtime(long unixtime) {
        return this.fromUnixtime(unixtime, "yyyy-MM-dd HH:mm:ss");
    }

    public String dateSub(String dateString1, int days) {
        String string;
        if (dateString1 == null) {
            return null;
        }
        Calendar calendar = this.calendarCache().get("calendar");
        SimpleDateFormat formatter = this.dateFormatterCache().get("yyyy-MM-dd");
        try {
            calendar.setTime(formatter.parse(dateString1));
            calendar.add(5, -days);
            Date newDate = calendar.getTime();
            string = formatter.format(newDate);
        }
        catch (ParseException parseException) {
            this.LOG().error(new scala.collection.mutable.StringBuilder().append((Object)"Parse exception in dateSub, input:").append((Object)dateString1).toString(), (Throwable)parseException);
            string = null;
        }
        return string;
    }

    public String dateSub(long t, int days) {
        Calendar calendar = this.calendarCache().get("calendar");
        SimpleDateFormat formatter = this.dateFormatterCache().get("yyyy-MM-dd");
        calendar.setTime(new Timestamp(t));
        calendar.add(5, -days);
        Date newDate = calendar.getTime();
        return formatter.format(newDate);
    }

    public String dateAdd(String dateString1, int days) {
        String string;
        if (dateString1 == null) {
            return null;
        }
        Calendar calendar = this.calendarCache().get("calendar");
        SimpleDateFormat formatter = this.dateFormatterCache().get("yyyy-MM-dd");
        try {
            calendar.setTime(formatter.parse(dateString1));
            calendar.add(5, days);
            Date newDate = calendar.getTime();
            string = formatter.format(newDate);
        }
        catch (ParseException parseException) {
            this.LOG().error(new scala.collection.mutable.StringBuilder().append((Object)"Parse exception in dateAdd, input:").append((Object)dateString1).toString(), (Throwable)parseException);
            string = null;
        }
        return string;
    }

    public String dateAdd(long t, int days) {
        Calendar calendar = this.calendarCache().get("calendar");
        SimpleDateFormat formatter = this.dateFormatterCache().get("yyyy-MM-dd");
        calendar.setTime(new Timestamp(t));
        calendar.add(5, days);
        Date newDate = calendar.getTime();
        return formatter.format(newDate);
    }

    public Integer divideInteger(Integer a, Integer b) {
        if (a == null || b == null) {
            return null;
        }
        return Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(a) / Predef$.MODULE$.Integer2int(b));
    }

    public String subString(String s, long p, long l) {
        if (s == null) {
            this.LOG().error("return null due to str of 'substring(str, start, len)' is null.");
            return null;
        }
        if (l < 0L) {
            this.LOG().error(new scala.collection.mutable.StringBuilder().append((Object)"len of 'substring(str, start, len)' must be >= 0 and Int type, but len = ").append((Object)BoxesRunTime.boxToLong((long)l)).toString());
            return null;
        }
        if (l > Integer.MAX_VALUE || p < Integer.MIN_VALUE || p > Integer.MAX_VALUE) {
            this.LOG().error(new scala.collection.mutable.StringBuilder().append((Object)"len or pos of 'substring(str, start, len)' must be Int type, but len = ").append((Object)BoxesRunTime.boxToLong((long)l)).append((Object)", pos=").append((Object)BoxesRunTime.boxToLong((long)p)).toString());
            return null;
        }
        int len = (int)l;
        int pos = (int)p;
        if (s.equals("")) {
            return "";
        }
        int start = 0;
        int end = 0;
        if (pos > 0) {
            start = pos - 1;
            if (start >= s.length()) {
                return "";
            }
        } else if (pos < 0) {
            start = s.length() + pos;
            if (start < 0) {
                return "";
            }
        } else {
            start = 0;
        }
        end = s.length() - start < len ? s.length() : start + len;
        return s.substring(start, end);
    }

    public String subString(String s, long p) {
        return this.subString(s, p, Integer.MAX_VALUE);
    }

    public String chr(long chr) {
        return chr < 0L ? "" : ((chr & 0xFFL) == 0L ? ((Object)BoxesRunTime.boxToCharacter((char)'\u0000')).toString() : ((Object)BoxesRunTime.boxToCharacter((char)((char)(chr & 0xFFL)))).toString());
    }

    public String overlay(String s, String r, long start, long length) {
        String string;
        if (s == null || r == null) {
            string = null;
        } else if (start <= 0L || start > (long)s.length()) {
            string = s;
        } else {
            StringBuilder sb = new StringBuilder();
            int start_ = (int)start;
            int len = (int)length;
            sb.append(s.substring(0, start_ - 1));
            sb.append(r);
            Object object = start_ + len <= s.length() && len > 0 ? sb.append(s.substring(start_ - 1 + len)) : BoxedUnit.UNIT;
            string = sb.toString();
        }
        return string;
    }

    public String overlay(String s, String r, long start) {
        return this.overlay(s, r, start, r.length());
    }

    public int position(BinaryString seek, BinaryString s) {
        return this.position(seek, s, 1);
    }

    public int position(BinaryString seek, BinaryString s, int from) {
        return s.indexOf(seek, from - 1) + 1;
    }

    public int instr(BinaryString str, BinaryString subString, int startPosition, int nthAppearance) {
        NonLocalReturnControl nonLocalReturnControl2;
        block7: {
            int n;
            Object object = new Object();
            try {
                if (nthAppearance <= 0) {
                    throw new IllegalArgumentException("nthAppearance must be positive!");
                }
                if (startPosition == 0) {
                    n = 0;
                } else if (startPosition > 0) {
                    IntRef startIndex = IntRef.create((int)startPosition);
                    IntRef index = IntRef.create((int)0);
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), nthAppearance).foreach$mVc$sp((Function1)new Serializable(str, subString, startIndex, index, object){
                        public static final long serialVersionUID = 0L;
                        private final BinaryString str$1;
                        private final BinaryString subString$1;
                        private final IntRef startIndex$1;
                        private final IntRef index$1;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(int appearance) {
                            this.apply$mcVI$sp(appearance);
                        }

                        public void apply$mcVI$sp(int appearance) {
                            this.index$1.elem = this.str$1.indexOf(this.subString$1, this.startIndex$1.elem - 1) + 1;
                            if (this.index$1.elem == 0) {
                                throw new NonLocalReturnControl.mcI.sp(this.nonLocalReturnKey1$1, 0);
                            }
                            this.startIndex$1.elem = this.index$1.elem + 1;
                        }
                        {
                            this.str$1 = str$1;
                            this.subString$1 = subString$1;
                            this.startIndex$1 = startIndex$1;
                            this.index$1 = index$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    n = index.elem;
                } else {
                    int pos = this.instr(str.reverse(), subString.reverse(), -startPosition, nthAppearance);
                    n = pos == 0 ? 0 : str.numChars() + 2 - pos - subString.numChars();
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block7;
                n = nonLocalReturnControl2.value$mcI$sp();
            }
            return n;
        }
        throw nonLocalReturnControl2;
    }

    public String hex(long x) {
        return Long.toHexString(x).toUpperCase();
    }

    public String hex(String x) {
        return Hex.encodeHexString((byte[])x.getBytes(StandardCharsets.UTF_8)).toUpperCase();
    }

    private ScalarFunctions$() {
        MODULE$ = this;
        this.LOG = LoggerFactory.getLogger(this.getClass());
        this.regexpPatternCache = new ThreadLocalCache<String, Pattern>(){

            public Pattern getNewInstance(String regex) {
                return Pattern.compile(regex);
            }
        };
        this.dateFormatterCache = new ThreadLocalCache<String, SimpleDateFormat>(){

            public SimpleDateFormat getNewInstance(String format2) {
                SimpleDateFormat dateFormat2 = new SimpleDateFormat(format2);
                dateFormat2.setLenient(false);
                dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                return dateFormat2;
            }
        };
        this.calendarCache = new ThreadLocalCache<String, Calendar>(){

            public Calendar getNewInstance(String format2) {
                Calendar calendar = Calendar.getInstance();
                calendar.setLenient(false);
                return calendar;
            }
        };
    }
}

